/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include "gtkspinbutton.h"


GtkWidget *spinner1;

void toggle_editable (GtkWidget *widget, GtkSpinButton *spin)
{
  gtk_entry_set_editable (GTK_ENTRY(spin), GTK_TOGGLE_BUTTON (widget)->active);
}

void change_digits (GtkWidget *widget, GtkSpinButton *spin)
{
  gtk_spin_button_set_digits (GTK_SPIN_BUTTON(spinner1), 
			      gtk_spin_button_get_value_as_int (spin));
}

void create_spins ()
{
  static GtkWidget *window = NULL;
  GtkWidget *box1;
  GtkWidget *box2;
  GtkWidget *spinner2;
  GtkWidget *button;
  GtkWidget *label;
  GtkWidget *separator;
  GtkAdjustment *adj;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC(gtk_main_quit),
		      NULL);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC(gtk_main_quit),
		      NULL);
  
  gtk_window_set_title (GTK_WINDOW (window), "SpinButton");
  gtk_container_border_width (GTK_CONTAINER (window), 0);
  
  box1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), box1);
  gtk_widget_show (box1);
  
  box2 = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (box2), 10);
  gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
  gtk_widget_show (box2);
  
  adj = (GtkAdjustment *) gtk_adjustment_new (0.0, 0.0, 10000.0,
					      3.1415, 100.0, 0.0);
  spinner1 = gtk_spin_button_new (adj, 6.283, 3);
  gtk_widget_set_usize (spinner1, 100, 0); 
  gtk_box_pack_start (GTK_BOX (box2), spinner1, TRUE, TRUE, 0);
  gtk_widget_show (spinner1);
  
  button = gtk_check_button_new_with_label ("Set editable");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (toggle_editable),
		      spinner1);
  gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
  gtk_widget_show (button);

  label = gtk_label_new ("# digits :");
  gtk_box_pack_start (GTK_BOX (box2), label, FALSE, TRUE, 0);
  gtk_widget_show (label);

  adj = (GtkAdjustment *) gtk_adjustment_new (3.0, 0.0, 6.0,
					      1.0, 3.0, 0.0);
  spinner2 = gtk_spin_button_new (adj, 0.0, 0);
  gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
		      GTK_SIGNAL_FUNC (change_digits),
		      (gpointer) spinner2);
  gtk_widget_set_usize (spinner2, 20, 0);
  gtk_box_pack_start (GTK_BOX (box2), spinner2, TRUE, TRUE, 0);
  gtk_widget_show (spinner2);

  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);
  gtk_widget_show (separator);
  
  box2 = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (box2), 10);
  gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);
  gtk_widget_show (box2);
  
  button = gtk_button_new_with_label ("Close");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT(window));
  gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
  gtk_widget_show (button);

  gtk_widget_show (window);
}

int
main (int argc, char *argv[])
{
  gtk_init (&argc, &argv);
  create_spins ();
  gtk_main ();
  return 0;
}
