/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "gtktreefactory.h"
#include "gtktree.h"
#include "gtktreeitem.h"
#include "gtktreefork.h"
#include "gtkvtree.h"
#include "gtkhtreeitem.h"
#include "gtkvtreefork.h"

#include <gtk/gtk.h>

GtkTreeEntry tree_items[] =
{
  { "GtkObject", NULL },
  { "GtkObject/GtkData", NULL },
  { "GtkObject/GtkData/GtkAdjustment", NULL },
  { "GtkObject/GtkData/(GtkGLContext)", NULL },
  { "GtkObject/GtkWidget", NULL },
  { "GtkObject/GtkWidget/GtkContainer", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkAlignment", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkEventBox", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkFrame", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkFrame/GtkAspectFrame", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkItem", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkItem/GtkListItem", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkItem/GtkMenuItem", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkItem/GtkMenuItem/GtkCheckMenuItem", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkItem/GtkMenuItem/GtkCheckMenuItem/GtkRadioMenuItem", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkItem/GtkTreeItem", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkItem/GtkTreeItem/(GtkHTreeItem)", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkViewport", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkWindow", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkWindow/GtkDialog", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkWindow/GtkDialog/GtkInputDialog", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBin/GtkWindow/GtkFileSelection", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBox", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBox/GtkButtonBox", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBox/GtkButtonBox/GtkHButtonBox", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBox/GtkButtonBox/GtkVButtonBox", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBox/GtkHBox", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBox/GtkVBox", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBox/GtkVBox/GtkColorSelection", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkBox/GtkVBox/GtkGammaCurve", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkButton", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkButton/GtkOptionMenu", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkButton/GtkToggleButton", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkButton/GtkToggleButton/GtkCheckButton", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkButton/GtkToggleButton/GtkCheckButton/GtkRadioButton", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkFixed", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkList", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkMenuShell", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkMenuShell/GtkMenu", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkMenuShell/GtkMenuBar", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkNotebook", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkPaned", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkPaned/GtkHPaned", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkPaned/GtkVPaned", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkScrolledWindow", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkTable", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkTree", NULL },
  { "GtkObject/GtkWidget/GtkContainer/GtkTree/(GtkVTree)", NULL },
  { "GtkObject/GtkWidget/GtkDrawingArea", NULL },
  { "GtkObject/GtkWidget/GtkDrawingArea/GtkCurve", NULL },
  { "GtkObject/GtkWidget/GtkEntry", NULL },
  { "GtkObject/GtkWidget/(GtkGLWidget)", NULL },
  { "GtkObject/GtkWidget/(GtkGLWidget)/(GtkGLRenderingArea)", NULL },
  { "GtkObject/GtkWidget/GtkMisc", NULL },
  { "GtkObject/GtkWidget/GtkMisc/GtkArrow", NULL },
  { "GtkObject/GtkWidget/GtkMisc/GtkImage", NULL },
  { "GtkObject/GtkWidget/GtkMisc/GtkLabel", NULL },
  { "GtkObject/GtkWidget/GtkMisc/GtkPixmap", NULL },
  { "GtkObject/GtkWidget/GtkPreview", NULL },
  { "GtkObject/GtkWidget/GtkProgressBar", NULL },
  { "GtkObject/GtkWidget/GtkRange", NULL },
  { "GtkObject/GtkWidget/GtkRange/GtkScale", NULL },
  { "GtkObject/GtkWidget/GtkRange/GtkScale/GtkHScale", NULL },
  { "GtkObject/GtkWidget/GtkRange/GtkScale/GtkVScale", NULL },
  { "GtkObject/GtkWidget/GtkRange/GtkScrollbar", NULL },
  { "GtkObject/GtkWidget/GtkRange/GtkScrollbar/GtkHScrollbar", NULL },
  { "GtkObject/GtkWidget/GtkRange/GtkScrollbar/GtkVScrollbar", NULL },
  { "GtkObject/GtkWidget/(GtkRootWindow)", NULL },
  { "GtkObject/GtkWidget/GtkRuler", NULL },
  { "GtkObject/GtkWidget/GtkRuler/GtkHRuler", NULL },
  { "GtkObject/GtkWidget/GtkRuler/GtkVRuler", NULL },
  { "GtkObject/GtkWidget/GtkSeparator", NULL },
  { "GtkObject/GtkWidget/GtkSeparator/GtkHSeparator", NULL },
  { "GtkObject/GtkWidget/GtkSeparator/GtkVSeparator", NULL },
  { "GtkObject/GtkWidget/GtkText", NULL },
  { "GtkObject/GtkWidget/(GtkTreeFork)", NULL },
  { "GtkObject/GtkWidget/(GtkTreeFork)/(GtkVTreeFork)", NULL },
};
gint ntree_items = sizeof(tree_items) / sizeof(tree_items[0]);


static void
toggle_show_tree_item (GtkWidget *widget,
		       GtkTreeItem *tree_item)
{
#  if 1
  if (tree_item->subtree && GTK_WIDGET_VISIBLE (tree_item->subtree))
    {
      gtk_tree_item_collapse (tree_item);
    }
  else
    {
      gtk_tree_item_expand (tree_item);
    }
#  else
  gtk_container_remove (GTK_WIDGET(tree_item)->parent, GTK_WIDGET(tree_item));
#  endif
}

void
button_size_request (GtkWidget *widget, GtkRequisition *requisition)
{
  requisition->width = 16;
  requisition->height = 8;
}

void
create_item (GtkTreePath *tree_path, GtkWidget *parent)
{
  GtkWidget *tree_item;
  GtkWidget *hbox;
  GtkWidget *label;

  tree_item = gtk_htree_item_new();
  hbox = gtk_hbox_new (FALSE, 3);
  gtk_container_add (GTK_CONTAINER (tree_item), hbox);
  label = gtk_label_new (tree_path->path);
  gtk_box_pack_start_defaults(GTK_BOX (hbox), label);
  gtk_widget_show (label);
  gtk_widget_show (hbox);

  gtk_container_add (GTK_CONTAINER (parent), tree_item);
  gtk_widget_show (tree_item);

  tree_path->widget = tree_item;
}

void
create_subtree (GtkTreePath *tree_path)
{
  GtkWidget *tree;
  GtkWidget *tree_fork;

  tree_fork = gtk_vtree_fork_new (GTK_VTREE_FORK_TYPE_B);
  gtk_tree_item_set_fork (GTK_TREE_ITEM (tree_path->widget),
			  tree_fork);
  gtk_widget_show (tree_fork);

  tree = gtk_vtree_new ();
  gtk_tree_item_set_subtree (GTK_TREE_ITEM (tree_path->widget), tree);
  gtk_widget_show(tree);


  {
    GtkWidget *hbox;
    GtkWidget *vbox;
    GtkWidget *button;

    hbox = GTK_WIDGET (GTK_BIN (tree_path->widget)->child);
    
    vbox = gtk_vbox_new (TRUE, 0);
    gtk_box_pack_start(GTK_BOX (hbox), vbox, FALSE, FALSE, 0);
    button = gtk_button_new ();
    GTK_WIDGET_UNSET_FLAGS (button, GTK_CAN_FOCUS);
    gtk_box_pack_start(GTK_BOX (vbox), button, FALSE, FALSE, 0);
    gtk_widget_show (button);
    gtk_widget_show (vbox);
    gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			       (GtkSignalFunc)toggle_show_tree_item,
			       GTK_OBJECT(tree_path->widget));
    gtk_signal_connect_object (GTK_OBJECT (button), "size_request",
			       (GtkSignalFunc)button_size_request,
			       GTK_OBJECT(tree_path->widget));
  }
}

static void
create_widgets()
{
    GtkTreeFactory *tree_factory;
    GtkWidget *tree;
    
    GtkWidget *dialog;
    GtkWidget *quit_button;
    GtkWidget *scrolled_window;

    dialog = gtk_dialog_new();

    scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_widget_set_usize (scrolled_window, 400, 300);
    gtk_box_pack_start_defaults(GTK_BOX (GTK_DIALOG (dialog)->vbox),
				scrolled_window);
    gtk_widget_show(scrolled_window);

    tree_factory = gtk_tree_factory_new();
    tree_factory->create_item = create_item;
    tree_factory->create_subtree = create_subtree;
    gtk_tree_factory_add_entries(tree_factory, tree_items, ntree_items);

    tree = tree_factory->widget;
    gtk_widget_show(tree);

    gtk_container_add(GTK_CONTAINER (scrolled_window), tree);

    quit_button = gtk_button_new_with_label("Quit");
    gtk_signal_connect(GTK_OBJECT(quit_button), "clicked",
		       (GtkSignalFunc)gtk_main_quit, NULL);
    gtk_widget_show(quit_button);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       quit_button, TRUE, TRUE, 0);

    gtk_widget_show(dialog);
}

int
main(int argc, char **argv)
{
    gtk_init(&argc, &argv);

    create_widgets();

    gtk_main();

    return 0;
}
