#!/usr/bin/perl -w

if (@ARGV != 1) {
    die "Usage: gen-color-table.pl rgb.txt > xpm-color-table.h\n";
}

open IN, $ARGV[0] || die "Cannot open $ARGV[0]: $!\n";

@colors = ();
while (defined($_ = <IN>)) {
    next if /^!/;
    if (!/^\s*([0-9]+)\s+([0-9]+)\s+([0-9]+)\s+(.*\S)\s+$/) {
	die "Cannot parse line $_";
    }

    push @colors, [$1, $2, $3, $4];
}

@colors = sort { lc($a->[3]) cmp lc($b->[3]) } @colors;

$offset = 0;

$date = gmtime;

print <<EOT;
/* xpm-color-table.h: Generated by gen-color-table.pl from rgb.txt
 *
 *  Date: $date
 *
 * Do not edit.   
 */
static const char color_names[] =
EOT

for $color (@colors) {
    $name = $color->[3];

    if ($offset != 0) {
	print qq(\n);
    }
    print qq(  "$name\\0");

    $color->[4] = $offset;
    $offset += length($name) + 1;
}

print ";\n\n";

print <<EOT;
typedef struct {
    guint16 name_offset;
    guchar red;
    guchar green;
    guchar blue;
} XPMColorEntry;

static const XPMColorEntry xColors[] = {
EOT

$i = 0;
for $color (@colors) {
    $red = $color->[0];
    $green = $color->[1];
    $blue = $color->[2];
    $offset = $color->[4];

    if ($i != 0) {
	print ",\n";
    }
    print "  { $offset, $red, $green, $blue }";
    $i++;
}

print "\n};\n";
