static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Kevin Cozens <kcozens@cvs.gimp.org>                         \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"  description (_(\"Path of file to load\"))                                   \n"
"property_uri (uri, _(\"URI\"), \"\")                                          \n"
"  description (_(\"URI for file to load\"))                                   \n"
"                                                                              \n"
"property_int (width, _(\"Width\"), -1)                                        \n"
"  description (_(\"Width for rendered image\"))                               \n"
"property_int (height, _(\"Height\"), -1)                                      \n"
"  description (_(\"Height for rendered image\"))                              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE svg-load.c                                           \n"
"                                                                              \n"
"#include <gegl-op.h>                                                          \n"
"#include <cairo.h>                                                            \n"
"#include <gegl-gio-private.h>                                                 \n"
"#include <librsvg/rsvg.h>                                                     \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GFile *file;                                                                \n"
"                                                                              \n"
"  RsvgHandle *handle;                                                         \n"
"                                                                              \n"
"  const Babl *format;                                                         \n"
"                                                                              \n"
"  gint width;                                                                 \n"
"  gint height;                                                                \n"
"} Priv;                                                                       \n"
"                                                                              \n"
"static void                                                                   \n"
"cleanup (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv *p = (Priv*) o->user_data;                                             \n"
"                                                                              \n"
"  if (p != NULL)                                                              \n"
"    {                                                                         \n"
"      if (p->handle != NULL)                                                  \n"
"        g_clear_object (&p->handle);                                          \n"
"                                                                              \n"
"      if (p->file != NULL)                                                    \n"
"        g_clear_object(&p->file);                                             \n"
"                                                                              \n"
"      p->width = p->height = 0;                                               \n"
"      p->format = NULL;                                                       \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"query_svg (GeglOperation *operation)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv *p = (Priv*) o->user_data;                                             \n"
"  RsvgDimensionData dimentions;                                               \n"
"                                                                              \n"
"  g_return_val_if_fail (p->handle != NULL, FALSE);                            \n"
"                                                                              \n"
"  rsvg_handle_get_dimensions (p->handle, &dimentions);                        \n"
"                                                                              \n"
"  p->format = babl_format (\"R'G'B'A u8\");                                   \n"
"                                                                              \n"
"  p->height = dimentions.height;                                              \n"
"  p->width = dimentions.width;                                                \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gint                                                                   \n"
"load_svg (GeglOperation *operation,                                           \n"
"          GeglBuffer    *output,                                              \n"
"          gint           width,                                               \n"
"          gint           height)                                              \n"
"{                                                                             \n"
"    GeglProperties    *o = GEGL_PROPERTIES (operation);                       \n"
"    Priv              *p = (Priv*) o->user_data;                              \n"
"    cairo_surface_t   *surface;                                               \n"
"    cairo_t           *cr;                                                    \n"
"                                                                              \n"
"    g_return_val_if_fail (p->handle != NULL, -1);                             \n"
"                                                                              \n"
"    surface = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width, height);\n"
"    cr = cairo_create (surface);                                              \n"
"                                                                              \n"
"    if (width != p->width || height != p->height)                             \n"
"      {                                                                       \n"
"        cairo_scale (cr,                                                      \n"
"                     (double)width / (double)p->width,                        \n"
"                     (double)height / (double)p->height);                     \n"
"      }                                                                       \n"
"                                                                              \n"
"    rsvg_handle_render_cairo (p->handle, cr);                                 \n"
"                                                                              \n"
"    cairo_surface_flush (surface);                                            \n"
"                                                                              \n"
"    gegl_buffer_set (output,                                                  \n"
"                     GEGL_RECTANGLE (0, 0, width, height),                    \n"
"                     0,                                                       \n"
"                     babl_format (\"cairo-ARGB32\"),                          \n"
"                     cairo_image_surface_get_data (surface),                  \n"
"                     cairo_image_surface_get_stride (surface));               \n"
"                                                                              \n"
"    cairo_destroy (cr);                                                       \n"
"    cairo_surface_destroy (surface);                                          \n"
"                                                                              \n"
"    return 0;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv *p = (o->user_data) ? o->user_data : g_new0 (Priv, 1);                 \n"
"  GError *error = NULL;                                                       \n"
"  GInputStream *stream;                                                       \n"
"  GFile *file = NULL;                                                         \n"
"                                                                              \n"
"  g_assert (p != NULL);                                                       \n"
"                                                                              \n"
"  if (p->file != NULL && (o->uri || o->path))                                 \n"
"    {                                                                         \n"
"      if (o->uri && strlen (o->uri) > 0)                                      \n"
"        file = g_file_new_for_uri (o->uri);                                   \n"
"      else if (o->path && strlen (o->path) > 0)                               \n"
"        file = g_file_new_for_path (o->path);                                 \n"
"      if (file != NULL)                                                       \n"
"        {                                                                     \n"
"          if (!g_file_equal (p->file, file))                                  \n"
"            cleanup (operation);                                              \n"
"          g_object_unref (file);                                              \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  o->user_data = (void*) p;                                                   \n"
"                                                                              \n"
"  if (p->handle == NULL)                                                      \n"
"    {                                                                         \n"
"      stream = gegl_gio_open_input_stream (o->uri, o->path, &p->file, &error);\n"
"      if (stream == NULL)                                                     \n"
"        {                                                                     \n"
"          g_warning (\"%s\", error->message);                                 \n"
"          g_error_free (error);                                               \n"
"          cleanup (operation);                                                \n"
"          return;                                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      p->handle = rsvg_handle_new_from_stream_sync (stream, p->file,          \n"
"                                                    RSVG_HANDLE_FLAGS_NONE,   \n"
"                                                    NULL, &error);            \n"
"      if (p->handle == NULL)                                                  \n"
"        {                                                                     \n"
"          g_warning (\"%s\", error->message);                                 \n"
"          g_error_free (error);                                               \n"
"          cleanup (operation);                                                \n"
"          return;                                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (!query_svg (operation))                                             \n"
"        {                                                                     \n"
"          g_warning (\"could not query SVG image file\");                     \n"
"          cleanup (operation);                                                \n"
"          return;                                                             \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"output\", p->format);               \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle result = { 0, 0, 0, 0 };                                      \n"
"  Priv *p = (Priv*) o->user_data;                                             \n"
"  gint width = o->width;                                                      \n"
"  gint height = o->height;                                                    \n"
"                                                                              \n"
"  if (p->handle != NULL)                                                      \n"
"    {                                                                         \n"
"      if (width < 1)                                                          \n"
"        width = p->width;                                                     \n"
"      if (height < 1)                                                         \n"
"        height = p->height;                                                   \n"
"                                                                              \n"
"      result.width = width;                                                   \n"
"      result.height = height;                                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv *p = (Priv*) o->user_data;                                             \n"
"  gint width = o->width;                                                      \n"
"  gint height = o->height;                                                    \n"
"                                                                              \n"
"  if (p->handle != NULL)                                                      \n"
"  {                                                                           \n"
"    if (width < 1)                                                            \n"
"      width = p->width;                                                       \n"
"    if (height < 1)                                                           \n"
"      height = p->height;                                                     \n"
"                                                                              \n"
"    if (load_svg (operation, output, width, height))                          \n"
"      {                                                                       \n"
"        if (o->uri != NULL && strlen(o->uri) > 0)                             \n"
"          g_warning (\"failed to render SVG from %s\", o->uri);               \n"
"        else                                                                  \n"
"          g_warning (\"failed to render SVG from %s\", o->path);              \n"
"        return FALSE;                                                         \n"
"      }                                                                       \n"
"                                                                              \n"
"    return TRUE;                                                              \n"
"  }                                                                           \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->user_data != NULL)                                                   \n"
"    {                                                                         \n"
"      cleanup (GEGL_OPERATION (object));                                      \n"
"      if (o->user_data != NULL)                                               \n"
"        g_free (o->user_data);                                                \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  G_OBJECT_CLASS(klass)->finalize = finalize;                                 \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process = process;                                            \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:svg-load\",                                      \n"
"    \"title\",        _(\"SVG File Loader\"),                                 \n"
"    \"categories\"  , \"input\",   /* not hidden because it has extra API */  \n"
"    \"description\" , _(\"Load an SVG file using librsvg\"),                  \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \"image/svg+xml\", \"gegl:svg-load\");                                    \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \".svg\", \"gegl:svg-load\");                                             \n"
"                                                                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \"image/svg+xml-compressed\", \"gegl:svg-load\");                         \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \".svgz\", \"gegl:svg-load\");                                            \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
