static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" *           2006 Dominik Ernst <dernst@gmx.de>                               \n"
" *           2006 Kevin Cozens <kcozens@cvs.gnome.org>                        \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <gegl-gio-private.h>                                                 \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"  description (_(\"Path of file to load.\"))                                  \n"
"property_uri (uri, _(\"URI\"), \"\")                                          \n"
"  description (_(\"URI for file to load.\"))                                  \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE png-load.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <png.h>                                                              \n"
"                                                                              \n"
"                                                                              \n"
"#define WARN_IF_ERROR(gerror) \\                                              \n"
"do { \\                                                                       \n"
"    if (gerror) { \\                                                          \n"
"      g_warning(\"gegl:png-load %s\", gerror->message); \\                    \n"
"    } \\                                                                      \n"
"} while(0)                                                                    \n"
"                                                                              \n"
"typedef enum {                                                                \n"
"  LOAD_PNG_TOO_SHORT,                                                         \n"
"  LOAD_PNG_WRONG_HEADER                                                       \n"
"} LoadPngErrors;                                                              \n"
"                                                                              \n"
"static GQuark error_quark(void)                                               \n"
"{                                                                             \n"
"  return g_quark_from_static_string (\"gegl:load-png-error-quark\");          \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"read_fn(png_structp png_ptr, png_bytep buffer, png_size_t length)             \n"
"{                                                                             \n"
"  GError *err = NULL;                                                         \n"
"  GInputStream *stream = G_INPUT_STREAM(png_get_io_ptr(png_ptr));             \n"
"  gsize bytes_read = 0;                                                       \n"
"  g_assert(stream);                                                           \n"
"                                                                              \n"
"  g_input_stream_read_all(stream, buffer, length, &bytes_read, NULL, &err);   \n"
"  if (err) {                                                                  \n"
"    g_printerr(\"gegl:load-png %s: %s\\n\", __PRETTY_FUNCTION__, err->message);\n"
"  }                                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"error_fn(png_structp png_ptr, png_const_charp msg)                            \n"
"{                                                                             \n"
"  g_printerr(\"LIBPNG ERROR: %s\", msg);                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"check_valid_png_header(GInputStream *stream, GError **err)                    \n"
"{                                                                             \n"
"  const size_t hdr_size=8;                                                    \n"
"  gssize hdr_read_size;                                                       \n"
"  unsigned char header[hdr_size];                                             \n"
"                                                                              \n"
"  hdr_read_size = g_input_stream_read(G_INPUT_STREAM(stream), header, hdr_size, NULL, err);\n"
"  if (hdr_read_size == -1)                                                    \n"
"    {                                                                         \n"
"      // err should be set by _read()                                         \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"  else if (hdr_read_size < hdr_size)                                          \n"
"    {                                                                         \n"
"      g_set_error(err, error_quark(), LOAD_PNG_TOO_SHORT,                     \n"
"                 \"too short for a png file, only %lu bytes.\",               \n"
"                 (unsigned long)hdr_read_size);                               \n"
"                                                                              \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"  else if (hdr_read_size > hdr_size)                                          \n"
"    {                                                                         \n"
"        const gboolean reached = TRUE;                                        \n"
"        g_assert(!reached);                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (png_sig_cmp (header, 0, hdr_size))                                      \n"
"    {                                                                         \n"
"      g_set_error(err, error_quark(), LOAD_PNG_WRONG_HEADER, \"wrong png header\");\n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static const Babl *                                                           \n"
"get_babl_format(int bit_depth, int color_type)                                \n"
"{                                                                             \n"
"   gchar format_string[32];                                                   \n"
"                                                                              \n"
"   if (color_type & PNG_COLOR_TYPE_RGB)                                       \n"
"      {                                                                       \n"
"        if (color_type & PNG_COLOR_MASK_ALPHA)                                \n"
"          strcpy (format_string, \"R'G'B'A \");                               \n"
"        else                                                                  \n"
"          strcpy (format_string, \"R'G'B' \");                                \n"
"      }                                                                       \n"
"    else if ((color_type & PNG_COLOR_TYPE_GRAY) == PNG_COLOR_TYPE_GRAY)       \n"
"      {                                                                       \n"
"        if (color_type & PNG_COLOR_MASK_ALPHA)                                \n"
"          strcpy (format_string, \"Y'A \");                                   \n"
"        else                                                                  \n"
"          strcpy (format_string, \"Y' \");                                    \n"
"      }                                                                       \n"
"    else if (color_type & PNG_COLOR_TYPE_PALETTE)                             \n"
"      {                                                                       \n"
"        if (color_type & PNG_COLOR_MASK_ALPHA)                                \n"
"          strcpy (format_string, \"R'G'B'A \");                               \n"
"        else                                                                  \n"
"          strcpy (format_string, \"R'G'B' \");                                \n"
"      }                                                                       \n"
"    else                                                                      \n"
"      {                                                                       \n"
"        return NULL;                                                          \n"
"      }                                                                       \n"
"                                                                              \n"
"    if (bit_depth <= 8)                                                       \n"
"      {                                                                       \n"
"        strcat (format_string, \"u8\");                                       \n"
"      }                                                                       \n"
"    else if(bit_depth == 16)                                                  \n"
"      {                                                                       \n"
"        strcat (format_string, \"u16\");                                      \n"
"      }                                                                       \n"
"    else                                                                      \n"
"      {                                                                       \n"
"        return NULL;                                                          \n"
"      }                                                                       \n"
"                                                                              \n"
"    return babl_format (format_string);                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static gint                                                                   \n"
"gegl_buffer_import_png (GeglBuffer  *gegl_buffer,                             \n"
"                        GInputStream *stream,                                 \n"
"                        gint         dest_x,                                  \n"
"                        gint         dest_y,                                  \n"
"                        gint        *ret_width,                               \n"
"                        gint        *ret_height,                              \n"
"                        const Babl  *format, // can be NULL                   \n"
"                        GError **err)                                         \n"
"{                                                                             \n"
"  gint           width;                                                       \n"
"  gint           bit_depth;                                                   \n"
"  gint           bpp;                                                         \n"
"  gint           number_of_passes=1;                                          \n"
"  png_uint_32    w;                                                           \n"
"  png_uint_32    h;                                                           \n"
"  png_structp    load_png_ptr;                                                \n"
"  png_infop      load_info_ptr;                                               \n"
"  guchar        *pixels;                                                      \n"
"  /*png_bytep     *rows;*/                                                    \n"
"                                                                              \n"
"                                                                              \n"
"  unsigned   int i;                                                           \n"
"  png_bytep  *row_p = NULL;                                                   \n"
"                                                                              \n"
"  g_return_val_if_fail(stream, -1);                                           \n"
"                                                                              \n"
"  if (!check_valid_png_header(stream, err))                                   \n"
"    {                                                                         \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  load_png_ptr = png_create_read_struct (PNG_LIBPNG_VER_STRING, NULL, error_fn, NULL);\n"
"                                                                              \n"
"  if (!load_png_ptr)                                                          \n"
"    {                                                                         \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  load_info_ptr = png_create_info_struct (load_png_ptr);                      \n"
"  if (!load_info_ptr)                                                         \n"
"    {                                                                         \n"
"      png_destroy_read_struct (&load_png_ptr, &load_info_ptr, NULL);          \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (setjmp (png_jmpbuf (load_png_ptr)))                                     \n"
"    {                                                                         \n"
"      png_destroy_read_struct (&load_png_ptr, &load_info_ptr, NULL);          \n"
"     if (row_p)                                                               \n"
"        g_free (row_p);                                                       \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  png_set_read_fn(load_png_ptr, stream, read_fn);                             \n"
"                                                                              \n"
"  png_set_sig_bytes (load_png_ptr, 8); // we already read header              \n"
"  png_read_info (load_png_ptr, load_info_ptr);                                \n"
"  {                                                                           \n"
"    int color_type;                                                           \n"
"    int interlace_type;                                                       \n"
"                                                                              \n"
"    png_get_IHDR (load_png_ptr,                                               \n"
"                  load_info_ptr,                                              \n"
"                  &w, &h,                                                     \n"
"                  &bit_depth,                                                 \n"
"                  &color_type,                                                \n"
"                  &interlace_type,                                            \n"
"                  NULL, NULL);                                                \n"
"    width = w;                                                                \n"
"    if (ret_width)                                                            \n"
"      *ret_width = w;                                                         \n"
"    if (ret_height)                                                           \n"
"      *ret_height = h;                                                        \n"
"                                                                              \n"
"    if (color_type == PNG_COLOR_TYPE_GRAY && bit_depth < 8)                   \n"
"      {                                                                       \n"
"        png_set_expand (load_png_ptr);                                        \n"
"        bit_depth = 8;                                                        \n"
"      }                                                                       \n"
"                                                                              \n"
"    if (png_get_valid (load_png_ptr, load_info_ptr, PNG_INFO_tRNS))           \n"
"      {                                                                       \n"
"        png_set_tRNS_to_alpha (load_png_ptr);                                 \n"
"        color_type |= PNG_COLOR_MASK_ALPHA;                                   \n"
"      }                                                                       \n"
"                                                                              \n"
"    switch (color_type)                                                       \n"
"      {                                                                       \n"
"        case PNG_COLOR_TYPE_GRAY:                                             \n"
"          bpp = 1;                                                            \n"
"          break;                                                              \n"
"        case PNG_COLOR_TYPE_GRAY_ALPHA:                                       \n"
"          bpp = 2;                                                            \n"
"          break;                                                              \n"
"        case PNG_COLOR_TYPE_RGB:                                              \n"
"          bpp = 3;                                                            \n"
"          break;                                                              \n"
"        case PNG_COLOR_TYPE_RGB_ALPHA:                                        \n"
"          bpp = 4;                                                            \n"
"          break;                                                              \n"
"        case (PNG_COLOR_TYPE_PALETTE | PNG_COLOR_MASK_ALPHA):                 \n"
"          bpp = 4;                                                            \n"
"          break;                                                              \n"
"        case PNG_COLOR_TYPE_PALETTE:                                          \n"
"          bpp = 3;                                                            \n"
"          break;                                                              \n"
"        default:                                                              \n"
"          g_warning (\"color type mismatch\");                                \n"
"          png_destroy_read_struct (&load_png_ptr, &load_info_ptr, NULL);      \n"
"          return -1;                                                          \n"
"      }                                                                       \n"
"                                                                              \n"
"    if (color_type == PNG_COLOR_TYPE_PALETTE)                                 \n"
"      png_set_palette_to_rgb (load_png_ptr);                                  \n"
"                                                                              \n"
"    if (bit_depth == 16)                                                      \n"
"      bpp = bpp << 1;                                                         \n"
"                                                                              \n"
"    if (!format)                                                              \n"
"      format = get_babl_format(bit_depth, color_type);                        \n"
"                                                                              \n"
"#if BYTE_ORDER == LITTLE_ENDIAN                                               \n"
"    if (bit_depth == 16)                                                      \n"
"      png_set_swap (load_png_ptr);                                            \n"
"#endif                                                                        \n"
"                                                                              \n"
"    if (interlace_type == PNG_INTERLACE_ADAM7)                                \n"
"      number_of_passes = png_set_interlace_handling (load_png_ptr);           \n"
"                                                                              \n"
"    if (png_get_valid (load_png_ptr, load_info_ptr, PNG_INFO_gAMA))           \n"
"      {                                                                       \n"
"        gdouble gamma;                                                        \n"
"        png_get_gAMA (load_png_ptr, load_info_ptr, &gamma);                   \n"
"        png_set_gamma (load_png_ptr, 2.2, gamma);                             \n"
"      }                                                                       \n"
"    else                                                                      \n"
"      {                                                                       \n"
"        png_set_gamma (load_png_ptr, 2.2, 0.45455);                           \n"
"      }                                                                       \n"
"                                                                              \n"
"    png_read_update_info (load_png_ptr, load_info_ptr);                       \n"
"  }                                                                           \n"
"                                                                              \n"
"  pixels = g_malloc0 (width*bpp);                                             \n"
"                                                                              \n"
"  {                                                                           \n"
"    gint           pass;                                                      \n"
"    GeglRectangle  rect;                                                      \n"
"                                                                              \n"
"    for (pass=0; pass<number_of_passes; pass++)                               \n"
"      {                                                                       \n"
"        for(i=0; i<h; i++)                                                    \n"
"          {                                                                   \n"
"            gegl_rectangle_set (&rect, 0, i, width, 1);                       \n"
"                                                                              \n"
"            if (pass != 0)                                                    \n"
"              gegl_buffer_get (gegl_buffer, &rect, 1.0, format, pixels, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"                                                                              \n"
"            png_read_rows (load_png_ptr, &pixels, NULL, 1);                   \n"
"            gegl_buffer_set (gegl_buffer, &rect, 0, format, pixels,           \n"
"                             GEGL_AUTO_ROWSTRIDE);                            \n"
"          }                                                                   \n"
"      }                                                                       \n"
"  }                                                                           \n"
"                                                                              \n"
"                                                                              \n"
"  png_read_end (load_png_ptr, NULL);                                          \n"
"  png_destroy_read_struct (&load_png_ptr, &load_info_ptr, NULL);              \n"
"                                                                              \n"
"  g_free (pixels);                                                            \n"
"                                                                              \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"                                                                              \n"
"static gint query_png (GInputStream *stream,                                  \n"
"                       gint        *width,                                    \n"
"                       gint        *height,                                   \n"
"                       const Babl  **format,                                  \n"
"                       GError **err)                                          \n"
"{                                                                             \n"
"  png_uint_32   w;                                                            \n"
"  png_uint_32   h;                                                            \n"
"  png_structp   load_png_ptr;                                                 \n"
"  png_infop     load_info_ptr;                                                \n"
"                                                                              \n"
"  png_bytep  *row_p = NULL;                                                   \n"
"  g_return_val_if_fail(stream, -1);                                           \n"
"                                                                              \n"
"  if (!check_valid_png_header(stream, err))                                   \n"
"    {                                                                         \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  load_png_ptr = png_create_read_struct (PNG_LIBPNG_VER_STRING, NULL, error_fn, NULL);\n"
"  if (!load_png_ptr)                                                          \n"
"    {                                                                         \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  load_info_ptr = png_create_info_struct (load_png_ptr);                      \n"
"  if (!load_info_ptr)                                                         \n"
"    {                                                                         \n"
"      png_destroy_read_struct (&load_png_ptr, &load_info_ptr, NULL);          \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (setjmp (png_jmpbuf (load_png_ptr)))                                     \n"
"    {                                                                         \n"
"     png_destroy_read_struct (&load_png_ptr, &load_info_ptr, NULL);           \n"
"     if (row_p)                                                               \n"
"        g_free (row_p);                                                       \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  png_set_read_fn(load_png_ptr, stream, read_fn);                             \n"
"  png_set_sig_bytes (load_png_ptr, 8); // we already read header              \n"
"  png_read_info (load_png_ptr, load_info_ptr);                                \n"
"  {                                                                           \n"
"    int bit_depth;                                                            \n"
"    int color_type;                                                           \n"
"    const Babl *f;                                                            \n"
"                                                                              \n"
"    png_get_IHDR (load_png_ptr,                                               \n"
"                  load_info_ptr,                                              \n"
"                  &w, &h,                                                     \n"
"                  &bit_depth,                                                 \n"
"                  &color_type,                                                \n"
"                  NULL, NULL, NULL);                                          \n"
"    *width = w;                                                               \n"
"    *height = h;                                                              \n"
"                                                                              \n"
"    if (png_get_valid (load_png_ptr, load_info_ptr, PNG_INFO_tRNS))           \n"
"      color_type |= PNG_COLOR_MASK_ALPHA;                                     \n"
"                                                                              \n"
"    f = get_babl_format(bit_depth, color_type);                               \n"
"    if (!f)                                                                   \n"
"      {                                                                       \n"
"        png_destroy_read_struct (&load_png_ptr, &load_info_ptr, NULL);        \n"
"        return -1;                                                            \n"
"      }                                                                       \n"
"    *format = f;                                                              \n"
"                                                                              \n"
"  }                                                                           \n"
"  png_destroy_read_struct (&load_png_ptr, &load_info_ptr, NULL);              \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  GeglRectangle result = {0,0,0,0};                                           \n"
"  gint          width, height;                                                \n"
"  gint          status;                                                       \n"
"  const Babl *  format;                                                       \n"
"  GError *err = NULL;                                                         \n"
"  GFile *infile = NULL;                                                       \n"
"                                                                              \n"
"  GInputStream *stream = gegl_gio_open_input_stream(o->uri, o->path, &infile, &err);\n"
"  WARN_IF_ERROR(err);                                                         \n"
"  if (!stream) return result;                                                 \n"
"  status = query_png(stream, &width, &height, &format, &err);                 \n"
"  WARN_IF_ERROR(err);                                                         \n"
"  g_input_stream_close(stream, NULL, NULL);                                   \n"
"                                                                              \n"
"  if (status)                                                                 \n"
"    {                                                                         \n"
"      width = 0;                                                              \n"
"      height = 0;                                                             \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"  result.width  = width;                                                      \n"
"  result.height  = height;                                                    \n"
"                                                                              \n"
"  if (infile) g_object_unref(infile);                                         \n"
"  g_object_unref(stream);                                                     \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gint        problem;                                                        \n"
"  gint        width, height;                                                  \n"
"  Babl        *format = NULL;                                                 \n"
"  GError *err = NULL;                                                         \n"
"  GFile *infile = NULL;                                                       \n"
"  GInputStream *stream = gegl_gio_open_input_stream(o->uri, o->path, &infile, &err);\n"
"  WARN_IF_ERROR(err);                                                         \n"
"  problem = gegl_buffer_import_png (output, stream, 0, 0,                     \n"
"                                    &width, &height, format, &err);           \n"
"  WARN_IF_ERROR(err);                                                         \n"
"  g_input_stream_close(stream, NULL, NULL);                                   \n"
"                                                                              \n"
"  if (problem)                                                                \n"
"    {                                                                         \n"
"      g_object_unref(infile);                                                 \n"
"      g_object_unref(stream);                                                 \n"
"      g_warning (\"%s failed to open file %s for reading.\",                  \n"
"                 G_OBJECT_TYPE_NAME (operation), o->path);                    \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"  if (infile) g_object_unref(infile);                                         \n"
"  g_object_unref(stream);                                                     \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process = process;                                            \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:png-load\",                                      \n"
"    \"title\",        _(\"PNG File Loader\"),                                 \n"
"    \"categories\",   \"hidden\",                                             \n"
"    \"description\",  _(\"PNG image loader.\"),                               \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"/*  static gboolean done=FALSE;                                               \n"
"    if (done)                                                                 \n"
"      return; */                                                              \n"
"  gegl_extension_handler_register_loader (\".png\", \"gegl:png-load\");       \n"
"/*  done = TRUE; */                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
