static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" *           2013 Daniel Sabo                                                 \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (x, _(\"X\"), 42)                                             \n"
"    description(_(\"Horizontal position\"))                                   \n"
"    ui_meta    (\"unit\", \"pixel-coordinate\")                               \n"
"    ui_meta    (\"axis\", \"x\")                                              \n"
"                                                                              \n"
"property_double (y, _(\"Y\"), 42)                                             \n"
"    description(_(\"Vertical position\"))                                     \n"
"    ui_meta    (\"unit\", \"pixel-coordinate\")                               \n"
"    ui_meta    (\"axis\", \"y\")                                              \n"
"                                                                              \n"
"property_double (width, _(\"Width\"), 23)                                     \n"
"    description (_(\"Horizontal extent\"))                                    \n"
"    value_range (0, G_MAXDOUBLE)                                              \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_double (height, _(\"Height\"), 42)                                   \n"
"    description (_(\"Vertical extent\"))                                      \n"
"    value_range (0, G_MAXDOUBLE)                                              \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_color  (color, _(\"Color\"), \"green\")                              \n"
"    description (_(\"Color to render\"))                                      \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_META                                                          \n"
"#define GEGL_OP_NAME     rectangle                                            \n"
"#define GEGL_OP_C_SOURCE rectangle.c                                          \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void attach (GeglOperation *operation)                                 \n"
"{                                                                             \n"
"  GeglNode *gegl = operation->node;                                           \n"
"  GeglNode *output, *color, *crop;                                            \n"
"                                                                              \n"
"  output = gegl_node_get_output_proxy (gegl, \"output\");                     \n"
"                                                                              \n"
"  color = gegl_node_new_child (gegl, \"operation\", \"gegl:color\", NULL);    \n"
"  crop  = gegl_node_new_child (gegl, \"operation\", \"gegl:crop\", NULL);     \n"
"                                                                              \n"
"  gegl_operation_meta_watch_node (operation, color);                          \n"
"  gegl_operation_meta_watch_node (operation, crop);                           \n"
"                                                                              \n"
"  gegl_node_link_many (color, crop, output, NULL);                            \n"
"                                                                              \n"
"  gegl_operation_meta_redirect (operation, \"color\", color, \"value\");      \n"
"  gegl_operation_meta_redirect (operation, \"x\", crop, \"x\");               \n"
"  gegl_operation_meta_redirect (operation, \"y\", crop, \"y\");               \n"
"  gegl_operation_meta_redirect (operation, \"width\", crop, \"width\");       \n"
"  gegl_operation_meta_redirect (operation, \"height\", crop, \"height\");     \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class = GEGL_OPERATION_CLASS (klass);         \n"
"                                                                              \n"
"  operation_class->attach = attach;                                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"  \"name\",               \"gegl:rectangle\",                                 \n"
"  \"title\",              _(\"Rectangle\"),                                   \n"
"  \"categories\",         \"render\",                                         \n"
"  \"reference-hash\", \"9014b57418e4de6d9a4081edff968de0\",                   \n"
"  \"position-dependent\", \"true\",                                           \n"
"  \"description\",                                                            \n"
"        _(\"A rectangular source of a fixed size with a solid color\"),       \n"
"        NULL);                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
