static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (s_amount, _(\"shadows amount\"), 0.2)                        \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (s_tonalwidth, _(\"shadows tonal width\"), 0.1)               \n"
"    value_range (0.001, 1.0)                                                  \n"
"                                                                              \n"
"property_double (s_radius, _(\"shadows radius\"), 5.0)                        \n"
"    value_range (0.0, 100.0)                                                  \n"
"                                                                              \n"
"property_double (h_amount, _(\"highlights amount\"), 0.2)                     \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (h_tonalwidth, _(\"highlights tonal width\"), 0.1)            \n"
"    value_range (0.001, 1.0)                                                  \n"
"                                                                              \n"
"property_double (h_radius, _(\"highlights radius\"), 5.0)                     \n"
"    value_range (0.0, 100.0)                                                  \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_META                                                          \n"
"#define GEGL_OP_NAME     shadows_highlights                                   \n"
"#define GEGL_OP_C_SOURCE shadows-highlights.c                                 \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"attach (GeglOperation *operation)                                             \n"
"{                                                                             \n"
"  GeglNode *gegl;                                                             \n"
"  GeglNode *input;                                                            \n"
"  GeglNode *output;                                                           \n"
"  GeglNode *s_blur;                                                           \n"
"  GeglNode *h_blur;                                                           \n"
"  GeglNode *shprocess;                                                        \n"
"                                                                              \n"
"  gegl   = operation->node;                                                   \n"
"  input  = gegl_node_get_input_proxy (gegl, \"input\");                       \n"
"  output = gegl_node_get_output_proxy (gegl, \"output\");                     \n"
"                                                                              \n"
"  s_blur = gegl_node_new_child (gegl,                                         \n"
"                                \"operation\",    \"gegl:gaussian-blur\",     \n"
"                                \"abyss-policy\", 1,                          \n"
"                                NULL);                                        \n"
"                                                                              \n"
"  h_blur = gegl_node_new_child (gegl,                                         \n"
"                                \"operation\",    \"gegl:gaussian-blur\",     \n"
"                                \"abyss-policy\", 1,                          \n"
"                                NULL);                                        \n"
"                                                                              \n"
"  shprocess = gegl_node_new_child (gegl,                                      \n"
"                                   \"operation\", \"gegl:shadows-highlights-correction\",\n"
"                                   NULL);                                     \n"
"                                                                              \n"
"  gegl_node_link (input, s_blur);                                             \n"
"  gegl_node_link (input, h_blur);                                             \n"
"  gegl_node_link_many (input, shprocess, output, NULL);                       \n"
"                                                                              \n"
"  gegl_node_connect_to (s_blur, \"output\", shprocess, \"aux\");              \n"
"  gegl_node_connect_to (h_blur, \"output\", shprocess, \"aux2\");             \n"
"                                                                              \n"
"  gegl_operation_meta_redirect (operation, \"s-amount\", shprocess, \"s-amount\");\n"
"  gegl_operation_meta_redirect (operation, \"s-tonalwidth\", shprocess, \"s-tonalwidth\");\n"
"  gegl_operation_meta_redirect (operation, \"s-radius\", s_blur, \"std-dev-x\");\n"
"  gegl_operation_meta_redirect (operation, \"s-radius\", s_blur, \"std-dev-y\");\n"
"  gegl_operation_meta_redirect (operation, \"h-amount\", shprocess, \"h-amount\");\n"
"  gegl_operation_meta_redirect (operation, \"h-tonalwidth\", shprocess, \"h-tonalwidth\");\n"
"  gegl_operation_meta_redirect (operation, \"h-radius\", h_blur, \"std-dev-x\");\n"
"  gegl_operation_meta_redirect (operation, \"h-radius\", h_blur, \"std-dev-y\");\n"
"                                                                              \n"
"  gegl_operation_meta_watch_nodes (operation, s_blur, h_blur, shprocess, NULL);\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class;                                        \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  operation_class->attach = attach;                                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:shadows-highlights\",                             \n"
"    \"title\",       _(\"Shadows Highlights\"),                               \n"
"    \"categories\",  \"light\",                                               \n"
"    \"description\", _(\"Performs shadows and highlights correction\"),       \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
