static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2007 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int (x0, _(\"X0\"), 0)                                               \n"
"  description (_(\"Start x coordinate\"))                                     \n"
"  value_range (0, 1000)                                                       \n"
"property_int (x1, _(\"X1\"), 0)                                               \n"
"  description (_(\"End x coordinate\"))                                       \n"
"  value_range (0, 1000)                                                       \n"
"                                                                              \n"
"property_int (y0, _(\"Y0\"), 0)                                               \n"
"  description (_(\"Start y coordinate\"))                                     \n"
"  value_range (0, 1000)                                                       \n"
"property_int (y1, _(\"Y1\"), 0)                                               \n"
"  description (_(\"End y coordinate\"))                                       \n"
"  value_range (0, 1000)                                                       \n"
"                                                                              \n"
"property_int (width,  _(\"Width\"),  1024)                                    \n"
"  value_range (10, 10000)                                                     \n"
"property_int (height,  _(\"Height\"),  256)                                   \n"
"  value_range (10, 10000)                                                     \n"
"                                                                              \n"
"property_double (min, _(\"Min\"), 500)                                        \n"
"  value_range (-500.0, 500)                                                   \n"
"  description (_(\"Value at bottom\"))                                        \n"
"                                                                              \n"
"property_double (max, _(\"Max\"), 8.0)                                        \n"
"  value_range (-500.0, 500)                                                   \n"
"  description (_(\"Value at top\"))                                           \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     line_profile                                         \n"
"#define GEGL_OP_C_SOURCE line-profile.c                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <cairo.h>                                                            \n"
"                                                                              \n"
"static gfloat                                                                 \n"
"buffer_sample (GeglBuffer *buffer,                                            \n"
"               gint        x,                                                 \n"
"               gint        y,                                                 \n"
"               gint        component)                                         \n"
"{                                                                             \n"
"  gfloat rgba[4];                                                             \n"
"  GeglRectangle roi = {x,y,1,1};                                              \n"
"                                                                              \n"
"  gegl_buffer_get (buffer, &roi, 1.0, babl_format (\"RGBA float\"), &rgba[0], GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"  return rgba[component];                                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gint        width = MAX(MAX (o->width, o->x0), o->x1);                      \n"
"  gint        height = MAX(MAX (o->height, o->y0), o->y1);                    \n"
"                                                                              \n"
"  {                                                                           \n"
"    GeglRectangle extent = {0,0,width,height};                                \n"
"    output = gegl_buffer_new (&extent, babl_format (\"B'aG'aR'aA u8\"));      \n"
"  }                                                                           \n"
"                                                                              \n"
"  {                                                                           \n"
"    guchar  *buf = g_new0 (guchar, width * height * 4);                       \n"
"    cairo_t *cr;                                                              \n"
"                                                                              \n"
"    cairo_surface_t *surface = cairo_image_surface_create_for_data (buf, CAIRO_FORMAT_ARGB32, width, height, width * 4);\n"
"    cr = cairo_create (surface);                                              \n"
"  /*  cairo_set_source_rgba (cr, 0.0, 0.0, 0.0, 1.0);                         \n"
"    cairo_rectangle (cr, 0,0, o->width, o->height);                           \n"
"    cairo_fill (cr);*/                                                        \n"
"                                                                              \n"
"#define val2y(val) (o->height - (val - o->min) * o->height / (o->max-o->min)) \n"
"                                                                              \n"
"    cairo_set_source_rgba (cr, .0, .0, .8, 0.5);                              \n"
"    cairo_move_to (cr, 0, val2y(0.0));                                        \n"
"    cairo_line_to (cr, o->width, val2y(0.0));                                 \n"
"                                                                              \n"
"    cairo_set_source_rgba (cr, .8, .8, .0, 0.5);                              \n"
"    cairo_move_to (cr, 0, val2y(1.0));                                        \n"
"    cairo_line_to (cr, o->width, val2y(1.0));                                 \n"
"                                                                              \n"
"    cairo_stroke (cr);                                                        \n"
"                                                                              \n"
"    cairo_set_line_join (cr, CAIRO_LINE_JOIN_ROUND);                          \n"
"    {                                                                         \n"
"      gint x;                                                                 \n"
"      cairo_set_source_rgba (cr, 1.0, 0.0, 0.0, 1.0);                         \n"
"      for (x=0;x<o->width;x++)                                                \n"
"        {                                                                     \n"
"          gfloat t = (1.0*x)/o->width;                                        \n"
"          gint sx = ((1.0-t) * o->x0) + (t * o->x1);                          \n"
"          gint sy = ((1.0-t) * o->y0) + (t * o->y1);                          \n"
"          cairo_line_to (cr, x, val2y(buffer_sample(input,sx,sy,0)));         \n"
"        }                                                                     \n"
"      cairo_stroke (cr);                                                      \n"
"    }                                                                         \n"
"    {                                                                         \n"
"      gint x;                                                                 \n"
"      cairo_set_source_rgba (cr, 0.0, 1.0, 0.0, 1.0);                         \n"
"      for (x=0;x<o->width;x++)                                                \n"
"        {                                                                     \n"
"          gfloat t = (1.0*x)/o->width;                                        \n"
"          gint sx = ((1.0-t) * o->x0) + (t * o->x1);                          \n"
"          gint sy = ((1.0-t) * o->y0) + (t * o->y1);                          \n"
"          cairo_line_to (cr, x, val2y(buffer_sample(input,sx,sy,1)));         \n"
"        }                                                                     \n"
"      cairo_stroke (cr);                                                      \n"
"    }                                                                         \n"
"    {                                                                         \n"
"      gint x;                                                                 \n"
"      cairo_set_source_rgba (cr, 0.0, 0.0, 1.0, 1.0);                         \n"
"      for (x=0;x<o->width;x++)                                                \n"
"        {                                                                     \n"
"          gfloat t = (1.0*x)/o->width;                                        \n"
"          gint sx = ((1.0-t) * o->x0) + (t * o->x1);                          \n"
"          gint sy = ((1.0-t) * o->y0) + (t * o->y1);                          \n"
"          cairo_line_to (cr, x, val2y(buffer_sample(input,sx,sy,2)));         \n"
"        }                                                                     \n"
"      cairo_stroke (cr);                                                      \n"
"    }                                                                         \n"
"   cairo_set_source_rgba (cr, 1.0, 0.0, 0.0, 0.4);                            \n"
"   cairo_move_to (cr, o->x0, o->y0);                                          \n"
"   cairo_line_to (cr, o->x1, o->y1);                                          \n"
"   cairo_stroke (cr);                                                         \n"
"                                                                              \n"
"    gegl_buffer_set (output, NULL, 0, babl_format (\"B'aG'aR'aA u8\"), buf, GEGL_AUTO_ROWSTRIDE);\n"
"  }                                                                           \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation        *self,                          \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  return *gegl_operation_source_get_bounding_box (self, \"input\");           \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  GeglRectangle defined = {0,0,o->width,o->height};                           \n"
"                                                                              \n"
"  defined.width  = MAX (MAX (o->width,  o->x0), o->x1);                       \n"
"  defined.height = MAX (MAX (o->height, o->y0), o->y1);                       \n"
"  return defined;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"        , \"gegl:line-profile\",                                  \n"
"    \"categories\"  , \"debug\",                                              \n"
"    \"title\"       , _(\"Line Profile\"),                                    \n"
"    \"description\" ,                                                         \n"
"          _(\"Renders luminance profiles for red green and blue components along\"\n"
"            \" the specified line in the input buffer, plotted in a buffer of the\"\n"
"            \" specified size.\"),                                            \n"
"          NULL);                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
