static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" *           2006 Dominik Ernst <dernst@gmx.de>                               \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"  description (_(\"Target path and filename, use '-' for stdout.\"))          \n"
"property_int (compression, _(\"Compression\"), 3)                             \n"
"  description (_(\"PNG compression level from 1 to 9\"))                      \n"
"  value_range (1, 9)                                                          \n"
"property_int (bitdepth, _(\"Bitdepth\"), 16)                                  \n"
"  description (_(\"8 and 16 are the currently accepted values.\"))            \n"
"  value_range (8, 16)                                                         \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_NAME png_save                                                 \n"
"#define GEGL_OP_C_SOURCE png-save.c                                           \n"
"                                                                              \n"
"#include <gegl-op.h>                                                          \n"
"#include <gegl-gio-private.h>                                                 \n"
"#include <png.h>                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"write_fn(png_structp png_ptr, png_bytep buffer, png_size_t length)            \n"
"{                                                                             \n"
"  GError *err = NULL;                                                         \n"
"  GOutputStream *stream = G_OUTPUT_STREAM(png_get_io_ptr(png_ptr));           \n"
"  gsize bytes_written = 0;                                                    \n"
"  g_assert(stream);                                                           \n"
"                                                                              \n"
"  g_output_stream_write_all(stream, buffer, length, &bytes_written, NULL, &err);\n"
"  if (err) {                                                                  \n"
"    g_printerr(\"gegl:save-png %s: %s\\n\", __PRETTY_FUNCTION__, err->message);\n"
"  }                                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"flush_fn(png_structp png_ptr)                                                 \n"
"{                                                                             \n"
"  GError *err = NULL;                                                         \n"
"  GOutputStream *stream = G_OUTPUT_STREAM(png_get_io_ptr(png_ptr));           \n"
"  g_assert(stream);                                                           \n"
"                                                                              \n"
"  g_output_stream_flush(stream, NULL, &err);                                  \n"
"  if (err) {                                                                  \n"
"    g_printerr(\"gegl:save-png %s: %s\\n\", __PRETTY_FUNCTION__, err->message);\n"
"  }                                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"error_fn(png_structp png_ptr, png_const_charp msg)                            \n"
"{                                                                             \n"
"  g_printerr(\"LIBPNG ERROR: %s\", msg);                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static gint                                                                   \n"
"export_png (GeglOperation       *operation,                                   \n"
"            GeglBuffer          *input,                                       \n"
"            const GeglRectangle *result,                                      \n"
"            png_structp          png,                                         \n"
"            png_infop            info,                                        \n"
"            gint                 compression,                                 \n"
"            gint                 bit_depth)                                   \n"
"{                                                                             \n"
"  gint           i, src_x, src_y;                                             \n"
"  png_uint_32    width, height;                                               \n"
"  guchar        *pixels;                                                      \n"
"  png_color_16   white;                                                       \n"
"  int            png_color_type;                                              \n"
"  gchar          format_string[16];                                           \n"
"  const Babl    *format;                                                      \n"
"                                                                              \n"
"  src_x = result->x;                                                          \n"
"  src_y = result->y;                                                          \n"
"  width = result->width;                                                      \n"
"  height = result->height;                                                    \n"
"                                                                              \n"
"  {                                                                           \n"
"    const Babl *babl = gegl_buffer_get_format (input);                        \n"
"                                                                              \n"
"    if (bit_depth != 16)                                                      \n"
"      bit_depth = 8;                                                          \n"
"                                                                              \n"
"    if (babl_format_has_alpha (babl))                                         \n"
"      if (babl_format_get_n_components (babl) != 2)                           \n"
"        {                                                                     \n"
"          png_color_type = PNG_COLOR_TYPE_RGB_ALPHA;                          \n"
"          strcpy (format_string, \"R'G'B'A \");                               \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          png_color_type = PNG_COLOR_TYPE_GRAY_ALPHA;                         \n"
"          strcpy (format_string, \"Y'A \");                                   \n"
"        }                                                                     \n"
"    else                                                                      \n"
"      if (babl_format_get_n_components (babl) != 1)                           \n"
"        {                                                                     \n"
"          png_color_type = PNG_COLOR_TYPE_RGB;                                \n"
"          strcpy (format_string, \"R'G'B' \");                                \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          png_color_type = PNG_COLOR_TYPE_GRAY;                               \n"
"          strcpy (format_string, \"Y' \");                                    \n"
"        }                                                                     \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (bit_depth == 16)                                                        \n"
"    strcat (format_string, \"u16\");                                          \n"
"  else                                                                        \n"
"    strcat (format_string, \"u8\");                                           \n"
"                                                                              \n"
"  if (setjmp (png_jmpbuf (png)))                                              \n"
"    return -1;                                                                \n"
"                                                                              \n"
"  png_set_compression_level (png, compression);                               \n"
"                                                                              \n"
"  png_set_IHDR (png, info,                                                    \n"
"     width, height, bit_depth, png_color_type,                                \n"
"     PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_DEFAULT); \n"
"                                                                              \n"
"  if (png_color_type == PNG_COLOR_TYPE_RGB || png_color_type == PNG_COLOR_TYPE_RGB_ALPHA)\n"
"    {                                                                         \n"
"      white.red = 0xff;                                                       \n"
"      white.blue = 0xff;                                                      \n"
"      white.green = 0xff;                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    white.gray = 0xff;                                                        \n"
"  png_set_bKGD (png, info, &white);                                           \n"
"                                                                              \n"
"  png_write_info (png, info);                                                 \n"
"                                                                              \n"
"#if BYTE_ORDER == LITTLE_ENDIAN                                               \n"
"  if (bit_depth > 8)                                                          \n"
"    png_set_swap (png);                                                       \n"
"#endif                                                                        \n"
"                                                                              \n"
"  format = babl_format (format_string);                                       \n"
"  pixels = g_malloc0 (width * babl_format_get_bytes_per_pixel (format));      \n"
"                                                                              \n"
"  for (i=0; i< height; i++)                                                   \n"
"    {                                                                         \n"
"      GeglRectangle rect;                                                     \n"
"                                                                              \n"
"      rect.x = src_x;                                                         \n"
"      rect.y = src_y+i;                                                       \n"
"      rect.width = width;                                                     \n"
"      rect.height = 1;                                                        \n"
"                                                                              \n"
"      gegl_buffer_get (input, &rect, 1.0, babl_format (format_string), pixels, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"                                                                              \n"
"      png_write_rows (png, &pixels, 1);                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  png_write_end (png, info);                                                  \n"
"                                                                              \n"
"  g_free (pixels);                                                            \n"
"                                                                              \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  png_structp png = NULL;                                                     \n"
"  png_infop info = NULL;                                                      \n"
"  GOutputStream *stream = NULL;                                               \n"
"  GFile *file = NULL;                                                         \n"
"  gboolean status = TRUE;                                                     \n"
"  GError *error = NULL;                                                       \n"
"                                                                              \n"
"  png = png_create_write_struct (PNG_LIBPNG_VER_STRING, NULL, error_fn, NULL);\n"
"  if (png != NULL)                                                            \n"
"    info = png_create_info_struct (png);                                      \n"
"  if (png == NULL || info == NULL)                                            \n"
"    {                                                                         \n"
"      status = FALSE;                                                         \n"
"      g_warning (\"failed to initialize PNG writer\");                        \n"
"      goto cleanup;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  stream = gegl_gio_open_output_stream (NULL, o->path, &file, &error);        \n"
"  if (stream == NULL)                                                         \n"
"    {                                                                         \n"
"      status = FALSE;                                                         \n"
"      g_warning (\"%s\", error->message);                                     \n"
"      goto cleanup;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  png_set_write_fn (png, stream, write_fn, flush_fn);                         \n"
"                                                                              \n"
"  if (export_png (operation, input, result, png, info, o->compression, o->bitdepth))\n"
"    {                                                                         \n"
"      status = FALSE;                                                         \n"
"      g_warning(\"could not export PNG file\");                               \n"
"      goto cleanup;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"cleanup:                                                                      \n"
"  if (info != NULL)                                                           \n"
"    png_destroy_write_struct (&png, &info);                                   \n"
"  else if (png != NULL)                                                       \n"
"    png_destroy_write_struct (&png, NULL);                                    \n"
"                                                                              \n"
"  if (stream != NULL)                                                         \n"
"    g_clear_object(&stream);                                                  \n"
"                                                                              \n"
"  if (file != NULL)                                                           \n"
"    g_clear_object(&file);                                                    \n"
"                                                                              \n"
"  return status;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass     *operation_class;                                    \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  sink_class      = GEGL_OPERATION_SINK_CLASS (klass);                        \n"
"                                                                              \n"
"  sink_class->process    = process;                                           \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",          \"gegl:png-save\",                                     \n"
"    \"title\",       _(\"PNG File Saver\"),                                   \n"
"    \"categories\" ,   \"output\",                                            \n"
"    \"description\", _(\"PNG image saver, using libpng\"),                    \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  gegl_operation_handlers_register_saver (                                    \n"
"    \".png\", \"gegl:png-save\");                                             \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
