static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006-2010 Øyvind Kolås <pippin@gimp.org>                       \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"/* no properties */                                                           \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_COMPOSER3                                               \n"
"#define GEGL_OP_NAME     remap                                                \n"
"#define GEGL_OP_C_SOURCE remap.c                                              \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  const Babl *format = babl_format (\"RGBA float\");                          \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  format);                  \n"
"  gegl_operation_set_format (operation, \"aux\",    format);                  \n"
"  gegl_operation_set_format (operation, \"aux2\",   format);                  \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *min_buf,                                        \n"
"         void                *max_buf,                                        \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  gint    i;                                                                  \n"
"  gfloat *in = in_buf;                                                        \n"
"  gfloat *min = min_buf;                                                      \n"
"  gfloat *max = max_buf;                                                      \n"
"  gfloat *out = out_buf;                                                      \n"
"  if (!min || !max || !out || !in)                                            \n"
"    return FALSE;                                                             \n"
"                                                                              \n"
"  for (i = 0; i < n_pixels; i++)                                              \n"
"    {                                                                         \n"
"      gint c;                                                                 \n"
"      for (c = 0; c < 3; c++)                                                 \n"
"        {                                                                     \n"
"          gfloat delta = max[c] - min[c];                                     \n"
"                                                                              \n"
"          if (delta > 0.0001 || delta < -0.0001)                              \n"
"            out[c] = (in[c] - min[c]) / delta;                                \n"
"          else                                                                \n"
"            out[c] = in[c];                                                   \n"
"        }                                                                     \n"
"                                                                              \n"
"      out[3] = in[3];                                                         \n"
"                                                                              \n"
"      in  += 4;                                                               \n"
"      out += 4;                                                               \n"
"      min += 4;                                                               \n"
"      max += 4;                                                               \n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass               *operation_class;                          \n"
"  GeglOperationPointComposer3Class *point_composer3_class;                    \n"
"                                                                              \n"
"  operation_class       = GEGL_OPERATION_CLASS (klass);                       \n"
"  point_composer3_class = GEGL_OPERATION_POINT_COMPOSER3_CLASS (klass);       \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  point_composer3_class->process = process;                                   \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:remap\",                                          \n"
"    \"title\"      , _(\"Remap\"),                                            \n"
"    \"description\",                                                          \n"
"          _(\"stretch components of pixels individually based on luminance envelopes\"),\n"
"    \"categories\" , \"compositors\",                                         \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
