static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2015 Thomas Manni <thomas.manni@free.fr>                         \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_component_extract)                                           \n"
"  enum_value (GEGL_COMPONENT_EXTRACT_RGB_RED, \"RGB Red\", N_(\"RGB Red\"))   \n"
"  enum_value (GEGL_COMPONENT_EXTRACT_RGB_GREEN, \"RGB Green\", N_(\"RGB Green\"))\n"
"  enum_value (GEGL_COMPONENT_EXTRACT_RGB_BLUE, \"RGB Blue\", N_(\"RGB Blue\"))\n"
"  enum_value (GEGL_COMPONENT_EXTRACT_HUE, \"Hue\", N_(\"Hue\"))               \n"
"  enum_value (GEGL_COMPONENT_EXTRACT_HSV_SATURATION, \"HSV Saturation\", N_(\"HSV Saturation\"))\n"
"  enum_value (GEGL_COMPONENT_EXTRACT_HSV_VALUE, \"HSV Value\", N_(\"HSV Value\"))\n"
"  enum_value (GEGL_COMPONENT_EXTRACT_HSL_SATURATION, \"HSL Saturation\", N_(\"HSL Saturation\"))\n"
"  enum_value (GEGL_COMPONENT_EXTRACT_HSL_LIGHTNESS, \"HSL Lightness\", N_(\"HSL Lightness\"))\n"
"  enum_value (GEGL_COMPONENT_EXTRACT_CMYK_CYAN, \"CMYK Cyan\", N_(\"CMYK Cyan\"))\n"
"  enum_value (GEGL_COMPONENT_EXTRACT_CMYK_MAGENTA, \"CMYK Magenta\", N_(\"CMYK Magenta\"))\n"
"  enum_value (GEGL_COMPONENT_EXTRACT_CMYK_YELLOW, \"CMYK Yellow\", N_(\"CMYK Yellow\"))\n"
"  enum_value (GEGL_COMPONENT_EXTRACT_CMYK_KEY, \"CMYK Key\", N_(\"CMYK Key\"))\n"
"  enum_value (GEGL_COMPONENT_EXTRACT_YCBCR_Y, \"Y'CbCr Y'\", N_(\"Y'CbCr Y'\"))\n"
"  enum_value (GEGL_COMPONENT_EXTRACT_YCBCR_CB, \"Y'CbCr Cb\", N_(\"Y'CbCr Cb\"))\n"
"  enum_value (GEGL_COMPONENT_EXTRACT_YCBCR_CR, \"Y'CbCr Cr\", N_(\"Y'CbCr Cr\"))\n"
"  enum_value (GEGL_COMPONENT_EXTRACT_LAB_L, \"LAB L\", N_(\"LAB L\"))         \n"
"  enum_value (GEGL_COMPONENT_EXTRACT_LAB_A, \"LAB A\", N_(\"LAB A\"))         \n"
"  enum_value (GEGL_COMPONENT_EXTRACT_LAB_B, \"LAB B\", N_(\"LAB B\"))         \n"
"  enum_value (GEGL_COMPONENT_EXTRACT_LCH_C, \"LCH C(ab)\", N_(\"LCH C(ab)\")) \n"
"  enum_value (GEGL_COMPONENT_EXTRACT_LCH_H, \"LCH H(ab)\", N_(\"LCH H(ab)\")) \n"
"  enum_value (GEGL_COMPONENT_EXTRACT_ALPHA, \"Alpha\", N_(\"Alpha\"))         \n"
"enum_end (GeglComponentExtract)                                               \n"
"                                                                              \n"
"property_enum (component, _(\"Component\"),                                   \n"
"               GeglComponentExtract, gegl_component_extract,                  \n"
"               GEGL_COMPONENT_EXTRACT_RGB_RED)                                \n"
"  description (_(\"Component to extract\"))                                   \n"
"                                                                              \n"
"property_boolean (invert, _(\"Invert component\"), FALSE)                     \n"
"     description (_(\"Invert the extracted component\"))                      \n"
"                                                                              \n"
"property_boolean (linear, _(\"Linear output\"), FALSE)                        \n"
"     description (_(\"Use linear output instead of gamma corrected\"))        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME component_extract                                        \n"
"#define GEGL_OP_C_SOURCE  component-extract.c                                 \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o             = GEGL_PROPERTIES (operation);                \n"
"  const Babl     *input_format  = NULL;                                       \n"
"  const Babl     *output_format = (o->linear ?                                \n"
"                                   babl_format (\"Y float\") :                \n"
"                                   babl_format (\"Y' float\"));               \n"
"                                                                              \n"
"  switch (o->component)                                                       \n"
"    {                                                                         \n"
"    case GEGL_COMPONENT_EXTRACT_ALPHA:                                        \n"
"      input_format = babl_format (\"YA float\");                              \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case GEGL_COMPONENT_EXTRACT_RGB_RED:                                      \n"
"    case GEGL_COMPONENT_EXTRACT_RGB_GREEN:                                    \n"
"    case GEGL_COMPONENT_EXTRACT_RGB_BLUE:                                     \n"
"      input_format = babl_format (\"R'G'B' float\");                          \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case GEGL_COMPONENT_EXTRACT_HUE:                                          \n"
"    case GEGL_COMPONENT_EXTRACT_HSV_SATURATION:                               \n"
"    case GEGL_COMPONENT_EXTRACT_HSV_VALUE:                                    \n"
"      input_format = babl_format (\"HSV float\");                             \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case GEGL_COMPONENT_EXTRACT_HSL_LIGHTNESS:                                \n"
"    case GEGL_COMPONENT_EXTRACT_HSL_SATURATION:                               \n"
"      input_format = babl_format (\"HSL float\");                             \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case GEGL_COMPONENT_EXTRACT_CMYK_CYAN:                                    \n"
"    case GEGL_COMPONENT_EXTRACT_CMYK_MAGENTA:                                 \n"
"    case GEGL_COMPONENT_EXTRACT_CMYK_YELLOW:                                  \n"
"    case GEGL_COMPONENT_EXTRACT_CMYK_KEY:                                     \n"
"      input_format = babl_format (\"CMYK float\");                            \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case GEGL_COMPONENT_EXTRACT_YCBCR_Y:                                      \n"
"    case GEGL_COMPONENT_EXTRACT_YCBCR_CB:                                     \n"
"    case GEGL_COMPONENT_EXTRACT_YCBCR_CR:                                     \n"
"      input_format = babl_format (\"Y'CbCr float\");                          \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case GEGL_COMPONENT_EXTRACT_LAB_L:                                        \n"
"    case GEGL_COMPONENT_EXTRACT_LAB_A:                                        \n"
"    case GEGL_COMPONENT_EXTRACT_LAB_B:                                        \n"
"      input_format = babl_format (\"CIE Lab float\");                         \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case GEGL_COMPONENT_EXTRACT_LCH_C:                                        \n"
"    case GEGL_COMPONENT_EXTRACT_LCH_H:                                        \n"
"      input_format = babl_format (\"CIE LCH(ab) float\");                     \n"
"      break;                                                                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", input_format);             \n"
"  gegl_operation_set_format (operation, \"output\", output_format);           \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                samples,                                        \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o      = GEGL_PROPERTIES (operation);                       \n"
"  const Babl     *format = gegl_operation_get_format (operation, \"input\");  \n"
"  gfloat         *in     = in_buf;                                            \n"
"  gfloat         *out    = out_buf;                                           \n"
"  gint            component_index = 0;                                        \n"
"  gint            n_components;                                               \n"
"  gdouble         min = 0.0;                                                  \n"
"  gdouble         max = 1.0;                                                  \n"
"                                                                              \n"
"  n_components = babl_format_get_n_components (format);                       \n"
"                                                                              \n"
"  switch (o->component)                                                       \n"
"    {                                                                         \n"
"    case GEGL_COMPONENT_EXTRACT_RGB_RED:                                      \n"
"    case GEGL_COMPONENT_EXTRACT_HUE:                                          \n"
"    case GEGL_COMPONENT_EXTRACT_CMYK_CYAN:                                    \n"
"    case GEGL_COMPONENT_EXTRACT_YCBCR_Y:                                      \n"
"    case GEGL_COMPONENT_EXTRACT_LAB_L:                                        \n"
"      component_index = 0;                                                    \n"
"                                                                              \n"
"      if (o->component == GEGL_COMPONENT_EXTRACT_LAB_L)                       \n"
"        {                                                                     \n"
"          max = 100.0;                                                        \n"
"        }                                                                     \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case GEGL_COMPONENT_EXTRACT_RGB_GREEN:                                    \n"
"    case GEGL_COMPONENT_EXTRACT_HSV_SATURATION:                               \n"
"    case GEGL_COMPONENT_EXTRACT_HSL_SATURATION:                               \n"
"    case GEGL_COMPONENT_EXTRACT_CMYK_MAGENTA:                                 \n"
"    case GEGL_COMPONENT_EXTRACT_YCBCR_CB:                                     \n"
"    case GEGL_COMPONENT_EXTRACT_LAB_A:                                        \n"
"    case GEGL_COMPONENT_EXTRACT_LCH_C:                                        \n"
"    case GEGL_COMPONENT_EXTRACT_ALPHA:                                        \n"
"      component_index = 1;                                                    \n"
"                                                                              \n"
"      if (o->component == GEGL_COMPONENT_EXTRACT_YCBCR_CB)                    \n"
"        {                                                                     \n"
"          min = -0.5;                                                         \n"
"          max =  0.5;                                                         \n"
"        }                                                                     \n"
"      else if (o->component == GEGL_COMPONENT_EXTRACT_LAB_A)                  \n"
"        {                                                                     \n"
"          min = -127.5;                                                       \n"
"          max =  127.5;                                                       \n"
"        }                                                                     \n"
"      else if (o->component == GEGL_COMPONENT_EXTRACT_LCH_C)                  \n"
"        {                                                                     \n"
"          max = 200.0;                                                        \n"
"        }                                                                     \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case GEGL_COMPONENT_EXTRACT_RGB_BLUE:                                     \n"
"    case GEGL_COMPONENT_EXTRACT_HSV_VALUE:                                    \n"
"    case GEGL_COMPONENT_EXTRACT_HSL_LIGHTNESS:                                \n"
"    case GEGL_COMPONENT_EXTRACT_CMYK_YELLOW:                                  \n"
"    case GEGL_COMPONENT_EXTRACT_YCBCR_CR:                                     \n"
"    case GEGL_COMPONENT_EXTRACT_LAB_B:                                        \n"
"    case GEGL_COMPONENT_EXTRACT_LCH_H:                                        \n"
"      component_index = 2;                                                    \n"
"                                                                              \n"
"      if (o->component == GEGL_COMPONENT_EXTRACT_YCBCR_CR)                    \n"
"        {                                                                     \n"
"          min = -0.5;                                                         \n"
"          max =  0.5;                                                         \n"
"        }                                                                     \n"
"      else if (o->component == GEGL_COMPONENT_EXTRACT_LAB_B)                  \n"
"        {                                                                     \n"
"          min = -127.5;                                                       \n"
"          max =  127.5;                                                       \n"
"        }                                                                     \n"
"      else if (o->component == GEGL_COMPONENT_EXTRACT_LCH_H)                  \n"
"        {                                                                     \n"
"          min = 0.0;                                                          \n"
"          max = 360.0;                                                        \n"
"        }                                                                     \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case GEGL_COMPONENT_EXTRACT_CMYK_KEY:                                     \n"
"      component_index = 3;                                                    \n"
"      break;                                                                  \n"
"    }                                                                         \n"
"                                                                              \n"
"    while (samples--)                                                         \n"
"      {                                                                       \n"
"        gdouble value = in[component_index];                                  \n"
"                                                                              \n"
"        if (min != 0.0 || max != 1.0)                                         \n"
"          {                                                                   \n"
"            gdouble scale  = 1.0 / (max - min);                               \n"
"            gdouble offset = -min;                                            \n"
"                                                                              \n"
"            value = CLAMP ((value + offset) * scale, 0.0, 1.0);               \n"
"          }                                                                   \n"
"                                                                              \n"
"        if (o->invert)                                                        \n"
"          out[0] = 1.0 - value;                                               \n"
"        else                                                                  \n"
"          out[0] = value;                                                     \n"
"                                                                              \n"
"        in  += n_components;                                                  \n"
"        out += 1;                                                             \n"
"      }                                                                       \n"
"                                                                              \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  operation_class->prepare        = prepare;                                  \n"
"  operation_class->opencl_support = FALSE;                                    \n"
"  point_filter_class->process     = process;                                  \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:component-extract\",                              \n"
"    \"title\",       _(\"Extract Component\"),                                \n"
"    \"categories\",  \"color\",                                               \n"
"    \"description\", _(\"Extract a color model component\"),                  \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
