static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" * Copyright 2008 Hubert Figuière <hub@figuiere.net>                         \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, \"File\", \"\")                                     \n"
"  description (_(\"Path of file to load.\"))                                  \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#include \"gegl-plugin.h\"                                                    \n"
"struct _GeglOp                                                                \n"
"{                                                                             \n"
"  GeglOperationSource parent_instance;                                        \n"
"  gpointer            properties;                                             \n"
"                                                                              \n"
"  gchar *cached_path;  /* Path we have cached. Detects need for recache. */   \n"
"};                                                                            \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GeglOperationSourceClass parent_class;                                      \n"
"} GeglOpClass;                                                                \n"
"                                                                              \n"
"#define GEGL_OP_C_SOURCE openraw.c                                            \n"
"#include \"gegl-op.h\"                                                        \n"
"GEGL_DEFINE_DYNAMIC_OPERATION(GEGL_TYPE_OPERATION_SOURCE)                     \n"
"                                                                              \n"
"#include <stdio.h>                                                            \n"
"#include <libopenraw/libopenraw.h>                                            \n"
"                                                                              \n"
"                                                                              \n"
"/* We can't release the pixel data itself, so we ignore the first argument    \n"
" * and release the libopenraw structure instead.                              \n"
" */                                                                           \n"
"static void                                                                   \n"
"destroy_rawdata (void * rawdata)                                              \n"
"{                                                                             \n"
"  or_rawdata_release (rawdata);                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"free_buffer (GeglOperation * operation)                                       \n"
"{                                                                             \n"
"  GeglProperties *o    = GEGL_PROPERTIES (operation);                         \n"
"  GeglOp  *self = GEGL_OP(operation);                                         \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      g_assert (self->cached_path);                                           \n"
"      g_object_unref (o->user_data);                                          \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (self->cached_path)                                                      \n"
"  {                                                                           \n"
"    g_free (self->cached_path);                                               \n"
"    self->cached_path = NULL;                                                 \n"
"  }                                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"/* Loads the RAW pixel data from the specified path in chant parameters into  \n"
" * a GeglBuffer for caching. Maintains copy of the path that has been cached  \n"
" * so we can check for modifications and recache.                             \n"
" */                                                                           \n"
"static GeglBuffer *                                                           \n"
"load_buffer (GeglOperation *operation)                                        \n"
"{                                                                             \n"
"  GeglProperties *o    = GEGL_PROPERTIES (operation);                         \n"
"  GeglOp  *self = GEGL_OP(operation);                                         \n"
"                                                                              \n"
"  ORRawDataRef rawdata;                                                       \n"
"  ORRawFileRef rawfile;                                                       \n"
"                                                                              \n"
"  /* If the path has changed since last time, destroy our cache */            \n"
"  if (!self->cached_path || strcmp (self->cached_path, o->path))              \n"
"    {                                                                         \n"
"      free_buffer(operation);                                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      return o->user_data;                                                    \n"
"    }                                                                         \n"
"  g_assert (self->cached_path == NULL);                                       \n"
"                                                                              \n"
"  /* Gather the file and data resources needed for our cache */               \n"
"  rawfile = or_rawfile_new(o->path, OR_RAWFILE_TYPE_UNKNOWN);                 \n"
"  if (!rawfile)                                                               \n"
"    {                                                                         \n"
"      return NULL;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  rawdata = or_rawdata_new();                                                 \n"
"  if(or_rawfile_get_rawdata(rawfile, rawdata, OR_OPTIONS_NONE) != OR_ERROR_NONE)\n"
"    {                                                                         \n"
"      goto clean_file;                                                        \n"
"    }                                                                         \n"
"                                                                              \n"
"  if(or_rawdata_format (rawdata) != OR_DATA_TYPE_CFA)                         \n"
"    {                                                                         \n"
"      goto clean_file;                                                        \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* Build a gegl_buffer, backed with the libopenraw supplied data. */        \n"
"    {                                                                         \n"
"      GeglRectangle extent = { 0, 0, 0, 0 };                                  \n"
"      guint32 width, height;                                                  \n"
"      void * data = or_rawdata_data(rawdata);                                 \n"
"                                                                              \n"
"      or_rawdata_dimensions(rawdata, &width, &height);                        \n"
"      g_assert (height > 0 && width > 0);                                     \n"
"      extent.width  = width;                                                  \n"
"      extent.height = height;                                                 \n"
"                                                                              \n"
"      g_assert (o->user_data == NULL);                                        \n"
"      o->user_data = gegl_buffer_linear_new_from_data(data,                   \n"
"                                                       babl_format (\"Y u16\"),\n"
"                                                       &extent,               \n"
"                                                       GEGL_AUTO_ROWSTRIDE,   \n"
"                                                       destroy_rawdata,       \n"
"                                                       rawdata);              \n"
"    }                                                                         \n"
"                                                                              \n"
"  self->cached_path = g_strdup (o->path);                                     \n"
"                                                                              \n"
"clean_file:                                                                   \n"
"  or_rawfile_release(rawfile);                                                \n"
"                                                                              \n"
"  return o->user_data;                                                        \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"Y u16\")); \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  if (!load_buffer (operation))                                               \n"
"    {                                                                         \n"
"      GeglRectangle nullrect = { 0, 0, 0, 0 };                                \n"
"      return nullrect;                                                        \n"
"    }                                                                         \n"
"                                                                              \n"
"  return *gegl_buffer_get_extent (o->user_data);                              \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation          *operation,                                   \n"
"         GeglOperationContext   *context,                                     \n"
"         const gchar            *output_pad,                                  \n"
"         const GeglRectangle    *result,                                      \n"
"         gint                    level)                                       \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  g_assert (g_str_equal (output_pad, \"output\"));                            \n"
"                                                                              \n"
"  if (!load_buffer (operation))                                               \n"
"    {                                                                         \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* Give the operation a reference to the object, and keep a reference       \n"
"   * ourselves. We desperately do not want to delete our cached object, as    \n"
"   * we continue to service metadata calls after giving the object to the     \n"
"   * context.                                                                 \n"
"   */                                                                         \n"
"  g_assert(o->user_data);                                                     \n"
"  gegl_operation_context_take_object (context, \"output\", G_OBJECT (o->user_data));\n"
"  g_object_ref (G_OBJECT (o->user_data));                                     \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"#include <glib-object.h>                                                      \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  free_buffer (GEGL_OPERATION (object));                                      \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  static gboolean done = FALSE;                                               \n"
"                                                                              \n"
"  GObjectClass             *object_class;                                     \n"
"  GeglOperationClass       *operation_class;                                  \n"
"                                                                              \n"
"  object_class    = G_OBJECT_CLASS (klass);                                   \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  object_class->finalize = finalize;                                          \n"
"                                                                              \n"
"  operation_class->process = process;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"  operation_class->prepare     = prepare;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:openraw-load\",                                   \n"
"    \"title\",       _(\"OpenRAW File Loader\"),                              \n"
"    \"categories\",  \"hidden\",                                              \n"
"    \"description\", \"Camera RAW image loader using Open RAW\",              \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  if (done)                                                                   \n"
"    return;                                                                   \n"
"                                                                              \n"
"  /* query libopenraw instead. need a new API */                              \n"
"  gegl_extension_handler_register (\".cr2\", \"gegl:openraw-load\");          \n"
"  gegl_extension_handler_register (\".crw\", \"gegl:openraw-load\");          \n"
"  gegl_extension_handler_register (\".erf\", \"gegl:openraw-load\");          \n"
"  gegl_extension_handler_register (\".mrw\", \"gegl:openraw-load\");          \n"
"  gegl_extension_handler_register (\".nef\", \"gegl:openraw-load\");          \n"
"  gegl_extension_handler_register (\".dng\", \"gegl:openraw-load\");          \n"
"                                                                              \n"
"  done = TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
