/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __ARTS_MCOP_MARSHAL_H__
#define __ARTS_MCOP_MARSHAL_H__

#include <csl/csldefs.h>
#include <csl/artsbinbuffer.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* MCOP message ids */
typedef enum
{
  ARTS_MCOP_MESSAGE_INVALID	= 0,
  ARTS_MCOP_SERVER_HELLO		= 1,
  ARTS_MCOP_CLIENT_HELLO		= 2,
  ARTS_MCOP_AUTH_ACCEPT		= 3,
  ARTS_MCOP_INVOCATION		= 4,
  ARTS_MCOP_RETURN		= 5,
  ARTS_MCOP_ONEWAY_INVOCATION	= 6
} ArtsMcopMessageType;

#define ARTS_MCOP_MAGIC  0x4d434f50      /* 1296256848 or 'MCOP' */

/* MCOP message header */
typedef struct
{
  int		     mcop_magic;	/* 0x4d434f50 "MCOP" */
  int		     message_length;
  ArtsMcopMessageType type;

  union {
    struct {
      char	*mcop_version;
      char	*server_id;
      int	 n_auth_protocols;
      char    **auth_protocols;
      char	*auth_seed;
    } server_hello;
    struct {
      char	*server_id;
      char	*auth_protocol;
      char	*auth_data;
    } client_hello;
    struct {
      int	 n_hints;
      char     **hints;
    } auth_accept;
    struct {
      int	 object_id;
      int	 method_id;
      int	 request_id;
      /* + arg values marshalled */
    } invocation;
    struct {
      int	 request_id;
      /* + 1 return value marshalled */
    } return_body;
    struct {
      int	 object_id;
      int	 method_id;
      /* + arg values marshalled */
    } oneway_invocation;
  } body;
} ArtsMcopMessage;

typedef struct
{
  char	       *server_id;
  int		object_id;
  int		n_urls;
  char	      **urls;
} ArtsMcopObjectReference;


void			_arts_mcop_message_free			(ArtsMcopMessage		*msg);
ArtsMcopMessage*	_arts_mcop_message_demarshal		(ArtsBinBuffer		*buffer);
void			_arts_mcop_message_marshal		(ArtsMcopMessage		*msg,
								 ArtsBinBuffer		*buffer);
void			_arts_mcop_object_reference_free		(ArtsMcopObjectReference	*oref);
ArtsMcopObjectReference*	_arts_mcop_object_reference_demarshal	(ArtsBinBuffer		*buffer);
void			_arts_mcop_object_reference_marshal	(ArtsMcopObjectReference	*oref,
								 ArtsBinBuffer		*buffer);
ArtsMcopObjectReference*	_arts_mcop_object_reference_from_hexurl	(const char		*hex_url);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __ARTS_MCOP_MARSHAL_H__ */
