/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __CSL_MAIN_H__
#define __CSL_MAIN_H__


#include	<csl/csldefs.h>
#include	<csl/cslutils.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* --- CSL Driver API --- */
typedef struct _CslDriver        CslDriver;
typedef struct _CslMutex         CslMutex;
typedef void (*CslMutexLock)    (CslMutex *mutex);
typedef void (*CslMutexUnlock)  (CslMutex *mutex);
typedef void (*CslMutexDestroy) (CslMutex *mutex);
struct _CslMutex	/* user supplied mutex */
{
  void           *user_data;
  CslMutexLock    lock;
  CslMutexUnlock  unlock;
  CslMutexDestroy destroy;
};
typedef enum
{
  CSL_ENONE,
  CSL_EINTERN,
  CSL_ENODRIVER,
  CSL_ENOIMPL,
  CSL_EBUSY,
  CSL_EPERMS,
  CSL_EIO,
  CSL_EFMTINVAL,
  CSL_EGETCAPS,
  CSL_ECAPSUPPORT,
  CSL_ESETCAPS
} CslErrorType;
typedef enum	/* driver capabilities */
{
  CSL_DRIVER_CAP_PCM	= (1 << 0),
  CSL_DRIVER_CAP_MIXER	= (1 << 1),
  CSL_DRIVER_CAP_MASK	= 0x03
} CslDriverCaps;

/* standard drivers */
#define	CSL_DRIVER_NAME_ARTS	"arts"
#define	CSL_DRIVER_NAME_OSS	"oss"


/* --- main API --- */
const char**	csl_list_drivers	(unsigned int	  *n_backends);
CslErrorType	csl_driver_init		(const char	  *driver_name,
					 CslDriver	 **driver);
CslErrorType	csl_driver_init_mutex	(const char	  *driver_name,
					 CslDriverCaps	   required_caps,
					 CslMutex         *mutex,
					 CslDriver	 **driver);
void		csl_driver_shutdown	(CslDriver	  *driver);
const char*	csl_strerror		(CslErrorType	   error_type);


/* --- convenience functions --- */
typedef struct _CslOptions CslOptions;
struct _CslOptions
{
  /* -F  */ unsigned int  float_samples : 1;
  /* -s  */ unsigned int  signed_samples : 1;
  /* -u  */ unsigned int  unsigned_samples : 1;
  /* -B  */ unsigned int  big_endian : 1;
  /* -L  */ unsigned int  little_endian : 1;
  /* -w: */ unsigned int  n_bits;
  /* -c: */ unsigned int  n_channels;
  /* -r: */ unsigned int  rate;
  /* -D: */ CslDebugFlags debug_flags;
  
  /* composed constructs: */
  unsigned int  endianess;	/* 1234 or 4321 */
  unsigned int  pcm_format;
};
void	csl_parse_options	(CslOptions	 *options,
				 int		 *argc_p,
				 char           **argv_p[]);
char*	csl_describe_options	(unsigned int	  indent);
char*	csl_describe_pcm_format	(unsigned int     pcm_format);



#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __CSL_MAIN_H__ */
