#include "bswgenapi.h"


/*-------- begin ../sfi/sfidl generated code --------*/


#include <string.h>
BsePartNote*
bse_part_note_new (void)
{
  BsePartNote* rec = g_new0 (BsePartNote, 1);
  return rec;
}

BsePartNote*
bse_part_note_copy_shallow (BsePartNote* rec)
{
  BsePartNote* rec_copy;
  if (!rec)
    return NULL;
  rec_copy = g_new0 (BsePartNote, 1);
  rec_copy->id =  (rec->id);
  rec_copy->channel =  (rec->channel);
  rec_copy->tick =  (rec->tick);
  rec_copy->duration =  (rec->duration);
  rec_copy->note =  (rec->note);
  rec_copy->fine_tune =  (rec->fine_tune);
  rec_copy->velocity =  (rec->velocity);
  rec_copy->selected =  (rec->selected);
  return rec_copy;
}

BsePartNote*
bse_part_note_from_rec (SfiRec *sfi_rec)
{
  GValue *element;
  BsePartNote* rec;
  if (!sfi_rec)
    return NULL;

  rec = g_new0 (BsePartNote, 1);
  element = sfi_rec_get (sfi_rec, "id");
  if (element)
    rec->id = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "channel");
  if (element)
    rec->channel = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "tick");
  if (element)
    rec->tick = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "duration");
  if (element)
    rec->duration = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "note");
  if (element)
    rec->note = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "fine_tune");
  if (element)
    rec->fine_tune = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "velocity");
  if (element)
    rec->velocity = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "selected");
  if (element)
    rec->selected = sfi_value_get_bool (element);
  return rec;
}

SfiRec *
bse_part_note_to_rec (BsePartNote* rec)
{
  SfiRec *sfi_rec;
  GValue *element;
  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->id);
  sfi_rec_set (sfi_rec, "id", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->channel);
  sfi_rec_set (sfi_rec, "channel", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->tick);
  sfi_rec_set (sfi_rec, "tick", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->duration);
  sfi_rec_set (sfi_rec, "duration", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->note);
  sfi_rec_set (sfi_rec, "note", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->fine_tune);
  sfi_rec_set (sfi_rec, "fine_tune", element);
  sfi_value_free (element);
  element = sfi_value_real (rec->velocity);
  sfi_rec_set (sfi_rec, "velocity", element);
  sfi_value_free (element);
  element = sfi_value_bool (rec->selected);
  sfi_rec_set (sfi_rec, "selected", element);
  sfi_value_free (element);
  return sfi_rec;
}

void
bse_part_note_free (BsePartNote* rec)
{
  g_return_if_fail (rec != NULL);
  
  g_free (rec);
}


BsePartControl*
bse_part_control_new (void)
{
  BsePartControl* rec = g_new0 (BsePartControl, 1);
  return rec;
}

BsePartControl*
bse_part_control_copy_shallow (BsePartControl* rec)
{
  BsePartControl* rec_copy;
  if (!rec)
    return NULL;
  rec_copy = g_new0 (BsePartControl, 1);
  rec_copy->id =  (rec->id);
  rec_copy->tick =  (rec->tick);
  rec_copy->control_type =  (rec->control_type);
  rec_copy->value =  (rec->value);
  rec_copy->selected =  (rec->selected);
  return rec_copy;
}

BsePartControl*
bse_part_control_from_rec (SfiRec *sfi_rec)
{
  GValue *element;
  BsePartControl* rec;
  if (!sfi_rec)
    return NULL;

  rec = g_new0 (BsePartControl, 1);
  element = sfi_rec_get (sfi_rec, "id");
  if (element)
    rec->id = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "tick");
  if (element)
    rec->tick = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "control_type");
  if (element)
    rec->control_type = bse_midi_signal_type_from_choice (sfi_value_get_choice (element));
  element = sfi_rec_get (sfi_rec, "value");
  if (element)
    rec->value = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "selected");
  if (element)
    rec->selected = sfi_value_get_bool (element);
  return rec;
}

SfiRec *
bse_part_control_to_rec (BsePartControl* rec)
{
  SfiRec *sfi_rec;
  GValue *element;
  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->id);
  sfi_rec_set (sfi_rec, "id", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->tick);
  sfi_rec_set (sfi_rec, "tick", element);
  sfi_value_free (element);
  element = sfi_value_choice (bse_midi_signal_type_to_choice (rec->control_type));
  sfi_rec_set (sfi_rec, "control_type", element);
  sfi_value_free (element);
  element = sfi_value_real (rec->value);
  sfi_rec_set (sfi_rec, "value", element);
  sfi_value_free (element);
  element = sfi_value_bool (rec->selected);
  sfi_rec_set (sfi_rec, "selected", element);
  sfi_value_free (element);
  return sfi_rec;
}

void
bse_part_control_free (BsePartControl* rec)
{
  g_return_if_fail (rec != NULL);
  
  g_free (rec);
}


BseNoteDescription*
bse_note_description_new (void)
{
  BseNoteDescription* rec = g_new0 (BseNoteDescription, 1);
  return rec;
}

BseNoteDescription*
bse_note_description_copy_shallow (BseNoteDescription* rec)
{
  BseNoteDescription* rec_copy;
  if (!rec)
    return NULL;
  rec_copy = g_new0 (BseNoteDescription, 1);
  rec_copy->note =  (rec->note);
  rec_copy->octave =  (rec->octave);
  rec_copy->freq =  (rec->freq);
  rec_copy->fine_tune =  (rec->fine_tune);
  rec_copy->semitone =  (rec->semitone);
  rec_copy->upshift =  (rec->upshift);
  rec_copy->letter =  (rec->letter);
  rec_copy->name = g_strdup (rec->name);
  rec_copy->max_fine_tune =  (rec->max_fine_tune);
  rec_copy->kammer_note =  (rec->kammer_note);
  return rec_copy;
}

BseNoteDescription*
bse_note_description_from_rec (SfiRec *sfi_rec)
{
  GValue *element;
  BseNoteDescription* rec;
  if (!sfi_rec)
    return NULL;

  rec = g_new0 (BseNoteDescription, 1);
  element = sfi_rec_get (sfi_rec, "note");
  if (element)
    rec->note = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "octave");
  if (element)
    rec->octave = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "freq");
  if (element)
    rec->freq = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "fine_tune");
  if (element)
    rec->fine_tune = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "semitone");
  if (element)
    rec->semitone = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "upshift");
  if (element)
    rec->upshift = sfi_value_get_bool (element);
  element = sfi_rec_get (sfi_rec, "letter");
  if (element)
    rec->letter = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "name");
  if (element)
    rec->name = sfi_value_dup_string (element);
  element = sfi_rec_get (sfi_rec, "max_fine_tune");
  if (element)
    rec->max_fine_tune = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "kammer_note");
  if (element)
    rec->kammer_note = sfi_value_get_int (element);
  return rec;
}

SfiRec *
bse_note_description_to_rec (BseNoteDescription* rec)
{
  SfiRec *sfi_rec;
  GValue *element;
  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->note);
  sfi_rec_set (sfi_rec, "note", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->octave);
  sfi_rec_set (sfi_rec, "octave", element);
  sfi_value_free (element);
  element = sfi_value_real (rec->freq);
  sfi_rec_set (sfi_rec, "freq", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->fine_tune);
  sfi_rec_set (sfi_rec, "fine_tune", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->semitone);
  sfi_rec_set (sfi_rec, "semitone", element);
  sfi_value_free (element);
  element = sfi_value_bool (rec->upshift);
  sfi_rec_set (sfi_rec, "upshift", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->letter);
  sfi_rec_set (sfi_rec, "letter", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->name);
  sfi_rec_set (sfi_rec, "name", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->max_fine_tune);
  sfi_rec_set (sfi_rec, "max_fine_tune", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->kammer_note);
  sfi_rec_set (sfi_rec, "kammer_note", element);
  sfi_value_free (element);
  return sfi_rec;
}

void
bse_note_description_free (BseNoteDescription* rec)
{
  g_return_if_fail (rec != NULL);
  
  if (rec->name) g_free (rec->name);
  g_free (rec);
}


BseNoteSequence*
bse_note_sequence_new (void)
{
  BseNoteSequence* rec = g_new0 (BseNoteSequence, 1);
  rec->notes = bse_note_seq_new();
  return rec;
}

BseNoteSequence*
bse_note_sequence_copy_shallow (BseNoteSequence* rec)
{
  BseNoteSequence* rec_copy;
  if (!rec)
    return NULL;
  rec_copy = g_new0 (BseNoteSequence, 1);
  rec_copy->offset =  (rec->offset);
  rec_copy->notes = bse_note_seq_copy_shallow (rec->notes);
  return rec_copy;
}

BseNoteSequence*
bse_note_sequence_from_rec (SfiRec *sfi_rec)
{
  GValue *element;
  BseNoteSequence* rec;
  if (!sfi_rec)
    return NULL;

  rec = g_new0 (BseNoteSequence, 1);
  element = sfi_rec_get (sfi_rec, "offset");
  if (element)
    rec->offset = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "notes");
  if (element)
    rec->notes = bse_note_seq_from_seq (sfi_value_get_seq (element));
  else
    rec->notes = bse_note_seq_new();
  return rec;
}

SfiRec *
bse_note_sequence_to_rec (BseNoteSequence* rec)
{
  SfiRec *sfi_rec;
  GValue *element;
  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->offset);
  sfi_rec_set (sfi_rec, "offset", element);
  sfi_value_free (element);
  element = sfi_value_new_take_seq (bse_note_seq_to_seq (rec->notes));
  sfi_rec_set (sfi_rec, "notes", element);
  sfi_value_free (element);
  return sfi_rec;
}

void
bse_note_sequence_free (BseNoteSequence* rec)
{
  g_return_if_fail (rec != NULL);
  
  if (rec->notes) bse_note_seq_free (rec->notes);
  g_free (rec);
}


BseIcon*
bse_icon_new (void)
{
  BseIcon* rec = g_new0 (BseIcon, 1);
  rec->pixels = sfi_bblock_new();
  return rec;
}

BseIcon*
bse_icon_copy_shallow (BseIcon* rec)
{
  BseIcon* rec_copy;
  if (!rec)
    return NULL;
  rec_copy = g_new0 (BseIcon, 1);
  rec_copy->bytes_per_pixel =  (rec->bytes_per_pixel);
  rec_copy->width =  (rec->width);
  rec_copy->height =  (rec->height);
  rec_copy->pixels = sfi_bblock_ref (rec->pixels);
  return rec_copy;
}

BseIcon*
bse_icon_from_rec (SfiRec *sfi_rec)
{
  GValue *element;
  BseIcon* rec;
  if (!sfi_rec)
    return NULL;

  rec = g_new0 (BseIcon, 1);
  element = sfi_rec_get (sfi_rec, "bytes_per_pixel");
  if (element)
    rec->bytes_per_pixel = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "width");
  if (element)
    rec->width = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "height");
  if (element)
    rec->height = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "pixels");
  if (element)
    rec->pixels = sfi_bblock_ref (sfi_value_get_bblock (element));
  else
    rec->pixels = sfi_bblock_new();
  return rec;
}

SfiRec *
bse_icon_to_rec (BseIcon* rec)
{
  SfiRec *sfi_rec;
  GValue *element;
  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->bytes_per_pixel);
  sfi_rec_set (sfi_rec, "bytes_per_pixel", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->width);
  sfi_rec_set (sfi_rec, "width", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->height);
  sfi_rec_set (sfi_rec, "height", element);
  sfi_value_free (element);
  element = sfi_value_bblock (rec->pixels);
  sfi_rec_set (sfi_rec, "pixels", element);
  sfi_value_free (element);
  return sfi_rec;
}

void
bse_icon_free (BseIcon* rec)
{
  g_return_if_fail (rec != NULL);
  
  if (rec->pixels) sfi_bblock_unref (rec->pixels);
  g_free (rec);
}


BseCategory*
bse_category_new (void)
{
  BseCategory* rec = g_new0 (BseCategory, 1);
  rec->icon = bse_icon_new();
  return rec;
}

BseCategory*
bse_category_copy_shallow (BseCategory* rec)
{
  BseCategory* rec_copy;
  if (!rec)
    return NULL;
  rec_copy = g_new0 (BseCategory, 1);
  rec_copy->category_id =  (rec->category_id);
  rec_copy->category = g_strdup (rec->category);
  rec_copy->mindex =  (rec->mindex);
  rec_copy->lindex =  (rec->lindex);
  rec_copy->type = g_strdup (rec->type);
  rec_copy->icon = bse_icon_copy_shallow (rec->icon);
  return rec_copy;
}

BseCategory*
bse_category_from_rec (SfiRec *sfi_rec)
{
  GValue *element;
  BseCategory* rec;
  if (!sfi_rec)
    return NULL;

  rec = g_new0 (BseCategory, 1);
  element = sfi_rec_get (sfi_rec, "category_id");
  if (element)
    rec->category_id = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "category");
  if (element)
    rec->category = sfi_value_dup_string (element);
  element = sfi_rec_get (sfi_rec, "mindex");
  if (element)
    rec->mindex = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "lindex");
  if (element)
    rec->lindex = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "type");
  if (element)
    rec->type = sfi_value_dup_string (element);
  element = sfi_rec_get (sfi_rec, "icon");
  if (element)
    rec->icon = bse_icon_from_rec (sfi_value_get_rec (element));
  else
    rec->icon = bse_icon_new();
  return rec;
}

SfiRec *
bse_category_to_rec (BseCategory* rec)
{
  SfiRec *sfi_rec;
  GValue *element;
  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->category_id);
  sfi_rec_set (sfi_rec, "category_id", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->category);
  sfi_rec_set (sfi_rec, "category", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->mindex);
  sfi_rec_set (sfi_rec, "mindex", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->lindex);
  sfi_rec_set (sfi_rec, "lindex", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->type);
  sfi_rec_set (sfi_rec, "type", element);
  sfi_value_free (element);
  element = sfi_value_new_take_rec (bse_icon_to_rec (rec->icon));
  sfi_rec_set (sfi_rec, "icon", element);
  sfi_value_free (element);
  return sfi_rec;
}

void
bse_category_free (BseCategory* rec)
{
  g_return_if_fail (rec != NULL);
  
  if (rec->category) g_free (rec->category);
  if (rec->type) g_free (rec->type);
  if (rec->icon) bse_icon_free (rec->icon);
  g_free (rec);
}


BseDot*
bse_dot_new (void)
{
  BseDot* rec = g_new0 (BseDot, 1);
  return rec;
}

BseDot*
bse_dot_copy_shallow (BseDot* rec)
{
  BseDot* rec_copy;
  if (!rec)
    return NULL;
  rec_copy = g_new0 (BseDot, 1);
  rec_copy->x =  (rec->x);
  rec_copy->y =  (rec->y);
  return rec_copy;
}

BseDot*
bse_dot_from_rec (SfiRec *sfi_rec)
{
  GValue *element;
  BseDot* rec;
  if (!sfi_rec)
    return NULL;

  rec = g_new0 (BseDot, 1);
  element = sfi_rec_get (sfi_rec, "x");
  if (element)
    rec->x = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "y");
  if (element)
    rec->y = sfi_value_get_real (element);
  return rec;
}

SfiRec *
bse_dot_to_rec (BseDot* rec)
{
  SfiRec *sfi_rec;
  GValue *element;
  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_value_real (rec->x);
  sfi_rec_set (sfi_rec, "x", element);
  sfi_value_free (element);
  element = sfi_value_real (rec->y);
  sfi_rec_set (sfi_rec, "y", element);
  sfi_value_free (element);
  return sfi_rec;
}

void
bse_dot_free (BseDot* rec)
{
  g_return_if_fail (rec != NULL);
  
  g_free (rec);
}


BseTrackPart*
bse_track_part_new (void)
{
  BseTrackPart* rec = g_new0 (BseTrackPart, 1);
  return rec;
}

BseTrackPart*
bse_track_part_copy_shallow (BseTrackPart* rec)
{
  BseTrackPart* rec_copy;
  if (!rec)
    return NULL;
  rec_copy = g_new0 (BseTrackPart, 1);
  rec_copy->tick =  (rec->tick);
  rec_copy->part =  (rec->part);
  rec_copy->duration =  (rec->duration);
  return rec_copy;
}

BseTrackPart*
bse_track_part_from_rec (SfiRec *sfi_rec)
{
  GValue *element;
  BseTrackPart* rec;
  if (!sfi_rec)
    return NULL;

  rec = g_new0 (BseTrackPart, 1);
  element = sfi_rec_get (sfi_rec, "tick");
  if (element)
    rec->tick = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "part");
  if (element)
    rec->part = sfi_value_get_proxy (element);
  element = sfi_rec_get (sfi_rec, "duration");
  if (element)
    rec->duration = sfi_value_get_int (element);
  return rec;
}

SfiRec *
bse_track_part_to_rec (BseTrackPart* rec)
{
  SfiRec *sfi_rec;
  GValue *element;
  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->tick);
  sfi_rec_set (sfi_rec, "tick", element);
  sfi_value_free (element);
  element = sfi_value_proxy (rec->part);
  sfi_rec_set (sfi_rec, "part", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->duration);
  sfi_rec_set (sfi_rec, "duration", element);
  sfi_value_free (element);
  return sfi_rec;
}

void
bse_track_part_free (BseTrackPart* rec)
{
  g_return_if_fail (rec != NULL);
  
  g_free (rec);
}


BseSongTiming*
bse_song_timing_new (void)
{
  BseSongTiming* rec = g_new0 (BseSongTiming, 1);
  return rec;
}

BseSongTiming*
bse_song_timing_copy_shallow (BseSongTiming* rec)
{
  BseSongTiming* rec_copy;
  if (!rec)
    return NULL;
  rec_copy = g_new0 (BseSongTiming, 1);
  rec_copy->tick =  (rec->tick);
  rec_copy->bpm =  (rec->bpm);
  rec_copy->numerator =  (rec->numerator);
  rec_copy->denominator =  (rec->denominator);
  rec_copy->tpqn =  (rec->tpqn);
  rec_copy->tpt =  (rec->tpt);
  return rec_copy;
}

BseSongTiming*
bse_song_timing_from_rec (SfiRec *sfi_rec)
{
  GValue *element;
  BseSongTiming* rec;
  if (!sfi_rec)
    return NULL;

  rec = g_new0 (BseSongTiming, 1);
  element = sfi_rec_get (sfi_rec, "tick");
  if (element)
    rec->tick = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "bpm");
  if (element)
    rec->bpm = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "numerator");
  if (element)
    rec->numerator = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "denominator");
  if (element)
    rec->denominator = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "tpqn");
  if (element)
    rec->tpqn = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "tpt");
  if (element)
    rec->tpt = sfi_value_get_int (element);
  return rec;
}

SfiRec *
bse_song_timing_to_rec (BseSongTiming* rec)
{
  SfiRec *sfi_rec;
  GValue *element;
  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->tick);
  sfi_rec_set (sfi_rec, "tick", element);
  sfi_value_free (element);
  element = sfi_value_real (rec->bpm);
  sfi_rec_set (sfi_rec, "bpm", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->numerator);
  sfi_rec_set (sfi_rec, "numerator", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->denominator);
  sfi_rec_set (sfi_rec, "denominator", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->tpqn);
  sfi_rec_set (sfi_rec, "tpqn", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->tpt);
  sfi_rec_set (sfi_rec, "tpt", element);
  sfi_value_free (element);
  return sfi_rec;
}

void
bse_song_timing_free (BseSongTiming* rec)
{
  g_return_if_fail (rec != NULL);
  
  g_free (rec);
}


BseSampleFileInfo*
bse_sample_file_info_new (void)
{
  BseSampleFileInfo* rec = g_new0 (BseSampleFileInfo, 1);
  rec->waves = bse_string_seq_new();
  return rec;
}

BseSampleFileInfo*
bse_sample_file_info_copy_shallow (BseSampleFileInfo* rec)
{
  BseSampleFileInfo* rec_copy;
  if (!rec)
    return NULL;
  rec_copy = g_new0 (BseSampleFileInfo, 1);
  rec_copy->file = g_strdup (rec->file);
  rec_copy->size =  (rec->size);
  rec_copy->mtime =  (rec->mtime);
  rec_copy->loader = g_strdup (rec->loader);
  rec_copy->waves = bse_string_seq_copy_shallow (rec->waves);
  rec_copy->error =  (rec->error);
  return rec_copy;
}

BseSampleFileInfo*
bse_sample_file_info_from_rec (SfiRec *sfi_rec)
{
  GValue *element;
  BseSampleFileInfo* rec;
  if (!sfi_rec)
    return NULL;

  rec = g_new0 (BseSampleFileInfo, 1);
  element = sfi_rec_get (sfi_rec, "file");
  if (element)
    rec->file = sfi_value_dup_string (element);
  element = sfi_rec_get (sfi_rec, "size");
  if (element)
    rec->size = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "mtime");
  if (element)
    rec->mtime = sfi_value_get_num (element);
  element = sfi_rec_get (sfi_rec, "loader");
  if (element)
    rec->loader = sfi_value_dup_string (element);
  element = sfi_rec_get (sfi_rec, "waves");
  if (element)
    rec->waves = bse_string_seq_from_seq (sfi_value_get_seq (element));
  else
    rec->waves = bse_string_seq_new();
  element = sfi_rec_get (sfi_rec, "error");
  if (element)
    rec->error = sfi_value_get_int (element);
  return rec;
}

SfiRec *
bse_sample_file_info_to_rec (BseSampleFileInfo* rec)
{
  SfiRec *sfi_rec;
  GValue *element;
  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_value_string (rec->file);
  sfi_rec_set (sfi_rec, "file", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->size);
  sfi_rec_set (sfi_rec, "size", element);
  sfi_value_free (element);
  element = sfi_value_num (rec->mtime);
  sfi_rec_set (sfi_rec, "mtime", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->loader);
  sfi_rec_set (sfi_rec, "loader", element);
  sfi_value_free (element);
  element = sfi_value_new_take_seq (bse_string_seq_to_seq (rec->waves));
  sfi_rec_set (sfi_rec, "waves", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->error);
  sfi_rec_set (sfi_rec, "error", element);
  sfi_value_free (element);
  return sfi_rec;
}

void
bse_sample_file_info_free (BseSampleFileInfo* rec)
{
  g_return_if_fail (rec != NULL);
  
  if (rec->file) g_free (rec->file);
  if (rec->loader) g_free (rec->loader);
  if (rec->waves) bse_string_seq_free (rec->waves);
  g_free (rec);
}


BseGConfig*
bse_gconfig_new (void)
{
  BseGConfig* rec = g_new0 (BseGConfig, 1);
  return rec;
}

BseGConfig*
bse_gconfig_copy_shallow (BseGConfig* rec)
{
  BseGConfig* rec_copy;
  if (!rec)
    return NULL;
  rec_copy = g_new0 (BseGConfig, 1);
  rec_copy->sample_path = g_strdup (rec->sample_path);
  rec_copy->effect_path = g_strdup (rec->effect_path);
  rec_copy->instrument_path = g_strdup (rec->instrument_path);
  rec_copy->script_path = g_strdup (rec->script_path);
  rec_copy->plugin_path = g_strdup (rec->plugin_path);
  rec_copy->ladspa_path = g_strdup (rec->ladspa_path);
  rec_copy->synth_latency =  (rec->synth_latency);
  rec_copy->synth_mixing_freq =  (rec->synth_mixing_freq);
  rec_copy->synth_control_freq =  (rec->synth_control_freq);
  rec_copy->invert_sustain =  (rec->invert_sustain);
  rec_copy->step_volume_dB =  (rec->step_volume_dB);
  rec_copy->step_bpm =  (rec->step_bpm);
  return rec_copy;
}

BseGConfig*
bse_gconfig_from_rec (SfiRec *sfi_rec)
{
  GValue *element;
  BseGConfig* rec;
  if (!sfi_rec)
    return NULL;

  rec = g_new0 (BseGConfig, 1);
  element = sfi_rec_get (sfi_rec, "sample_path");
  if (element)
    rec->sample_path = sfi_value_dup_string (element);
  element = sfi_rec_get (sfi_rec, "effect_path");
  if (element)
    rec->effect_path = sfi_value_dup_string (element);
  element = sfi_rec_get (sfi_rec, "instrument_path");
  if (element)
    rec->instrument_path = sfi_value_dup_string (element);
  element = sfi_rec_get (sfi_rec, "script_path");
  if (element)
    rec->script_path = sfi_value_dup_string (element);
  element = sfi_rec_get (sfi_rec, "plugin_path");
  if (element)
    rec->plugin_path = sfi_value_dup_string (element);
  element = sfi_rec_get (sfi_rec, "ladspa_path");
  if (element)
    rec->ladspa_path = sfi_value_dup_string (element);
  element = sfi_rec_get (sfi_rec, "synth_latency");
  if (element)
    rec->synth_latency = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "synth_mixing_freq");
  if (element)
    rec->synth_mixing_freq = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "synth_control_freq");
  if (element)
    rec->synth_control_freq = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "invert_sustain");
  if (element)
    rec->invert_sustain = sfi_value_get_bool (element);
  element = sfi_rec_get (sfi_rec, "step_volume_dB");
  if (element)
    rec->step_volume_dB = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "step_bpm");
  if (element)
    rec->step_bpm = sfi_value_get_int (element);
  return rec;
}

SfiRec *
bse_gconfig_to_rec (BseGConfig* rec)
{
  SfiRec *sfi_rec;
  GValue *element;
  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_value_string (rec->sample_path);
  sfi_rec_set (sfi_rec, "sample_path", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->effect_path);
  sfi_rec_set (sfi_rec, "effect_path", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->instrument_path);
  sfi_rec_set (sfi_rec, "instrument_path", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->script_path);
  sfi_rec_set (sfi_rec, "script_path", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->plugin_path);
  sfi_rec_set (sfi_rec, "plugin_path", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->ladspa_path);
  sfi_rec_set (sfi_rec, "ladspa_path", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->synth_latency);
  sfi_rec_set (sfi_rec, "synth_latency", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->synth_mixing_freq);
  sfi_rec_set (sfi_rec, "synth_mixing_freq", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->synth_control_freq);
  sfi_rec_set (sfi_rec, "synth_control_freq", element);
  sfi_value_free (element);
  element = sfi_value_bool (rec->invert_sustain);
  sfi_rec_set (sfi_rec, "invert_sustain", element);
  sfi_value_free (element);
  element = sfi_value_real (rec->step_volume_dB);
  sfi_rec_set (sfi_rec, "step_volume_dB", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->step_bpm);
  sfi_rec_set (sfi_rec, "step_bpm", element);
  sfi_value_free (element);
  return sfi_rec;
}

void
bse_gconfig_free (BseGConfig* rec)
{
  g_return_if_fail (rec != NULL);
  
  if (rec->sample_path) g_free (rec->sample_path);
  if (rec->effect_path) g_free (rec->effect_path);
  if (rec->instrument_path) g_free (rec->instrument_path);
  if (rec->script_path) g_free (rec->script_path);
  if (rec->plugin_path) g_free (rec->plugin_path);
  if (rec->ladspa_path) g_free (rec->ladspa_path);
  g_free (rec);
}


BseSnifferRequest*
bse_sniffer_request_new (void)
{
  BseSnifferRequest* rec = g_new0 (BseSnifferRequest, 1);
  return rec;
}

BseSnifferRequest*
bse_sniffer_request_copy_shallow (BseSnifferRequest* rec)
{
  BseSnifferRequest* rec_copy;
  if (!rec)
    return NULL;
  rec_copy = g_new0 (BseSnifferRequest, 1);
  rec_copy->sniffer =  (rec->sniffer);
  rec_copy->time_type =  (rec->time_type);
  rec_copy->variable_time =  (rec->variable_time);
  rec_copy->n_samples =  (rec->n_samples);
  rec_copy->sniffer_type =  (rec->sniffer_type);
  return rec_copy;
}

BseSnifferRequest*
bse_sniffer_request_from_rec (SfiRec *sfi_rec)
{
  GValue *element;
  BseSnifferRequest* rec;
  if (!sfi_rec)
    return NULL;

  rec = g_new0 (BseSnifferRequest, 1);
  element = sfi_rec_get (sfi_rec, "sniffer");
  if (element)
    rec->sniffer = sfi_value_get_proxy (element);
  element = sfi_rec_get (sfi_rec, "time_type");
  if (element)
    rec->time_type = bse_sniffer_time_type_from_choice (sfi_value_get_choice (element));
  element = sfi_rec_get (sfi_rec, "variable_time");
  if (element)
    rec->variable_time = sfi_value_get_num (element);
  element = sfi_rec_get (sfi_rec, "n_samples");
  if (element)
    rec->n_samples = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "sniffer_type");
  if (element)
    rec->sniffer_type = bse_sniffer_type_from_choice (sfi_value_get_choice (element));
  return rec;
}

SfiRec *
bse_sniffer_request_to_rec (BseSnifferRequest* rec)
{
  SfiRec *sfi_rec;
  GValue *element;
  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_value_proxy (rec->sniffer);
  sfi_rec_set (sfi_rec, "sniffer", element);
  sfi_value_free (element);
  element = sfi_value_choice (bse_sniffer_time_type_to_choice (rec->time_type));
  sfi_rec_set (sfi_rec, "time_type", element);
  sfi_value_free (element);
  element = sfi_value_num (rec->variable_time);
  sfi_rec_set (sfi_rec, "variable_time", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->n_samples);
  sfi_rec_set (sfi_rec, "n_samples", element);
  sfi_value_free (element);
  element = sfi_value_choice (bse_sniffer_type_to_choice (rec->sniffer_type));
  sfi_rec_set (sfi_rec, "sniffer_type", element);
  sfi_value_free (element);
  return sfi_rec;
}

void
bse_sniffer_request_free (BseSnifferRequest* rec)
{
  g_return_if_fail (rec != NULL);
  
  g_free (rec);
}


BseIntSeq*
bse_int_seq_new (void)
{
  return g_new0 (BseIntSeq, 1);
}

void
bse_int_seq_append (BseIntSeq* seq, SfiInt element)
{
  g_return_if_fail (seq != NULL);

  seq->ints = g_realloc (seq->ints, (seq->n_ints + 1) * sizeof (seq->ints[0]));
  seq->ints[seq->n_ints++] =  (element);
}

BseIntSeq*
bse_int_seq_copy_shallow (BseIntSeq* seq)
{
  BseIntSeq* seq_copy;
  guint i;
  if (!seq)
    return NULL;

  seq_copy = bse_int_seq_new ();
  for (i = 0; i < seq->n_ints; i++)
    bse_int_seq_append (seq_copy, seq->ints[i]);
  return seq_copy;
}

BseIntSeq*
bse_int_seq_from_seq (SfiSeq *sfi_seq)
{
  BseIntSeq* seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, NULL);

  length = sfi_seq_length (sfi_seq);
  seq = g_new0 (BseIntSeq, 1);
  seq->n_ints = length;
  seq->ints = g_malloc (seq->n_ints * sizeof (seq->ints[0]));

  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      seq->ints[i] = sfi_value_get_int (element);
    }
  return seq;
}

SfiSeq *
bse_int_seq_to_seq (BseIntSeq* seq)
{
  SfiSeq *sfi_seq;
  guint i;

  g_return_val_if_fail (seq != NULL, NULL);

  sfi_seq = sfi_seq_new ();
  for (i = 0; i < seq->n_ints; i++)
    {
      GValue *element = sfi_value_int (seq->ints[i]);
      sfi_seq_append (sfi_seq, element);
      sfi_value_free (element);
    }
  return sfi_seq;
}

void
bse_int_seq_resize (BseIntSeq* seq, guint new_size)
{
  g_return_if_fail (seq != NULL);


  seq->ints = g_realloc (seq->ints, new_size * sizeof (seq->ints[0]));
  if (new_size > seq->n_ints)
    memset (&seq->ints[seq->n_ints], 0, sizeof(seq->ints[0]) * (new_size - seq->n_ints));
  seq->n_ints = new_size;
}

void
bse_int_seq_free (BseIntSeq* seq)
{
  g_return_if_fail (seq != NULL);
  
  g_free (seq->ints);
  g_free (seq);
}


BseNoteSeq*
bse_note_seq_new (void)
{
  return g_new0 (BseNoteSeq, 1);
}

void
bse_note_seq_append (BseNoteSeq* seq, SfiInt element)
{
  g_return_if_fail (seq != NULL);

  seq->notes = g_realloc (seq->notes, (seq->n_notes + 1) * sizeof (seq->notes[0]));
  seq->notes[seq->n_notes++] =  (element);
}

BseNoteSeq*
bse_note_seq_copy_shallow (BseNoteSeq* seq)
{
  BseNoteSeq* seq_copy;
  guint i;
  if (!seq)
    return NULL;

  seq_copy = bse_note_seq_new ();
  for (i = 0; i < seq->n_notes; i++)
    bse_note_seq_append (seq_copy, seq->notes[i]);
  return seq_copy;
}

BseNoteSeq*
bse_note_seq_from_seq (SfiSeq *sfi_seq)
{
  BseNoteSeq* seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, NULL);

  length = sfi_seq_length (sfi_seq);
  seq = g_new0 (BseNoteSeq, 1);
  seq->n_notes = length;
  seq->notes = g_malloc (seq->n_notes * sizeof (seq->notes[0]));

  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      seq->notes[i] = sfi_value_get_int (element);
    }
  return seq;
}

SfiSeq *
bse_note_seq_to_seq (BseNoteSeq* seq)
{
  SfiSeq *sfi_seq;
  guint i;

  g_return_val_if_fail (seq != NULL, NULL);

  sfi_seq = sfi_seq_new ();
  for (i = 0; i < seq->n_notes; i++)
    {
      GValue *element = sfi_value_int (seq->notes[i]);
      sfi_seq_append (sfi_seq, element);
      sfi_value_free (element);
    }
  return sfi_seq;
}

void
bse_note_seq_resize (BseNoteSeq* seq, guint new_size)
{
  g_return_if_fail (seq != NULL);


  seq->notes = g_realloc (seq->notes, new_size * sizeof (seq->notes[0]));
  if (new_size > seq->n_notes)
    memset (&seq->notes[seq->n_notes], 0, sizeof(seq->notes[0]) * (new_size - seq->n_notes));
  seq->n_notes = new_size;
}

void
bse_note_seq_free (BseNoteSeq* seq)
{
  g_return_if_fail (seq != NULL);
  
  g_free (seq->notes);
  g_free (seq);
}


BseStringSeq*
bse_string_seq_new (void)
{
  return g_new0 (BseStringSeq, 1);
}

void
bse_string_seq_append (BseStringSeq* seq, const gchar* element)
{
  g_return_if_fail (seq != NULL);

  seq->strings = g_realloc (seq->strings, (seq->n_strings + 1) * sizeof (seq->strings[0]));
  seq->strings[seq->n_strings++] = g_strdup (element);
}

BseStringSeq*
bse_string_seq_copy_shallow (BseStringSeq* seq)
{
  BseStringSeq* seq_copy;
  guint i;
  if (!seq)
    return NULL;

  seq_copy = bse_string_seq_new ();
  for (i = 0; i < seq->n_strings; i++)
    bse_string_seq_append (seq_copy, seq->strings[i]);
  return seq_copy;
}

BseStringSeq*
bse_string_seq_from_seq (SfiSeq *sfi_seq)
{
  BseStringSeq* seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, NULL);

  length = sfi_seq_length (sfi_seq);
  seq = g_new0 (BseStringSeq, 1);
  seq->n_strings = length;
  seq->strings = g_malloc (seq->n_strings * sizeof (seq->strings[0]));

  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      seq->strings[i] = sfi_value_dup_string (element);
    }
  return seq;
}

SfiSeq *
bse_string_seq_to_seq (BseStringSeq* seq)
{
  SfiSeq *sfi_seq;
  guint i;

  g_return_val_if_fail (seq != NULL, NULL);

  sfi_seq = sfi_seq_new ();
  for (i = 0; i < seq->n_strings; i++)
    {
      GValue *element = sfi_value_string (seq->strings[i]);
      sfi_seq_append (sfi_seq, element);
      sfi_value_free (element);
    }
  return sfi_seq;
}

void
bse_string_seq_resize (BseStringSeq* seq, guint new_size)
{
  g_return_if_fail (seq != NULL);

  if (seq->n_strings > new_size)
    {
      guint i;
      for (i = new_size; i < seq->n_strings; i++)
        if (seq->strings[i])  g_free (seq->strings[i]);
    }

  seq->strings = g_realloc (seq->strings, new_size * sizeof (seq->strings[0]));
  if (new_size > seq->n_strings)
    memset (&seq->strings[seq->n_strings], 0, sizeof(seq->strings[0]) * (new_size - seq->n_strings));
  seq->n_strings = new_size;
}

void
bse_string_seq_free (BseStringSeq* seq)
{
  guint i;

  g_return_if_fail (seq != NULL);
  
  for (i = 0; i < seq->n_strings; i++)
        if (seq->strings[i])  g_free (seq->strings[i]);
  g_free (seq->strings);
  g_free (seq);
}


BseItemSeq*
bse_item_seq_new (void)
{
  return g_new0 (BseItemSeq, 1);
}

void
bse_item_seq_append (BseItemSeq* seq, SfiProxy element)
{
  g_return_if_fail (seq != NULL);

  seq->items = g_realloc (seq->items, (seq->n_items + 1) * sizeof (seq->items[0]));
  seq->items[seq->n_items++] =  (element);
}

BseItemSeq*
bse_item_seq_copy_shallow (BseItemSeq* seq)
{
  BseItemSeq* seq_copy;
  guint i;
  if (!seq)
    return NULL;

  seq_copy = bse_item_seq_new ();
  for (i = 0; i < seq->n_items; i++)
    bse_item_seq_append (seq_copy, seq->items[i]);
  return seq_copy;
}

BseItemSeq*
bse_item_seq_from_seq (SfiSeq *sfi_seq)
{
  BseItemSeq* seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, NULL);

  length = sfi_seq_length (sfi_seq);
  seq = g_new0 (BseItemSeq, 1);
  seq->n_items = length;
  seq->items = g_malloc (seq->n_items * sizeof (seq->items[0]));

  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      seq->items[i] = sfi_value_get_proxy (element);
    }
  return seq;
}

SfiSeq *
bse_item_seq_to_seq (BseItemSeq* seq)
{
  SfiSeq *sfi_seq;
  guint i;

  g_return_val_if_fail (seq != NULL, NULL);

  sfi_seq = sfi_seq_new ();
  for (i = 0; i < seq->n_items; i++)
    {
      GValue *element = sfi_value_proxy (seq->items[i]);
      sfi_seq_append (sfi_seq, element);
      sfi_value_free (element);
    }
  return sfi_seq;
}

void
bse_item_seq_resize (BseItemSeq* seq, guint new_size)
{
  g_return_if_fail (seq != NULL);


  seq->items = g_realloc (seq->items, new_size * sizeof (seq->items[0]));
  if (new_size > seq->n_items)
    memset (&seq->items[seq->n_items], 0, sizeof(seq->items[0]) * (new_size - seq->n_items));
  seq->n_items = new_size;
}

void
bse_item_seq_free (BseItemSeq* seq)
{
  g_return_if_fail (seq != NULL);
  
  g_free (seq->items);
  g_free (seq);
}


BsePartNoteSeq*
bse_part_note_seq_new (void)
{
  return g_new0 (BsePartNoteSeq, 1);
}

void
bse_part_note_seq_append (BsePartNoteSeq* seq, BsePartNote* element)
{
  g_return_if_fail (seq != NULL);

  seq->pnotes = g_realloc (seq->pnotes, (seq->n_pnotes + 1) * sizeof (seq->pnotes[0]));
  seq->pnotes[seq->n_pnotes++] = bse_part_note_copy_shallow (element);
}

BsePartNoteSeq*
bse_part_note_seq_copy_shallow (BsePartNoteSeq* seq)
{
  BsePartNoteSeq* seq_copy;
  guint i;
  if (!seq)
    return NULL;

  seq_copy = bse_part_note_seq_new ();
  for (i = 0; i < seq->n_pnotes; i++)
    bse_part_note_seq_append (seq_copy, seq->pnotes[i]);
  return seq_copy;
}

BsePartNoteSeq*
bse_part_note_seq_from_seq (SfiSeq *sfi_seq)
{
  BsePartNoteSeq* seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, NULL);

  length = sfi_seq_length (sfi_seq);
  seq = g_new0 (BsePartNoteSeq, 1);
  seq->n_pnotes = length;
  seq->pnotes = g_malloc (seq->n_pnotes * sizeof (seq->pnotes[0]));

  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      seq->pnotes[i] = bse_part_note_from_rec (sfi_value_get_rec (element));
    }
  return seq;
}

SfiSeq *
bse_part_note_seq_to_seq (BsePartNoteSeq* seq)
{
  SfiSeq *sfi_seq;
  guint i;

  g_return_val_if_fail (seq != NULL, NULL);

  sfi_seq = sfi_seq_new ();
  for (i = 0; i < seq->n_pnotes; i++)
    {
      GValue *element = sfi_value_new_take_rec (bse_part_note_to_rec (seq->pnotes[i]));
      sfi_seq_append (sfi_seq, element);
      sfi_value_free (element);
    }
  return sfi_seq;
}

void
bse_part_note_seq_resize (BsePartNoteSeq* seq, guint new_size)
{
  g_return_if_fail (seq != NULL);

  if (seq->n_pnotes > new_size)
    {
      guint i;
      for (i = new_size; i < seq->n_pnotes; i++)
        if (seq->pnotes[i])  bse_part_note_free (seq->pnotes[i]);
    }

  seq->pnotes = g_realloc (seq->pnotes, new_size * sizeof (seq->pnotes[0]));
  if (new_size > seq->n_pnotes)
    {
      guint i;
      for (i = seq->n_pnotes; i < new_size; i++)
        seq->pnotes[i] = bse_part_note_new();
    }
  seq->n_pnotes = new_size;
}

void
bse_part_note_seq_free (BsePartNoteSeq* seq)
{
  guint i;

  g_return_if_fail (seq != NULL);
  
  for (i = 0; i < seq->n_pnotes; i++)
        if (seq->pnotes[i])  bse_part_note_free (seq->pnotes[i]);
  g_free (seq->pnotes);
  g_free (seq);
}


BsePartControlSeq*
bse_part_control_seq_new (void)
{
  return g_new0 (BsePartControlSeq, 1);
}

void
bse_part_control_seq_append (BsePartControlSeq* seq, BsePartControl* element)
{
  g_return_if_fail (seq != NULL);

  seq->pcontrols = g_realloc (seq->pcontrols, (seq->n_pcontrols + 1) * sizeof (seq->pcontrols[0]));
  seq->pcontrols[seq->n_pcontrols++] = bse_part_control_copy_shallow (element);
}

BsePartControlSeq*
bse_part_control_seq_copy_shallow (BsePartControlSeq* seq)
{
  BsePartControlSeq* seq_copy;
  guint i;
  if (!seq)
    return NULL;

  seq_copy = bse_part_control_seq_new ();
  for (i = 0; i < seq->n_pcontrols; i++)
    bse_part_control_seq_append (seq_copy, seq->pcontrols[i]);
  return seq_copy;
}

BsePartControlSeq*
bse_part_control_seq_from_seq (SfiSeq *sfi_seq)
{
  BsePartControlSeq* seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, NULL);

  length = sfi_seq_length (sfi_seq);
  seq = g_new0 (BsePartControlSeq, 1);
  seq->n_pcontrols = length;
  seq->pcontrols = g_malloc (seq->n_pcontrols * sizeof (seq->pcontrols[0]));

  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      seq->pcontrols[i] = bse_part_control_from_rec (sfi_value_get_rec (element));
    }
  return seq;
}

SfiSeq *
bse_part_control_seq_to_seq (BsePartControlSeq* seq)
{
  SfiSeq *sfi_seq;
  guint i;

  g_return_val_if_fail (seq != NULL, NULL);

  sfi_seq = sfi_seq_new ();
  for (i = 0; i < seq->n_pcontrols; i++)
    {
      GValue *element = sfi_value_new_take_rec (bse_part_control_to_rec (seq->pcontrols[i]));
      sfi_seq_append (sfi_seq, element);
      sfi_value_free (element);
    }
  return sfi_seq;
}

void
bse_part_control_seq_resize (BsePartControlSeq* seq, guint new_size)
{
  g_return_if_fail (seq != NULL);

  if (seq->n_pcontrols > new_size)
    {
      guint i;
      for (i = new_size; i < seq->n_pcontrols; i++)
        if (seq->pcontrols[i])  bse_part_control_free (seq->pcontrols[i]);
    }

  seq->pcontrols = g_realloc (seq->pcontrols, new_size * sizeof (seq->pcontrols[0]));
  if (new_size > seq->n_pcontrols)
    {
      guint i;
      for (i = seq->n_pcontrols; i < new_size; i++)
        seq->pcontrols[i] = bse_part_control_new();
    }
  seq->n_pcontrols = new_size;
}

void
bse_part_control_seq_free (BsePartControlSeq* seq)
{
  guint i;

  g_return_if_fail (seq != NULL);
  
  for (i = 0; i < seq->n_pcontrols; i++)
        if (seq->pcontrols[i])  bse_part_control_free (seq->pcontrols[i]);
  g_free (seq->pcontrols);
  g_free (seq);
}


BseCategorySeq*
bse_category_seq_new (void)
{
  return g_new0 (BseCategorySeq, 1);
}

void
bse_category_seq_append (BseCategorySeq* seq, BseCategory* element)
{
  g_return_if_fail (seq != NULL);

  seq->cats = g_realloc (seq->cats, (seq->n_cats + 1) * sizeof (seq->cats[0]));
  seq->cats[seq->n_cats++] = bse_category_copy_shallow (element);
}

BseCategorySeq*
bse_category_seq_copy_shallow (BseCategorySeq* seq)
{
  BseCategorySeq* seq_copy;
  guint i;
  if (!seq)
    return NULL;

  seq_copy = bse_category_seq_new ();
  for (i = 0; i < seq->n_cats; i++)
    bse_category_seq_append (seq_copy, seq->cats[i]);
  return seq_copy;
}

BseCategorySeq*
bse_category_seq_from_seq (SfiSeq *sfi_seq)
{
  BseCategorySeq* seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, NULL);

  length = sfi_seq_length (sfi_seq);
  seq = g_new0 (BseCategorySeq, 1);
  seq->n_cats = length;
  seq->cats = g_malloc (seq->n_cats * sizeof (seq->cats[0]));

  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      seq->cats[i] = bse_category_from_rec (sfi_value_get_rec (element));
    }
  return seq;
}

SfiSeq *
bse_category_seq_to_seq (BseCategorySeq* seq)
{
  SfiSeq *sfi_seq;
  guint i;

  g_return_val_if_fail (seq != NULL, NULL);

  sfi_seq = sfi_seq_new ();
  for (i = 0; i < seq->n_cats; i++)
    {
      GValue *element = sfi_value_new_take_rec (bse_category_to_rec (seq->cats[i]));
      sfi_seq_append (sfi_seq, element);
      sfi_value_free (element);
    }
  return sfi_seq;
}

void
bse_category_seq_resize (BseCategorySeq* seq, guint new_size)
{
  g_return_if_fail (seq != NULL);

  if (seq->n_cats > new_size)
    {
      guint i;
      for (i = new_size; i < seq->n_cats; i++)
        if (seq->cats[i])  bse_category_free (seq->cats[i]);
    }

  seq->cats = g_realloc (seq->cats, new_size * sizeof (seq->cats[0]));
  if (new_size > seq->n_cats)
    {
      guint i;
      for (i = seq->n_cats; i < new_size; i++)
        seq->cats[i] = bse_category_new();
    }
  seq->n_cats = new_size;
}

void
bse_category_seq_free (BseCategorySeq* seq)
{
  guint i;

  g_return_if_fail (seq != NULL);
  
  for (i = 0; i < seq->n_cats; i++)
        if (seq->cats[i])  bse_category_free (seq->cats[i]);
  g_free (seq->cats);
  g_free (seq);
}


BseDotSeq*
bse_dot_seq_new (void)
{
  return g_new0 (BseDotSeq, 1);
}

void
bse_dot_seq_append (BseDotSeq* seq, BseDot* element)
{
  g_return_if_fail (seq != NULL);

  seq->dots = g_realloc (seq->dots, (seq->n_dots + 1) * sizeof (seq->dots[0]));
  seq->dots[seq->n_dots++] = bse_dot_copy_shallow (element);
}

BseDotSeq*
bse_dot_seq_copy_shallow (BseDotSeq* seq)
{
  BseDotSeq* seq_copy;
  guint i;
  if (!seq)
    return NULL;

  seq_copy = bse_dot_seq_new ();
  for (i = 0; i < seq->n_dots; i++)
    bse_dot_seq_append (seq_copy, seq->dots[i]);
  return seq_copy;
}

BseDotSeq*
bse_dot_seq_from_seq (SfiSeq *sfi_seq)
{
  BseDotSeq* seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, NULL);

  length = sfi_seq_length (sfi_seq);
  seq = g_new0 (BseDotSeq, 1);
  seq->n_dots = length;
  seq->dots = g_malloc (seq->n_dots * sizeof (seq->dots[0]));

  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      seq->dots[i] = bse_dot_from_rec (sfi_value_get_rec (element));
    }
  return seq;
}

SfiSeq *
bse_dot_seq_to_seq (BseDotSeq* seq)
{
  SfiSeq *sfi_seq;
  guint i;

  g_return_val_if_fail (seq != NULL, NULL);

  sfi_seq = sfi_seq_new ();
  for (i = 0; i < seq->n_dots; i++)
    {
      GValue *element = sfi_value_new_take_rec (bse_dot_to_rec (seq->dots[i]));
      sfi_seq_append (sfi_seq, element);
      sfi_value_free (element);
    }
  return sfi_seq;
}

void
bse_dot_seq_resize (BseDotSeq* seq, guint new_size)
{
  g_return_if_fail (seq != NULL);

  if (seq->n_dots > new_size)
    {
      guint i;
      for (i = new_size; i < seq->n_dots; i++)
        if (seq->dots[i])  bse_dot_free (seq->dots[i]);
    }

  seq->dots = g_realloc (seq->dots, new_size * sizeof (seq->dots[0]));
  if (new_size > seq->n_dots)
    {
      guint i;
      for (i = seq->n_dots; i < new_size; i++)
        seq->dots[i] = bse_dot_new();
    }
  seq->n_dots = new_size;
}

void
bse_dot_seq_free (BseDotSeq* seq)
{
  guint i;

  g_return_if_fail (seq != NULL);
  
  for (i = 0; i < seq->n_dots; i++)
        if (seq->dots[i])  bse_dot_free (seq->dots[i]);
  g_free (seq->dots);
  g_free (seq);
}


BseTrackPartSeq*
bse_track_part_seq_new (void)
{
  return g_new0 (BseTrackPartSeq, 1);
}

void
bse_track_part_seq_append (BseTrackPartSeq* seq, BseTrackPart* element)
{
  g_return_if_fail (seq != NULL);

  seq->tparts = g_realloc (seq->tparts, (seq->n_tparts + 1) * sizeof (seq->tparts[0]));
  seq->tparts[seq->n_tparts++] = bse_track_part_copy_shallow (element);
}

BseTrackPartSeq*
bse_track_part_seq_copy_shallow (BseTrackPartSeq* seq)
{
  BseTrackPartSeq* seq_copy;
  guint i;
  if (!seq)
    return NULL;

  seq_copy = bse_track_part_seq_new ();
  for (i = 0; i < seq->n_tparts; i++)
    bse_track_part_seq_append (seq_copy, seq->tparts[i]);
  return seq_copy;
}

BseTrackPartSeq*
bse_track_part_seq_from_seq (SfiSeq *sfi_seq)
{
  BseTrackPartSeq* seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, NULL);

  length = sfi_seq_length (sfi_seq);
  seq = g_new0 (BseTrackPartSeq, 1);
  seq->n_tparts = length;
  seq->tparts = g_malloc (seq->n_tparts * sizeof (seq->tparts[0]));

  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      seq->tparts[i] = bse_track_part_from_rec (sfi_value_get_rec (element));
    }
  return seq;
}

SfiSeq *
bse_track_part_seq_to_seq (BseTrackPartSeq* seq)
{
  SfiSeq *sfi_seq;
  guint i;

  g_return_val_if_fail (seq != NULL, NULL);

  sfi_seq = sfi_seq_new ();
  for (i = 0; i < seq->n_tparts; i++)
    {
      GValue *element = sfi_value_new_take_rec (bse_track_part_to_rec (seq->tparts[i]));
      sfi_seq_append (sfi_seq, element);
      sfi_value_free (element);
    }
  return sfi_seq;
}

void
bse_track_part_seq_resize (BseTrackPartSeq* seq, guint new_size)
{
  g_return_if_fail (seq != NULL);

  if (seq->n_tparts > new_size)
    {
      guint i;
      for (i = new_size; i < seq->n_tparts; i++)
        if (seq->tparts[i])  bse_track_part_free (seq->tparts[i]);
    }

  seq->tparts = g_realloc (seq->tparts, new_size * sizeof (seq->tparts[0]));
  if (new_size > seq->n_tparts)
    {
      guint i;
      for (i = seq->n_tparts; i < new_size; i++)
        seq->tparts[i] = bse_track_part_new();
    }
  seq->n_tparts = new_size;
}

void
bse_track_part_seq_free (BseTrackPartSeq* seq)
{
  guint i;

  g_return_if_fail (seq != NULL);
  
  for (i = 0; i < seq->n_tparts; i++)
        if (seq->tparts[i])  bse_track_part_free (seq->tparts[i]);
  g_free (seq->tparts);
  g_free (seq);
}


BseSnifferRequestSeq*
bse_sniffer_request_seq_new (void)
{
  return g_new0 (BseSnifferRequestSeq, 1);
}

void
bse_sniffer_request_seq_append (BseSnifferRequestSeq* seq, BseSnifferRequest* element)
{
  g_return_if_fail (seq != NULL);

  seq->requests = g_realloc (seq->requests, (seq->n_requests + 1) * sizeof (seq->requests[0]));
  seq->requests[seq->n_requests++] = bse_sniffer_request_copy_shallow (element);
}

BseSnifferRequestSeq*
bse_sniffer_request_seq_copy_shallow (BseSnifferRequestSeq* seq)
{
  BseSnifferRequestSeq* seq_copy;
  guint i;
  if (!seq)
    return NULL;

  seq_copy = bse_sniffer_request_seq_new ();
  for (i = 0; i < seq->n_requests; i++)
    bse_sniffer_request_seq_append (seq_copy, seq->requests[i]);
  return seq_copy;
}

BseSnifferRequestSeq*
bse_sniffer_request_seq_from_seq (SfiSeq *sfi_seq)
{
  BseSnifferRequestSeq* seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, NULL);

  length = sfi_seq_length (sfi_seq);
  seq = g_new0 (BseSnifferRequestSeq, 1);
  seq->n_requests = length;
  seq->requests = g_malloc (seq->n_requests * sizeof (seq->requests[0]));

  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      seq->requests[i] = bse_sniffer_request_from_rec (sfi_value_get_rec (element));
    }
  return seq;
}

SfiSeq *
bse_sniffer_request_seq_to_seq (BseSnifferRequestSeq* seq)
{
  SfiSeq *sfi_seq;
  guint i;

  g_return_val_if_fail (seq != NULL, NULL);

  sfi_seq = sfi_seq_new ();
  for (i = 0; i < seq->n_requests; i++)
    {
      GValue *element = sfi_value_new_take_rec (bse_sniffer_request_to_rec (seq->requests[i]));
      sfi_seq_append (sfi_seq, element);
      sfi_value_free (element);
    }
  return sfi_seq;
}

void
bse_sniffer_request_seq_resize (BseSnifferRequestSeq* seq, guint new_size)
{
  g_return_if_fail (seq != NULL);

  if (seq->n_requests > new_size)
    {
      guint i;
      for (i = new_size; i < seq->n_requests; i++)
        if (seq->requests[i])  bse_sniffer_request_free (seq->requests[i]);
    }

  seq->requests = g_realloc (seq->requests, new_size * sizeof (seq->requests[0]));
  if (new_size > seq->n_requests)
    {
      guint i;
      for (i = seq->n_requests; i < new_size; i++)
        seq->requests[i] = bse_sniffer_request_new();
    }
  seq->n_requests = new_size;
}

void
bse_sniffer_request_seq_free (BseSnifferRequestSeq* seq)
{
  guint i;

  g_return_if_fail (seq != NULL);
  
  for (i = 0; i < seq->n_requests; i++)
        if (seq->requests[i])  bse_sniffer_request_free (seq->requests[i]);
  g_free (seq->requests);
  g_free (seq);
}


static const SfiConstants bse_midi_signal_type_vals[172] = {
  { "bse-midi-signal-control-0", 25, 45 },
  { "bse-midi-signal-continuous-0", 28, 6 },
  { "bse-midi-signal-control-100", 27, 145 },
  { "bse-midi-signal-control-10", 26, 55 },
  { "bse-midi-signal-continuous-10", 29, 16 },
  { "bse-midi-signal-control-110", 27, 155 },
  { "bse-midi-signal-control-20", 26, 65 },
  { "bse-midi-signal-continuous-20", 29, 26 },
  { "bse-midi-signal-control-120", 27, 165 },
  { "bse-midi-signal-control-30", 26, 75 },
  { "bse-midi-signal-continuous-30", 29, 36 },
  { "bse-midi-signal-control-40", 26, 85 },
  { "bse-midi-signal-control-50", 26, 95 },
  { "bse-midi-signal-control-60", 26, 105 },
  { "bse-midi-signal-control-70", 26, 115 },
  { "bse-midi-signal-control-80", 26, 125 },
  { "bse-midi-signal-control-90", 26, 135 },
  { "bse-midi-signal-control-1", 25, 46 },
  { "bse-midi-signal-continuous-1", 28, 7 },
  { "bse-midi-signal-control-101", 27, 146 },
  { "bse-midi-signal-control-11", 26, 56 },
  { "bse-midi-signal-continuous-11", 29, 17 },
  { "bse-midi-signal-control-111", 27, 156 },
  { "bse-midi-signal-control-21", 26, 66 },
  { "bse-midi-signal-continuous-21", 29, 27 },
  { "bse-midi-signal-control-121", 27, 166 },
  { "bse-midi-signal-control-31", 26, 76 },
  { "bse-midi-signal-continuous-31", 29, 37 },
  { "bse-midi-signal-control-41", 26, 86 },
  { "bse-midi-signal-control-51", 26, 96 },
  { "bse-midi-signal-control-61", 26, 106 },
  { "bse-midi-signal-control-71", 26, 116 },
  { "bse-midi-signal-control-81", 26, 126 },
  { "bse-midi-signal-control-91", 26, 136 },
  { "bse-midi-signal-control-2", 25, 47 },
  { "bse-midi-signal-continuous-2", 28, 8 },
  { "bse-midi-signal-control-102", 27, 147 },
  { "bse-midi-signal-control-12", 26, 57 },
  { "bse-midi-signal-continuous-12", 29, 18 },
  { "bse-midi-signal-control-112", 27, 157 },
  { "bse-midi-signal-control-22", 26, 67 },
  { "bse-midi-signal-continuous-22", 29, 28 },
  { "bse-midi-signal-control-122", 27, 167 },
  { "bse-midi-signal-control-32", 26, 77 },
  { "bse-midi-signal-control-42", 26, 87 },
  { "bse-midi-signal-control-52", 26, 97 },
  { "bse-midi-signal-control-62", 26, 107 },
  { "bse-midi-signal-control-72", 26, 117 },
  { "bse-midi-signal-control-82", 26, 127 },
  { "bse-midi-signal-control-92", 26, 137 },
  { "bse-midi-signal-control-3", 25, 48 },
  { "bse-midi-signal-continuous-3", 28, 9 },
  { "bse-midi-signal-control-103", 27, 148 },
  { "bse-midi-signal-control-13", 26, 58 },
  { "bse-midi-signal-continuous-13", 29, 19 },
  { "bse-midi-signal-control-113", 27, 158 },
  { "bse-midi-signal-control-23", 26, 68 },
  { "bse-midi-signal-continuous-23", 29, 29 },
  { "bse-midi-signal-control-123", 27, 168 },
  { "bse-midi-signal-control-33", 26, 78 },
  { "bse-midi-signal-control-43", 26, 88 },
  { "bse-midi-signal-control-53", 26, 98 },
  { "bse-midi-signal-control-63", 26, 108 },
  { "bse-midi-signal-control-73", 26, 118 },
  { "bse-midi-signal-control-83", 26, 128 },
  { "bse-midi-signal-control-93", 26, 138 },
  { "bse-midi-signal-control-4", 25, 49 },
  { "bse-midi-signal-continuous-4", 28, 10 },
  { "bse-midi-signal-control-104", 27, 149 },
  { "bse-midi-signal-control-14", 26, 59 },
  { "bse-midi-signal-continuous-14", 29, 20 },
  { "bse-midi-signal-control-114", 27, 159 },
  { "bse-midi-signal-control-24", 26, 69 },
  { "bse-midi-signal-continuous-24", 29, 30 },
  { "bse-midi-signal-control-124", 27, 169 },
  { "bse-midi-signal-control-34", 26, 79 },
  { "bse-midi-signal-control-44", 26, 89 },
  { "bse-midi-signal-control-54", 26, 99 },
  { "bse-midi-signal-control-64", 26, 109 },
  { "bse-midi-signal-control-74", 26, 119 },
  { "bse-midi-signal-control-84", 26, 129 },
  { "bse-midi-signal-control-94", 26, 139 },
  { "bse-midi-signal-control-5", 25, 50 },
  { "bse-midi-signal-continuous-5", 28, 11 },
  { "bse-midi-signal-control-105", 27, 150 },
  { "bse-midi-signal-control-15", 26, 60 },
  { "bse-midi-signal-continuous-15", 29, 21 },
  { "bse-midi-signal-control-115", 27, 160 },
  { "bse-midi-signal-control-25", 26, 70 },
  { "bse-midi-signal-continuous-25", 29, 31 },
  { "bse-midi-signal-control-125", 27, 170 },
  { "bse-midi-signal-control-35", 26, 80 },
  { "bse-midi-signal-control-45", 26, 90 },
  { "bse-midi-signal-control-55", 26, 100 },
  { "bse-midi-signal-control-65", 26, 110 },
  { "bse-midi-signal-control-75", 26, 120 },
  { "bse-midi-signal-control-85", 26, 130 },
  { "bse-midi-signal-control-95", 26, 140 },
  { "bse-midi-signal-control-6", 25, 51 },
  { "bse-midi-signal-continuous-6", 28, 12 },
  { "bse-midi-signal-control-106", 27, 151 },
  { "bse-midi-signal-control-16", 26, 61 },
  { "bse-midi-signal-continuous-16", 29, 22 },
  { "bse-midi-signal-control-116", 27, 161 },
  { "bse-midi-signal-control-26", 26, 71 },
  { "bse-midi-signal-continuous-26", 29, 32 },
  { "bse-midi-signal-control-126", 27, 171 },
  { "bse-midi-signal-control-36", 26, 81 },
  { "bse-midi-signal-control-46", 26, 91 },
  { "bse-midi-signal-control-56", 26, 101 },
  { "bse-midi-signal-control-66", 26, 111 },
  { "bse-midi-signal-control-76", 26, 121 },
  { "bse-midi-signal-control-86", 26, 131 },
  { "bse-midi-signal-control-96", 26, 141 },
  { "bse-midi-signal-control-7", 25, 52 },
  { "bse-midi-signal-continuous-7", 28, 13 },
  { "bse-midi-signal-control-107", 27, 152 },
  { "bse-midi-signal-control-17", 26, 62 },
  { "bse-midi-signal-continuous-17", 29, 23 },
  { "bse-midi-signal-control-117", 27, 162 },
  { "bse-midi-signal-control-27", 26, 72 },
  { "bse-midi-signal-continuous-27", 29, 33 },
  { "bse-midi-signal-control-127", 27, 172 },
  { "bse-midi-signal-control-37", 26, 82 },
  { "bse-midi-signal-control-47", 26, 92 },
  { "bse-midi-signal-control-57", 26, 102 },
  { "bse-midi-signal-control-67", 26, 112 },
  { "bse-midi-signal-control-77", 26, 122 },
  { "bse-midi-signal-control-87", 26, 132 },
  { "bse-midi-signal-control-97", 26, 142 },
  { "bse-midi-signal-control-8", 25, 53 },
  { "bse-midi-signal-continuous-8", 28, 14 },
  { "bse-midi-signal-control-108", 27, 153 },
  { "bse-midi-signal-control-18", 26, 63 },
  { "bse-midi-signal-continuous-18", 29, 24 },
  { "bse-midi-signal-control-118", 27, 163 },
  { "bse-midi-signal-control-28", 26, 73 },
  { "bse-midi-signal-continuous-28", 29, 34 },
  { "bse-midi-signal-control-38", 26, 83 },
  { "bse-midi-signal-control-48", 26, 93 },
  { "bse-midi-signal-control-58", 26, 103 },
  { "bse-midi-signal-control-68", 26, 113 },
  { "bse-midi-signal-control-78", 26, 123 },
  { "bse-midi-signal-control-88", 26, 133 },
  { "bse-midi-signal-control-98", 26, 143 },
  { "bse-midi-signal-control-9", 25, 54 },
  { "bse-midi-signal-continuous-9", 28, 15 },
  { "bse-midi-signal-control-109", 27, 154 },
  { "bse-midi-signal-control-19", 26, 64 },
  { "bse-midi-signal-continuous-19", 29, 25 },
  { "bse-midi-signal-control-119", 27, 164 },
  { "bse-midi-signal-control-29", 26, 74 },
  { "bse-midi-signal-continuous-29", 29, 35 },
  { "bse-midi-signal-control-39", 26, 84 },
  { "bse-midi-signal-control-49", 26, 94 },
  { "bse-midi-signal-control-59", 26, 104 },
  { "bse-midi-signal-control-69", 26, 114 },
  { "bse-midi-signal-control-79", 26, 124 },
  { "bse-midi-signal-control-89", 26, 134 },
  { "bse-midi-signal-control-99", 26, 144 },
  { "bse-midi-signal-pitch-bend", 26, 3 },
  { "bse-midi-signal-fine-tune", 25, 5 },
  { "bse-midi-signal-pressure", 24, 2 },
  { "bse-midi-signal-constant-negative-high", 38, 42 },
  { "bse-midi-signal-constant-high", 29, 38 },
  { "bse-midi-signal-program", 23, 1 },
  { "bse-midi-signal-parameter", 25, 43 },
  { "bse-midi-signal-non-parameter", 29, 44 },
  { "bse-midi-signal-constant-negative-center", 40, 41 },
  { "bse-midi-signal-constant-center", 31, 39 },
  { "bse-midi-signal-constant-low", 28, 40 },
  { "bse-midi-signal-velocity", 24, 4 },
};

const gchar*
bse_midi_signal_type_to_choice (BseMidiSignalType value)
{
  g_return_val_if_fail (value >= 1 && value <= 172, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_midi_signal_type_vals), bse_midi_signal_type_vals, value);
}

BseMidiSignalType
bse_midi_signal_type_from_choice (const gchar *choice)
{
  return (BseMidiSignalType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_midi_signal_type_vals), bse_midi_signal_type_vals, choice) : 0);
}

static const SfiConstants bse_biquad_filter_type_vals[2] = {
  { "bse-biquad-filter-resonant-highpass", 35, 2 },
  { "bse-biquad-filter-resonant-lowpass", 34, 1 },
};

const gchar*
bse_biquad_filter_type_to_choice (BseBiquadFilterType value)
{
  g_return_val_if_fail (value >= 1 && value <= 2, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_biquad_filter_type_vals), bse_biquad_filter_type_vals, value);
}

BseBiquadFilterType
bse_biquad_filter_type_from_choice (const gchar *choice)
{
  return (BseBiquadFilterType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_biquad_filter_type_vals), bse_biquad_filter_type_vals, choice) : 0);
}

static const SfiConstants bse_biquad_filter_norm_vals[3] = {
  { "bse-biquad-filter-norm-passband", 31, 1 },
  { "bse-biquad-filter-norm-resonance-gain", 37, 2 },
  { "bse-biquad-filter-norm-peak-gain", 32, 3 },
};

const gchar*
bse_biquad_filter_norm_to_choice (BseBiquadFilterNorm value)
{
  g_return_val_if_fail (value >= 1 && value <= 3, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_biquad_filter_norm_vals), bse_biquad_filter_norm_vals, value);
}

BseBiquadFilterNorm
bse_biquad_filter_norm_from_choice (const gchar *choice)
{
  return (BseBiquadFilterNorm) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_biquad_filter_norm_vals), bse_biquad_filter_norm_vals, choice) : 0);
}

static const SfiConstants bse_registration_type_vals[3] = {
  { "bse-register-done", 17, 3 },
  { "bse-register-plugin", 19, 1 },
  { "bse-register-script", 19, 2 },
};

const gchar*
bse_registration_type_to_choice (BseRegistrationType value)
{
  g_return_val_if_fail (value >= 1 && value <= 3, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_registration_type_vals), bse_registration_type_vals, value);
}

BseRegistrationType
bse_registration_type_from_choice (const gchar *choice)
{
  return (BseRegistrationType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_registration_type_vals), bse_registration_type_vals, choice) : 0);
}

static const SfiConstants bse_user_msg_type_vals[4] = {
  { "bse-user-msg-warning", 20, 3 },
  { "bse-user-msg-question", 21, 2 },
  { "bse-user-msg-info", 17, 1 },
  { "bse-user-msg-error", 18, 4 },
};

const gchar*
bse_user_msg_type_to_choice (BseUserMsgType value)
{
  g_return_val_if_fail (value >= 1 && value <= 4, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_user_msg_type_vals), bse_user_msg_type_vals, value);
}

BseUserMsgType
bse_user_msg_type_from_choice (const gchar *choice)
{
  return (BseUserMsgType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_user_msg_type_vals), bse_user_msg_type_vals, choice) : 0);
}

static const SfiConstants bse_error_type_vals[58] = {
  { "bse-error-no-data", 17, 20 },
  { "bse-error-device-async", 22, 29 },
  { "bse-error-file-read-failed", 26, 12 },
  { "bse-error-file-write-failed", 27, 13 },
  { "bse-error-file-seek-failed", 26, 11 },
  { "bse-error-file-open-failed", 26, 10 },
  { "bse-error-source-channels-connected", 35, 39 },
  { "bse-error-unimplemented", 23, 27 },
  { "bse-error-source-type-invalid", 29, 43 },
  { "bse-error-format-invalid", 24, 22 },
  { "bse-error-proc-not-found", 24, 44 },
  { "bse-error-file-not-found", 24, 8 },
  { "bse-error-wave-not-found", 24, 25 },
  { "bse-error-no-space", 18, 16 },
  { "bse-error-device-not-available", 30, 28 },
  { "bse-error-source-no-such-module", 31, 34 },
  { "bse-error-none", 14, 0 },
  { "bse-error-codec-failure", 23, 26 },
  { "bse-error-source-ichannel-in-use", 32, 38 },
  { "bse-error-file-eof", 18, 7 },
  { "bse-error-device-caps-mismatch", 30, 32 },
  { "bse-error-source-parent-mismatch", 32, 40 },
  { "bse-error-source-bad-loopback", 29, 41 },
  { "bse-error-internal", 18, 1 },
  { "bse-error-proc-param-inval", 26, 46 },
  { "bse-error-source-no-such-ichannel", 33, 35 },
  { "bse-error-source-no-such-ochannel", 33, 36 },
  { "bse-error-invalid-duration", 26, 56 },
  { "bse-error-source-no-such-connection", 35, 37 },
  { "bse-error-proc-execution", 24, 47 },
  { "bse-error-spawn", 15, 50 },
  { "bse-error-unknown", 17, 2 },
  { "bse-error-format-unknown", 24, 23 },
  { "bse-error-no-seek-info", 22, 19 },
  { "bse-error-file-io", 17, 3 },
  { "bse-error-invalid-overlap", 25, 57 },
  { "bse-error-temp", 14, 24 },
  { "bse-error-no-header", 19, 18 },
  { "bse-error-not-owner", 19, 54 },
  { "bse-error-file-is-dir", 21, 9 },
  { "bse-error-parse-error", 21, 49 },
  { "bse-error-no-files", 18, 15 },
  { "bse-error-many-files", 20, 14 },
  { "bse-error-file-perms", 20, 4 },
  { "bse-error-device-get-caps", 25, 31 },
  { "bse-error-device-set-caps", 25, 33 },
  { "bse-error-file-exists", 21, 6 },
  { "bse-error-no-target", 19, 53 },
  { "bse-error-invalid-offset", 24, 55 },
  { "bse-error-no-event", 18, 52 },
  { "bse-error-data-corrupt", 22, 21 },
  { "bse-error-proc-abort", 20, 48 },
  { "bse-error-no-memory", 19, 17 },
  { "bse-error-no-entry", 18, 51 },
  { "bse-error-proc-busy", 19, 45 },
  { "bse-error-device-busy", 21, 30 },
  { "bse-error-source-busy", 21, 42 },
  { "bse-error-file-busy", 19, 5 },
};

const gchar*
bse_error_type_to_choice (BseErrorType value)
{
  g_return_val_if_fail (value >= 0 && value <= 57, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_error_type_vals), bse_error_type_vals, value);
}

BseErrorType
bse_error_type_from_choice (const gchar *choice)
{
  return (BseErrorType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_error_type_vals), bse_error_type_vals, choice) : 0);
}

static const SfiConstants bse_project_state_vals[3] = {
  { "bse-project-active", 18, 2 },
  { "bse-project-inactive", 20, 1 },
  { "bse-project-playing", 19, 3 },
};

const gchar*
bse_project_state_to_choice (BseProjectState value)
{
  g_return_val_if_fail (value >= 1 && value <= 3, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_project_state_vals), bse_project_state_vals, value);
}

BseProjectState
bse_project_state_from_choice (const gchar *choice)
{
  return (BseProjectState) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_project_state_vals), bse_project_state_vals, choice) : 0);
}

static const SfiConstants bse_standard_osc_wave_type_vals[9] = {
  { "bse-standard-osc-triangle", 25, 2 },
  { "bse-standard-osc-sine", 21, 1 },
  { "bse-standard-osc-square", 23, 8 },
  { "bse-standard-osc-peak-rise", 26, 5 },
  { "bse-standard-osc-saw-rise", 25, 3 },
  { "bse-standard-osc-pulse", 22, 9 },
  { "bse-standard-osc-peak-fall", 26, 6 },
  { "bse-standard-osc-saw-fall", 25, 4 },
  { "bse-standard-osc-moog-saw", 25, 7 },
};

const gchar*
bse_standard_osc_wave_type_to_choice (BseStandardOscWaveType value)
{
  g_return_val_if_fail (value >= 1 && value <= 9, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_standard_osc_wave_type_vals), bse_standard_osc_wave_type_vals, value);
}

BseStandardOscWaveType
bse_standard_osc_wave_type_from_choice (const gchar *choice)
{
  return (BseStandardOscWaveType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_standard_osc_wave_type_vals), bse_standard_osc_wave_type_vals, choice) : 0);
}

static const SfiConstants bse_sniffer_type_vals[3] = {
  { "bse-sniffer-average-inputs", 26, 3 },
  { "bse-sniffer-require-single-input", 32, 1 },
  { "bse-sniffer-pick-first-input", 28, 2 },
};

const gchar*
bse_sniffer_type_to_choice (BseSnifferType value)
{
  g_return_val_if_fail (value >= 1 && value <= 3, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_sniffer_type_vals), bse_sniffer_type_vals, value);
}

BseSnifferType
bse_sniffer_type_from_choice (const gchar *choice)
{
  return (BseSnifferType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_sniffer_type_vals), bse_sniffer_type_vals, choice) : 0);
}

static const SfiConstants bse_sniffer_time_type_vals[3] = {
  { "bse-sniffer-time-absolute-tick-stamp", 36, 1 },
  { "bse-sniffer-time-relative-tick-stamp", 36, 2 },
  { "bse-sniffer-time-relative-usecs", 31, 3 },
};

const gchar*
bse_sniffer_time_type_to_choice (BseSnifferTimeType value)
{
  g_return_val_if_fail (value >= 1 && value <= 3, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_sniffer_time_type_vals), bse_sniffer_time_type_vals, value);
}

BseSnifferTimeType
bse_sniffer_time_type_from_choice (const gchar *choice)
{
  return (BseSnifferTimeType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_sniffer_time_type_vals), bse_sniffer_time_type_vals, choice) : 0);
}

void
bse_item_add_parasite (SfiProxy bse_item_object, const gchar* path, SfiRec* parasite) {
  sfi_glue_vcall_void ("BseItem+add-parasite", 'p', bse_item_object, 's', path, 'R', parasite, 0);
}

SfiBool
bse_item_check_is_a (SfiProxy bse_item_object, const gchar* type_name) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseItem+check-is-a", 'p', bse_item_object, 's', type_name, 0);
  return _retval;
}

void
bse_item_clear_undo (SfiProxy bse_item_object) {
  sfi_glue_vcall_void ("BseItem+clear-undo", 'p', bse_item_object, 0);
}

SfiProxy
bse_item_common_ancestor (SfiProxy bse_item_object, SfiProxy item2) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseItem+common-ancestor", 'p', bse_item_object, 'p', item2, 0);
  return _retval;
}

SfiFBlock*
bse_item_fixme_get_parasite (SfiProxy bse_item_object, const gchar* name) {
  SfiFBlock* _retval;
  _retval = sfi_glue_vcall_fblock ("BseItem+fixme-get-parasite", 'p', bse_item_object, 's', name, 0);
  return _retval;
}

void
bse_item_fixme_set_parasite (SfiProxy bse_item_object, const gchar* name, SfiFBlock* parasite) {
  sfi_glue_vcall_void ("BseItem+fixme-set-parasite", 'p', bse_item_object, 's', name, 'F', parasite, 0);
}

BseIcon*
bse_item_get_icon (SfiProxy bse_item_object) {
  SfiRec* _retval;
  BseIcon* _retval_conv;
  _retval = sfi_glue_vcall_rec ("BseItem+get-icon", 'p', bse_item_object, 0);
  _retval_conv = bse_icon_from_rec (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_icon_free);
  return _retval_conv;
}

const gchar*
bse_item_get_name (SfiProxy bse_item_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-name", 'p', bse_item_object, 0);
  return _retval;
}

const gchar*
bse_item_get_name_or_type (SfiProxy bse_item_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-name-or-type", 'p', bse_item_object, 0);
  return _retval;
}

SfiRec*
bse_item_get_parasite (SfiProxy bse_item_object, const gchar* path) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BseItem+get-parasite", 'p', bse_item_object, 's', path, 0);
  return _retval;
}

SfiProxy
bse_item_get_parent (SfiProxy bse_item_object) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseItem+get-parent", 'p', bse_item_object, 0);
  return _retval;
}

SfiProxy
bse_item_get_project (SfiProxy bse_item_object) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseItem+get-project", 'p', bse_item_object, 0);
  return _retval;
}

SfiInt
bse_item_get_seqid (SfiProxy bse_item_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseItem+get-seqid", 'p', bse_item_object, 0);
  return _retval;
}

const gchar*
bse_item_get_type (SfiProxy bse_item_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-type", 'p', bse_item_object, 0);
  return _retval;
}

const gchar*
bse_item_get_type_authors (SfiProxy bse_item_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-type-authors", 'p', bse_item_object, 0);
  return _retval;
}

const gchar*
bse_item_get_type_blurb (SfiProxy bse_item_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-type-blurb", 'p', bse_item_object, 0);
  return _retval;
}

const gchar*
bse_item_get_type_license (SfiProxy bse_item_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-type-license", 'p', bse_item_object, 0);
  return _retval;
}

const gchar*
bse_item_get_type_name (SfiProxy bse_item_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-type-name", 'p', bse_item_object, 0);
  return _retval;
}

const gchar*
bse_item_get_uname_path (SfiProxy bse_item_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-uname-path", 'p', bse_item_object, 0);
  return _retval;
}

void
bse_item_group_undo (SfiProxy bse_item_object, const gchar* name) {
  sfi_glue_vcall_void ("BseItem+group-undo", 'p', bse_item_object, 's', name, 0);
}

SfiBool
bse_item_internal (SfiProxy bse_item_object) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseItem+internal", 'p', bse_item_object, 0);
  return _retval;
}

BseItemSeq*
bse_item_list_items (SfiProxy bse_item_object, const gchar* property_name) {
  SfiSeq* _retval;
  BseItemSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BseItem+list-items", 'p', bse_item_object, 's', property_name, 0);
  _retval_conv = bse_item_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_item_seq_free);
  return _retval_conv;
}

BseStringSeq*
bse_item_list_parasites (SfiProxy bse_item_object, const gchar* path) {
  SfiSeq* _retval;
  BseStringSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BseItem+list-parasites", 'p', bse_item_object, 's', path, 0);
  _retval_conv = bse_string_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_string_seq_free);
  return _retval_conv;
}

void
bse_item_redo (SfiProxy bse_item_object) {
  sfi_glue_vcall_void ("BseItem+redo", 'p', bse_item_object, 0);
}

SfiInt
bse_item_redo_depth (SfiProxy bse_item_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseItem+redo-depth", 'p', bse_item_object, 0);
  return _retval;
}

void
bse_item_set_name (SfiProxy bse_item_object, const gchar* name) {
  sfi_glue_vcall_void ("BseItem+set-name", 'p', bse_item_object, 's', name, 0);
}

void
bse_item_set_parasite (SfiProxy bse_item_object, const gchar* path, SfiRec* parasite) {
  sfi_glue_vcall_void ("BseItem+set-parasite", 'p', bse_item_object, 's', path, 'R', parasite, 0);
}

void
bse_item_undo (SfiProxy bse_item_object) {
  sfi_glue_vcall_void ("BseItem+undo", 'p', bse_item_object, 0);
}

SfiInt
bse_item_undo_depth (SfiProxy bse_item_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseItem+undo-depth", 'p', bse_item_object, 0);
  return _retval;
}

void
bse_item_ungroup_undo (SfiProxy bse_item_object) {
  sfi_glue_vcall_void ("BseItem+ungroup-undo", 'p', bse_item_object, 0);
}

void
bse_item_unuse (SfiProxy bse_item_object) {
  sfi_glue_vcall_void ("BseItem+unuse", 'p', bse_item_object, 0);
}

SfiProxy
bse_item_use (SfiProxy bse_item_object) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseItem+use", 'p', bse_item_object, 0);
  return _retval;
}

SfiInt
bse_data_pocket_create_entry (SfiProxy bse_data_pocket_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseDataPocket+create-entry", 'p', bse_data_pocket_object, 0);
  return _retval;
}

BseErrorType
bse_data_pocket_delete_entry (SfiProxy bse_data_pocket_object, SfiInt entry_id) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseDataPocket+delete-entry", 'p', bse_data_pocket_object, 'i', entry_id, 0);
  return bse_error_type_from_choice (_retval);
}

SfiReal
bse_data_pocket_get_float (SfiProxy bse_data_pocket_object, SfiInt entry_id, const gchar* name) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("BseDataPocket+get-float", 'p', bse_data_pocket_object, 'i', entry_id, 's', name, 0);
  return _retval;
}

SfiInt
bse_data_pocket_get_int (SfiProxy bse_data_pocket_object, SfiInt entry_id, const gchar* name) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseDataPocket+get-int", 'p', bse_data_pocket_object, 'i', entry_id, 's', name, 0);
  return _retval;
}

SfiInt
bse_data_pocket_get_n_entries (SfiProxy bse_data_pocket_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseDataPocket+get-n-entries", 'p', bse_data_pocket_object, 0);
  return _retval;
}

SfiInt
bse_data_pocket_get_nth_entry_id (SfiProxy bse_data_pocket_object, SfiInt entry_index) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseDataPocket+get-nth-entry-id", 'p', bse_data_pocket_object, 'i', entry_index, 0);
  return _retval;
}

SfiProxy
bse_data_pocket_get_object (SfiProxy bse_data_pocket_object, SfiInt entry_id, const gchar* name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseDataPocket+get-object", 'p', bse_data_pocket_object, 'i', entry_id, 's', name, 0);
  return _retval;
}

const gchar*
bse_data_pocket_get_string (SfiProxy bse_data_pocket_object, SfiInt entry_id, const gchar* name) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseDataPocket+get-string", 'p', bse_data_pocket_object, 'i', entry_id, 's', name, 0);
  return _retval;
}

BseErrorType
bse_data_pocket_set_float (SfiProxy bse_data_pocket_object, SfiInt entry_id, const gchar* name, SfiReal number) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseDataPocket+set-float", 'p', bse_data_pocket_object, 'i', entry_id, 's', name, 'r', number, 0);
  return bse_error_type_from_choice (_retval);
}

BseErrorType
bse_data_pocket_set_int (SfiProxy bse_data_pocket_object, SfiInt entry_id, const gchar* name, SfiInt number) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseDataPocket+set-int", 'p', bse_data_pocket_object, 'i', entry_id, 's', name, 'i', number, 0);
  return bse_error_type_from_choice (_retval);
}

BseErrorType
bse_data_pocket_set_object (SfiProxy bse_data_pocket_object, SfiInt entry_id, const gchar* name, SfiProxy item) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseDataPocket+set-object", 'p', bse_data_pocket_object, 'i', entry_id, 's', name, 'p', item, 0);
  return bse_error_type_from_choice (_retval);
}

BseErrorType
bse_data_pocket_set_string (SfiProxy bse_data_pocket_object, SfiInt entry_id, const gchar* name, const gchar* string) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseDataPocket+set-string", 'p', bse_data_pocket_object, 'i', entry_id, 's', name, 's', string, 0);
  return bse_error_type_from_choice (_retval);
}

void
bse_editable_sample_close (SfiProxy bse_editable_sample_object) {
  sfi_glue_vcall_void ("BseEditableSample+close", 'p', bse_editable_sample_object, 0);
}

SfiFBlock*
bse_editable_sample_collect_stats (SfiProxy bse_editable_sample_object, SfiInt voffset, SfiReal offset_scale, SfiInt block_size, SfiInt stepping, SfiInt max_pairs) {
  SfiFBlock* _retval;
  _retval = sfi_glue_vcall_fblock ("BseEditableSample+collect-stats", 'p', bse_editable_sample_object, 'i', voffset, 'r', offset_scale, 'i', block_size, 'i', stepping, 'i', max_pairs, 0);
  return _retval;
}

SfiInt
bse_editable_sample_get_length (SfiProxy bse_editable_sample_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseEditableSample+get-length", 'p', bse_editable_sample_object, 0);
  return _retval;
}

SfiInt
bse_editable_sample_get_n_channels (SfiProxy bse_editable_sample_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseEditableSample+get-n-channels", 'p', bse_editable_sample_object, 0);
  return _retval;
}

SfiReal
bse_editable_sample_get_osc_freq (SfiProxy bse_editable_sample_object) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("BseEditableSample+get-osc-freq", 'p', bse_editable_sample_object, 0);
  return _retval;
}

BseErrorType
bse_editable_sample_open (SfiProxy bse_editable_sample_object) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseEditableSample+open", 'p', bse_editable_sample_object, 0);
  return bse_error_type_from_choice (_retval);
}

SfiFBlock*
bse_editable_sample_read_samples (SfiProxy bse_editable_sample_object, SfiInt voffset) {
  SfiFBlock* _retval;
  _retval = sfi_glue_vcall_fblock ("BseEditableSample+read-samples", 'p', bse_editable_sample_object, 'i', voffset, 0);
  return _retval;
}

void
bse_janitor_add_action (SfiProxy bse_janitor_object, const gchar* action, const gchar* name, const gchar* blurb) {
  sfi_glue_vcall_void ("BseJanitor+add-action", 'p', bse_janitor_object, 's', action, 's', name, 's', blurb, 0);
}

void
bse_janitor_exit (SfiProxy bse_janitor_object, BseUserMsgType msg_type, const gchar* message) {
  sfi_glue_vcall_void ("BseJanitor+exit", 'p', bse_janitor_object, 'C', bse_user_msg_type_to_choice (msg_type), 's', message, 0);
}

const gchar*
bse_janitor_get_action (SfiProxy bse_janitor_object, SfiInt nth_action) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseJanitor+get-action", 'p', bse_janitor_object, 'i', nth_action, 0);
  return _retval;
}

const gchar*
bse_janitor_get_action_blurb (SfiProxy bse_janitor_object, SfiInt nth_action) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseJanitor+get-action-blurb", 'p', bse_janitor_object, 'i', nth_action, 0);
  return _retval;
}

const gchar*
bse_janitor_get_action_name (SfiProxy bse_janitor_object, SfiInt nth_action) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseJanitor+get-action-name", 'p', bse_janitor_object, 'i', nth_action, 0);
  return _retval;
}

const gchar*
bse_janitor_get_proc_name (SfiProxy bse_janitor_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseJanitor+get-proc-name", 'p', bse_janitor_object, 0);
  return _retval;
}

const gchar*
bse_janitor_get_script_name (SfiProxy bse_janitor_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseJanitor+get-script-name", 'p', bse_janitor_object, 0);
  return _retval;
}

void
bse_janitor_kill (SfiProxy bse_janitor_object) {
  sfi_glue_vcall_void ("BseJanitor+kill", 'p', bse_janitor_object, 0);
}

SfiInt
bse_janitor_n_actions (SfiProxy bse_janitor_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseJanitor+n-actions", 'p', bse_janitor_object, 0);
  return _retval;
}

void
bse_janitor_progress (SfiProxy bse_janitor_object, SfiReal progress) {
  sfi_glue_vcall_void ("BseJanitor+progress", 'p', bse_janitor_object, 'r', progress, 0);
}

void
bse_janitor_remove_action (SfiProxy bse_janitor_object, const gchar* action) {
  sfi_glue_vcall_void ("BseJanitor+remove-action", 'p', bse_janitor_object, 's', action, 0);
}

void
bse_janitor_set_msg (SfiProxy bse_janitor_object, BseUserMsgType msg_type, const gchar* message) {
  sfi_glue_vcall_void ("BseJanitor+set-msg", 'p', bse_janitor_object, 'C', bse_user_msg_type_to_choice (msg_type), 's', message, 0);
}

void
bse_janitor_trigger_action (SfiProxy bse_janitor_object, const gchar* action) {
  sfi_glue_vcall_void ("BseJanitor+trigger-action", 'p', bse_janitor_object, 's', action, 0);
}

SfiInt
bse_midi_notifier_current_time (SfiProxy bse_midi_notifier_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseMidiNotifier+current-time", 'p', bse_midi_notifier_object, 0);
  return _retval;
}

BseErrorType
bse_part_change_control (SfiProxy bse_part_object, SfiInt id, SfiInt tick, BseMidiSignalType control_type, SfiReal value) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BsePart+change-control", 'p', bse_part_object, 'i', id, 'i', tick, 'C', bse_midi_signal_type_to_choice (control_type), 'r', value, 0);
  return bse_error_type_from_choice (_retval);
}

BseErrorType
bse_part_change_note (SfiProxy bse_part_object, SfiInt id, SfiInt tick, SfiInt duration, SfiInt note, SfiInt fine_tune, SfiReal velocity) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BsePart+change-note", 'p', bse_part_object, 'i', id, 'i', tick, 'i', duration, 'i', note, 'i', fine_tune, 'r', velocity, 0);
  return bse_error_type_from_choice (_retval);
}

BsePartNoteSeq*
bse_part_check_overlap (SfiProxy bse_part_object, SfiInt tick, SfiInt duration, SfiInt note) {
  SfiSeq* _retval;
  BsePartNoteSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BsePart+check-overlap", 'p', bse_part_object, 'i', tick, 'i', duration, 'i', note, 0);
  _retval_conv = bse_part_note_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_part_note_seq_free);
  return _retval_conv;
}

BseErrorType
bse_part_delete_event (SfiProxy bse_part_object, SfiInt id) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BsePart+delete-event", 'p', bse_part_object, 'i', id, 0);
  return bse_error_type_from_choice (_retval);
}

void
bse_part_deselect_controls (SfiProxy bse_part_object, SfiInt tick, SfiInt duration, BseMidiSignalType control_type) {
  sfi_glue_vcall_void ("BsePart+deselect-controls", 'p', bse_part_object, 'i', tick, 'i', duration, 'C', bse_midi_signal_type_to_choice (control_type), 0);
}

void
bse_part_deselect_event (SfiProxy bse_part_object, SfiInt id) {
  sfi_glue_vcall_void ("BsePart+deselect-event", 'p', bse_part_object, 'i', id, 0);
}

void
bse_part_deselect_notes (SfiProxy bse_part_object, SfiInt tick, SfiInt duration, SfiInt min_note, SfiInt max_note) {
  sfi_glue_vcall_void ("BsePart+deselect-notes", 'p', bse_part_object, 'i', tick, 'i', duration, 'i', min_note, 'i', max_note, 0);
}

BsePartControlSeq*
bse_part_get_channel_controls (SfiProxy bse_part_object, SfiInt channel, SfiInt tick, SfiInt duration, BseMidiSignalType control_type) {
  SfiSeq* _retval;
  BsePartControlSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BsePart+get-channel-controls", 'p', bse_part_object, 'i', channel, 'i', tick, 'i', duration, 'C', bse_midi_signal_type_to_choice (control_type), 0);
  _retval_conv = bse_part_control_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_part_control_seq_free);
  return _retval_conv;
}

BsePartControlSeq*
bse_part_get_controls (SfiProxy bse_part_object, SfiInt tick, BseMidiSignalType control_type) {
  SfiSeq* _retval;
  BsePartControlSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BsePart+get-controls", 'p', bse_part_object, 'i', tick, 'C', bse_midi_signal_type_to_choice (control_type), 0);
  _retval_conv = bse_part_control_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_part_control_seq_free);
  return _retval_conv;
}

SfiInt
bse_part_get_max_note (SfiProxy bse_part_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BsePart+get-max-note", 'p', bse_part_object, 0);
  return _retval;
}

SfiInt
bse_part_get_min_note (SfiProxy bse_part_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BsePart+get-min-note", 'p', bse_part_object, 0);
  return _retval;
}

BsePartNoteSeq*
bse_part_get_notes (SfiProxy bse_part_object, SfiInt tick, SfiInt note) {
  SfiSeq* _retval;
  BsePartNoteSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BsePart+get-notes", 'p', bse_part_object, 'i', tick, 'i', note, 0);
  _retval_conv = bse_part_note_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_part_note_seq_free);
  return _retval_conv;
}

BseSongTiming*
bse_part_get_timing (SfiProxy bse_part_object, SfiInt tick) {
  SfiRec* _retval;
  BseSongTiming* _retval_conv;
  _retval = sfi_glue_vcall_rec ("BsePart+get-timing", 'p', bse_part_object, 'i', tick, 0);
  _retval_conv = bse_song_timing_from_rec (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_song_timing_free);
  return _retval_conv;
}

SfiInt
bse_part_insert_control (SfiProxy bse_part_object, SfiInt tick, BseMidiSignalType control_type, SfiReal value) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BsePart+insert-control", 'p', bse_part_object, 'i', tick, 'C', bse_midi_signal_type_to_choice (control_type), 'r', value, 0);
  return _retval;
}

SfiInt
bse_part_insert_note (SfiProxy bse_part_object, SfiInt channel, SfiInt tick, SfiInt duration, SfiInt note, SfiInt fine_tune, SfiReal velocity) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BsePart+insert-note", 'p', bse_part_object, 'i', channel, 'i', tick, 'i', duration, 'i', note, 'i', fine_tune, 'r', velocity, 0);
  return _retval;
}

SfiInt
bse_part_insert_note_auto (SfiProxy bse_part_object, SfiInt tick, SfiInt duration, SfiInt note, SfiInt fine_tune, SfiReal velocity) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BsePart+insert-note-auto", 'p', bse_part_object, 'i', tick, 'i', duration, 'i', note, 'i', fine_tune, 'r', velocity, 0);
  return _retval;
}

SfiBool
bse_part_is_event_selected (SfiProxy bse_part_object, SfiInt id) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BsePart+is-event-selected", 'p', bse_part_object, 'i', id, 0);
  return _retval;
}

BsePartControlSeq*
bse_part_list_controls (SfiProxy bse_part_object, SfiInt tick, SfiInt duration, BseMidiSignalType control_type) {
  SfiSeq* _retval;
  BsePartControlSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BsePart+list-controls", 'p', bse_part_object, 'i', tick, 'i', duration, 'C', bse_midi_signal_type_to_choice (control_type), 0);
  _retval_conv = bse_part_control_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_part_control_seq_free);
  return _retval_conv;
}

BsePartNoteSeq*
bse_part_list_notes_crossing (SfiProxy bse_part_object, SfiInt tick, SfiInt duration) {
  SfiSeq* _retval;
  BsePartNoteSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BsePart+list-notes-crossing", 'p', bse_part_object, 'i', tick, 'i', duration, 0);
  _retval_conv = bse_part_note_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_part_note_seq_free);
  return _retval_conv;
}

BsePartNoteSeq*
bse_part_list_notes_within (SfiProxy bse_part_object, SfiInt channel, SfiInt tick, SfiInt duration) {
  SfiSeq* _retval;
  BsePartNoteSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BsePart+list-notes-within", 'p', bse_part_object, 'i', channel, 'i', tick, 'i', duration, 0);
  _retval_conv = bse_part_note_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_part_note_seq_free);
  return _retval_conv;
}

BsePartControlSeq*
bse_part_list_selected_controls (SfiProxy bse_part_object, BseMidiSignalType control_type) {
  SfiSeq* _retval;
  BsePartControlSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BsePart+list-selected-controls", 'p', bse_part_object, 'C', bse_midi_signal_type_to_choice (control_type), 0);
  _retval_conv = bse_part_control_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_part_control_seq_free);
  return _retval_conv;
}

BsePartNoteSeq*
bse_part_list_selected_notes (SfiProxy bse_part_object) {
  SfiSeq* _retval;
  BsePartNoteSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BsePart+list-selected-notes", 'p', bse_part_object, 0);
  _retval_conv = bse_part_note_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_part_note_seq_free);
  return _retval_conv;
}

void
bse_part_queue_controls (SfiProxy bse_part_object, SfiInt tick, SfiInt duration) {
  sfi_glue_vcall_void ("BsePart+queue-controls", 'p', bse_part_object, 'i', tick, 'i', duration, 0);
}

void
bse_part_queue_notes (SfiProxy bse_part_object, SfiInt tick, SfiInt duration, SfiInt min_note, SfiInt max_note) {
  sfi_glue_vcall_void ("BsePart+queue-notes", 'p', bse_part_object, 'i', tick, 'i', duration, 'i', min_note, 'i', max_note, 0);
}

void
bse_part_select_controls_exclusive (SfiProxy bse_part_object, SfiInt tick, SfiInt duration, BseMidiSignalType control_type) {
  sfi_glue_vcall_void ("BsePart+select-controls-exclusive", 'p', bse_part_object, 'i', tick, 'i', duration, 'C', bse_midi_signal_type_to_choice (control_type), 0);
}

void
bse_part_select_event (SfiProxy bse_part_object, SfiInt id) {
  sfi_glue_vcall_void ("BsePart+select-event", 'p', bse_part_object, 'i', id, 0);
}

void
bse_part_select_notes (SfiProxy bse_part_object, SfiInt tick, SfiInt duration, SfiInt min_note, SfiInt max_note) {
  sfi_glue_vcall_void ("BsePart+select-notes", 'p', bse_part_object, 'i', tick, 'i', duration, 'i', min_note, 'i', max_note, 0);
}

void
bse_part_select_notes_exclusive (SfiProxy bse_part_object, SfiInt tick, SfiInt duration, SfiInt min_note, SfiInt max_note) {
  sfi_glue_vcall_void ("BsePart+select-notes-exclusive", 'p', bse_part_object, 'i', tick, 'i', duration, 'i', min_note, 'i', max_note, 0);
}

void
bse_source_clear_inputs (SfiProxy bse_source_object) {
  sfi_glue_vcall_void ("BseSource+clear-inputs", 'p', bse_source_object, 0);
}

void
bse_source_clear_outputs (SfiProxy bse_source_object) {
  sfi_glue_vcall_void ("BseSource+clear-outputs", 'p', bse_source_object, 0);
}

SfiBool
bse_source_has_outputs (SfiProxy bse_source_object) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseSource+has-outputs", 'p', bse_source_object, 0);
  return _retval;
}

const gchar*
bse_source_ichannel_blurb (SfiProxy bse_source_object, SfiInt input_channel) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ichannel-blurb", 'p', bse_source_object, 'i', input_channel, 0);
  return _retval;
}

SfiInt
bse_source_ichannel_get_n_joints (SfiProxy bse_source_object, SfiInt input_channel) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseSource+ichannel-get-n-joints", 'p', bse_source_object, 'i', input_channel, 0);
  return _retval;
}

SfiInt
bse_source_ichannel_get_ochannel (SfiProxy bse_source_object, SfiInt input_channel, SfiInt input_joint) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseSource+ichannel-get-ochannel", 'p', bse_source_object, 'i', input_channel, 'i', input_joint, 0);
  return _retval;
}

SfiProxy
bse_source_ichannel_get_osource (SfiProxy bse_source_object, SfiInt input_channel, SfiInt input_joint) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSource+ichannel-get-osource", 'p', bse_source_object, 'i', input_channel, 'i', input_joint, 0);
  return _retval;
}

const gchar*
bse_source_ichannel_ident (SfiProxy bse_source_object, SfiInt input_channel) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ichannel-ident", 'p', bse_source_object, 'i', input_channel, 0);
  return _retval;
}

const gchar*
bse_source_ichannel_label (SfiProxy bse_source_object, SfiInt input_channel) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ichannel-label", 'p', bse_source_object, 'i', input_channel, 0);
  return _retval;
}

SfiBool
bse_source_is_joint_ichannel (SfiProxy bse_source_object, const gchar* input_channel) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseSource+is-joint-ichannel", 'p', bse_source_object, 's', input_channel, 0);
  return _retval;
}

SfiBool
bse_source_is_joint_ichannel_by_id (SfiProxy bse_source_object, SfiInt input_channel) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseSource+is-joint-ichannel-by-id", 'p', bse_source_object, 'i', input_channel, 0);
  return _retval;
}

SfiInt
bse_source_n_ichannels (SfiProxy bse_source_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseSource+n-ichannels", 'p', bse_source_object, 0);
  return _retval;
}

SfiInt
bse_source_n_ochannels (SfiProxy bse_source_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseSource+n-ochannels", 'p', bse_source_object, 0);
  return _retval;
}

const gchar*
bse_source_ochannel_blurb (SfiProxy bse_source_object, SfiInt input_channel) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ochannel-blurb", 'p', bse_source_object, 'i', input_channel, 0);
  return _retval;
}

const gchar*
bse_source_ochannel_ident (SfiProxy bse_source_object, SfiInt input_channel) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ochannel-ident", 'p', bse_source_object, 'i', input_channel, 0);
  return _retval;
}

const gchar*
bse_source_ochannel_label (SfiProxy bse_source_object, SfiInt input_channel) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ochannel-label", 'p', bse_source_object, 'i', input_channel, 0);
  return _retval;
}

BseErrorType
bse_source_set_input (SfiProxy bse_source_object, const gchar* input_channel, SfiProxy omodule, const gchar* output_channel) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSource+set-input", 'p', bse_source_object, 's', input_channel, 'p', omodule, 's', output_channel, 0);
  return bse_error_type_from_choice (_retval);
}

BseErrorType
bse_source_set_input_by_id (SfiProxy bse_source_object, SfiInt input_channel, SfiProxy omodule, SfiInt output_channel) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSource+set-input-by-id", 'p', bse_source_object, 'i', input_channel, 'p', omodule, 'i', output_channel, 0);
  return bse_error_type_from_choice (_retval);
}

void
bse_source_set_pos (SfiProxy bse_source_object, SfiReal x_pos, SfiReal y_pos) {
  sfi_glue_vcall_void ("BseSource+set-pos", 'p', bse_source_object, 'r', x_pos, 'r', y_pos, 0);
}

BseErrorType
bse_source_unset_input (SfiProxy bse_source_object, const gchar* input_channel, SfiProxy omodule, const gchar* output_channel) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSource+unset-input", 'p', bse_source_object, 's', input_channel, 'p', omodule, 's', output_channel, 0);
  return bse_error_type_from_choice (_retval);
}

BseErrorType
bse_source_unset_input_by_id (SfiProxy bse_source_object, SfiInt input_channel, SfiProxy omodule, SfiInt output_channel) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSource+unset-input-by-id", 'p', bse_source_object, 'i', input_channel, 'p', omodule, 'i', output_channel, 0);
  return bse_error_type_from_choice (_retval);
}

SfiProxy
bse_track_create_sniffer (SfiProxy bse_track_object) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseTrack+create-sniffer", 'p', bse_track_object, 0);
  return _retval;
}

SfiProxy
bse_track_get_part (SfiProxy bse_track_object, SfiInt tick) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseTrack+get-part", 'p', bse_track_object, 'i', tick, 0);
  return _retval;
}

BseSongTiming*
bse_track_get_timing (SfiProxy bse_track_object, SfiInt tick) {
  SfiRec* _retval;
  BseSongTiming* _retval_conv;
  _retval = sfi_glue_vcall_rec ("BseTrack+get-timing", 'p', bse_track_object, 'i', tick, 0);
  _retval_conv = bse_song_timing_from_rec (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_song_timing_free);
  return _retval_conv;
}

SfiInt
bse_track_insert_part (SfiProxy bse_track_object, SfiInt tick, SfiProxy part) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseTrack+insert-part", 'p', bse_track_object, 'i', tick, 'p', part, 0);
  return _retval;
}

BseTrackPartSeq*
bse_track_list_parts (SfiProxy bse_track_object) {
  SfiSeq* _retval;
  BseTrackPartSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BseTrack+list-parts", 'p', bse_track_object, 0);
  _retval_conv = bse_track_part_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_track_part_seq_free);
  return _retval_conv;
}

void
bse_track_remove_link (SfiProxy bse_track_object, SfiInt id) {
  sfi_glue_vcall_void ("BseTrack+remove-link", 'p', bse_track_object, 'i', id, 0);
}

void
bse_track_remove_tick (SfiProxy bse_track_object, SfiInt tick) {
  sfi_glue_vcall_void ("BseTrack+remove-tick", 'p', bse_track_object, 'i', tick, 0);
}

SfiProxy
bse_container_get_item (SfiProxy bse_container_object, const gchar* item_type, SfiInt seq_id) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseContainer+get-item", 'p', bse_container_object, 's', item_type, 'i', seq_id, 0);
  return _retval;
}

BseItemSeq*
bse_container_list_items (SfiProxy bse_container_object) {
  SfiSeq* _retval;
  BseItemSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BseContainer+list-items", 'p', bse_container_object, 0);
  _retval_conv = bse_item_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_item_seq_free);
  return _retval_conv;
}

SfiProxy
bse_container_lookup_item (SfiProxy bse_container_object, const gchar* uname) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseContainer+lookup-item", 'p', bse_container_object, 's', uname, 0);
  return _retval;
}

SfiReal
bse_wave_chunk_get_mix_freq (SfiProxy bse_wave_object, SfiInt chunk_index) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("BseWave+chunk-get-mix-freq", 'p', bse_wave_object, 'i', chunk_index, 0);
  return _retval;
}

SfiReal
bse_wave_chunk_get_osc_freq (SfiProxy bse_wave_object, SfiInt chunk_index) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("BseWave+chunk-get-osc-freq", 'p', bse_wave_object, 'i', chunk_index, 0);
  return _retval;
}

BseErrorType
bse_wave_load_wave (SfiProxy bse_wave_object, const gchar* file_name, const gchar* wave_name) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseWave+load-wave", 'p', bse_wave_object, 's', file_name, 's', wave_name, 0);
  return bse_error_type_from_choice (_retval);
}

SfiInt
bse_wave_n_wave_chunks (SfiProxy bse_wave_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseWave+n-wave-chunks", 'p', bse_wave_object, 0);
  return _retval;
}

SfiProxy
bse_wave_use_editable (SfiProxy bse_wave_object, SfiInt chunk_index) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseWave+use-editable", 'p', bse_wave_object, 'i', chunk_index, 0);
  return _retval;
}

void
bse_wave_osc_pcm_seek_perc (SfiProxy bse_wave_osc_object, SfiReal pos_perc) {
  sfi_glue_vcall_void ("BseWaveOsc+pcm-seek-perc", 'p', bse_wave_osc_object, 'r', pos_perc, 0);
}

void
bse_wave_osc_request_pcm_position (SfiProxy bse_wave_osc_object) {
  sfi_glue_vcall_void ("BseWaveOsc+request-pcm-position", 'p', bse_wave_osc_object, 0);
}

void
bse_wave_osc_set_from_editable_sample (SfiProxy bse_wave_osc_object, SfiProxy esample) {
  sfi_glue_vcall_void ("BseWaveOsc+set-from-editable-sample", 'p', bse_wave_osc_object, 'p', esample, 0);
}

BseErrorType
bse_project_import_midi_file (SfiProxy bse_project_object, const gchar* file_name) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+import-midi-file", 'p', bse_project_object, 's', file_name, 0);
  return bse_error_type_from_choice (_retval);
}

BseErrorType
bse_project_restore_from_file (SfiProxy bse_project_object, const gchar* file_name) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+restore-from-file", 'p', bse_project_object, 's', file_name, 0);
  return bse_error_type_from_choice (_retval);
}

BseErrorType
bse_project_store_bse (SfiProxy bse_project_object, SfiProxy super, const gchar* file_name, SfiBool self_contained) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+store-bse", 'p', bse_project_object, 'p', super, 's', file_name, 'b', self_contained, 0);
  return bse_error_type_from_choice (_retval);
}

BseErrorType
bse_project_activate (SfiProxy bse_project_object) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+activate", 'p', bse_project_object, 0);
  return bse_error_type_from_choice (_retval);
}

void
bse_project_auto_deactivate (SfiProxy bse_project_object, SfiInt msec_delay) {
  sfi_glue_vcall_void ("BseProject+auto-deactivate", 'p', bse_project_object, 'i', msec_delay, 0);
}

SfiBool
bse_project_can_play (SfiProxy bse_project_object) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseProject+can-play", 'p', bse_project_object, 0);
  return _retval;
}

void
bse_project_clear_undo (SfiProxy bse_project_object) {
  sfi_glue_vcall_void ("BseProject+clear-undo", 'p', bse_project_object, 0);
}

SfiProxy
bse_project_create_csynth (SfiProxy bse_project_object, const gchar* name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+create-csynth", 'p', bse_project_object, 's', name, 0);
  return _retval;
}

SfiProxy
bse_project_create_midi_synth (SfiProxy bse_project_object, const gchar* name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+create-midi-synth", 'p', bse_project_object, 's', name, 0);
  return _retval;
}

SfiProxy
bse_project_create_song (SfiProxy bse_project_object, const gchar* name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+create-song", 'p', bse_project_object, 's', name, 0);
  return _retval;
}

void
bse_project_deactivate (SfiProxy bse_project_object) {
  sfi_glue_vcall_void ("BseProject+deactivate", 'p', bse_project_object, 0);
}

SfiProxy
bse_project_find_item (SfiProxy bse_project_object, const gchar* uname_path) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+find-item", 'p', bse_project_object, 's', uname_path, 0);
  return _retval;
}

SfiProxy
bse_project_get_data_pocket (SfiProxy bse_project_object, const gchar* name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+get-data-pocket", 'p', bse_project_object, 's', name, 0);
  return _retval;
}

BseProjectState
bse_project_get_state (SfiProxy bse_project_object) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+get-state", 'p', bse_project_object, 0);
  return bse_project_state_from_choice (_retval);
}

BseItemSeq*
bse_project_get_supers (SfiProxy bse_project_object) {
  SfiSeq* _retval;
  BseItemSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BseProject+get-supers", 'p', bse_project_object, 0);
  _retval_conv = bse_item_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_item_seq_free);
  return _retval_conv;
}

SfiProxy
bse_project_get_wave_repo (SfiProxy bse_project_object) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+get-wave-repo", 'p', bse_project_object, 0);
  return _retval;
}

SfiBool
bse_project_is_active (SfiProxy bse_project_object) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseProject+is-active", 'p', bse_project_object, 0);
  return _retval;
}

SfiBool
bse_project_is_playing (SfiProxy bse_project_object) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseProject+is-playing", 'p', bse_project_object, 0);
  return _retval;
}

BseStringSeq*
bse_project_list_uname_paths (SfiProxy bse_project_object, const gchar* item_type) {
  SfiSeq* _retval;
  BseStringSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BseProject+list-uname-paths", 'p', bse_project_object, 's', item_type, 0);
  _retval_conv = bse_string_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_string_seq_free);
  return _retval_conv;
}

BseItemSeq*
bse_project_match_items_by_uname (SfiProxy bse_project_object, const gchar* item_type, const gchar* uname) {
  SfiSeq* _retval;
  BseItemSeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("BseProject+match-items-by-uname", 'p', bse_project_object, 's', item_type, 's', uname, 0);
  _retval_conv = bse_item_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_item_seq_free);
  return _retval_conv;
}

BseErrorType
bse_project_play (SfiProxy bse_project_object) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+play", 'p', bse_project_object, 0);
  return bse_error_type_from_choice (_retval);
}

void
bse_project_redo (SfiProxy bse_project_object) {
  sfi_glue_vcall_void ("BseProject+redo", 'p', bse_project_object, 0);
}

SfiInt
bse_project_redo_depth (SfiProxy bse_project_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseProject+redo-depth", 'p', bse_project_object, 0);
  return _retval;
}

void
bse_project_remove_snet (SfiProxy bse_project_object, SfiProxy snet) {
  sfi_glue_vcall_void ("BseProject+remove-snet", 'p', bse_project_object, 'p', snet, 0);
}

void
bse_project_start_playback (SfiProxy bse_project_object) {
  sfi_glue_vcall_void ("BseProject+start-playback", 'p', bse_project_object, 0);
}

void
bse_project_stop (SfiProxy bse_project_object) {
  sfi_glue_vcall_void ("BseProject+stop", 'p', bse_project_object, 0);
}

void
bse_project_stop_playback (SfiProxy bse_project_object) {
  sfi_glue_vcall_void ("BseProject+stop-playback", 'p', bse_project_object, 0);
}

void
bse_project_undo (SfiProxy bse_project_object) {
  sfi_glue_vcall_void ("BseProject+undo", 'p', bse_project_object, 0);
}

SfiInt
bse_project_undo_depth (SfiProxy bse_project_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseProject+undo-depth", 'p', bse_project_object, 0);
  return _retval;
}

SfiBool
bse_server_can_load (SfiProxy bse_server_object, const gchar* file_name) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseServer+can-load", 'p', bse_server_object, 's', file_name, 0);
  return _retval;
}

BseNoteDescription*
bse_server_construct_note (SfiProxy bse_server_object, SfiInt semitone, SfiInt octave, SfiInt fine_tune) {
  SfiRec* _retval;
  BseNoteDescription* _retval_conv;
  _retval = sfi_glue_vcall_rec ("BseServer+construct-note", 'p', bse_server_object, 'i', semitone, 'i', octave, 'i', fine_tune, 0);
  _retval_conv = bse_note_description_from_rec (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_note_description_free);
  return _retval_conv;
}

BseNoteDescription*
bse_server_describe_note (SfiProxy bse_server_object, SfiInt note, SfiInt fine_tune) {
  SfiRec* _retval;
  BseNoteDescription* _retval_conv;
  _retval = sfi_glue_vcall_rec ("BseServer+describe-note", 'p', bse_server_object, 'i', note, 'i', fine_tune, 0);
  _retval_conv = bse_note_description_from_rec (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_note_description_free);
  return _retval_conv;
}

const gchar*
bse_server_get_custom_effect_dir (SfiProxy bse_server_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-custom-effect-dir", 'p', bse_server_object, 0);
  return _retval;
}

const gchar*
bse_server_get_custom_instrument_dir (SfiProxy bse_server_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-custom-instrument-dir", 'p', bse_server_object, 0);
  return _retval;
}

const gchar*
bse_server_get_demo_path (SfiProxy bse_server_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-demo-path", 'p', bse_server_object, 0);
  return _retval;
}

const gchar*
bse_server_get_effect_path (SfiProxy bse_server_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-effect-path", 'p', bse_server_object, 0);
  return _retval;
}

const gchar*
bse_server_get_instrument_path (SfiProxy bse_server_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-instrument-path", 'p', bse_server_object, 0);
  return _retval;
}

const gchar*
bse_server_get_ladspa_path (SfiProxy bse_server_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-ladspa-path", 'p', bse_server_object, 0);
  return _retval;
}

SfiProxy
bse_server_get_midi_notifier (SfiProxy bse_server_object) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseServer+get-midi-notifier", 'p', bse_server_object, 0);
  return _retval;
}

const gchar*
bse_server_get_mp3_version (SfiProxy bse_server_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-mp3-version", 'p', bse_server_object, 0);
  return _retval;
}

const gchar*
bse_server_get_plugin_path (SfiProxy bse_server_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-plugin-path", 'p', bse_server_object, 0);
  return _retval;
}

const gchar*
bse_server_get_sample_path (SfiProxy bse_server_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-sample-path", 'p', bse_server_object, 0);
  return _retval;
}

const gchar*
bse_server_get_script_path (SfiProxy bse_server_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-script-path", 'p', bse_server_object, 0);
  return _retval;
}

const gchar*
bse_server_get_version (SfiProxy bse_server_object) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-version", 'p', bse_server_object, 0);
  return _retval;
}

SfiInt
bse_server_n_scripts (SfiProxy bse_server_object) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseServer+n-scripts", 'p', bse_server_object, 0);
  return _retval;
}

BseNoteDescription*
bse_server_note_from_freq (SfiProxy bse_server_object, SfiReal freq) {
  SfiRec* _retval;
  BseNoteDescription* _retval_conv;
  _retval = sfi_glue_vcall_rec ("BseServer+note-from-freq", 'p', bse_server_object, 'r', freq, 0);
  _retval_conv = bse_note_description_from_rec (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_note_description_free);
  return _retval_conv;
}

BseNoteDescription*
bse_server_note_from_string (SfiProxy bse_server_object, const gchar* name) {
  SfiRec* _retval;
  BseNoteDescription* _retval_conv;
  _retval = sfi_glue_vcall_rec ("BseServer+note-from-string", 'p', bse_server_object, 's', name, 0);
  _retval_conv = bse_note_description_from_rec (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_note_description_free);
  return _retval_conv;
}

SfiBool
bse_server_preferences_locked (SfiProxy bse_server_object) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseServer+preferences-locked", 'p', bse_server_object, 0);
  return _retval;
}

void
bse_server_register_core_plugins (SfiProxy bse_server_object) {
  sfi_glue_vcall_void ("BseServer+register-core-plugins", 'p', bse_server_object, 0);
}

void
bse_server_register_ladspa_plugins (SfiProxy bse_server_object) {
  sfi_glue_vcall_void ("BseServer+register-ladspa-plugins", 'p', bse_server_object, 0);
}

void
bse_server_register_scripts (SfiProxy bse_server_object) {
  sfi_glue_vcall_void ("BseServer+register-scripts", 'p', bse_server_object, 0);
}

void
bse_server_save_preferences (SfiProxy bse_server_object) {
  sfi_glue_vcall_void ("BseServer+save-preferences", 'p', bse_server_object, 0);
}

SfiProxy
bse_server_use_new_project (SfiProxy bse_server_object, const gchar* name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseServer+use-new-project", 'p', bse_server_object, 's', name, 0);
  return _retval;
}

BseErrorType
bse_snet_can_create_source (SfiProxy bse_snet_object, const gchar* module_type) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSNet+can-create-source", 'p', bse_snet_object, 's', module_type, 0);
  return bse_error_type_from_choice (_retval);
}

SfiProxy
bse_snet_create_source (SfiProxy bse_snet_object, const gchar* module_type) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSNet+create-source", 'p', bse_snet_object, 's', module_type, 0);
  return _retval;
}

BseErrorType
bse_snet_remove_source (SfiProxy bse_snet_object, SfiProxy module) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSNet+remove-source", 'p', bse_snet_object, 'p', module, 0);
  return bse_error_type_from_choice (_retval);
}

SfiBool
bse_snet_supports_user_synths (SfiProxy bse_snet_object) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseSNet+supports-user-synths", 'p', bse_snet_object, 0);
  return _retval;
}

BseErrorType
bse_wave_repo_load_file (SfiProxy bse_wave_repo_object, const gchar* file_name) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseWaveRepo+load-file", 'p', bse_wave_repo_object, 's', file_name, 0);
  return bse_error_type_from_choice (_retval);
}

void
bse_wave_repo_remove_wave (SfiProxy bse_wave_repo_object, SfiProxy wave) {
  sfi_glue_vcall_void ("BseWaveRepo+remove-wave", 'p', bse_wave_repo_object, 'p', wave, 0);
}

SfiProxy
bse_song_create_part (SfiProxy bse_song_object) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSong+create-part", 'p', bse_song_object, 0);
  return _retval;
}

SfiProxy
bse_song_create_track (SfiProxy bse_song_object) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSong+create-track", 'p', bse_song_object, 0);
  return _retval;
}

SfiProxy
bse_song_find_track_for_part (SfiProxy bse_song_object, SfiProxy part) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSong+find-track-for-part", 'p', bse_song_object, 'p', part, 0);
  return _retval;
}

BseSongTiming*
bse_song_get_timing (SfiProxy bse_song_object, SfiInt tick) {
  SfiRec* _retval;
  BseSongTiming* _retval_conv;
  _retval = sfi_glue_vcall_rec ("BseSong+get-timing", 'p', bse_song_object, 'i', tick, 0);
  _retval_conv = bse_song_timing_from_rec (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_song_timing_free);
  return _retval_conv;
}

void
bse_song_remove_part (SfiProxy bse_song_object, SfiProxy part) {
  sfi_glue_vcall_void ("BseSong+remove-part", 'p', bse_song_object, 'p', part, 0);
}

void
bse_song_remove_track (SfiProxy bse_song_object, SfiProxy track) {
  sfi_glue_vcall_void ("BseSong+remove-track", 'p', bse_song_object, 'p', track, 0);
}

void
bse_song_synthesize_note (SfiProxy bse_song_object, SfiProxy track, SfiInt duration, SfiInt note, SfiInt fine_tune, SfiReal velocity) {
  sfi_glue_vcall_void ("BseSong+synthesize-note", 'p', bse_song_object, 'p', track, 'i', duration, 'i', note, 'i', fine_tune, 'r', velocity, 0);
}

BseCategory*
bse_category_from_id (SfiInt category_id) {
  SfiRec* _retval;
  BseCategory* _retval_conv;
  _retval = sfi_glue_vcall_rec ("bse-category-from-id", 'i', category_id, 0);
  _retval_conv = bse_category_from_rec (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_category_free);
  return _retval_conv;
}

BseCategorySeq*
bse_categories_match (const gchar* pattern) {
  SfiSeq* _retval;
  BseCategorySeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("bse-categories-match", 's', pattern, 0);
  _retval_conv = bse_category_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_category_seq_free);
  return _retval_conv;
}

BseCategorySeq*
bse_categories_match_method (const gchar* pattern, const gchar* type) {
  SfiSeq* _retval;
  BseCategorySeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("bse-categories-match-method", 's', pattern, 's', type, 0);
  _retval_conv = bse_category_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_category_seq_free);
  return _retval_conv;
}

BseCategorySeq*
bse_categories_match_typed (const gchar* pattern, const gchar* type) {
  SfiSeq* _retval;
  BseCategorySeq* _retval_conv;
  _retval = sfi_glue_vcall_seq ("bse-categories-match-typed", 's', pattern, 's', type, 0);
  _retval_conv = bse_category_seq_from_seq (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_category_seq_free);
  return _retval_conv;
}

const gchar*
bse_error_blurb (BseErrorType error) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("bse-error-blurb", 'C', bse_error_type_to_choice (error), 0);
  return _retval;
}

const gchar*
bse_error_name (BseErrorType error) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("bse-error-name", 'C', bse_error_type_to_choice (error), 0);
  return _retval;
}

SfiProxy
bse_janitor_get_specific (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("bse-janitor-get-specific", 0);
  return _retval;
}

SfiInt
bse_note_from_freq (SfiReal frequency) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("bse-note-from-freq", 'r', frequency, 0);
  return _retval;
}

SfiReal
bse_note_to_freq (SfiInt note, SfiInt fine_tune) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("bse-note-to-freq", 'i', note, 'i', fine_tune, 0);
  return _retval;
}

SfiBool
bse_proxy_check (SfiProxy item, const gchar* type_name) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("bse-proxy-check", 'p', item, 's', type_name, 0);
  return _retval;
}

BseSampleFileInfo*
bse_sample_file_info (const gchar* file_name) {
  SfiRec* _retval;
  BseSampleFileInfo* _retval_conv;
  _retval = sfi_glue_vcall_rec ("bse-sample-file-info", 's', file_name, 0);
  _retval_conv = bse_sample_file_info_from_rec (_retval);
  if (_retval_conv != NULL) sfi_glue_gc_add (_retval_conv, bse_sample_file_info_free);
  return _retval_conv;
}

SfiReal
bse_string_extract_number (const gchar* string, const gchar* format, SfiReal aux_base, SfiReal dflt) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("bse-string-extract-number", 's', string, 's', format, 'r', aux_base, 'r', dflt, 0);
  return _retval;
}

const gchar*
bse_type_authors (const gchar* type) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("bse-type-authors", 's', type, 0);
  return _retval;
}

const gchar*
bse_type_blurb (const gchar* type) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("bse-type-blurb", 's', type, 0);
  return _retval;
}

const gchar*
bse_type_license (const gchar* type) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("bse-type-license", 's', type, 0);
  return _retval;
}

const gchar*
bse_type_options (const gchar* type) {
  const gchar* _retval;
  _retval = sfi_glue_vcall_string ("bse-type-options", 's', type, 0);
  return _retval;
}

void
bse_sniffer_request_samples (SfiProxy obj, SfiNum tick_stamp, SfiInt n_samples, BseSnifferType stype) {
  sfi_glue_vcall_void ("bse-sniffer-request-samples", 'p', obj, 'n', tick_stamp, 'i', n_samples, 'C', bse_sniffer_type_to_choice (stype), 0);
}

SfiNum
bse_sniffer_get_tick_stamp (SfiProxy obj) {
  SfiNum _retval;
  _retval = sfi_glue_vcall_num ("bse-sniffer-get-tick-stamp", 'p', obj, 0);
  return _retval;
}

SfiInt
bse_sniffer_get_mix_freq (SfiProxy obj) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("bse-sniffer-get-mix-freq", 'p', obj, 0);
  return _retval;
}

void
bse_sniffer_request_combined (BseSnifferRequestSeq* srs) {
  SfiSeq* srs__c = bse_sniffer_request_seq_to_seq (srs);
  sfi_glue_vcall_void ("bse-sniffer-request-combined", 'Q', srs__c, 0);
  sfi_seq_unref (srs__c);
}


/*-------- end ../sfi/sfidl generated code --------*/


