
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseserver.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bseserver.h>
#include <bse/bseproject.h>
#include <bse/gslloader.h>
#include <bse/bsemidinotifier.h>
#include <bse/bsemidievent.h>
#include <bse/bsejanitor.h>
#include <bse/bsescripthelper.h>
#include <bse/bsegconfig.h>
#include <bse/bseladspa.h>
#include "topconfig.h"
#include <string.h>


#line 35 "bseserver.proc"


/* --- use-new-project --- */
static void
use_new_project_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 37 "bseserver.proc"
 {
#line 39 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", "Project Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("project", "Project", NULL,
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
}
#line 38 "bseserver.proc"
  proc->help = "Create a new project, owned by the caller (name is modified to be unique if necessary)";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 46 "bseserver.proc"
 }
static BseErrorType
#line 46 "bseserver.proc"
use_new_project_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 49 "bseserver.proc"
{
#line 50 "bseserver.proc"
  
  BseServer *server     = (BseServer*) bse_value_get_object (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  gchar *uname;
  guint num = 1;
  BseProject *project;
  
#line 57 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 61 "bseserver.proc"
  
  uname = g_strdup (name);
  while (bse_server_find_project (server, uname))
    {
      g_free (uname);
      uname = g_strdup_printf ("%s-%u", name, num++);
    }
  
#line 69 "bseserver.proc"
  
  project = bse_server_create_project (server, uname);
  g_free (uname);
  bse_item_use (BSE_ITEM (project));
  g_object_unref (project);
  
#line 75 "bseserver.proc"
  
  bse_value_set_object (out_values++, G_OBJECT (project));
  
  return BSE_ERROR_NONE;
}

/* --- get-midi-notifier --- */
static void
get_midi_notifier_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 81 "bseserver.proc"
 {
#line 83 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("midi_notifier", "Midi Notifier", NULL,
				 BSE_TYPE_MIDI_NOTIFIER, SFI_PARAM_DEFAULT);
}
#line 82 "bseserver.proc"
  proc->help = "Retrieve the global midi notifier object.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 88 "bseserver.proc"
 }
static BseErrorType
#line 88 "bseserver.proc"
get_midi_notifier_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 91 "bseserver.proc"
{
#line 92 "bseserver.proc"
  
  BseServer *self = bse_value_get_object (in_values++);
  BseMidiNotifier *notifier;
  
#line 96 "bseserver.proc"
  
  if (!BSE_IS_SERVER (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  notifier = NULL;
#if 0
  midi_receiver = bse_server_get_midi_receiver (self, "default");
  notifier = bse_midi_receiver_get_notifier (midi_receiver);
  if (!notifier)
    {
      notifier = g_object_new (BSE_TYPE_MIDI_NOTIFIER, NULL);
      bse_midi_receiver_set_notifier (midi_receiver, notifier);
      g_object_unref (notifier);
    }
#endif
  
#line 112 "bseserver.proc"
  
  bse_value_set_object (out_values++, G_OBJECT (notifier));
  
  return BSE_ERROR_NONE;
}

/* --- can-load --- */
static void
can_load_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 118 "bseserver.proc"
 {
#line 120 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("file_name", "File Name", "The file to find a loader for",
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_bool ("can-load", NULL, NULL,
			  FALSE, SFI_PARAM_DEFAULT);
}
#line 119 "bseserver.proc"
  proc->help = "Check whether a loader can be found for a wave file";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 127 "bseserver.proc"
 }
static BseErrorType
#line 127 "bseserver.proc"
can_load_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 130 "bseserver.proc"
{
#line 131 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  gchar *file_name	= sfi_value_get_string (in_values++);
  GslWaveFileInfo *finfo;
  
#line 136 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 140 "bseserver.proc"
  
  finfo = gsl_wave_file_info_load (file_name, NULL);
  sfi_value_set_bool (out_values++, finfo != NULL);
  if (finfo)
    gsl_wave_file_info_unref (finfo);
  
  return BSE_ERROR_NONE;
}

/* --- describe-note --- */
static void
describe_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 149 "bseserver.proc"
 {
#line 151 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", NULL);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
			 BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_DEFAULT);
}
#line 150 "bseserver.proc"
  proc->help = "Describe a note, providing information about its octave, semitone, frequency, etc.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 158 "bseserver.proc"
 }
static BseErrorType
#line 158 "bseserver.proc"
describe_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 161 "bseserver.proc"
{
#line 162 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  gint       note	= sfi_value_get_int (in_values++);
  gint       fine_tune	= sfi_value_get_int (in_values++);
  
#line 167 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 171 "bseserver.proc"
  
  bse_value_take_boxed (out_values++, bse_note_description (note, fine_tune));
  
  return BSE_ERROR_NONE;
}

/* --- note-from-freq --- */
static void
note_from_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 177 "bseserver.proc"
 {
#line 179 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_real ("freq", "Frequency", NULL,
			  BSE_KAMMER_FREQUENCY_f,
			  0, BSE_MAX_FREQUENCY_f,
			  10.0, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
			 BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_DEFAULT);
}
#line 178 "bseserver.proc"
  proc->help = "Describe a note, given its frequency.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 188 "bseserver.proc"
 }
static BseErrorType
#line 188 "bseserver.proc"
note_from_freq_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 191 "bseserver.proc"
{
#line 192 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  gfloat     freq	= sfi_value_get_real (in_values++);
  gint note;
  
#line 197 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 201 "bseserver.proc"
  
  note = bse_note_from_freq (freq);
  bse_value_take_boxed (out_values++, bse_note_description (note, 0));
  
  return BSE_ERROR_NONE;
}

/* --- note-from-string --- */
static void
note_from_string_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 208 "bseserver.proc"
 {
#line 210 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", NULL,
			    "", SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
			 BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_DEFAULT);
}
#line 209 "bseserver.proc"
  proc->help = "Describe a note, given its name and octave offset.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 217 "bseserver.proc"
 }
static BseErrorType
#line 217 "bseserver.proc"
note_from_string_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 220 "bseserver.proc"
{
#line 221 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  gchar     *name     	= sfi_value_get_string (in_values++);
  gint note;
  
#line 226 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 230 "bseserver.proc"
  
  note = bse_note_from_string (name);
  bse_value_take_boxed (out_values++, bse_note_description (note, 0));
  
  return BSE_ERROR_NONE;
}

/* --- construct-note --- */
static void
construct_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 237 "bseserver.proc"
 {
#line 239 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("semitone", NULL, NULL,
			 9, 0, 11, 1,
			 SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_octave ("octave", NULL, NULL);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", NULL);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
			 BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_DEFAULT);
}
#line 238 "bseserver.proc"
  proc->help = "Describe a note, given its semitone, octave and fine tune.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 249 "bseserver.proc"
 }
static BseErrorType
#line 249 "bseserver.proc"
construct_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 252 "bseserver.proc"
{
#line 253 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  guint      semitone	= sfi_value_get_int (in_values++);
  gint       octave	= sfi_value_get_int (in_values++);
  gint       fine_tune	= sfi_value_get_int (in_values++);
  gint note;
  
#line 260 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 264 "bseserver.proc"
  
  note = BSE_NOTE_GENERIC (octave, semitone);
  bse_value_take_boxed (out_values++, bse_note_description (note, fine_tune));
  
  return BSE_ERROR_NONE;
}

/* --- n-scripts --- */
static void
n_scripts_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 271 "bseserver.proc"
 {
#line 273 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_int ("n_connections", NULL, "Number of Connections",
			 0, 0, G_MAXINT, 1,
			 SFI_PARAM_DEFAULT);
}
#line 272 "bseserver.proc"
  proc->help = "Return the number of scripts currently running on this server.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 279 "bseserver.proc"
 }
static BseErrorType
#line 279 "bseserver.proc"
n_scripts_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 282 "bseserver.proc"
{
#line 283 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  GSList *slist;
  guint n_scripts = 0;
  
#line 288 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 292 "bseserver.proc"
  
  for (slist = server->children; slist; slist = slist->next)
    if (BSE_IS_JANITOR (slist->data))
      n_scripts++;
  
#line 297 "bseserver.proc"
  
  sfi_value_set_int (out_values++, n_scripts);
  
  return BSE_ERROR_NONE;
}

/* --- preferences-locked --- */
static void
preferences_locked_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 303 "bseserver.proc"
 {
#line 305 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_bool ("locked", NULL, NULL,
			  FALSE, SFI_PARAM_DEFAULT);
}
#line 304 "bseserver.proc"
  proc->help = "Returns whether the bse-preferences property is currently locked against modifications or not.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 310 "bseserver.proc"
 }
static BseErrorType
#line 310 "bseserver.proc"
preferences_locked_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 313 "bseserver.proc"
{
#line 314 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  
#line 317 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 321 "bseserver.proc"
  
  sfi_value_set_int (out_values++, bse_gconfig_locked ());
  
  return BSE_ERROR_NONE;
}

typedef struct _ScriptRegistration ScriptRegistration;
struct _ScriptRegistration
{
  gchar         *script;
  BseErrorType (*register_func) (const gchar *script,
				 BseJanitor **janitor_p);
  ScriptRegistration *next;
};

static gboolean	register_scripts (gpointer data);

static void
script_janitor_closed (BseJanitor *janitor,
		       BseServer  *server)
{
  bse_server_registration (server, BSE_REGISTER_SCRIPT, bse_janitor_get_script (janitor), NULL);
  bse_idle_normal (register_scripts, server);
}

static gboolean
register_scripts (gpointer data)
{
  BseServer *server = data;
  ScriptRegistration *scr = g_object_get_data (server, "script-registration-queue");
  BseJanitor *janitor = NULL;
  BseErrorType error;

  if (!scr)
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return FALSE;
    }
  g_object_set_data (server, "script-registration-queue", scr->next);

  error = scr->register_func (scr->script, &janitor);
  if (!janitor)
    bse_server_registration (server, BSE_REGISTER_SCRIPT, scr->script, bse_error_blurb (error));
  else
    g_object_connect (janitor, "signal::closed", script_janitor_closed, server, NULL);
  g_free (scr->script);
  g_free (scr);
  return !janitor;
}

/* --- register-scripts --- */
static void
register_scripts_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 371 "bseserver.proc"
 {
#line 373 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
}
#line 372 "bseserver.proc"
  proc->help = "Register external scripts.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 376 "bseserver.proc"
 }
static BseErrorType
#line 376 "bseserver.proc"
register_scripts_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 379 "bseserver.proc"
{
  static gboolean registration_done = FALSE;
#line 381 "bseserver.proc"
  
  BseServer *server	       = bse_value_get_object (in_values++);
  ScriptRegistration *scr_list = NULL;
  SfiRing *ring;

#line 386 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;

  if (registration_done)
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return BSE_ERROR_NONE;
    }
  registration_done = TRUE;

  ring = bse_script_path_list_files ();
  while (ring)
    {
      ScriptRegistration *scr = g_new0 (ScriptRegistration, 1);
      scr->script = sfi_ring_pop_head (&ring);
      scr->register_func = bse_script_file_register;
      scr->next = scr_list;
      scr_list = scr;
    }

  g_object_set_data (server, "script-registration-queue", scr_list);
  bse_idle_normal (register_scripts, server);

  return BSE_ERROR_NONE;
}

static gboolean
register_core_plugins (gpointer data)
{
  BseServer *server = data;
  SfiRing *plugins = g_object_get_data (server, "plugin-registration-queue");
  const gchar *error;

  if (plugins)
    {
      gchar *name = sfi_ring_pop_head (&plugins);
      g_object_set_data (server, "plugin-registration-queue", plugins);
      error = bse_plugin_check_load (name);
      bse_server_registration (server, BSE_REGISTER_PLUGIN, name, error);
      g_free (name);
    }
  else
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return FALSE;
    }
  return TRUE;
}

/* --- register-core-plugins --- */
static void
register_core_plugins_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 436 "bseserver.proc"
 {
#line 438 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
}
#line 437 "bseserver.proc"
  proc->help = "Register core plugins.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 441 "bseserver.proc"
 }
static BseErrorType
#line 441 "bseserver.proc"
register_core_plugins_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 444 "bseserver.proc"
{
  static gboolean registration_done = FALSE;
#line 446 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  SfiRing *ring;

#line 450 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;

  if (registration_done)
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return BSE_ERROR_NONE;
    }
  registration_done = TRUE;

  ring = bse_plugin_path_list_files ();
  g_object_set_data (server, "plugin-registration-queue", ring);

  bse_idle_normal (register_core_plugins, server);

  return BSE_ERROR_NONE;
}

static gboolean
register_ladspa_plugins (gpointer data)
{
  BseServer *server = data;
  SfiRing *lplugins = g_object_get_data (server, "ladspa-registration-queue");
  const gchar *error;

  if (g_object_get_data (server, "plugin-registration-queue"))
    {
#line 478 "bseserver.proc"
      
      return TRUE;
    }

  if (lplugins)
    {
      gchar *name = sfi_ring_pop_head (&lplugins);
      g_object_set_data (server, "ladspa-registration-queue", lplugins);
      error = bse_ladspa_plugin_check_load (name);
      bse_server_registration (server, BSE_REGISTER_PLUGIN, name, error);
      g_free (name);
    }
  else
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return FALSE;
    }
  return TRUE;
}

/* --- register-ladspa-plugins --- */
static void
register_ladspa_plugins_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 498 "bseserver.proc"
 {
#line 500 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
}
#line 499 "bseserver.proc"
  proc->help = "Register LADSPA (Linux Audio Developer's Simple Plugin API) plugins.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 503 "bseserver.proc"
 }
static BseErrorType
#line 503 "bseserver.proc"
register_ladspa_plugins_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 506 "bseserver.proc"
{
  static gboolean registration_done = FALSE;
#line 508 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  SfiRing *ring;

#line 512 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;

  if (registration_done)
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return BSE_ERROR_NONE;
    }
  registration_done = TRUE;

  ring = bse_ladspa_plugin_path_list_files ();
  g_object_set_data (server, "ladspa-registration-queue", ring);

  bse_idle_normal (register_ladspa_plugins, server);

  return BSE_ERROR_NONE;
}

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

/* --- save-preferences --- */
static void
save_preferences_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 536 "bseserver.proc"
 {
#line 538 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
}
#line 537 "bseserver.proc"
  proc->help = "Request the bse-preferences property to be saved into BSE's configuration file.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 541 "bseserver.proc"
 }
static BseErrorType
#line 541 "bseserver.proc"
save_preferences_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 544 "bseserver.proc"
{
#line 545 "bseserver.proc"
  
  BseServer *server = bse_value_get_object (in_values++);
  SfiWStore *wstore;
  gchar *file_name;
  GValue *value;
  SfiRec *rec;
  gint fd;
  
#line 553 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;

  file_name = g_strconcat (g_get_home_dir (), "/.bserc", NULL);
  fd = open (file_name,
#line 559 "bseserver.proc"
	     O_WRONLY | O_CREAT | O_TRUNC, 
	     0666);
  g_free (file_name);
  if (fd < 0)
    return BSE_ERROR_NONE;

  wstore = sfi_wstore_new ();
  sfi_wstore_printf (wstore, "; rc-file for BSE v%s\n", BSE_VERSION);

#line 568 "bseserver.proc"
  
  sfi_wstore_puts (wstore, "\n; BseGConfig Dump\n");
  rec = bse_gconfig_to_rec (bse_global_config);
  value = sfi_value_rec (rec);
  sfi_wstore_put_param (wstore, value, bse_gconfig_pspec ());
  sfi_value_free (value);
  sfi_rec_unref (rec);
  sfi_wstore_puts (wstore, "\n");

#line 577 "bseserver.proc"
  
  sfi_wstore_flush_fd (wstore, fd);
  sfi_wstore_destroy (wstore);
  close (fd);

  return BSE_ERROR_NONE;
}

/* --- get-version --- */
static void
get_version_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 585 "bseserver.proc"
 {
#line 587 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("version", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
}
#line 586 "bseserver.proc"
  proc->help = "Retrieve BSE version.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 591 "bseserver.proc"
 }
static BseErrorType
#line 591 "bseserver.proc"
get_version_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 594 "bseserver.proc"
{
  sfi_value_set_string (out_values++, BSE_VERSION);
  return BSE_ERROR_NONE;
}

/* --- get-sample-path --- */
static void
get_sample_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 599 "bseserver.proc"
 {
#line 601 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
}
#line 600 "bseserver.proc"
  proc->help = "Retrieve sample search path.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 605 "bseserver.proc"
 }
static BseErrorType
#line 605 "bseserver.proc"
get_sample_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 608 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_SAMPLES, BSE_GCONFIG (sample_path), NULL));
  return BSE_ERROR_NONE;
}

/* --- get-effect-path --- */
static void
get_effect_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 613 "bseserver.proc"
 {
#line 615 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
}
#line 614 "bseserver.proc"
  proc->help = "Retrieve effect search path.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 619 "bseserver.proc"
 }
static BseErrorType
#line 619 "bseserver.proc"
get_effect_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 622 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_EFFECTS, BSE_GCONFIG (effect_path), NULL));
  return BSE_ERROR_NONE;
}

/* --- get-instrument-path --- */
static void
get_instrument_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 627 "bseserver.proc"
 {
#line 629 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
}
#line 628 "bseserver.proc"
  proc->help = "Retrieve instrument search path.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 633 "bseserver.proc"
 }
static BseErrorType
#line 633 "bseserver.proc"
get_instrument_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 636 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_INSTRUMENTS, BSE_GCONFIG (instrument_path), NULL));
  return BSE_ERROR_NONE;
}

/* --- get-script-path --- */
static void
get_script_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 641 "bseserver.proc"
 {
#line 643 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
}
#line 642 "bseserver.proc"
  proc->help = "Retrieve script search path.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 647 "bseserver.proc"
 }
static BseErrorType
#line 647 "bseserver.proc"
get_script_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 650 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_SCRIPTS, BSE_GCONFIG (script_path), NULL));
  return BSE_ERROR_NONE;
}

/* --- get-plugin-path --- */
static void
get_plugin_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 655 "bseserver.proc"
 {
#line 657 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
}
#line 656 "bseserver.proc"
  proc->help = "Retrieve plugin search path.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 661 "bseserver.proc"
 }
static BseErrorType
#line 661 "bseserver.proc"
get_plugin_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 664 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_PLUGINS, BSE_GCONFIG (plugin_path), NULL));
  return BSE_ERROR_NONE;
}

/* --- get-ladspa-path --- */
static void
get_ladspa_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 669 "bseserver.proc"
 {
#line 671 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
}
#line 670 "bseserver.proc"
  proc->help = "Retrieve ladspa search path.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 675 "bseserver.proc"
 }
static BseErrorType
#line 675 "bseserver.proc"
get_ladspa_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 678 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_LADSPA, BSE_GCONFIG (ladspa_path), NULL));
  return BSE_ERROR_NONE;
}

#include "gsldatahandle-mad.h"

/* --- get-mp3-version --- */
static void
get_mp3_version_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 685 "bseserver.proc"
 {
#line 687 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("version", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
}
#line 686 "bseserver.proc"
  proc->help = "Retrieve BSE MP3 handler version.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 691 "bseserver.proc"
 }
static BseErrorType
#line 691 "bseserver.proc"
get_mp3_version_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 694 "bseserver.proc"
{
  const gchar *c = gsl_data_handle_mad_version ();
  if (c)
    sfi_value_take_string (out_values++, g_strconcat ("MAD ", c, NULL));
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static BseExportNodeProc __enode_use_new_project = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseServer+use-new-project", "/Methods/BseServer/General/Use New Project", NULL },
  0, use_new_project_setup, use_new_project_exec, 
};
static BseExportNodeProc __enode_get_midi_notifier = {
  { (BseExportNode*) &__enode_use_new_project, BSE_EXPORT_NODE_PROC,
    "BseServer+get-midi-notifier", "/Methods/BseServer/General/Get Midi Notifier", NULL },
  0, get_midi_notifier_setup, get_midi_notifier_exec, 
};
static BseExportNodeProc __enode_can_load = {
  { (BseExportNode*) &__enode_get_midi_notifier, BSE_EXPORT_NODE_PROC,
    "BseServer+can-load", "/Methods/BseServer/General/Can Load", NULL },
  0, can_load_setup, can_load_exec, 
};
static BseExportNodeProc __enode_describe_note = {
  { (BseExportNode*) &__enode_can_load, BSE_EXPORT_NODE_PROC,
    "BseServer+describe-note", "/Methods/BseServer/General/Describe Note", NULL },
  0, describe_note_setup, describe_note_exec, 
};
static BseExportNodeProc __enode_note_from_freq = {
  { (BseExportNode*) &__enode_describe_note, BSE_EXPORT_NODE_PROC,
    "BseServer+note-from-freq", "/Methods/BseServer/General/Note From Freq", NULL },
  0, note_from_freq_setup, note_from_freq_exec, 
};
static BseExportNodeProc __enode_note_from_string = {
  { (BseExportNode*) &__enode_note_from_freq, BSE_EXPORT_NODE_PROC,
    "BseServer+note-from-string", "/Methods/BseServer/General/Note From String", NULL },
  0, note_from_string_setup, note_from_string_exec, 
};
static BseExportNodeProc __enode_construct_note = {
  { (BseExportNode*) &__enode_note_from_string, BSE_EXPORT_NODE_PROC,
    "BseServer+construct-note", "/Methods/BseServer/General/Construct Note", NULL },
  0, construct_note_setup, construct_note_exec, 
};
static BseExportNodeProc __enode_n_scripts = {
  { (BseExportNode*) &__enode_construct_note, BSE_EXPORT_NODE_PROC,
    "BseServer+n-scripts", "/Methods/BseServer/General/N Scripts", NULL },
  0, n_scripts_setup, n_scripts_exec, 
};
static BseExportNodeProc __enode_preferences_locked = {
  { (BseExportNode*) &__enode_n_scripts, BSE_EXPORT_NODE_PROC,
    "BseServer+preferences-locked", "/Methods/BseServer/General/Preferences Locked", NULL },
  0, preferences_locked_setup, preferences_locked_exec, 
};
static BseExportNodeProc __enode_register_scripts = {
  { (BseExportNode*) &__enode_preferences_locked, BSE_EXPORT_NODE_PROC,
    "BseServer+register-scripts", "/Methods/BseServer/General/Register Scripts", NULL },
  0, register_scripts_setup, register_scripts_exec, 
};
static BseExportNodeProc __enode_register_core_plugins = {
  { (BseExportNode*) &__enode_register_scripts, BSE_EXPORT_NODE_PROC,
    "BseServer+register-core-plugins", "/Methods/BseServer/General/Register Core Plugins", NULL },
  0, register_core_plugins_setup, register_core_plugins_exec, 
};
static BseExportNodeProc __enode_register_ladspa_plugins = {
  { (BseExportNode*) &__enode_register_core_plugins, BSE_EXPORT_NODE_PROC,
    "BseServer+register-ladspa-plugins", "/Methods/BseServer/General/Register Ladspa Plugins", NULL },
  0, register_ladspa_plugins_setup, register_ladspa_plugins_exec, 
};
static BseExportNodeProc __enode_save_preferences = {
  { (BseExportNode*) &__enode_register_ladspa_plugins, BSE_EXPORT_NODE_PROC,
    "BseServer+save-preferences", "/Methods/BseServer/General/Save Preferences", NULL },
  0, save_preferences_setup, save_preferences_exec, 
};
static BseExportNodeProc __enode_get_version = {
  { (BseExportNode*) &__enode_save_preferences, BSE_EXPORT_NODE_PROC,
    "BseServer+get-version", "/Methods/BseServer/General/Get Version", NULL },
  0, get_version_setup, get_version_exec, 
};
static BseExportNodeProc __enode_get_sample_path = {
  { (BseExportNode*) &__enode_get_version, BSE_EXPORT_NODE_PROC,
    "BseServer+get-sample-path", "/Methods/BseServer/General/Get Sample Path", NULL },
  0, get_sample_path_setup, get_sample_path_exec, 
};
static BseExportNodeProc __enode_get_effect_path = {
  { (BseExportNode*) &__enode_get_sample_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-effect-path", "/Methods/BseServer/General/Get Effect Path", NULL },
  0, get_effect_path_setup, get_effect_path_exec, 
};
static BseExportNodeProc __enode_get_instrument_path = {
  { (BseExportNode*) &__enode_get_effect_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-instrument-path", "/Methods/BseServer/General/Get Instrument Path", NULL },
  0, get_instrument_path_setup, get_instrument_path_exec, 
};
static BseExportNodeProc __enode_get_script_path = {
  { (BseExportNode*) &__enode_get_instrument_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-script-path", "/Methods/BseServer/General/Get Script Path", NULL },
  0, get_script_path_setup, get_script_path_exec, 
};
static BseExportNodeProc __enode_get_plugin_path = {
  { (BseExportNode*) &__enode_get_script_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-plugin-path", "/Methods/BseServer/General/Get Plugin Path", NULL },
  0, get_plugin_path_setup, get_plugin_path_exec, 
};
static BseExportNodeProc __enode_get_ladspa_path = {
  { (BseExportNode*) &__enode_get_plugin_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-ladspa-path", "/Methods/BseServer/General/Get Ladspa Path", NULL },
  0, get_ladspa_path_setup, get_ladspa_path_exec, 
};
static BseExportNodeProc __enode_get_mp3_version = {
  { (BseExportNode*) &__enode_get_ladspa_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-mp3-version", "/Methods/BseServer/General/Get Mp3 Version", NULL },
  0, get_mp3_version_setup, get_mp3_version_exec, 
};
BseExportNode* bse__builtin_init_bseserver_gen_proc_c (void);
BseExportNode* bse__builtin_init_bseserver_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_get_mp3_version;
}

/**
 ** Generated data ends here
 **/
