
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsepart.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsepart.h>
#include        <bse/bsesong.h>


#line 26 "bsepart.proc"


/* --- insert-note --- */
static GType type_id_insert_note = 0;
static void
insert_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 28 "bsepart.proc"
 {
#line 30 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++) = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_DEFAULT SFI_PARAM_HINT_SCALE);
  *(out_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_DEFAULT);
}
#line 29 "bsepart.proc"
  proc->help = "Insert a new note into a part.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 45 "bsepart.proc"
 }
static BseErrorType
#line 45 "bsepart.proc"
insert_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 48 "bsepart.proc"
{
#line 49 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note	     = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  BseUndoStack *ustack;
  guint id;
  
#line 59 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 63 "bsepart.proc"
  
  ustack = bse_item_undo_open (self, "insert-note");
  id = bse_part_insert_note (self, tick, duration, note, fine_tune, velocity);
  if (id)
    bse_item_push_undo_proc (self, "delete-event", id);
  bse_item_undo_close (ustack);

#line 70 "bsepart.proc"
  
  sfi_value_set_int (out_values++, id);
  
  return BSE_ERROR_NONE;
}

/* --- insert-control --- */
static GType type_id_insert_control = 0;
static void
insert_control_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 76 "bsepart.proc"
 {
#line 78 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_real ("value", "Value", NULL,
			  0.0, -1.0, +1.0, 0.1,
			  SFI_PARAM_DEFAULT SFI_PARAM_HINT_SCALE);
  *(out_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_DEFAULT);
}
#line 77 "bsepart.proc"
  proc->help = "Insert a new control event into a part.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 91 "bsepart.proc"
 }
static BseErrorType
#line 91 "bsepart.proc"
insert_control_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 94 "bsepart.proc"
{
#line 95 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    ctype     = g_value_get_enum (in_values++);
  gfloat   value     = sfi_value_get_real (in_values++);
  BseUndoStack *ustack;
  guint id;
  
#line 103 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 107 "bsepart.proc"
  
  ustack = bse_item_undo_open (self, "insert-event");
  id = bse_part_insert_control (self, tick, ctype, value);
  if (id)
    bse_item_push_undo_proc (self, "delete-event", id);
  bse_item_undo_close (ustack);

#line 114 "bsepart.proc"
  
  sfi_value_set_int (out_values++, id);
  
  return BSE_ERROR_NONE;
}

/* --- change-note --- */
static GType type_id_change_note = 0;
static void
change_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 120 "bsepart.proc"
 {
#line 122 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++) = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_DEFAULT SFI_PARAM_HINT_SCALE);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
}
#line 121 "bsepart.proc"
  proc->help = "Change an existing note within a part.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 140 "bsepart.proc"
 }
static BseErrorType
#line 140 "bsepart.proc"
change_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 143 "bsepart.proc"
{
#line 144 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    id	     = sfi_value_get_int (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note	     = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  gboolean success = FALSE;
  BsePartQueryEvent equery;

#line 155 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 159 "bsepart.proc"
  
  if (bse_part_query_event (self, id, &equery) == BSE_PART_EVENT_NOTE)
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "change-note");
      if (equery.tick != tick || equery.duration != duration ||
          equery.note != note || equery.fine_tune != fine_tune ||
          equery.velocity != velocity)
        {
          success = bse_part_change_note (self, id, tick, duration, note, fine_tune, velocity);
          if (success)
            bse_item_push_undo_proc (self, "change-note", id, equery.tick, equery.duration,
                                     equery.note, equery.fine_tune, equery.velocity);
        }
      else
        success = TRUE;
      bse_item_undo_close (ustack);
    }

#line 177 "bsepart.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_EVENT);
  
  return BSE_ERROR_NONE;
}

/* --- change-control --- */
static GType type_id_change_control = 0;
static void
change_control_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 183 "bsepart.proc"
 {
#line 185 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_real ("value", "Value", NULL,
			  0.0, -1.0, +1.0, 0.1,
			  SFI_PARAM_DEFAULT SFI_PARAM_HINT_SCALE);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
}
#line 184 "bsepart.proc"
  proc->help = "Change an existing control event within a part.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 201 "bsepart.proc"
 }
static BseErrorType
#line 201 "bsepart.proc"
change_control_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 204 "bsepart.proc"
{
#line 205 "bsepart.proc"
  
  BsePart *self  = bse_value_get_object (in_values++);
  guint    id    = sfi_value_get_int (in_values++);
  guint    tick  = sfi_value_get_int (in_values++);
  guint    ctype = g_value_get_enum (in_values++);
  gfloat   value = sfi_value_get_real (in_values++);
  BsePartQueryEvent equery;
  gboolean success = FALSE;

#line 214 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 218 "bsepart.proc"
  
  bse_part_query_event (self, id, &equery);
  if (equery.event_type == BSE_PART_EVENT_CONTROL && !BSE_PART_NOTE_CONTROL (ctype))
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "change-control");
      if (equery.tick != tick || equery.control_type != ctype || equery.control_value != value)
        {
          success = bse_part_change_control (self, id, tick, ctype, value);
          if (success)
            bse_item_push_undo_proc (self, "change-control", id, equery.tick, equery.control_type, equery.control_value);
        }
      else
        success = TRUE;
      bse_item_undo_close (ustack);
    }
  else if (equery.event_type == BSE_PART_EVENT_NOTE && BSE_PART_NOTE_CONTROL (ctype))
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "change-control");
      BsePartQueryEvent xquery;
      success = bse_part_change_control (self, id, tick, ctype, value);
      if (success && bse_part_query_event (self, id, &xquery) == BSE_PART_EVENT_NOTE &&
          (equery.fine_tune_value != xquery.fine_tune_value ||
           equery.velocity_value  != xquery.velocity_value))
        switch (ctype)
          {
          case BSE_MIDI_SIGNAL_VELOCITY:
            bse_item_push_undo_proc (self, "change-control", id, equery.tick, ctype, equery.velocity_value);
            break;
          case BSE_MIDI_SIGNAL_FINE_TUNE:
            bse_item_push_undo_proc (self, "change-control", id, equery.tick, ctype, equery.fine_tune_value);
            break;
          default: ;
          }
      bse_item_undo_close (ustack);
    }
  
#line 254 "bsepart.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_EVENT);
  
  return BSE_ERROR_NONE;
}

/* --- delete-event --- */
static GType type_id_delete_event = 0;
static void
delete_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 260 "bsepart.proc"
 {
#line 262 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
}
#line 261 "bsepart.proc"
  proc->help = "Delete an existing event from a part.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 270 "bsepart.proc"
 }
static BseErrorType
#line 270 "bsepart.proc"
delete_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 273 "bsepart.proc"
{
#line 274 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  BsePartQueryEvent equery;
  gboolean deleted = FALSE;

#line 280 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 284 "bsepart.proc"
  
  bse_part_query_event (self, id, &equery);
  if (equery.event_type == BSE_PART_EVENT_NOTE)
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "delete-note");
      deleted = bse_part_delete_event (self, id);
      if (deleted)
        bse_item_push_undo_proc (self, "insert-note", equery.tick, equery.duration,
                                 equery.note, equery.fine_tune, equery.velocity);
      bse_item_undo_close (ustack);
    }
  else if (equery.event_type == BSE_PART_EVENT_CONTROL)
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "delete-control");
      deleted = bse_part_delete_event (self, id);
      if (deleted)
        bse_item_push_undo_proc (self, "insert-control", equery.tick, equery.control_type, equery.control_value);
      bse_item_undo_close (ustack);
    }

#line 304 "bsepart.proc"
  
  g_value_set_enum (out_values++, deleted ? BSE_ERROR_NONE : BSE_ERROR_NO_EVENT);
  
  return BSE_ERROR_NONE;
}

/* --- is-selected-event --- */
static GType type_id_is_selected_event = 0;
static void
is_selected_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 310 "bsepart.proc"
 {
#line 312 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_bool ("selected", "Selected", NULL,
			  FALSE, SFI_PARAM_DEFAULT);
}
#line 311 "bsepart.proc"
  proc->help = "Check whether a specific event is selected.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 319 "bsepart.proc"
 }
static BseErrorType
#line 319 "bsepart.proc"
is_selected_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 322 "bsepart.proc"
{
#line 323 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  gboolean selected;
  
#line 328 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 332 "bsepart.proc"
  
  selected = bse_part_is_selected_event (self, id);
  
#line 335 "bsepart.proc"
  
  sfi_value_set_bool (out_values++, selected);
  
  return BSE_ERROR_NONE;
}

/* --- list-notes-crossing --- */
static GType type_id_list_notes_crossing = 0;
static void
list_notes_crossing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 341 "bsepart.proc"
 {
#line 343 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_DEFAULT);
}
#line 342 "bsepart.proc"
  proc->help = "List all notes within or crossing a tick range.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 352 "bsepart.proc"
 }
static BseErrorType
#line 352 "bsepart.proc"
list_notes_crossing_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 355 "bsepart.proc"
{
#line 356 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  
#line 361 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 365 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes_crossing (self, tick, duration, BSE_MIN_NOTE, BSE_MAX_NOTE));
  
  return BSE_ERROR_NONE;
}

/* --- list-controls --- */
static GType type_id_list_controls = 0;
static void
list_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 371 "bsepart.proc"
 {
#line 373 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("control_list", "Control List", NULL,
                                BSE_TYPE_PART_CONTROL_SEQ, SFI_PARAM_DEFAULT);
}
#line 372 "bsepart.proc"
  proc->help = "List all control events within a tick range.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 385 "bsepart.proc"
 }
static BseErrorType
#line 385 "bsepart.proc"
list_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 388 "bsepart.proc"
{
#line 389 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  guint    ctype     = g_value_get_enum (in_values++);
  
#line 395 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 399 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_controls (self, tick, duration, ctype));
  
  return BSE_ERROR_NONE;
}

/* --- queue-notes --- */
static GType type_id_queue_notes = 0;
static void
queue_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 405 "bsepart.proc"
 {
#line 407 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Note", NULL,
				 SFI_PARAM_DEFAULT);
}
#line 406 "bsepart.proc"
  proc->help = "Queue updates for all notes starting within the given rectangle.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 418 "bsepart.proc"
 }
static BseErrorType
#line 418 "bsepart.proc"
queue_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 421 "bsepart.proc"
{
#line 422 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  gint     min_note = sfi_value_get_note (in_values++);
  gint     max_note = sfi_value_get_note (in_values++);
  
#line 429 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 433 "bsepart.proc"
  
  bse_part_queue_notes_within (self, tick, duration, min_note, max_note);
  
  return BSE_ERROR_NONE;
}

/* --- queue-controls --- */
static GType type_id_queue_controls = 0;
static void
queue_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 439 "bsepart.proc"
 {
#line 441 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
}
#line 440 "bsepart.proc"
  proc->help = "Queue updates for all notes starting within the given range.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 448 "bsepart.proc"
 }
static BseErrorType
#line 448 "bsepart.proc"
queue_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 451 "bsepart.proc"
{
#line 452 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  
#line 457 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 461 "bsepart.proc"
  
  bse_part_queue_controls (self, tick, duration);
  
  return BSE_ERROR_NONE;
}

/* --- list-selected-notes --- */
static GType type_id_list_selected_notes = 0;
static void
list_selected_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 467 "bsepart.proc"
 {
#line 469 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_DEFAULT);
}
#line 468 "bsepart.proc"
  proc->help = "List all currently selected notes.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 474 "bsepart.proc"
 }
static BseErrorType
#line 474 "bsepart.proc"
list_selected_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 477 "bsepart.proc"
{
#line 478 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  
#line 481 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 485 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_selected_notes (self));
  
  return BSE_ERROR_NONE;
}

/* --- list-selected-controls --- */
static GType type_id_list_selected_controls = 0;
static void
list_selected_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 491 "bsepart.proc"
 {
#line 493 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("control_list", "Control List", NULL,
                                BSE_TYPE_PART_CONTROL_SEQ, SFI_PARAM_DEFAULT);
}
#line 492 "bsepart.proc"
  proc->help = "List all currently selected control events of a specific type.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 501 "bsepart.proc"
 }
static BseErrorType
#line 501 "bsepart.proc"
list_selected_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 504 "bsepart.proc"
{
#line 505 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    ctype    = g_value_get_enum (in_values++);
  
#line 509 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 513 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_selected_controls (self, ctype));
  
  return BSE_ERROR_NONE;
}

/* --- check-overlap --- */
static GType type_id_check_overlap = 0;
static void
check_overlap_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 519 "bsepart.proc"
 {
#line 521 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_DEFAULT);
}
#line 520 "bsepart.proc"
  proc->help = "Check whether a note would overlap with neighbours.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 531 "bsepart.proc"
 }
static BseErrorType
#line 531 "bsepart.proc"
check_overlap_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 534 "bsepart.proc"
{
#line 535 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  gint     note     = sfi_value_get_note (in_values++);
  
#line 541 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 545 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes_crossing (self, tick, duration, note, note));
  
  return BSE_ERROR_NONE;
}

/* --- get-notes --- */
static GType type_id_get_notes = 0;
static void
get_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 551 "bsepart.proc"
 {
#line 553 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_DEFAULT);
}
#line 552 "bsepart.proc"
  proc->help = "Retrieve all notes of specific frequency at a specific tick.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 562 "bsepart.proc"
 }
static BseErrorType
#line 562 "bsepart.proc"
get_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 565 "bsepart.proc"
{
#line 566 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  gint     note     = sfi_value_get_note (in_values++);
  
#line 571 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 575 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes_crossing (self, tick, 1, note, note));
  
  return BSE_ERROR_NONE;
}

/* --- get-controls --- */
static GType type_id_get_controls = 0;
static void
get_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 581 "bsepart.proc"
 {
#line 583 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("control_list", "Control List", NULL,
                                BSE_TYPE_PART_CONTROL_SEQ, SFI_PARAM_DEFAULT);
}
#line 582 "bsepart.proc"
  proc->help = "Retrieve all control events of a specific type within range.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 593 "bsepart.proc"
 }
static BseErrorType
#line 593 "bsepart.proc"
get_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 596 "bsepart.proc"
{
#line 597 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    ctype    = g_value_get_enum (in_values++);
  
#line 602 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 606 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_controls (self, tick, 1, ctype));
  
  return BSE_ERROR_NONE;
}

/* --- get-min-note --- */
static GType type_id_get_min_note = 0;
static void
get_min_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 612 "bsepart.proc"
 {
#line 614 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_DEFAULT);
}
#line 613 "bsepart.proc"
  proc->help = "Retrieve the minimum note supported in this part.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 619 "bsepart.proc"
 }
static BseErrorType
#line 619 "bsepart.proc"
get_min_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 622 "bsepart.proc"
{
#line 623 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  
#line 626 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 630 "bsepart.proc"
  
  sfi_value_set_int (out_values++, BSE_MIN_NOTE);
  
  return BSE_ERROR_NONE;
}

/* --- get-max-note --- */
static GType type_id_get_max_note = 0;
static void
get_max_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 636 "bsepart.proc"
 {
#line 638 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_DEFAULT);
}
#line 637 "bsepart.proc"
  proc->help = "Retrieve the maximum note supported in this part.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 643 "bsepart.proc"
 }
static BseErrorType
#line 643 "bsepart.proc"
get_max_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 646 "bsepart.proc"
{
#line 647 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  
#line 650 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 654 "bsepart.proc"
  
  sfi_value_set_int (out_values++, BSE_MAX_NOTE);
  
  return BSE_ERROR_NONE;
}

/* --- get-max-tick --- */
static GType type_id_get_max_tick = 0;
static void
get_max_tick_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 660 "bsepart.proc"
 {
#line 662 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_int ("tick", "Tick", "Maximum Tick",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
}
#line 661 "bsepart.proc"
  proc->help = "Retrieve the maximum tick count represented in a part.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 667 "bsepart.proc"
 }
static BseErrorType
#line 667 "bsepart.proc"
get_max_tick_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 670 "bsepart.proc"
{
#line 671 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  
#line 674 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 678 "bsepart.proc"
  
  sfi_value_set_int (out_values++, BSE_PART_MAX_TICK);
  
  return BSE_ERROR_NONE;
}

/* --- select-notes-exclusive --- */
static GType type_id_select_notes_exclusive = 0;
static void
select_notes_exclusive_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 684 "bsepart.proc"
 {
#line 686 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Selection Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Selection Note", NULL,
				 SFI_PARAM_DEFAULT);
}
#line 685 "bsepart.proc"
  proc->help = "Select all notes within rectangle and deselect all others.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 697 "bsepart.proc"
 }
static BseErrorType
#line 697 "bsepart.proc"
select_notes_exclusive_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 700 "bsepart.proc"
{
#line 701 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  gint  min_note  = sfi_value_get_note (in_values++);
  gint  max_note  = sfi_value_get_note (in_values++);
  
#line 708 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_notes_exclusive (self, tick, duration, min_note, max_note);
  
  return BSE_ERROR_NONE;
}

/* --- select-controls-exclusive --- */
static GType type_id_select_controls_exclusive = 0;
static void
select_controls_exclusive_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 717 "bsepart.proc"
 {
#line 719 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_DEFAULT);
}
#line 718 "bsepart.proc"
  proc->help = "Select all control events within range and deselect all others.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 729 "bsepart.proc"
 }
static BseErrorType
#line 729 "bsepart.proc"
select_controls_exclusive_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 732 "bsepart.proc"
{
#line 733 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  guint ctype     = g_value_get_enum (in_values++);
  
#line 739 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_controls_exclusive (self, tick, duration, ctype);
  
  return BSE_ERROR_NONE;
}

/* --- select-notes --- */
static GType type_id_select_notes = 0;
static void
select_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 748 "bsepart.proc"
 {
#line 750 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Selection Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Selection Note", NULL,
				 SFI_PARAM_DEFAULT);
}
#line 749 "bsepart.proc"
  proc->help = "Select all notes within rectangle.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 761 "bsepart.proc"
 }
static BseErrorType
#line 761 "bsepart.proc"
select_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 764 "bsepart.proc"
{
#line 765 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  gint  min_note  = sfi_value_get_note (in_values++);
  gint  max_note  = sfi_value_get_note (in_values++);
  
#line 772 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_notes (self, tick, duration, min_note, max_note);
  
  return BSE_ERROR_NONE;
}

/* --- deselect-notes --- */
static GType type_id_deselect_notes = 0;
static void
deselect_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 781 "bsepart.proc"
 {
#line 783 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Selection Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Selection Note", NULL,
				 SFI_PARAM_DEFAULT);
}
#line 782 "bsepart.proc"
  proc->help = "Deselect all notes within rectangle.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 794 "bsepart.proc"
 }
static BseErrorType
#line 794 "bsepart.proc"
deselect_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 797 "bsepart.proc"
{
#line 798 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  gint  min_note  = sfi_value_get_note (in_values++);
  gint  max_note  = sfi_value_get_note (in_values++);
  
#line 805 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_deselect_notes (self, tick, duration, min_note, max_note);
  
  return BSE_ERROR_NONE;
}

/* --- deselect-controls --- */
static GType type_id_deselect_controls = 0;
static void
deselect_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 814 "bsepart.proc"
 {
#line 816 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_DEFAULT);
}
#line 815 "bsepart.proc"
  proc->help = "Deselect all controls within given range.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 826 "bsepart.proc"
 }
static BseErrorType
#line 826 "bsepart.proc"
deselect_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 829 "bsepart.proc"
{
#line 830 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  guint ctype     = g_value_get_enum (in_values++);
  
#line 836 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_deselect_controls (self, tick, duration, ctype);
  
  return BSE_ERROR_NONE;
}

/* --- select-event --- */
static GType type_id_select_event = 0;
static void
select_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 845 "bsepart.proc"
 {
#line 847 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_DEFAULT);
}
#line 846 "bsepart.proc"
  proc->help = "Select an existing event.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 852 "bsepart.proc"
 }
static BseErrorType
#line 852 "bsepart.proc"
select_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 855 "bsepart.proc"
{
#line 856 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  gboolean id_valid;
  
#line 861 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 865 "bsepart.proc"
  
  id_valid = bse_part_select_event (self, id);
  
  return id_valid ? BSE_ERROR_NONE : BSE_ERROR_PROC_PARAM_INVAL;
}

/* --- deselect-event --- */
static GType type_id_deselect_event = 0;
static void
deselect_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 871 "bsepart.proc"
 {
#line 873 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_DEFAULT);
}
#line 872 "bsepart.proc"
  proc->help = "Deselect an existing event.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 878 "bsepart.proc"
 }
static BseErrorType
#line 878 "bsepart.proc"
deselect_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 881 "bsepart.proc"
{
#line 882 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  gboolean id_valid;
  
#line 887 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 891 "bsepart.proc"
  
  id_valid = bse_part_deselect_event (self, id);
  
  return id_valid ? BSE_ERROR_NONE : BSE_ERROR_PROC_PARAM_INVAL;
}

/* --- get-timing --- */
static GType type_id_get_timing = 0;
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 897 "bsepart.proc"
 {
#line 899 "bsepart.proc"
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL, BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_DEFAULT);
#line 898 "bsepart.proc"
  proc->help = "Retrieve song timing information at a specific tick.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 902 "bsepart.proc"
}  }
static BseErrorType
#line 902 "bsepart.proc"
get_timing_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 905 "bsepart.proc"
{
#line 906 "bsepart.proc"
  
  BsePart *self = bse_value_get_object (in_values++);
  SfiInt   tick = sfi_value_get_int (in_values++);
  BseItem *parent;
  BseSongTiming timing = { 0, };

#line 912 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 916 "bsepart.proc"
  
  parent = BSE_ITEM (self)->parent;
  if (BSE_IS_SONG (parent))
    bse_song_get_timing (BSE_SONG (parent), tick, &timing);
  else
    bse_song_timing_get_default (&timing);

#line 923 "bsepart.proc"
  
  bse_value_set_boxed (out_values++, &timing);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_insert_note, "BsePart+insert-note", NULL, 0, insert_note_setup, insert_note_exec, NULL, "/Method/BsePart/General/Insert Note", { 0, }, },
  { &type_id_insert_control, "BsePart+insert-control", NULL, 0, insert_control_setup, insert_control_exec, NULL, "/Method/BsePart/General/Insert Control", { 0, }, },
  { &type_id_change_note, "BsePart+change-note", NULL, 0, change_note_setup, change_note_exec, NULL, "/Method/BsePart/General/Change Note", { 0, }, },
  { &type_id_change_control, "BsePart+change-control", NULL, 0, change_control_setup, change_control_exec, NULL, "/Method/BsePart/General/Change Control", { 0, }, },
  { &type_id_delete_event, "BsePart+delete-event", NULL, 0, delete_event_setup, delete_event_exec, NULL, "/Method/BsePart/General/Delete Event", { 0, }, },
  { &type_id_is_selected_event, "BsePart+is-selected-event", NULL, 0, is_selected_event_setup, is_selected_event_exec, NULL, "/Method/BsePart/General/Is Selected Event", { 0, }, },
  { &type_id_list_notes_crossing, "BsePart+list-notes-crossing", NULL, 0, list_notes_crossing_setup, list_notes_crossing_exec, NULL, "/Method/BsePart/General/List Notes Crossing", { 0, }, },
  { &type_id_list_controls, "BsePart+list-controls", NULL, 0, list_controls_setup, list_controls_exec, NULL, "/Method/BsePart/General/List Controls", { 0, }, },
  { &type_id_queue_notes, "BsePart+queue-notes", NULL, 0, queue_notes_setup, queue_notes_exec, NULL, "/Method/BsePart/General/Queue Notes", { 0, }, },
  { &type_id_queue_controls, "BsePart+queue-controls", NULL, 0, queue_controls_setup, queue_controls_exec, NULL, "/Method/BsePart/General/Queue Controls", { 0, }, },
  { &type_id_list_selected_notes, "BsePart+list-selected-notes", NULL, 0, list_selected_notes_setup, list_selected_notes_exec, NULL, "/Method/BsePart/General/List Selected Notes", { 0, }, },
  { &type_id_list_selected_controls, "BsePart+list-selected-controls", NULL, 0, list_selected_controls_setup, list_selected_controls_exec, NULL, "/Method/BsePart/General/List Selected Controls", { 0, }, },
  { &type_id_check_overlap, "BsePart+check-overlap", NULL, 0, check_overlap_setup, check_overlap_exec, NULL, "/Method/BsePart/General/Check Overlap", { 0, }, },
  { &type_id_get_notes, "BsePart+get-notes", NULL, 0, get_notes_setup, get_notes_exec, NULL, "/Method/BsePart/General/Get Notes", { 0, }, },
  { &type_id_get_controls, "BsePart+get-controls", NULL, 0, get_controls_setup, get_controls_exec, NULL, "/Method/BsePart/General/Get Controls", { 0, }, },
  { &type_id_get_min_note, "BsePart+get-min-note", NULL, 0, get_min_note_setup, get_min_note_exec, NULL, "/Method/BsePart/General/Get Min Note", { 0, }, },
  { &type_id_get_max_note, "BsePart+get-max-note", NULL, 0, get_max_note_setup, get_max_note_exec, NULL, "/Method/BsePart/General/Get Max Note", { 0, }, },
  { &type_id_get_max_tick, "BsePart+get-max-tick", NULL, 0, get_max_tick_setup, get_max_tick_exec, NULL, "/Method/BsePart/General/Get Max Tick", { 0, }, },
  { &type_id_select_notes_exclusive, "BsePart+select-notes-exclusive", NULL, 0, select_notes_exclusive_setup, select_notes_exclusive_exec, NULL, "/Method/BsePart/General/Select Notes Exclusive", { 0, }, },
  { &type_id_select_controls_exclusive, "BsePart+select-controls-exclusive", NULL, 0, select_controls_exclusive_setup, select_controls_exclusive_exec, NULL, "/Method/BsePart/General/Select Controls Exclusive", { 0, }, },
  { &type_id_select_notes, "BsePart+select-notes", NULL, 0, select_notes_setup, select_notes_exec, NULL, "/Method/BsePart/General/Select Notes", { 0, }, },
  { &type_id_deselect_notes, "BsePart+deselect-notes", NULL, 0, deselect_notes_setup, deselect_notes_exec, NULL, "/Method/BsePart/General/Deselect Notes", { 0, }, },
  { &type_id_deselect_controls, "BsePart+deselect-controls", NULL, 0, deselect_controls_setup, deselect_controls_exec, NULL, "/Method/BsePart/General/Deselect Controls", { 0, }, },
  { &type_id_select_event, "BsePart+select-event", NULL, 0, select_event_setup, select_event_exec, NULL, "/Method/BsePart/General/Select Event", { 0, }, },
  { &type_id_deselect_event, "BsePart+deselect-event", NULL, 0, deselect_event_setup, deselect_event_exec, NULL, "/Method/BsePart/General/Deselect Event", { 0, }, },
  { &type_id_get_timing, "BsePart+get-timing", NULL, 0, get_timing_setup, get_timing_exec, NULL, "/Method/BsePart/General/Get Timing", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
