
/*-------- begin ../sfi/bse-plugin-generator generated code --------*/



#include <bse/bsecxxplugin.h>

namespace Arts {

/* class prototypes */
class CompressorBase;
class Compressor;
class StereoCompressorBase;
class StereoCompressor;

/* choice/enum types */

/* classes */
class CompressorBase : public ::Bse::Effect {
#define ARTS_TYPE_COMPRESSOR (BSE_CXX_DECLARED_CLASS_TYPE (Compressor))
public:
  static inline const unsigned char* pixstream () { return NULL; }
  static inline const char* category  () { return "/Modules/Enhance/ArtsCompressor"; }
  static inline const char* blurb     () { return "ArtsCompressor compresses the sound."; }
  static inline const char* type_name () { return "ArtsCompressor"; }
public:
  enum {
    ICHANNEL_INVALUE,
    N_ICHANNELS
  };
  enum {
    OCHANNEL_OUTVALUE,
    N_OCHANNELS
  };
  /* "transport" structure to configure synthesis modules from properties */
  struct CompressorProperties {
    SfiReal attack;
    SfiReal release;
    SfiReal threshold;
    SfiReal ratio;
    SfiReal output;
    explicit CompressorProperties (CompressorBase *p) :
      attack (p->attack),
      release (p->release),
      threshold (p->threshold),
      ratio (p->ratio),
      output (p->output)
    {
    }
  };
protected:
  SfiReal attack;
  SfiReal release;
  SfiReal threshold;
  SfiReal ratio;
  SfiReal output;
protected:
  enum CompressorPropertyID {
    PROP_ATTACK = 1,
    PROP_RELEASE,
    PROP_THRESHOLD,
    PROP_RATIO,
    PROP_OUTPUT,
  };
public:
  void set_property (guint prop_id, const ::Bse::Value &value, GParamSpec *pspec)
  {
    switch (prop_id) {
    case PROP_ATTACK:
      attack = sfi_value_get_real (&value);
    break;
    case PROP_RELEASE:
      release = sfi_value_get_real (&value);
    break;
    case PROP_THRESHOLD:
      threshold = sfi_value_get_real (&value);
    break;
    case PROP_RATIO:
      ratio = sfi_value_get_real (&value);
    break;
    case PROP_OUTPUT:
      output = sfi_value_get_real (&value);
    break;
    };
    property_changed ((CompressorPropertyID) prop_id);
    update_modules();
    switch (prop_id) {
    default: ;
    };
  }
  void get_property (guint prop_id, ::Bse::Value &value, GParamSpec *pspec)
  {
    switch (prop_id) {
    case PROP_ATTACK:
      sfi_value_set_real (&value, attack);
    break;
    case PROP_RELEASE:
      sfi_value_set_real (&value, release);
    break;
    case PROP_THRESHOLD:
      sfi_value_set_real (&value, threshold);
    break;
    case PROP_RATIO:
      sfi_value_set_real (&value, ratio);
    break;
    case PROP_OUTPUT:
      sfi_value_set_real (&value, output);
    break;
    };
  }
private:
  static struct StaticData {
    int dummy;
  } static_data;
protected:
  virtual void property_changed (CompressorPropertyID) {}
  virtual ~CompressorBase ()
  {
  }
public:
  static void class_init (::Bse::CxxBaseClass *klass)
  {
    klass->add (PROP_ATTACK, sfidl_pspec_Real ("Parameters","attack","Attack [ms]" , "Set the attack time in milli seconds" , 10 , 0.10000000000000001 , 250 , 10 , ":r:w:G:S:" ":scale"));
    klass->add (PROP_RELEASE, sfidl_pspec_Real ("Parameters","release","Release [ms]" , "Set the release time in milli seconds" , 10 , 0.10000000000000001 , 250 , 10 , ":r:w:G:S:" ":scale"));
    klass->add (PROP_THRESHOLD, sfidl_pspec_LogScale ("Parameters","threshold","Threshold" , "Set the threshold" , 1 , 1.0000000000000001e-05 , 1 , 0.001 , pow ( 2 , - 8 ) , 2 , 8 , ":r:w:G:S:"));
    klass->add (PROP_RATIO, sfidl_pspec_Real ("Parameters","ratio","Ratio" , "Set the compression ratio" , 0.80000000000000004 , 0 , 1 , 0.10000000000000001 , ":r:w:G:S:" ":scale"));
    klass->add (PROP_OUTPUT, sfidl_pspec_LogScale ("Parameters","output","Output" , "Set the output amplification" , 1 , 0.10000000000000001 , 10 , 1 , pow ( 2 , 0 ) , 2 , log ( 10 ) / log ( 2 ) , ":r:w:G:S:"));
    klass->add_ichannel ("Audio In", "Audio input", ICHANNEL_INVALUE);
    klass->add_ochannel ("Audio Out", "Compressed audio output", OCHANNEL_OUTVALUE);
  }
};
BSE_CXX_DECLARE_CLASS (Compressor);
class StereoCompressorBase : public ::Bse::Effect {
#define ARTS_TYPE_STEREO_COMPRESSOR (BSE_CXX_DECLARED_CLASS_TYPE (StereoCompressor))
public:
  static inline const unsigned char* pixstream () { return NULL; }
  static inline const char* category  () { return "/Modules/Enhance/ArtsStereoCompressor"; }
  static inline const char* blurb     () { return "ArtsStereoCompressor compresses the sound."; }
  static inline const char* type_name () { return "ArtsStereoCompressor"; }
public:
  enum {
    ICHANNEL_INLEFT,
    ICHANNEL_INRIGHT,
    N_ICHANNELS
  };
  enum {
    OCHANNEL_OUTLEFT,
    OCHANNEL_OUTRIGHT,
    N_OCHANNELS
  };
  /* "transport" structure to configure synthesis modules from properties */
  struct StereoCompressorProperties {
    SfiReal attack;
    SfiReal release;
    SfiReal threshold;
    SfiReal ratio;
    SfiReal output;
    explicit StereoCompressorProperties (StereoCompressorBase *p) :
      attack (p->attack),
      release (p->release),
      threshold (p->threshold),
      ratio (p->ratio),
      output (p->output)
    {
    }
  };
protected:
  SfiReal attack;
  SfiReal release;
  SfiReal threshold;
  SfiReal ratio;
  SfiReal output;
protected:
  enum StereoCompressorPropertyID {
    PROP_ATTACK = 1,
    PROP_RELEASE,
    PROP_THRESHOLD,
    PROP_RATIO,
    PROP_OUTPUT,
  };
public:
  void set_property (guint prop_id, const ::Bse::Value &value, GParamSpec *pspec)
  {
    switch (prop_id) {
    case PROP_ATTACK:
      attack = sfi_value_get_real (&value);
    break;
    case PROP_RELEASE:
      release = sfi_value_get_real (&value);
    break;
    case PROP_THRESHOLD:
      threshold = sfi_value_get_real (&value);
    break;
    case PROP_RATIO:
      ratio = sfi_value_get_real (&value);
    break;
    case PROP_OUTPUT:
      output = sfi_value_get_real (&value);
    break;
    };
    property_changed ((StereoCompressorPropertyID) prop_id);
    update_modules();
    switch (prop_id) {
    default: ;
    };
  }
  void get_property (guint prop_id, ::Bse::Value &value, GParamSpec *pspec)
  {
    switch (prop_id) {
    case PROP_ATTACK:
      sfi_value_set_real (&value, attack);
    break;
    case PROP_RELEASE:
      sfi_value_set_real (&value, release);
    break;
    case PROP_THRESHOLD:
      sfi_value_set_real (&value, threshold);
    break;
    case PROP_RATIO:
      sfi_value_set_real (&value, ratio);
    break;
    case PROP_OUTPUT:
      sfi_value_set_real (&value, output);
    break;
    };
  }
private:
  static struct StaticData {
    int dummy;
  } static_data;
protected:
  virtual void property_changed (StereoCompressorPropertyID) {}
  virtual ~StereoCompressorBase ()
  {
  }
public:
  static void class_init (::Bse::CxxBaseClass *klass)
  {
    klass->add (PROP_ATTACK, sfidl_pspec_Real ("Parameters","attack","Attack [ms]" , "Set the attack time in milli seconds" , 10 , 0.10000000000000001 , 250 , 10 , ":r:w:G:S:" ":scale"));
    klass->add (PROP_RELEASE, sfidl_pspec_Real ("Parameters","release","Release [ms]" , "Set the release time in milli seconds" , 10 , 0.10000000000000001 , 250 , 10 , ":r:w:G:S:" ":scale"));
    klass->add (PROP_THRESHOLD, sfidl_pspec_LogScale ("Parameters","threshold","Threshold" , "Set the threshold" , 1 , 1.0000000000000001e-05 , 1 , 0.001 , pow ( 2 , - 8 ) , 2 , 8 , ":r:w:G:S:"));
    klass->add (PROP_RATIO, sfidl_pspec_Real ("Parameters","ratio","Ratio" , "Set the compression ratio" , 0.80000000000000004 , 0 , 1 , 0.10000000000000001 , ":r:w:G:S:" ":scale"));
    klass->add (PROP_OUTPUT, sfidl_pspec_LogScale ("Parameters","output","Output" , "Set the output amplification" , 1 , 0.10000000000000001 , 10 , 1 , pow ( 2 , 0 ) , 2 , log ( 10 ) / log ( 2 ) , ":r:w:G:S:"));
    klass->add_ichannel ("Left Audio In", "Left audio input", ICHANNEL_INLEFT);
    klass->add_ichannel ("Right Audio In", "Right audio input", ICHANNEL_INRIGHT);
    klass->add_ochannel ("Left Audio Out", "Compressed left audio output", OCHANNEL_OUTLEFT);
    klass->add_ochannel ("Right Audio Out", "Compressed right audio output", OCHANNEL_OUTRIGHT);
  }
};
BSE_CXX_DECLARE_CLASS (StereoCompressor);



}; /* Arts */


/*-------- end ../sfi/bse-plugin-generator generated code --------*/


