
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsesource.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsesource.h>


#line 26 "bsesource.proc"


/* --- set-input-by-id --- */
static GType type_id_set_input_by_id = 0;
static void
set_input_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 28 "bsesource.proc"
 {
#line 30 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("imodule", "Input Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Output Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
}
#line 29 "bsesource.proc"
  proc->help = "Connect a module input to another module's output.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 42 "bsesource.proc"
 }
static BseErrorType
#line 42 "bsesource.proc"
set_input_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 45 "bsesource.proc"
{
#line 46 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  guint ichannel     = sfi_value_get_int (in_values++);
  BseSource *osource = bse_value_get_object (in_values++);
  guint ochannel     = sfi_value_get_int (in_values++);
  BseErrorType error;
  
#line 53 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 58 "bsesource.proc"
  
  error = bse_source_set_input (isource, ichannel, osource, ochannel);
  
#line 61 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- set-input --- */
static GType type_id_set_input = 0;
static void
set_input_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 67 "bsesource.proc"
 {
#line 69 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("imodule", "Input Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("input-channel", "Input Channel", NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("output-channel", "Output Channel", NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
}
#line 68 "bsesource.proc"
  proc->help = "Connect a module input to another module's output.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 81 "bsesource.proc"
 }
static BseErrorType
#line 81 "bsesource.proc"
set_input_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 84 "bsesource.proc"
{
#line 85 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  gchar *ichannel    = sfi_value_get_string (in_values++);
  BseSource *osource = bse_value_get_object (in_values++);
  gchar *ochannel    = sfi_value_get_string (in_values++);
  BseErrorType error;
  
#line 92 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent ||
      !ichannel || !ochannel)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 98 "bsesource.proc"
  
  error = bse_source_set_input (isource, bse_source_find_ichannel (isource, ichannel),
				osource, bse_source_find_ochannel (osource, ochannel));
  
#line 102 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- unset-input-by-id --- */
static GType type_id_unset_input_by_id = 0;
static void
unset_input_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 108 "bsesource.proc"
 {
#line 110 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Output Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
}
#line 109 "bsesource.proc"
  proc->help = "Disconnect a module input.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 122 "bsesource.proc"
 }
static BseErrorType
#line 122 "bsesource.proc"
unset_input_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 125 "bsesource.proc"
{
#line 126 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  guint ichannel     = sfi_value_get_int (in_values++);
  BseSource *osource = bse_value_get_object (in_values++);
  guint ochannel     = sfi_value_get_int (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 133 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 138 "bsesource.proc"
  
  error = bse_source_unset_input (isource, ichannel, osource, ochannel);
  
#line 141 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- unset-input --- */
static GType type_id_unset_input = 0;
static void
unset_input_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 147 "bsesource.proc"
 {
#line 149 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("input-channel", "Input Channel", NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("output-channel", "Output Channel", NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
}
#line 148 "bsesource.proc"
  proc->help = "Disconnect a module input.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 161 "bsesource.proc"
 }
static BseErrorType
#line 161 "bsesource.proc"
unset_input_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 164 "bsesource.proc"
{
#line 165 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  gchar *ichannel    = sfi_value_get_string (in_values++);
  BseSource *osource = bse_value_get_object (in_values++);
  gchar *ochannel    = sfi_value_get_string (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 172 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent ||
      !ichannel || !ochannel)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 178 "bsesource.proc"
  
  error = bse_source_unset_input (isource, bse_source_find_ichannel (isource, ichannel),
				  osource, bse_source_find_ochannel (osource, ochannel));
  
#line 182 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- clear-inputs --- */
static GType type_id_clear_inputs = 0;
static void
clear_inputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 188 "bsesource.proc"
 {
#line 190 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
}
#line 189 "bsesource.proc"
  proc->help = "Disconnect all module inputs.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 193 "bsesource.proc"
 }
static BseErrorType
#line 193 "bsesource.proc"
clear_inputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 196 "bsesource.proc"
{
#line 197 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  
#line 200 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 204 "bsesource.proc"
  
  bse_source_clear_ichannels (isource);
  
  return BSE_ERROR_NONE;
}

/* --- clear-outputs --- */
static GType type_id_clear_outputs = 0;
static void
clear_outputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 210 "bsesource.proc"
 {
#line 212 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
}
#line 211 "bsesource.proc"
  proc->help = "Disconnect all module outputs.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 215 "bsesource.proc"
 }
static BseErrorType
#line 215 "bsesource.proc"
clear_outputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 218 "bsesource.proc"
{
#line 219 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  
#line 222 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 226 "bsesource.proc"
  
  bse_source_clear_ochannels (isource);
  
  return BSE_ERROR_NONE;
}

/* --- has-outputs --- */
static GType type_id_has_outputs = 0;
static void
has_outputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 232 "bsesource.proc"
 {
#line 234 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_bool ("has_outputs", "Has Outputs", NULL,
			  FALSE, SFI_PARAM_DEFAULT);
}
#line 233 "bsesource.proc"
  proc->help = "Check whether a module has output channel connections.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 239 "bsesource.proc"
 }
static BseErrorType
#line 239 "bsesource.proc"
has_outputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 242 "bsesource.proc"
{
#line 243 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  
#line 246 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 250 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, source->outputs != NULL);
  
  return BSE_ERROR_NONE;
}

/* --- n-ichannels --- */
static GType type_id_n_ichannels = 0;
static void
n_ichannels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 256 "bsesource.proc"
 {
#line 258 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_int ("n_channels", "Number of Channels", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
}
#line 257 "bsesource.proc"
  proc->help = "Get the number of input channels of a module.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 263 "bsesource.proc"
 }
static BseErrorType
#line 263 "bsesource.proc"
n_ichannels_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 266 "bsesource.proc"
{
#line 267 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  
#line 270 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 274 "bsesource.proc"
  
  sfi_value_set_int (out_values++, BSE_SOURCE_N_ICHANNELS (source));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-name --- */
static GType type_id_ichannel_name = 0;
static void
ichannel_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 280 "bsesource.proc"
 {
#line 282 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_string ("channel_name", "Channel Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 281 "bsesource.proc"
  proc->help = "Get input channel name.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 289 "bsesource.proc"
 }
static BseErrorType
#line 289 "bsesource.proc"
ichannel_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 292 "bsesource.proc"
{
#line 293 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 297 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 301 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_NAME (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-ident --- */
static GType type_id_ichannel_ident = 0;
static void
ichannel_ident_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 307 "bsesource.proc"
 {
#line 309 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_string ("channel_name", "Channel Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 308 "bsesource.proc"
  proc->help = "Get canonical input channel name.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 316 "bsesource.proc"
 }
static BseErrorType
#line 316 "bsesource.proc"
ichannel_ident_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 319 "bsesource.proc"
{
#line 320 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 324 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 328 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_IDENT (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-blurb --- */
static GType type_id_ichannel_blurb = 0;
static void
ichannel_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 334 "bsesource.proc"
 {
#line 336 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_string ("channel_blurb", "Channel Blurb", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 335 "bsesource.proc"
  proc->help = "Get input channel description.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 343 "bsesource.proc"
 }
static BseErrorType
#line 343 "bsesource.proc"
ichannel_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 346 "bsesource.proc"
{
#line 347 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 351 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 355 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_BLURB (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- is-joint-ichannel-by-id --- */
static GType type_id_is_joint_ichannel_by_id = 0;
static void
is_joint_ichannel_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 361 "bsesource.proc"
 {
#line 363 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_bool ("is_jchannel", "Is Joint Channel", NULL,
			  FALSE, SFI_PARAM_DEFAULT);
}
#line 362 "bsesource.proc"
  proc->help = "Check if an input channel is a joint (multi-connect) channel.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 370 "bsesource.proc"
 }
static BseErrorType
#line 370 "bsesource.proc"
is_joint_ichannel_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 373 "bsesource.proc"
{
#line 374 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 378 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 382 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- is-joint-ichannel --- */
static GType type_id_is_joint_ichannel = 0;
static void
is_joint_ichannel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 388 "bsesource.proc"
 {
#line 390 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("input-channel", "Input Channel", NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_bool ("is_jchannel", "Is Joint Channel", NULL,
			  FALSE, SFI_PARAM_DEFAULT);
}
#line 389 "bsesource.proc"
  proc->help = "Check if an input channel is a joint (multi-connect) channel.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 397 "bsesource.proc"
 }
static BseErrorType
#line 397 "bsesource.proc"
is_joint_ichannel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 400 "bsesource.proc"
{
#line 401 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  gchar *ichannel   = sfi_value_get_string (in_values++);
  guint id;
  
#line 406 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !ichannel)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 410 "bsesource.proc"
  
  id = bse_source_find_ichannel (source, ichannel);
  sfi_value_set_bool (out_values++,
		      id < BSE_SOURCE_N_ICHANNELS (source) ? BSE_SOURCE_IS_JOINT_ICHANNEL (source, id) : FALSE);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-n-joints --- */
static GType type_id_ichannel_get_n_joints = 0;
static void
ichannel_get_n_joints_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 418 "bsesource.proc"
 {
#line 420 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_int ("n_joints", "Number of Connections", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
}
#line 419 "bsesource.proc"
  proc->help = "Retrieve the number of inputs connected to an input channel.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 427 "bsesource.proc"
 }
static BseErrorType
#line 427 "bsesource.proc"
ichannel_get_n_joints_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 430 "bsesource.proc"
{
#line 431 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  BseSourceInput *input;
  
#line 436 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 440 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel))
    sfi_value_set_int (out_values++, input->jdata.n_joints);
  else
    sfi_value_set_int (out_values++, input->idata.osource ? 1 : 0);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-osource --- */
static GType type_id_ichannel_get_osource = 0;
static void
ichannel_get_osource_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 450 "bsesource.proc"
 {
#line 452 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("input-joint", "Input Joint", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("osource", "Output Source", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
}
#line 451 "bsesource.proc"
  proc->help = "Retrieve output module connected to a specific joint of an input channel";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 461 "bsesource.proc"
 }
static BseErrorType
#line 461 "bsesource.proc"
ichannel_get_osource_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 464 "bsesource.proc"
{
#line 465 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  guint joint       = sfi_value_get_int (in_values++);
  BseSourceInput *input;
  
#line 471 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 475 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel) && joint < input->jdata.n_joints)
    bse_value_set_object (out_values++, input->jdata.joints[joint].osource);
  else if (joint < 1)
    bse_value_set_object (out_values++, input->idata.osource);
  else
    bse_value_set_object (out_values++, NULL);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-ochannel --- */
static GType type_id_ichannel_get_ochannel = 0;
static void
ichannel_get_ochannel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 487 "bsesource.proc"
 {
#line 489 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("input-joint", "Input Joint", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_int ("ochannel", "Output Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
}
#line 488 "bsesource.proc"
  proc->help = "Retrieve output channel of the module connected to a specific joint of an input channel.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 498 "bsesource.proc"
 }
static BseErrorType
#line 498 "bsesource.proc"
ichannel_get_ochannel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 501 "bsesource.proc"
{
#line 502 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  guint joint       = sfi_value_get_int (in_values++);
  BseSourceInput *input;
  
#line 508 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 512 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel) && joint < input->jdata.n_joints)
    sfi_value_set_int (out_values++, input->jdata.joints[joint].ochannel);
  else if (joint < 1)
    sfi_value_set_int (out_values++, input->idata.ochannel);
  else
    sfi_value_set_int (out_values++, G_MAXINT);
  
  return BSE_ERROR_NONE;
}

/* --- n-ochannels --- */
static GType type_id_n_ochannels = 0;
static void
n_ochannels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 524 "bsesource.proc"
 {
#line 526 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_int ("n_channels", "Number of Channels", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
}
#line 525 "bsesource.proc"
  proc->help = "Get the number of output channels of a module.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 531 "bsesource.proc"
 }
static BseErrorType
#line 531 "bsesource.proc"
n_ochannels_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 534 "bsesource.proc"
{
#line 535 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  
#line 538 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 542 "bsesource.proc"
  
  sfi_value_set_int (out_values++, BSE_SOURCE_N_OCHANNELS (source));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-name --- */
static GType type_id_ochannel_name = 0;
static void
ochannel_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 548 "bsesource.proc"
 {
#line 550 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_string ("channel_name", "Channel Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 549 "bsesource.proc"
  proc->help = "Get output channel name.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 557 "bsesource.proc"
 }
static BseErrorType
#line 557 "bsesource.proc"
ochannel_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 560 "bsesource.proc"
{
#line 561 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
  
#line 565 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 569 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_NAME (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-ident --- */
static GType type_id_ochannel_ident = 0;
static void
ochannel_ident_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 575 "bsesource.proc"
 {
#line 577 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_string ("channel_name", "Channel Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 576 "bsesource.proc"
  proc->help = "Get canonical output channel name.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 584 "bsesource.proc"
 }
static BseErrorType
#line 584 "bsesource.proc"
ochannel_ident_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 587 "bsesource.proc"
{
#line 588 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
  
#line 592 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 596 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_IDENT (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-blurb --- */
static GType type_id_ochannel_blurb = 0;
static void
ochannel_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 602 "bsesource.proc"
 {
#line 604 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_string ("channel_blurb", "Channel Blurb", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 603 "bsesource.proc"
  proc->help = "Get output channel description.";
#line 24 "bsesource.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Copyright (C) 2001-2003 Tim Janik";
#line 611 "bsesource.proc"
 }
static BseErrorType
#line 611 "bsesource.proc"
ochannel_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 614 "bsesource.proc"
{
#line 615 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
  
#line 619 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 623 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_BLURB (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_set_input_by_id, "BseSource+set-input-by-id", NULL, 0, set_input_by_id_setup, set_input_by_id_exec, NULL, "/Method/BseSource/General/Set Input By Id", { 0, }, },
  { &type_id_set_input, "BseSource+set-input", NULL, 0, set_input_setup, set_input_exec, NULL, "/Method/BseSource/General/Set Input", { 0, }, },
  { &type_id_unset_input_by_id, "BseSource+unset-input-by-id", NULL, 0, unset_input_by_id_setup, unset_input_by_id_exec, NULL, "/Method/BseSource/General/Unset Input By Id", { 0, }, },
  { &type_id_unset_input, "BseSource+unset-input", NULL, 0, unset_input_setup, unset_input_exec, NULL, "/Method/BseSource/General/Unset Input", { 0, }, },
  { &type_id_clear_inputs, "BseSource+clear-inputs", NULL, 0, clear_inputs_setup, clear_inputs_exec, NULL, "/Method/BseSource/General/Clear Inputs", { 0, }, },
  { &type_id_clear_outputs, "BseSource+clear-outputs", NULL, 0, clear_outputs_setup, clear_outputs_exec, NULL, "/Method/BseSource/General/Clear Outputs", { 0, }, },
  { &type_id_has_outputs, "BseSource+has-outputs", NULL, 0, has_outputs_setup, has_outputs_exec, NULL, "/Method/BseSource/General/Has Outputs", { 0, }, },
  { &type_id_n_ichannels, "BseSource+n-ichannels", NULL, 0, n_ichannels_setup, n_ichannels_exec, NULL, "/Method/BseSource/General/N Ichannels", { 0, }, },
  { &type_id_ichannel_name, "BseSource+ichannel-name", NULL, 0, ichannel_name_setup, ichannel_name_exec, NULL, "/Method/BseSource/General/Ichannel Name", { 0, }, },
  { &type_id_ichannel_ident, "BseSource+ichannel-ident", NULL, 0, ichannel_ident_setup, ichannel_ident_exec, NULL, "/Method/BseSource/General/Ichannel Ident", { 0, }, },
  { &type_id_ichannel_blurb, "BseSource+ichannel-blurb", NULL, 0, ichannel_blurb_setup, ichannel_blurb_exec, NULL, "/Method/BseSource/General/Ichannel Blurb", { 0, }, },
  { &type_id_is_joint_ichannel_by_id, "BseSource+is-joint-ichannel-by-id", NULL, 0, is_joint_ichannel_by_id_setup, is_joint_ichannel_by_id_exec, NULL, "/Method/BseSource/General/Is Joint Ichannel By Id", { 0, }, },
  { &type_id_is_joint_ichannel, "BseSource+is-joint-ichannel", NULL, 0, is_joint_ichannel_setup, is_joint_ichannel_exec, NULL, "/Method/BseSource/General/Is Joint Ichannel", { 0, }, },
  { &type_id_ichannel_get_n_joints, "BseSource+ichannel-get-n-joints", NULL, 0, ichannel_get_n_joints_setup, ichannel_get_n_joints_exec, NULL, "/Method/BseSource/General/Ichannel Get N Joints", { 0, }, },
  { &type_id_ichannel_get_osource, "BseSource+ichannel-get-osource", NULL, 0, ichannel_get_osource_setup, ichannel_get_osource_exec, NULL, "/Method/BseSource/General/Ichannel Get Osource", { 0, }, },
  { &type_id_ichannel_get_ochannel, "BseSource+ichannel-get-ochannel", NULL, 0, ichannel_get_ochannel_setup, ichannel_get_ochannel_exec, NULL, "/Method/BseSource/General/Ichannel Get Ochannel", { 0, }, },
  { &type_id_n_ochannels, "BseSource+n-ochannels", NULL, 0, n_ochannels_setup, n_ochannels_exec, NULL, "/Method/BseSource/General/N Ochannels", { 0, }, },
  { &type_id_ochannel_name, "BseSource+ochannel-name", NULL, 0, ochannel_name_setup, ochannel_name_exec, NULL, "/Method/BseSource/General/Ochannel Name", { 0, }, },
  { &type_id_ochannel_ident, "BseSource+ochannel-ident", NULL, 0, ochannel_ident_setup, ochannel_ident_exec, NULL, "/Method/BseSource/General/Ochannel Ident", { 0, }, },
  { &type_id_ochannel_blurb, "BseSource+ochannel-blurb", NULL, 0, ochannel_blurb_setup, ochannel_blurb_exec, NULL, "/Method/BseSource/General/Ochannel Blurb", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
