
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseproject.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bseproject.h>
#include        <bse/bsestorage.h>
#include        <bse/bsesong.h>
#include        <bse/bsewaverepo.h>
#include        <bse/bsesnet.h>
#include        <bse/bsemidisynth.h>
#include        <bse/bsedatapocket.h>


#line 31 "bseproject.proc"


/* --- is-playing --- */
static GType type_id_is_playing = 0;
static void
is_playing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 33 "bseproject.proc"
 {
#line 35 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_bool ("is_playing", "Is Playing", "Whether the project is currently producing sound",
			  FALSE, SFI_PARAM_DEFAULT);
#line 34 "bseproject.proc"
  proc->help = "Check whether a project is currently playing";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 39 "bseproject.proc"
}  }
static BseErrorType
#line 39 "bseproject.proc"
is_playing_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 42 "bseproject.proc"
{
#line 43 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 46 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 50 "bseproject.proc"
  
  
#line 52 "bseproject.proc"
  
  sfi_value_set_bool (out_values++, BSE_SOURCE_PREPARED (project));
  
  return BSE_ERROR_NONE;
}

/* --- restore-from-file --- */
static GType type_id_restore_from_file = 0;
static void
restore_from_file_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 58 "bseproject.proc"
 {
#line 60 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("file-name", "File", "Source file name",
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_enum ("error", "Error", "Error indicating possible failures",
			       BSE_ERROR_NONE, BSE_TYPE_ERROR_TYPE,
			       SFI_PARAM_DEFAULT);
#line 59 "bseproject.proc"
  proc->help = "Load a project from file";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 67 "bseproject.proc"
}  }
static BseErrorType
#line 67 "bseproject.proc"
restore_from_file_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 70 "bseproject.proc"
{
#line 71 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *file_name = sfi_value_get_string (in_values++);
  BseStorage *storage;
  BseErrorType error;
  
#line 77 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 81 "bseproject.proc"
  
  storage = g_object_new (BSE_TYPE_STORAGE, NULL);

  error = bse_storage_input_file (storage, file_name);
  if (!error)
    {
      // bse_storage_set_upath_resolver (storage, bse_project_upath_resolver, project);
      error = bse_project_restore (project, storage);
    }
  bse_storage_reset (storage);
  g_object_unref (storage);
  
#line 93 "bseproject.proc"
  
  bse_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- store-bse --- */
static GType type_id_store_bse = 0;
static void
store_bse_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 99 "bseproject.proc"
 {
#line 101 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("file-name", "File", "Destination file name",
			    NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_bool ("self-contained", "Self Contained",
			  "Whether references to other objects (e.g. samples) should "
			  "be stored or whether to include everything in a self-contained .bse file",
			  FALSE, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_genum ("error", "Error", "Error indicating possible failures",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
#line 100 "bseproject.proc"
  proc->help = "Save a project into a BSE file";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 112 "bseproject.proc"
}  }
static BseErrorType
#line 112 "bseproject.proc"
store_bse_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 115 "bseproject.proc"
{
#line 116 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *file_name = sfi_value_get_string (in_values++);
  gboolean self_contained = sfi_value_get_bool (in_values++);
  BseErrorType error;
  
#line 122 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  error = bse_project_store_bse (project, file_name, self_contained);
  
#line 128 "bseproject.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- create-song --- */
static GType type_id_create_song = 0;
static void
create_song_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 134 "bseproject.proc"
 {
#line 136 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "Song name",
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("song", "Song", "The new song",
				 BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 142 "bseproject.proc"
}  }
static BseErrorType
#line 142 "bseproject.proc"
create_song_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 145 "bseproject.proc"
{
#line 146 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *name         = sfi_value_get_string (in_values++);
  BseSong *song;
  
#line 151 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 155 "bseproject.proc"
  
  song = g_object_new (BSE_TYPE_SONG,
		       name ? "uname" : NULL, name,
		       NULL);
  bse_container_add_item (BSE_CONTAINER (project), BSE_ITEM (song));
  
#line 161 "bseproject.proc"
  
  bse_value_set_object (out_values++, G_OBJECT (song));
  g_object_unref (song);
  
  return BSE_ERROR_NONE;
}

/* --- ensure-wave-repo --- */
static GType type_id_ensure_wave_repo = 0;
static void
ensure_wave_repo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 168 "bseproject.proc"
 {
#line 170 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("wrepo", "Wave Repo", "The project's unique wave repo",
				 BSE_TYPE_WAVE_REPO, SFI_PARAM_DEFAULT);
#line 169 "bseproject.proc"
  proc->help = "Ensure the project has a wave repository";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 174 "bseproject.proc"
}  }
static BseErrorType
#line 174 "bseproject.proc"
ensure_wave_repo_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 177 "bseproject.proc"
{
#line 178 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  BseWaveRepo *wrepo = NULL;
  
#line 182 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 186 "bseproject.proc"
  
  wrepo = bse_project_get_wave_repo (project);
  if (!wrepo)
    {
      wrepo = g_object_new (BSE_TYPE_WAVE_REPO, NULL);
      bse_container_add_item (BSE_CONTAINER (project), BSE_ITEM (wrepo));
      g_object_unref (wrepo);
    }
  
#line 195 "bseproject.proc"
  
  bse_value_set_object (out_values++, G_OBJECT (wrepo));
  
  return BSE_ERROR_NONE;
}

/* --- get-data-pocket --- */
static GType type_id_get_data_pocket = 0;
static void
get_data_pocket_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 201 "bseproject.proc"
 {
#line 203 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name of the data pocket",
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_DEFAULT);
#line 202 "bseproject.proc"
  proc->help = "Retrieve a specifically named data pocket for this project";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 209 "bseproject.proc"
}  }
static BseErrorType
#line 209 "bseproject.proc"
get_data_pocket_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 212 "bseproject.proc"
{
#line 213 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *name = sfi_value_get_string (in_values++);
  BseItem *item;
  
#line 218 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 222 "bseproject.proc"
  
  item = bse_project_lookup_typed_item (project, BSE_TYPE_DATA_POCKET, name);
  if (!item)
    {
      item = g_object_new (BSE_TYPE_DATA_POCKET, "uname", name, NULL);
      bse_container_add_item (BSE_CONTAINER (project), item);
      g_object_unref (item);
    }
  
#line 231 "bseproject.proc"
  
  bse_value_set_object (out_values++, item);
  
  return BSE_ERROR_NONE;
}

/* --- create-snet --- */
static GType type_id_create_snet = 0;
static void
create_snet_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 237 "bseproject.proc"
 {
#line 239 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "Synth network name",
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("snet", "Synthesizer Network", "New synth network",
				 BSE_TYPE_SNET, SFI_PARAM_DEFAULT);
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 245 "bseproject.proc"
}  }
static BseErrorType
#line 245 "bseproject.proc"
create_snet_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 248 "bseproject.proc"
{
#line 249 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *name         = sfi_value_get_string (in_values++);
  BseSNet *snet;
  
#line 254 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 258 "bseproject.proc"
  
  snet = g_object_new (BSE_TYPE_SNET,
		       name ? "uname" : NULL, name,
		       NULL);
  bse_container_add_item (BSE_CONTAINER (project), BSE_ITEM (snet));
  
#line 264 "bseproject.proc"
  
  bse_value_set_object (out_values++, G_OBJECT (snet));
  g_object_unref (snet);
  
  return BSE_ERROR_NONE;
}

/* --- create-midi-synth --- */
static GType type_id_create_midi_synth = 0;
static void
create_midi_synth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 271 "bseproject.proc"
 {
#line 273 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "MIDI synth name",
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("midi_synth", "MIDI Synthesizer", "New MIDI synth",
				 BSE_TYPE_MIDI_SYNTH, SFI_PARAM_DEFAULT);
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 279 "bseproject.proc"
}  }
static BseErrorType
#line 279 "bseproject.proc"
create_midi_synth_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 282 "bseproject.proc"
{
#line 283 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *name         = sfi_value_get_string (in_values++);
  BseMidiSynth *midi_synth;
  
#line 288 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 292 "bseproject.proc"
  
  midi_synth = g_object_new (BSE_TYPE_MIDI_SYNTH,
			     name ? "uname" : NULL, name,
			     NULL);
  bse_container_add_item (BSE_CONTAINER (project), BSE_ITEM (midi_synth));
  
#line 298 "bseproject.proc"
  
  bse_value_set_object (out_values++, G_OBJECT (midi_synth));
  g_object_unref (midi_synth);
  
  return BSE_ERROR_NONE;
}

/* --- list-uname-paths --- */
static GType type_id_list_uname_paths = 0;
static void
list_uname_paths_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 305 "bseproject.proc"
 {
#line 308 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("item_type", NULL, NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("uname_paths", "Uname Paths", NULL, BSE_TYPE_STRING_SEQ, SFI_PARAM_DEFAULT);
#line 306 "bseproject.proc"
  proc->help = ("List uname paths for all items of a specified type within this project. "
	   "By their uname paths, items are uniquely identifyable within a project.");
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 313 "bseproject.proc"
}  }
static BseErrorType
#line 313 "bseproject.proc"
list_uname_paths_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 316 "bseproject.proc"
{
#line 317 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  const gchar *tname  = sfi_value_get_string (in_values++);
  GType type          = tname ? g_type_from_name (tname) : 0;
  
#line 322 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !g_type_is_a (type, BSE_TYPE_ITEM))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 326 "bseproject.proc"
  
  bse_value_take_boxed (out_values++, bse_project_list_upaths (project, type));
  
  return BSE_ERROR_NONE;
}

/* --- find-item --- */
static GType type_id_find_item = 0;
static void
find_item_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 332 "bseproject.proc"
 {
#line 334 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("uname_path", NULL, NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 333 "bseproject.proc"
  proc->help = "Find an item within a project, given its uname path.";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 340 "bseproject.proc"
}  }
static BseErrorType
#line 340 "bseproject.proc"
find_item_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 343 "bseproject.proc"
{
#line 344 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  const gchar *string = sfi_value_get_string (in_values++);
  
#line 348 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !string)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 352 "bseproject.proc"
  
  bse_value_set_object (out_values++, bse_container_resolve_upath (BSE_CONTAINER (project), string));
  
  return BSE_ERROR_NONE;
}

/* --- match-items-by-uname --- */
static GType type_id_match_items_by_uname = 0;
static void
match_items_by_uname_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 358 "bseproject.proc"
 {
#line 360 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("item_type", NULL, NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("uname", NULL, NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("item_list", "Item List", NULL, BSE_TYPE_PROXY_SEQ, SFI_PARAM_DEFAULT);
#line 359 "bseproject.proc"
  proc->help = "Retrieve all items of a specific type within a project with matching uname";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 367 "bseproject.proc"
}  }
static BseErrorType
#line 367 "bseproject.proc"
match_items_by_uname_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 370 "bseproject.proc"
{
#line 371 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  const gchar *tname  = sfi_value_get_string (in_values++);
  const gchar *string = sfi_value_get_string (in_values++);
  GType type          = tname ? g_type_from_name (tname) : 0;
  GList *list, *free_list;
  BseProxySeq *pseq;
  
#line 379 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !string || !g_type_is_a (type, BSE_TYPE_ITEM))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 383 "bseproject.proc"
  
  pseq = bse_proxy_seq_new ();
  free_list = bse_objects_list_by_uname (type, string);
  for (list = free_list; list; list = list->next)
    if (bse_item_get_project (list->data) == project)
      {
	bse_proxy_seq_append (pseq, BSE_OBJECT_ID (list->data));
	break;
      }
  g_list_free (free_list);
  
#line 394 "bseproject.proc"
  
  bse_value_take_boxed (out_values++, pseq);
  
  return BSE_ERROR_NONE;
}

/* --- get-supers --- */
static GType type_id_get_supers = 0;
static void
get_supers_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 400 "bseproject.proc"
 {
#line 402 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("super_list", NULL, NULL, BSE_TYPE_PROXY_SEQ, SFI_PARAM_DEFAULT);
#line 401 "bseproject.proc"
  proc->help = "Retrieve all supers of this project.";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 405 "bseproject.proc"
}  }
static BseErrorType
#line 405 "bseproject.proc"
get_supers_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 408 "bseproject.proc"
{
#line 409 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  BseProxySeq *pseq;
  GSList *slist;
  
#line 414 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 418 "bseproject.proc"
  
  pseq = bse_proxy_seq_new ();
  for (slist = project->supers; slist; slist = slist->next)
    bse_proxy_seq_append (pseq, BSE_OBJECT_ID (slist->data));
  
#line 423 "bseproject.proc"
  
  bse_value_take_boxed (out_values++, pseq);
  
  return BSE_ERROR_NONE;
}

/* --- can-play --- */
static GType type_id_can_play = 0;
static void
can_play_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 429 "bseproject.proc"
 {
#line 431 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_bool ("can_play", "Can Play", "Whether project playback makes sense",
			  FALSE, SFI_PARAM_DEFAULT);
#line 430 "bseproject.proc"
  proc->help = "Check whether project playback would makes sense.";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 435 "bseproject.proc"
}  }
static BseErrorType
#line 435 "bseproject.proc"
can_play_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 438 "bseproject.proc"
{
#line 439 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 442 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 446 "bseproject.proc"
  
  sfi_value_set_bool (out_values++, project->supers != NULL);
  
  return BSE_ERROR_NONE;
}

/* --- get-state --- */
static GType type_id_get_state = 0;
static void
get_state_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 452 "bseproject.proc"
 {
#line 454 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_genum ("state", "State", "Project playback/activation state",
				BSE_TYPE_PROJECT_STATE, BSE_PROJECT_INACTIVE, SFI_PARAM_DEFAULT);
#line 453 "bseproject.proc"
  proc->help = "Retrieve the current project state.";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 458 "bseproject.proc"
}  }
static BseErrorType
#line 458 "bseproject.proc"
get_state_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 461 "bseproject.proc"
{
#line 462 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  
#line 465 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 469 "bseproject.proc"
  
  g_value_set_enum (out_values++, self->state);
  
  return BSE_ERROR_NONE;
}

/* --- activate --- */
static GType type_id_activate = 0;
static void
activate_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 475 "bseproject.proc"
 {
#line 477 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
#line 476 "bseproject.proc"
  proc->help = "Activate a project, precondition to start playback.";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 482 "bseproject.proc"
}  }
static BseErrorType
#line 482 "bseproject.proc"
activate_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 485 "bseproject.proc"
{
#line 486 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  BseErrorType error;

#line 490 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  error = bse_project_activate (self);

  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- start-playback --- */
static GType type_id_start_playback = 0;
static void
start_playback_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 501 "bseproject.proc"
 {
#line 503 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
#line 502 "bseproject.proc"
  proc->help = "Start playback in an activated project.";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 505 "bseproject.proc"
}  }
static BseErrorType
#line 505 "bseproject.proc"
start_playback_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 508 "bseproject.proc"
{
#line 509 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 512 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_start_playback (self);

  return BSE_ERROR_NONE;
}

/* --- stop-playback --- */
static GType type_id_stop_playback = 0;
static void
stop_playback_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 521 "bseproject.proc"
 {
#line 523 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
#line 522 "bseproject.proc"
  proc->help = "Stop project playback.";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 525 "bseproject.proc"
}  }
static BseErrorType
#line 525 "bseproject.proc"
stop_playback_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 528 "bseproject.proc"
{
#line 529 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 532 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_stop_playback (self);

  return BSE_ERROR_NONE;
}

/* --- deactivate --- */
static GType type_id_deactivate = 0;
static void
deactivate_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 541 "bseproject.proc"
 {
#line 543 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
#line 542 "bseproject.proc"
  proc->help = "Deactivate the project, automatically stop playback.";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 545 "bseproject.proc"
}  }
static BseErrorType
#line 545 "bseproject.proc"
deactivate_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 548 "bseproject.proc"
{
#line 549 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 552 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_deactivate (self);

  return BSE_ERROR_NONE;
}

/* --- play --- */
static GType type_id_play = 0;
static void
play_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 561 "bseproject.proc"
 {
#line 563 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
#line 562 "bseproject.proc"
  proc->help = "Activate a project and start project playback (and already playing project is first halted).";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 568 "bseproject.proc"
}  }
static BseErrorType
#line 568 "bseproject.proc"
play_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 571 "bseproject.proc"
{
#line 572 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  BseErrorType error;

#line 576 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  error = bse_project_activate (self);
  if (!error)
    {
      if (self->state == BSE_PROJECT_PLAYING)
	bse_project_stop_playback (self);
      bse_project_start_playback (self);
    }

  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- stop --- */
static GType type_id_stop = 0;
static void
stop_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 593 "bseproject.proc"
 {
#line 595 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", "Project", "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
#line 594 "bseproject.proc"
  proc->help = "Stop project playback and deactivate project.";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 597 "bseproject.proc"
}  }
static BseErrorType
#line 597 "bseproject.proc"
stop_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 600 "bseproject.proc"
{
#line 601 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 604 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_deactivate (self);

  return BSE_ERROR_NONE;
}

/* --- auto-deactivate --- */
static GType type_id_auto_deactivate = 0;
static void
auto_deactivate_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 613 "bseproject.proc"
 {
#line 615 "bseproject.proc"
  *(in_pspecs++) = bse_param_spec_object ("project", NULL, "The project",
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("msec_delay", NULL, "Delay for deactivation in milliseconds",
			 0, -1, G_MAXINT, 1000, SFI_PARAM_DEFAULT);
#line 614 "bseproject.proc"
  proc->help = "Automatically deactivate a project once playback stopped.";
#line 29 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 619 "bseproject.proc"
}  }
static BseErrorType
#line 619 "bseproject.proc"
auto_deactivate_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 622 "bseproject.proc"
{
#line 623 "bseproject.proc"
  
  BseProject *self  = bse_value_get_object (in_values++);
  gint64      msecs = sfi_value_get_int (in_values++);

#line 627 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  self->deactivate_usecs = msecs < 0 ? -1 : msecs * 1000;

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_is_playing, "BseProject+is-playing", NULL, 0, is_playing_setup, is_playing_exec, NULL, "/Method/BseProject/General/Is Playing", { 0, }, },
  { &type_id_restore_from_file, "BseProject+restore-from-file", NULL, 0, restore_from_file_setup, restore_from_file_exec, NULL, "/Method/BseProject/File/Restore", { 0, }, },
  { &type_id_store_bse, "BseProject+store-bse", NULL, 0, store_bse_setup, store_bse_exec, NULL, "/Method/BseProject/File/Store", { 0, }, },
  { &type_id_create_song, "BseProject+create-song", "Create a song for this project.", 0, create_song_setup, create_song_exec, NULL, "/Method/BseProject/General/Create Song", { 0, }, },
  { &type_id_ensure_wave_repo, "BseProject+ensure-wave-repo", NULL, 0, ensure_wave_repo_setup, ensure_wave_repo_exec, NULL, "/Method/BseProject/General/Ensure Wave Repo", { 0, }, },
  { &type_id_get_data_pocket, "BseProject+get-data-pocket", NULL, 0, get_data_pocket_setup, get_data_pocket_exec, NULL, "/Method/BseProject/General/Get Data Pocket", { 0, }, },
  { &type_id_create_snet, "BseProject+create-snet", "Create a synthsizer network for this project.", 0, create_snet_setup, create_snet_exec, NULL, "/Method/BseProject/General/Create Snet", { 0, }, },
  { &type_id_create_midi_synth, "BseProject+create-midi-synth", "Create a MIDI synthesizer network for this project.", 0, create_midi_synth_setup, create_midi_synth_exec, NULL, "/Method/BseProject/General/Create Midi Synth", { 0, }, },
  { &type_id_list_uname_paths, "BseProject+list-uname-paths", NULL, 0, list_uname_paths_setup, list_uname_paths_exec, NULL, "/Method/BseProject/General/List Uname Paths", { 0, }, },
  { &type_id_find_item, "BseProject+find-item", NULL, 0, find_item_setup, find_item_exec, NULL, "/Method/BseProject/General/Find Item", { 0, }, },
  { &type_id_match_items_by_uname, "BseProject+match-items-by-uname", NULL, 0, match_items_by_uname_setup, match_items_by_uname_exec, NULL, "/Method/BseProject/General/Match Items By Uname", { 0, }, },
  { &type_id_get_supers, "BseProject+get-supers", NULL, 0, get_supers_setup, get_supers_exec, NULL, "/Method/BseProject/General/Get Supers", { 0, }, },
  { &type_id_can_play, "BseProject+can-play", NULL, 0, can_play_setup, can_play_exec, NULL, "/Method/BseProject/General/Can Play", { 0, }, },
  { &type_id_get_state, "BseProject+get-state", NULL, 0, get_state_setup, get_state_exec, NULL, "/Method/BseProject/General/Get State", { 0, }, },
  { &type_id_activate, "BseProject+activate", NULL, 0, activate_setup, activate_exec, NULL, "/Method/BseProject/General/Activate", { 0, }, },
  { &type_id_start_playback, "BseProject+start-playback", NULL, 0, start_playback_setup, start_playback_exec, NULL, "/Method/BseProject/General/Start Playback", { 0, }, },
  { &type_id_stop_playback, "BseProject+stop-playback", NULL, 0, stop_playback_setup, stop_playback_exec, NULL, "/Method/BseProject/General/Stop Playback", { 0, }, },
  { &type_id_deactivate, "BseProject+deactivate", NULL, 0, deactivate_setup, deactivate_exec, NULL, "/Method/BseProject/General/Deactivate", { 0, }, },
  { &type_id_play, "BseProject+play", NULL, 0, play_setup, play_exec, NULL, "/Method/BseProject/General/Play", { 0, }, },
  { &type_id_stop, "BseProject+stop", NULL, 0, stop_setup, stop_exec, NULL, "/Method/BseProject/General/Stop", { 0, }, },
  { &type_id_auto_deactivate, "BseProject+auto-deactivate", NULL, 0, auto_deactivate_setup, auto_deactivate_exec, NULL, "/Method/BseProject/General/Auto Deactivate", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
