
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsedatapocket.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsedatapocket.h>


#line 26 "bsedatapocket.proc"


/* --- create-entry --- */
static GType type_id_create_entry = 0;
static void
create_entry_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 28 "bsedatapocket.proc"
 {
#line 31 "bsedatapocket.proc"
  *(in_pspecs++) = g_param_spec_object ("data_pocket", "Data Pocket", NULL,
			       BSE_TYPE_DATA_POCKET, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_uint ("entry_id", "Entry ID", "The unique pocket entry ID",
			     1, G_MAXINT, 1, BSE_PARAM_DEFAULT);
#line 29 "bsedatapocket.proc"
  proc->help = ("Create a new entry in a data pocket. "
	   "Entries have a unique ID which is required to set values in a data pocket.");
#line 23 "bsedatapocket.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsedatapocket.proc"
  proc->date = "2002";
#line 35 "bsedatapocket.proc"
}  }
static BseErrorType
#line 35 "bsedatapocket.proc"
create_entry_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 38 "bsedatapocket.proc"
{
#line 39 "bsedatapocket.proc"
  
  BseDataPocket *pocket = g_value_get_object (in_values++);
  guint id;

#line 43 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 47 "bsedatapocket.proc"
  
  id = _bse_data_pocket_create_entry (pocket);

#line 50 "bsedatapocket.proc"
  
  g_value_set_uint (out_values++, id);
  
  return BSE_ERROR_NONE;
}

/* --- delete-entry --- */
static GType type_id_delete_entry = 0;
static void
delete_entry_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 56 "bsedatapocket.proc"
 {
#line 58 "bsedatapocket.proc"
  *(in_pspecs++) = g_param_spec_object ("data_pocket", "Data Pocket", NULL,
			       BSE_TYPE_DATA_POCKET, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("entry_id", "Entry ID", "The unique pocket entry ID",
			     1, G_MAXINT, 1, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", "BSE error code",
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
#line 57 "bsedatapocket.proc"
  proc->help = "Delete an existing entry from a data pocket";
#line 23 "bsedatapocket.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsedatapocket.proc"
  proc->date = "2002";
#line 65 "bsedatapocket.proc"
}  }
static BseErrorType
#line 65 "bsedatapocket.proc"
delete_entry_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 68 "bsedatapocket.proc"
{
#line 69 "bsedatapocket.proc"
  
  BseDataPocket *pocket = g_value_get_object (in_values++);
  guint id              = g_value_get_uint (in_values++);
  gboolean fail = TRUE;

#line 74 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 78 "bsedatapocket.proc"
  
  if (id)
    fail = _bse_data_pocket_delete_entry (pocket, id);

#line 82 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, fail ? BSE_ERROR_NOT_FOUND : BSE_ERROR_NONE);

  return BSE_ERROR_NONE;
}

/* --- get-n-entries --- */
static GType type_id_get_n_entries = 0;
static void
get_n_entries_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 88 "bsedatapocket.proc"
 {
#line 90 "bsedatapocket.proc"
  *(in_pspecs++) = g_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
			       BSE_TYPE_DATA_POCKET, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_uint ("n_entries", "N Entries", "The number of entries in use",
			     0, G_MAXINT, 1, BSE_PARAM_DEFAULT);
#line 89 "bsedatapocket.proc"
  proc->help = "Retrive the number of entries created in a data pocket.";
#line 23 "bsedatapocket.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsedatapocket.proc"
  proc->date = "2002";
#line 94 "bsedatapocket.proc"
}  }
static BseErrorType
#line 94 "bsedatapocket.proc"
get_n_entries_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 97 "bsedatapocket.proc"
{
#line 98 "bsedatapocket.proc"
  
  BseDataPocket *pocket = g_value_get_object (in_values++);

#line 101 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 105 "bsedatapocket.proc"
  
  g_value_set_uint (out_values++, pocket->n_entries);

  return BSE_ERROR_NONE;
}

/* --- get-nth-entry-id --- */
static GType type_id_get_nth_entry_id = 0;
static void
get_nth_entry_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 111 "bsedatapocket.proc"
 {
#line 113 "bsedatapocket.proc"
  *(in_pspecs++) = g_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
			       BSE_TYPE_DATA_POCKET, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("entry_index", "Entry Index", "index into number of entries present",
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_uint ("entry_id", "Entry ID", "The unique pocket entry ID (or 0 if there's no such entry)",
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
#line 112 "bsedatapocket.proc"
  proc->help = "Retrive the ID of an entry in the data pocket by sequential index.";
#line 23 "bsedatapocket.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsedatapocket.proc"
  proc->date = "2002";
#line 119 "bsedatapocket.proc"
}  }
static BseErrorType
#line 119 "bsedatapocket.proc"
get_nth_entry_id_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 122 "bsedatapocket.proc"
{
#line 123 "bsedatapocket.proc"
  
  BseDataPocket *pocket = g_value_get_object (in_values++);
  guint index           = g_value_get_uint (in_values++);

#line 127 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 131 "bsedatapocket.proc"
  
  g_value_set_uint (out_values++, index < pocket->n_entries ? pocket->entries[index].id : 0);

  return BSE_ERROR_NONE;
}

/* --- set-float --- */
static GType type_id_set_float = 0;
static void
set_float_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 137 "bsedatapocket.proc"
 {
#line 141 "bsedatapocket.proc"
  *(in_pspecs++) = g_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
			       BSE_TYPE_DATA_POCKET, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("entry_id", "Entry ID", "The unique pocket entry ID",
			     1, G_MAXINT, 1, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("name", "Name", "Name for the value",
			       0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_float ("number", "Number", "The value to store in the data pocket entry",
			      -G_MAXFLOAT, G_MAXFLOAT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", "BSE error code",
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
#line 138 "bsedatapocket.proc"
  proc->help = ("Set a named floating point value in a data pocket entry. "
	   "Names are required to distinguish different values from each other "
	   "when accessing values in a data pocket.");
#line 23 "bsedatapocket.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsedatapocket.proc"
  proc->date = "2002";
#line 152 "bsedatapocket.proc"
}  }
static BseErrorType
#line 152 "bsedatapocket.proc"
set_float_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 155 "bsedatapocket.proc"
{
#line 156 "bsedatapocket.proc"
  
  BseDataPocket *pocket = g_value_get_object (in_values++);
  guint id              = g_value_get_uint (in_values++);
  gchar *name           = g_value_get_string (in_values++);
  gfloat v_float        = g_value_get_float (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;

#line 164 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 168 "bsedatapocket.proc"
  
  value.v_float = v_float;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_FLOAT, value);

#line 173 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NOT_FOUND);

  return BSE_ERROR_NONE;
}

/* --- set-int --- */
static GType type_id_set_int = 0;
static void
set_int_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 179 "bsedatapocket.proc"
 {
#line 183 "bsedatapocket.proc"
  *(in_pspecs++) = g_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
			       BSE_TYPE_DATA_POCKET, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("entry_id", "Entry ID", "The unique pocket entry ID",
			     1, G_MAXINT, 1, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("name", "Name", "Name for the value",
			       0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_int ("number", "Number", "The value to store in the data pocket entry",
			    -G_MAXINT, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", "BSE error code",
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
#line 180 "bsedatapocket.proc"
  proc->help = ("Set a named integer value in a data pocket entry. "
	   "Names are required to distinguish different values from each other "
	   "when accessing values in a data pocket.");
#line 23 "bsedatapocket.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsedatapocket.proc"
  proc->date = "2002";
#line 194 "bsedatapocket.proc"
}  }
static BseErrorType
#line 194 "bsedatapocket.proc"
set_int_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 197 "bsedatapocket.proc"
{
#line 198 "bsedatapocket.proc"
  
  BseDataPocket *pocket = g_value_get_object (in_values++);
  guint id              = g_value_get_uint (in_values++);
  gchar *name           = g_value_get_string (in_values++);
  guint v_uint          = g_value_get_int (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;

#line 206 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 210 "bsedatapocket.proc"
  
  value.v_int = v_uint;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_INT, value);

#line 215 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NOT_FOUND);

  return BSE_ERROR_NONE;
}

/* --- set-object --- */
static GType type_id_set_object = 0;
static void
set_object_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 221 "bsedatapocket.proc"
 {
#line 225 "bsedatapocket.proc"
  *(in_pspecs++) = g_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
			       BSE_TYPE_DATA_POCKET, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("entry_id", "Entry ID", "The unique pocket entry ID",
			     1, G_MAXINT, 1, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("name", "Name", "Name for the value",
			       0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_object ("item", "Item", "The value to store in the data pocket entry",
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", "BSE error code",
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
#line 222 "bsedatapocket.proc"
  proc->help = ("Set a named object reference in a data pocket entry. "
	   "Object references stored in a data pocket must exist within the "
	   "same project that the data pocket belongs to");
#line 23 "bsedatapocket.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsedatapocket.proc"
  proc->date = "2002";
#line 236 "bsedatapocket.proc"
}  }
static BseErrorType
#line 236 "bsedatapocket.proc"
set_object_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 239 "bsedatapocket.proc"
{
#line 240 "bsedatapocket.proc"
  
  BseDataPocket *pocket = g_value_get_object (in_values++);
  guint id              = g_value_get_uint (in_values++);
  gchar *name           = g_value_get_string (in_values++);
  BseItem *v_object     = g_value_get_object (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;

#line 248 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket) ||
      (v_object && !bse_item_common_ancestor ((BseItem*) pocket, v_object)))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 253 "bsedatapocket.proc"
  
  value.v_object = v_object;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_OBJECT, value);

#line 258 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NOT_FOUND);

  return BSE_ERROR_NONE;
}

/* --- set-string --- */
static GType type_id_set_string = 0;
static void
set_string_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 264 "bsedatapocket.proc"
 {
#line 266 "bsedatapocket.proc"
  *(in_pspecs++) = g_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
			       BSE_TYPE_DATA_POCKET, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("entry_id", "Entry ID", "The unique pocket entry ID",
			     1, G_MAXINT, 1, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("name", "Name", "Name for the value",
			       0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("string", "String", "The value to store in the data pocket entry",
			       0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", "BSE error code",
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
#line 265 "bsedatapocket.proc"
  proc->help = ("Set a named string in a data pocket entry.");
#line 23 "bsedatapocket.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsedatapocket.proc"
  proc->date = "2002";
#line 277 "bsedatapocket.proc"
}  }
static BseErrorType
#line 277 "bsedatapocket.proc"
set_string_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 280 "bsedatapocket.proc"
{
#line 281 "bsedatapocket.proc"
  
  BseDataPocket *pocket = g_value_get_object (in_values++);
  guint id              = g_value_get_uint (in_values++);
  gchar *name           = g_value_get_string (in_values++);
  gchar *v_string       = g_value_get_string (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;

#line 289 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 293 "bsedatapocket.proc"
  
  value.v_string = v_string;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_STRING, value);

#line 298 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NOT_FOUND);

  return BSE_ERROR_NONE;
}

/* --- get-float --- */
static GType type_id_get_float = 0;
static void
get_float_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 304 "bsedatapocket.proc"
 {
#line 306 "bsedatapocket.proc"
  *(in_pspecs++) = g_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
			       BSE_TYPE_DATA_POCKET, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("entry_id", "Entry ID", "The unique pocket entry ID",
			     1, G_MAXINT, 1, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("name", "Name", "Name for the value",
			       0, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_float ("number", "Number", "The value stored in the data pocket entry",
			      -G_MAXFLOAT, G_MAXFLOAT, 0, BSE_PARAM_DEFAULT);
#line 305 "bsedatapocket.proc"
  proc->help = "Retrive a previously set floating point value from a data pocket entry.";
#line 23 "bsedatapocket.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsedatapocket.proc"
  proc->date = "2002";
#line 314 "bsedatapocket.proc"
}  }
static BseErrorType
#line 314 "bsedatapocket.proc"
get_float_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 317 "bsedatapocket.proc"
{
#line 318 "bsedatapocket.proc"
  
  BseDataPocket *pocket = g_value_get_object (in_values++);
  guint id              = g_value_get_uint (in_values++);
  gchar *name           = g_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;

#line 325 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 329 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);

#line 332 "bsedatapocket.proc"
  
  g_value_set_float (out_values++, type == BSE_DATA_POCKET_FLOAT ? value.v_float : 0);

  return BSE_ERROR_NONE;
}

/* --- get-int --- */
static GType type_id_get_int = 0;
static void
get_int_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 338 "bsedatapocket.proc"
 {
#line 340 "bsedatapocket.proc"
  *(in_pspecs++) = g_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
			       BSE_TYPE_DATA_POCKET, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("entry_id", "Entry ID", "The unique pocket entry ID",
			     1, G_MAXINT, 1, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("name", "Name", "Name for the value",
			       0, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_int ("number", "Number", "The value stored in the data pocket entry",
			    -G_MAXINT, G_MAXINT, 0, BSE_PARAM_DEFAULT);
#line 339 "bsedatapocket.proc"
  proc->help = "Retrive a previously set integer value from a data pocket entry.";
#line 23 "bsedatapocket.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsedatapocket.proc"
  proc->date = "2002";
#line 348 "bsedatapocket.proc"
}  }
static BseErrorType
#line 348 "bsedatapocket.proc"
get_int_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 351 "bsedatapocket.proc"
{
#line 352 "bsedatapocket.proc"
  
  BseDataPocket *pocket = g_value_get_object (in_values++);
  guint id              = g_value_get_uint (in_values++);
  gchar *name           = g_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;

#line 359 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 363 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);

#line 366 "bsedatapocket.proc"
  
  g_value_set_int (out_values++, type == BSE_DATA_POCKET_INT ? value.v_int : 0);

  return BSE_ERROR_NONE;
}

/* --- get-object --- */
static GType type_id_get_object = 0;
static void
get_object_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 372 "bsedatapocket.proc"
 {
#line 374 "bsedatapocket.proc"
  *(in_pspecs++) = g_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
			       BSE_TYPE_DATA_POCKET, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("entry_id", "Entry ID", "The unique pocket entry ID",
			     1, G_MAXINT, 1, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("name", "Name", "Name for the value",
			       0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_object ("item", "Item", "The value stored in the data pocket entry",
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
#line 373 "bsedatapocket.proc"
  proc->help = "Retrive a previously set object reference from a data pocket entry.";
#line 23 "bsedatapocket.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsedatapocket.proc"
  proc->date = "2002";
#line 382 "bsedatapocket.proc"
}  }
static BseErrorType
#line 382 "bsedatapocket.proc"
get_object_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 385 "bsedatapocket.proc"
{
#line 386 "bsedatapocket.proc"
  
  BseDataPocket *pocket = g_value_get_object (in_values++);
  guint id              = g_value_get_uint (in_values++);
  gchar *name           = g_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;

#line 393 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 397 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);

#line 400 "bsedatapocket.proc"
  
  g_value_set_object (out_values++, type == BSE_DATA_POCKET_OBJECT ? value.v_object : 0);

  return BSE_ERROR_NONE;
}

/* --- get-string --- */
static GType type_id_get_string = 0;
static void
get_string_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 406 "bsedatapocket.proc"
 {
#line 408 "bsedatapocket.proc"
  *(in_pspecs++) = g_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
			       BSE_TYPE_DATA_POCKET, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("entry_id", "Entry ID", "The unique pocket entry ID",
			     1, G_MAXINT, 1, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("name", "Name", "Name for the value",
			       0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_string ("string", "String", "The value stored in the data pocket entry",
			       0, BSE_PARAM_DEFAULT);
#line 407 "bsedatapocket.proc"
  proc->help = "Retrive a previously set string from a data pocket entry.";
#line 23 "bsedatapocket.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsedatapocket.proc"
  proc->date = "2002";
#line 416 "bsedatapocket.proc"
}  }
static BseErrorType
#line 416 "bsedatapocket.proc"
get_string_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 419 "bsedatapocket.proc"
{
#line 420 "bsedatapocket.proc"
  
  BseDataPocket *pocket = g_value_get_object (in_values++);
  guint id              = g_value_get_uint (in_values++);
  gchar *name           = g_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;

#line 427 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 431 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);

#line 434 "bsedatapocket.proc"
  
  g_value_set_string (out_values++, type == BSE_DATA_POCKET_STRING ? value.v_string : 0);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_create_entry, "BseDataPocket+create-entry", NULL, 0, create_entry_setup, create_entry_exec, NULL, "/Method/BseDataPocket/General/Create Entry", { 0, }, },
  { &type_id_delete_entry, "BseDataPocket+delete-entry", NULL, 0, delete_entry_setup, delete_entry_exec, NULL, "/Method/BseDataPocket/General/Delete Entry", { 0, }, },
  { &type_id_get_n_entries, "BseDataPocket+get-n-entries", NULL, 0, get_n_entries_setup, get_n_entries_exec, NULL, "/Method/BseDataPocket/General/Get N Entries", { 0, }, },
  { &type_id_get_nth_entry_id, "BseDataPocket+get-nth-entry-id", NULL, 0, get_nth_entry_id_setup, get_nth_entry_id_exec, NULL, "/Method/BseDataPocket/General/Get Nth Entry Id", { 0, }, },
  { &type_id_set_float, "BseDataPocket+set-float", NULL, 0, set_float_setup, set_float_exec, NULL, "/Method/BseDataPocket/General/Set Float", { 0, }, },
  { &type_id_set_int, "BseDataPocket+set-int", NULL, 0, set_int_setup, set_int_exec, NULL, "/Method/BseDataPocket/General/Set Int", { 0, }, },
  { &type_id_set_object, "BseDataPocket+set-object", NULL, 0, set_object_setup, set_object_exec, NULL, "/Method/BseDataPocket/General/Set Object", { 0, }, },
  { &type_id_set_string, "BseDataPocket+set-string", NULL, 0, set_string_setup, set_string_exec, NULL, "/Method/BseDataPocket/General/Set String", { 0, }, },
  { &type_id_get_float, "BseDataPocket+get-float", NULL, 0, get_float_setup, get_float_exec, NULL, "/Method/BseDataPocket/General/Get Float", { 0, }, },
  { &type_id_get_int, "BseDataPocket+get-int", NULL, 0, get_int_setup, get_int_exec, NULL, "/Method/BseDataPocket/General/Get Int", { 0, }, },
  { &type_id_get_object, "BseDataPocket+get-object", NULL, 0, get_object_setup, get_object_exec, NULL, "/Method/BseDataPocket/General/Get Object", { 0, }, },
  { &type_id_get_string, "BseDataPocket+get-string", NULL, 0, get_string_setup, get_string_exec, NULL, "/Method/BseDataPocket/General/Get String", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
