
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsecontainer.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsecontainer.h>


#line 27 "bsecontainer.proc"


/* --- list-items --- */
static GType type_id_list_items = 0;
static void
list_items_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 29 "bsecontainer.proc"
 {
#line 31 "bsecontainer.proc"
  *(in_pspecs++) = g_param_spec_object ("container", NULL, NULL,
			       BSE_TYPE_CONTAINER, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_boxed ("item_list", NULL, NULL,
			      BSW_TYPE_ITER_PROXY,
			      BSE_PARAM_DEFAULT);
#line 30 "bsecontainer.proc"
  proc->help = "Retrive all items within a container";
#line 24 "bsecontainer.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsecontainer.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsecontainer.proc"
  proc->date = "2002";
#line 36 "bsecontainer.proc"
}  }
static BseErrorType
#line 36 "bsecontainer.proc"
list_items_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 39 "bsecontainer.proc"
{
#line 40 "bsecontainer.proc"
  
  BseContainer *container = g_value_get_object (in_values++);

#line 43 "bsecontainer.proc"
  
  if (!BSE_IS_CONTAINER (container))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 47 "bsecontainer.proc"
  
  g_value_set_boxed_take_ownership (out_values++, bse_container_list_items (container));

  return BSE_ERROR_NONE;
}

/* --- lookup-item --- */
static GType type_id_lookup_item = 0;
static void
lookup_item_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 53 "bsecontainer.proc"
 {
#line 57 "bsecontainer.proc"
  *(in_pspecs++) = g_param_spec_object ("container", "Container", "The Container",
			       BSE_TYPE_CONTAINER, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("uname", "UName", "Unique item name",
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_object ("item", "Item", "The item named by uname",
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
#line 55 "bsecontainer.proc"
  proc->help = ("Lookup an immediate child of a container from its uname (the uname "
	   "is the name of the item, unique between all immediate children of a container).");
#line 24 "bsecontainer.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsecontainer.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsecontainer.proc"
  proc->date = "2002";
#line 63 "bsecontainer.proc"
}  }
static BseErrorType
#line 63 "bsecontainer.proc"
lookup_item_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 66 "bsecontainer.proc"
{
#line 67 "bsecontainer.proc"
  
  BseContainer *container = g_value_get_object (in_values++);
  gchar *uname            = g_value_get_string (in_values++);
  
#line 71 "bsecontainer.proc"
  
  if (!BSE_IS_CONTAINER (container) || !uname)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 75 "bsecontainer.proc"
  
  g_value_set_object (out_values++, bse_container_lookup_item (container, uname));

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_list_items, "BseContainer+list-items", NULL, 0, list_items_setup, list_items_exec, NULL, "/Method/BseContainer/General/List Items", { 0, }, },
  { &type_id_lookup_item, "BseContainer+lookup-item", "Find an item within a container.", 0, lookup_item_setup, lookup_item_exec, NULL, "/Method/BseContainer/General/Lookup Item", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
