
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsesnet.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsesnet.h>
#include        <bse/bsemain.h>


#line 28 "bsesnet.proc"


/* --- supports-user-synths --- */
static GType type_id_supports_user_synths = 0;
static void
supports_user_synths_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 30 "bsesnet.proc"
 {
#line 32 "bsesnet.proc"
  *(in_pspecs++) = g_param_spec_object ("snet", "Synth Net", NULL,
			       BSE_TYPE_SNET, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_boolean ("user_synth", "User Synth", NULL,
				FALSE, BSE_PARAM_DEFAULT);
#line 31 "bsesnet.proc"
  proc->help = "Check whether users may edit synthesis modules of this network";
#line 25 "bsesnet.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bsesnet.proc"
  proc->copyright = "Tim Janik";
#line 27 "bsesnet.proc"
  proc->date = "2001";
#line 36 "bsesnet.proc"
}  }
static BseErrorType
#line 36 "bsesnet.proc"
supports_user_synths_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 39 "bsesnet.proc"
{
#line 40 "bsesnet.proc"
  
  BseSNet *snet = g_value_get_object (in_values++);

#line 43 "bsesnet.proc"
  
  if (!BSE_IS_SNET (snet))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 47 "bsesnet.proc"
  
  g_value_set_boolean (out_values++, BSE_SNET_USER_SYNTH (snet));
  
  return BSE_ERROR_NONE;
}

/* --- can-create-source --- */
static GType type_id_can_create_source = 0;
static void
can_create_source_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 53 "bsesnet.proc"
 {
#line 55 "bsesnet.proc"
  *(in_pspecs++) = g_param_spec_object ("snet", "Synth Net", NULL,
			       BSE_TYPE_SNET, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("module_type", "Module Type", NULL,
			       "", BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_enum ("error", "Error", NULL,
			     BSE_TYPE_ERROR_TYPE, 0,
			     BSE_PARAM_DEFAULT);
#line 54 "bsesnet.proc"
  proc->help = "Check whether inserting a new module into a synthesis network is possible";
#line 25 "bsesnet.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bsesnet.proc"
  proc->copyright = "Tim Janik";
#line 27 "bsesnet.proc"
  proc->date = "2001";
#line 62 "bsesnet.proc"
}  }
static BseErrorType
#line 62 "bsesnet.proc"
can_create_source_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 65 "bsesnet.proc"
{
#line 66 "bsesnet.proc"
  
  BseSNet *snet = g_value_get_object (in_values++);
  const gchar *type_name = g_value_get_string (in_values++);
  GType type = g_type_from_name (type_name);
  BseErrorType error = BSE_ERROR_NONE;

#line 72 "bsesnet.proc"
  
  if (!BSE_IS_SNET (snet))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 76 "bsesnet.proc"
  
  if (!BSE_SNET_USER_SYNTH (snet) && !BSE_DVL_EXT)
    error = BSE_ERROR_PERMS;
  else if (!g_type_is_a (type, BSE_TYPE_SOURCE) ||
	   g_type_is_a (type, BSE_TYPE_CONTAINER))
    error = BSE_ERROR_SOURCE_TYPE_INVALID;

#line 83 "bsesnet.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- create-source --- */
static GType type_id_create_source = 0;
static void
create_source_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 89 "bsesnet.proc"
 {
#line 91 "bsesnet.proc"
  *(in_pspecs++) = g_param_spec_object ("snet", "Synth Net", NULL,
			       BSE_TYPE_SNET, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("module_type", "Module Type", NULL,
			       "", BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("module", "New Module", NULL,
			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
#line 90 "bsesnet.proc"
  proc->help = "Insert a new module into a synthesis network";
#line 25 "bsesnet.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bsesnet.proc"
  proc->copyright = "Tim Janik";
#line 27 "bsesnet.proc"
  proc->date = "2001";
#line 97 "bsesnet.proc"
}  }
static BseErrorType
#line 97 "bsesnet.proc"
create_source_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 100 "bsesnet.proc"
{
#line 101 "bsesnet.proc"
  
  BseSNet *snet = g_value_get_object (in_values++);
  const gchar *type_name = g_value_get_string (in_values++);
  BseContainer *container;
  BseSource *source;
  BseErrorType error;

#line 108 "bsesnet.proc"
  
  if (!BSE_IS_SNET (snet))
    return BSE_ERROR_PROC_PARAM_INVAL;
  if (bse_item_exec (snet, "can-create-source", type_name, &error) != 0 ||
      error != 0)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 115 "bsesnet.proc"
  
  container = BSE_CONTAINER (snet);
  source = g_object_new (g_type_from_name (type_name), NULL);
  bse_container_add_item (container, BSE_ITEM (source));

#line 120 "bsesnet.proc"
  
  g_value_set_object (out_values++, source);
  g_object_unref (source);
  
  return BSE_ERROR_NONE;
}

/* --- remove-source --- */
static GType type_id_remove_source = 0;
static void
remove_source_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 127 "bsesnet.proc"
 {
#line 129 "bsesnet.proc"
  *(in_pspecs++) = g_param_spec_object ("snet", "Synth Net", NULL,
			       BSE_TYPE_SNET, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", NULL,
			     BSE_TYPE_ERROR_TYPE, 0,
			     BSE_PARAM_DEFAULT);
#line 128 "bsesnet.proc"
  proc->help = "Remove an existing module from its synthesis network";
#line 25 "bsesnet.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bsesnet.proc"
  proc->copyright = "Tim Janik";
#line 27 "bsesnet.proc"
  proc->date = "2001";
#line 136 "bsesnet.proc"
}  }
static BseErrorType
#line 136 "bsesnet.proc"
remove_source_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 139 "bsesnet.proc"
{
#line 140 "bsesnet.proc"
  
  BseSNet *snet = g_value_get_object (in_values++);
  BseSource *source = g_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;

#line 145 "bsesnet.proc"
  
  if (!BSE_IS_SNET (snet) || !BSE_IS_SOURCE (source) || BSE_ITEM (source)->parent != BSE_ITEM (snet) ||
      (!BSE_SNET_USER_SYNTH (snet) && !BSE_DVL_EXT))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 150 "bsesnet.proc"
  
  bse_container_remove_item (BSE_CONTAINER (snet), BSE_ITEM (source));
  
#line 153 "bsesnet.proc"
  
  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_supports_user_synths, "BseSNet+supports-user-synths", NULL, 0, supports_user_synths_setup, supports_user_synths_exec, NULL, "/Method/BseSNet/General/Supports User Synths", { 0, }, },
  { &type_id_can_create_source, "BseSNet+can-create-source", NULL, 0, can_create_source_setup, can_create_source_exec, NULL, "/Method/BseSNet/General/Can Create Source", { 0, }, },
  { &type_id_create_source, "BseSNet+create-source", NULL, 0, create_source_setup, create_source_exec, NULL, "/Method/BseSNet/General/Create Source", { 0, }, },
  { &type_id_remove_source, "BseSNet+remove-source", NULL, 0, remove_source_setup, remove_source_exec, NULL, "/Method/BseSNet/General/Remove Source", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
