/* BseCompressor - BSE Compressor
 * Copyright (C) 1999 Tim Janik
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * bsecompressor.h: BSE Compressor - compresses loud and boosts quit things
 */
#ifndef __BSE_COMPRESSOR_H__
#define __BSE_COMPRESSOR_H__

#define  BSE_PLUGIN_NAME  "BseCompressor"

#include <bse/bseplugin.h>
#include <bse/bsesource.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */





/* --- object type macros --- */
#define BSE_TYPE_COMPRESSOR              (type_id_compressor)
#define BSE_COMPRESSOR(object)           (BSE_CHECK_STRUCT_CAST ((object), BSE_TYPE_COMPRESSOR, BseCompressor))
#define BSE_COMPRESSOR_CLASS(class)      (BSE_CHECK_CLASS_CAST ((class), BSE_TYPE_COMPRESSOR, BseCompressorClass))
#define BSE_IS_COMPRESSOR(object)        (BSE_CHECK_STRUCT_TYPE ((object), BSE_TYPE_COMPRESSOR))
#define BSE_IS_COMPRESSOR_CLASS(class)   (BSE_CHECK_CLASS_TYPE ((class), BSE_TYPE_COMPRESSOR))
#define BSE_COMPRESSOR_GET_CLASS(object) ((BseCompressorClass*) (((BseObject*) (object))->bse_struct.bse_class))


/* --- BseCompressor source --- */
typedef struct _BseCompressor      BseCompressor;
typedef struct _BseCompressorClass BseCompressorClass;
struct _BseCompressor
{
  BseSource       parent_object;
  
  gfloat	  pi_fact;
};
struct _BseCompressorClass
{
  BseSourceClass parent_class;
};


/* --- channels --- */
enum
{
  BSE_COMPRESSOR_ICHANNEL_NONE,
  BSE_COMPRESSOR_ICHANNEL_MONO1
};
enum
{
  BSE_COMPRESSOR_OCHANNEL_NONE,
  BSE_COMPRESSOR_OCHANNEL_MONO1
};





#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __BSE_COMPRESSOR_H__ */
