/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BSE_SONG_H__
#define __BSE_SONG_H__

#include	<bse/bsebase.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define	BSE_TYPE_SONG			(bse_song_get_type ())
#define	BSE_SONG(object)		(GTK_CHECK_CAST ((object), BSE_TYPE_SONG, BseSong))
#define BSE_SONG_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), BSE_TYPE_SONG, BseSongClass))
#define BSE_IS_SONG(object)		(GTK_CHECK_TYPE ((object), BSE_TYPE_SONG))
#define BSE_IS_SONG_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), BSE_TYPE_SONG))

struct _BseSong
{
  GtkObject	object;
  
  gchar	*name;
  gchar *blurb;
  gchar *author;
  gchar *copyright;
  gchar *bse_version;
  
  
  gulong creation_time;
  gulong modification_time;
  gulong last_modification_time;
  
  guint	bpm;
  guint	master_volume;
  
  guint	pattern_length		/* >= 4 by convention */;
  guint	n_channels		/* >= 2 by convention */;
  
  GList	*instruments		/* of type BseInstrument* */;
  GList *patterns		/* of type BsePattern* */;
  GList	*effect_processors	/* of type BseEffectProcessor* */;
  GList	*lfos			/* of type BseLfo* */;
  
  BseSequencer	*sequencer;
  
  
  guint pattern_list_length;
  BsePattern **pattern_list;
};

struct _BseSongClass
{
  GtkObjectClass	parent_class;

  /* signals
   */
  void	(*changed)		(BseSong	*song,
				 gulong		 m_time);
  void	(*pattern_changed)	(BseSong	*song,
				 BsePattern	*pattern);
  void	(*instrument_changed)	(BseSong	*song,
				 BseInstrument	*instrument);
  void	(*note_changed)		(BseSong	*song,
				 BsePattern	*pattern,
				 guint		 channel,
				 guint		 row);
};


/* --- prototypes --- */
GtkType		bse_song_get_type		(void);
BseSong*	bse_song_new			(const gchar	*song_name,
						 const gchar	*author,
						 const gchar	*copyright,
						 guint		 n_channels);
#define		bse_song_ref( song )		gtk_object_ref ((GtkObject*) (song))
#define		bse_song_unref( song )		gtk_object_unref ((GtkObject*) (song))
BseSong*	bse_song_lookup			(const gchar	*song_name);
BsePattern*	bse_song_add_pattern		(BseSong	*song);
BsePattern*	bse_song_get_pattern		(BseSong	*song,
						 guint		 pattern_guid);
BsePattern*	bse_song_get_pattern_from_list	(BseSong	*song,
						 guint		 pattern_index);
BseInstrument*	bse_song_sample_instrument_new	(BseSong	*song,
						 BseSample	*sample);
BseInstrument*	bse_song_get_instrument		(BseSong	*song,
						 guint		 instr_guid);
gboolean	bse_song_is_playing		(BseSong	*song);
void		bse_song_changed		(BseSong	*song);
void		bse_song_pattern_changed	(BseSong	*song,
						 BsePattern	*pattern);
void		bse_song_instrument_changed	(BseSong	*song,
						 BseInstrument	*instrument);
void		bse_song_note_changed		(BseSong	*song,
						 BsePattern	*pattern,
						 guint		 channel,
						 guint		 row);
void		bse_song_set_pattern_length	(BseSong	*song,
						 guint		 pattern_length);
void		bse_song_set_creation		(BseSong	*song,
						 gulong		 c_time);
void		bse_song_set_modification	(BseSong	*song,
						 gulong		 m_time);
void		bse_song_set_bpm		(BseSong	*song,
						 guint		 bpm);
void		bse_song_set_volume		(BseSong	*song,
						 guint		 master_volume);
GList*		bse_song_list_all		(void);
void		bse_song_set_name		(BseSong	*song,
						 const gchar	*name);
gchar*		bse_song_get_name		(BseSong	*song);
void		bse_song_set_blurb		(BseSong	*song,
						 const gchar	*name);
gchar*		bse_song_get_blurb		(BseSong	*song);
void		bse_song_set_author		(BseSong	*song,
						 const gchar	*name);
gchar*		bse_song_get_author		(BseSong	*song);
void		bse_song_set_copyright		(BseSong	*song,
						 const gchar	*name);
gchar*		bse_song_get_copyright		(BseSong	*song);
void	bse_song_reload_instrument_samples	(BseSong		*song,
						 BseSampleLookupCB	cb_func,
						 gpointer		cb_data);





#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_SONG_H__ */
