/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef	__BSE_SAMPLE_H__
#define	__BSE_SAMPLE_H__

#include	<bse/bsebase.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


#define BSE_TYPE_SAMPLE			(bse_sample_get_type ())
#define BSE_SAMPLE(object)		(GTK_CHECK_CAST ((object), BSE_TYPE_SAMPLE, BseSample))
#define BSE_SAMPLE_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), BSE_TYPE_SAMPLE, BseSampleClass))
#define BSE_IS_SAMPLE(object)		(GTK_CHECK_TYPE ((object), BSE_TYPE_SAMPLE))
#define BSE_IS_SAMPLE_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), BSE_TYPE_SAMPLE))

							       
struct _BseMunk
{
  guint recording_note;
  guint n_values		/* including n_channels count */;
  
  /* loop_end == 0 indicates no loop
   */
  guint loop_begin		/* offset, including n_channels count */;
  guint loop_end		/* offset, including n_channels count */;
  
  BseSampleValue *values	/* length: n_values * size (BseSampleValue) +
				 * max_buffer_size
				 */;
  
  BseValueBlock *block;
};

struct _BseSample
{
  GtkObject	object;

  BseSampleType	 type;
  gchar		*name;
  gchar		*blurb;
  gchar		*file_name;
  gchar		*type_blurb;
  
  gulong	 creation_time;
  gulong	 modification_time;
  gulong	 last_modification_time;

  guint		 n_channels;
  guint		 recording_freq;
  
  BseMunk	 munk[BSE_MAX_SAMPLE_MUNKS];
};

struct _BseSampleClass
{
  GtkObjectClass	parent_class;

  gchar                 *cpair_comment_single;

  GHashTable	       *sample_hash_table;    /* holding BseSampleHashEntry* */

  /* signals
   */
  void	(*changed)	(BseSample	*sample,
			 gulong		 m_time);
};

struct _BseSampleHashEntry
{
  gchar		*sample_name;
  gchar		*sample_path;
  BseSample	*sample;
};


/* --- prototypes --- */
GtkType		bse_sample_get_type		(void);
BseSample*	bse_sample_new			(BseSampleType	type,
						 const gchar	*sample_name,
						 const gchar	*file_name);
#define		bse_sample_ref( sample )	gtk_object_ref ((GtkObject*) (sample))
#define		bse_sample_unref( sample )	gtk_object_unref ((GtkObject*) (sample))
void		bse_sample_changed		(BseSample	*sample);
void		bse_sample_set_name		(BseSample	*sample,
						 const gchar	*sample_name);
gchar*		bse_sample_get_name		(BseSample	*sample);
void		bse_sample_set_params		(BseSample	*sample,
						 guint		 n_channels,
						 float		 recording_freq);
void		bse_sample_set_creation		(BseSample	*sample,
						 gulong		 c_time);
void		bse_sample_set_modification	(BseSample	*sample,
						 gulong		 m_time);
void		bse_sample_set_munk		(BseSample	*sample,
						 guint		 munk,
						 guint		 recording_note,
						 BseValueBlock	*block,
						 guint		 block_offset,
						 guint		 n_values,
						 guint		 loop_begin,
						 guint		 loop_end);
void		bse_sample_set_munks		(BseSample	*sample,
						 guint		 first_munk,
						 guint		 last_munk,
						 guint		 recording_note,
						 BseValueBlock	*block,
						 guint		 block_offset,
						 guint		 n_values,
						 guint		 loop_begin,
						 guint		 loop_end);
void		bse_sample_fillup_munks		(BseSample	*sample);
BseSample*	bse_sample_lookup		(const gchar	*sample_name);
gchar*		bse_sample_lookup_path		(const gchar	*sample_name);
BseSampleHashEntry* bse_sample_lookup_entry	(const gchar	*sample_name);
void		bse_sample_set_blurb		(BseSample	*sample,
						 const gchar	*blurb);
gchar*		bse_sample_get_blurb		(BseSample	*sample);
void		bse_sample_set_file_name	(BseSample	*sample,
						 const gchar	*file_name);
gchar*		bse_sample_get_file_name	(BseSample	*sample);
void		bse_sample_set_type_blurb	(BseSample	*sample,
						 const gchar	*type_blurb);
gchar*		bse_sample_get_type_blurb	(BseSample	*sample);
void		bse_sample_cache_dump_rc	(const gchar	*prefix_match,
						 gboolean	 loaded_only,
						 BsePrintFunc	 print_func,
						 gpointer	 func_data);
void		bse_sample_cache_parse_rc	(const gchar	*file_name);
void		bse_sample_cache_parse_rc_string(const gchar	*rc_string);
void		bse_sample_cache_parse_rc_scanner(GScanner	*scanner);


/* the returned GList* needs to be freed by g_list_free()
 */
GList*		bse_sample_list_all		(void);
void		bse_sample_cache_blow		(void);





#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_SAMPLE_H__ */
