/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * bsebase.h: base definitions for libbse
 */
#ifndef __BSE_BASE_H__
#define __BSE_BASE_H__

#include	<bse/bseenums.h>
#include	<bse/bsedefs.h>
#include	<bse/bseutils.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* --- asserts --- */
#define	bse_critical_assert		g_assert


/* --- frequencies --- */
#define	BSE_SAMPLE_DFL_RECORDING_FREQ	(44100)
#define	BSE_KAMMER_FREQ			(440)

/* --- bpm --- */
#define	BSE_MIN_BPM			(60)
#define	BSE_MAX_BPM			(360)
#define	BSE_INIT_DFL_BPM		(160)

/* --- volumes & balance --- */
#define	BSE_MAX_BALANCE			(BSE_FULL_VOLUME_f)
#define	BSE_MIN_BALANCE			(- BSE_FULL_VOLUME_f)
#define	BSE_MAX_VOLUME			(4096)
#define	BSE_MIN_VOLUME			(0)
/* #define	BSE_FULL_VOLUME			(127) */
#define	BSE_FULL_VOLUME_f		((double) 127.0)
#define	BSE_DFL_MASTER_VOLUME		(100)
#define	BSE_DFL_INSTRUMENT_VOLUME	(80)
#define	BSE_DFL_VOICE_VOLUME		(100)

/* --- instruments --- */
#define	BSE_MIN_TRANSPOSE		(-12)	/* ??? */
#define	BSE_MAX_TRANSPOSE		(12)	/* ??? */
#define	BSE_MIN_FINE_TUNE		(-6)	/* ??? */
#define	BSE_MAX_FINE_TUNE		(6)	/* ??? */

/* --- envelopes --- */
#define	BSE_MIN_ENV_LEVEL		(0)
#define	BSE_MAX_ENV_LEVEL		(127)	/* ??? */
#define	BSE_MIN_ENV_TIME		(0)
#define	BSE_MAX_ENV_TIME		(1024)	/* ??? */
#define	BSE_NO_ENV_TIME			(BSE_MAX_ENV_TIME + 1)

/* --- samples --- */
#define	BSE_MAX_SAMPLE_CHANNELS		(2)
#define	BSE_MAX_SAMPLE_MUNKS		(BSE_MAX_NOTE + 1)

/* --- channels & patterns --- */
#define	BSE_MAX_CHANNELS		(256)
#define	BSE_MIN_CHANNELS		(2)
#define	BSE_DFL_N_CHANNELS		(16)
#define	BSE_MAX_PATTERN_LENGTH		(256)
#define	BSE_MIN_PATTERN_LENGTH		(4)
#define	BSE_DFL_PATTERN_LENGTH		(64)
#define	BSE_MAX_N_PATTERNS		(65536)

/* --- mixer --- */
#define	BSE_MIN_N_MIXER_VALUES		(32)
#define	BSE_DFL_N_MIXER_VALUES		(512)
#define	BSE_MAX_N_MIXER_VALUES		(1024)
#define	BSE_MIN_N_MIXER_CHANNELS	(2)
#define	BSE_DFL_N_MIXER_CHANNELS	(2)
#define	BSE_MAX_N_MIXER_CHANNELS	(2)
#define	BSE_MIN_MIX_FREQ		(1378)
#define	BSE_DFL_MIX_FREQ		(22050)
#define	BSE_MAX_MIX_FREQ		(96000)

/* --- miscellaneous --- */
#define	BSE_CHANNEL_2_VOICE_FACTOR	(2)
#define	BSE_DFL_PATTERN_LENGTH		(64)
#define	BSE_DFL_LOAD_BUFFER_SIZE	(65536)
#define	BSE_VALUE_BLOCK_N_PAD_VALUES	(BSE_MAX_N_MIXER_VALUES * BSE_MAX_N_MIXER_CHANNELS)

/* --- notes --- */
#define	BSE_KAMMER_NOTE			((gint) (69) /* A! */)
#define	BSE_KAMMER_OCTAVE		((gint) (-1))
#define	BSE_NOTE_UNPARSABLE		(BSE_NOTE_VOID + 1)
#define	BSE_NOTE_VOID			(1024)
#define	BSE_MIN_NOTE			(0)
#define	BSE_MAX_NOTE			(127)
#define	BSE_SAMPLE_DFL_BASE_NOTE	(BSE_KAMMER_NOTE)
#define	BSE_NOTE_C(o)			(CLAMP (BSE_KAMMER_NOTE - 9 + ((o) - BSE_KAMMER_OCTAVE) * 12, BSE_MIN_NOTE, BSE_MAX_NOTE))
#define	BSE_NOTE_Cis(o)			(CLAMP (BSE_KAMMER_NOTE - 8 + ((o) - BSE_KAMMER_OCTAVE) * 12, BSE_MIN_NOTE, BSE_MAX_NOTE))
#define	BSE_NOTE_Des(o)			(BSE_NOTE_Cis (o))
#define	BSE_NOTE_D(o)			(CLAMP (BSE_KAMMER_NOTE - 7 + ((o) - BSE_KAMMER_OCTAVE) * 12, BSE_MIN_NOTE, BSE_MAX_NOTE))
#define	BSE_NOTE_Dis(o)			(CLAMP (BSE_KAMMER_NOTE - 6 + ((o) - BSE_KAMMER_OCTAVE) * 12, BSE_MIN_NOTE, BSE_MAX_NOTE))
#define	BSE_NOTE_Es(o)			(BSE_NOTE_Dis (o))
#define	BSE_NOTE_E(o)			(CLAMP (BSE_KAMMER_NOTE - 5 + ((o) - BSE_KAMMER_OCTAVE) * 12, BSE_MIN_NOTE, BSE_MAX_NOTE))
#define	BSE_NOTE_F(o)			(CLAMP (BSE_KAMMER_NOTE - 4 + ((o) - BSE_KAMMER_OCTAVE) * 12, BSE_MIN_NOTE, BSE_MAX_NOTE))
#define	BSE_NOTE_Fis(o)			(CLAMP (BSE_KAMMER_NOTE - 3 + ((o) - BSE_KAMMER_OCTAVE) * 12, BSE_MIN_NOTE, BSE_MAX_NOTE))
#define	BSE_NOTE_Ges(o)			(BSE_NOTE_Fis (o))
#define	BSE_NOTE_G(o)			(CLAMP (BSE_KAMMER_NOTE - 2 + ((o) - BSE_KAMMER_OCTAVE) * 12, BSE_MIN_NOTE, BSE_MAX_NOTE))
#define	BSE_NOTE_Gis(o)			(CLAMP (BSE_KAMMER_NOTE - 1 + ((o) - BSE_KAMMER_OCTAVE) * 12, BSE_MIN_NOTE, BSE_MAX_NOTE))
#define	BSE_NOTE_As(o)			(BSE_NOTE_Gis (o))
#define	BSE_NOTE_A(o)			(CLAMP (BSE_KAMMER_NOTE + 0 + ((o) - BSE_KAMMER_OCTAVE) * 12, BSE_MIN_NOTE, BSE_MAX_NOTE))
#define	BSE_NOTE_Ais(o)			(CLAMP (BSE_KAMMER_NOTE + 1 + ((o) - BSE_KAMMER_OCTAVE) * 12, BSE_MIN_NOTE, BSE_MAX_NOTE))
#define	BSE_NOTE_Bes(o)			(BSE_NOTE_Ais (o))
#define	BSE_NOTE_B(o)			(CLAMP (BSE_KAMMER_NOTE + 2 + ((o) - BSE_KAMMER_OCTAVE) * 12, BSE_MIN_NOTE, BSE_MAX_NOTE))
#define	BSE_NOTE_GENERIC(ht_i,o)	(BSE_NOTE_C(o)+(ht_i)-1 >= BSE_MIN_NOTE && BSE_NOTE_C(o)+(ht_i)-1 <= BSE_MAX_NOTE ? BSE_NOTE_C(o)+(ht_i)-1 : BSE_NOTE_VOID)
#define	BSE_NOTE_OCTAVE_UP(n)		((n)+12 <= BSE_MAX_NOTE && (n)+12 >= BSE_MIN_NOTE ? (n)+12 : (n))
#define	BSE_NOTE_OCTAVE_DOWN(n)		((n) >= BSE_MIN_NOTE+12 && (n)-12 <= BSE_MAX_NOTE ? (n)-12 : (n))


/* --- global variables --- */
extern	const guint	bse_version_major;
extern	const guint	bse_version_revision;
extern	const guint	bse_version_age;
extern	const guint	bse_bsw_version_major;
extern	const guint	bse_bsw_version_age;
extern	const gchar	*bse_version;
extern	const gchar	*bse_bsw_version;
extern	const gdouble	*bse_halftone_factor_table /* array of [BSE_MAX_NOTE] */;
extern	const guint	*bse_halftone_factor_table_fixed /* array of [BSE_MAX_NOTE] */;

/* FIXME: provide accessors for these values
 */
extern	guint		bse_default_bpm;


/* --- prototypes --- */
gboolean	bse_initialized		(void);
void		bse_init		(int	  *argc,
					 char	***argv);
guint		bse_get_obuffer_size	(void);
BseSample*      bse_get_zero_sample     (void);




#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_BASE_H__ */
