/* BEAST - Bedevilled Audio System
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BST_RC_H__
#define __BST_RC_H__

#include	<bse/bse.h>
#include	<gtk/gtk.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


typedef enum
{
  BST_RC_ZERO			=  0x00,
  BST_RC_FORCE_DUMP		=  1 << 0,
  BST_RC_AUTOMATIC		=  1 << 1,
  BST_RC_PREFERENCES		=  1 << 2,
  BST_RC_MASK			=  0x07
} BstRcFlags;

typedef enum
{
  BST_RC_NONE,
  BST_RC_BOOL,
  BST_RC_LONG,
  BST_RC_DOUBLE,
  BST_RC_STRING,
  BST_RC_STRING_LIST,
  BST_RC_CALLBACK,
  BST_RC_LAST
} BstRcType;

typedef struct _BstRcAny	BstRcAny;
typedef struct _BstRcBool	BstRcBool;
typedef struct _BstRcLong	BstRcLong;
typedef struct _BstRcDouble	BstRcDouble;
typedef struct _BstRcString	BstRcString;
typedef struct _BstRcStringList	BstRcStringList;
typedef	struct _BstRcCallback	BstRcCallback;
typedef union  _BstRcUnion	BstRcUnion;

struct _BstRcAny
{
  BstRcType	 type;
  gchar		*arg_name;
  BstRcFlags	 flags;
  gchar		*description;
};

struct _BstRcBool
{
  BstRcType	 type;
  gchar		*arg_name;
  BstRcFlags	 flags;
  gchar		*description;
  gboolean	 default_value;
  gboolean	 value;
};

struct _BstRcLong
{
  BstRcType	 type;
  gchar		*arg_name;
  BstRcFlags	 flags;
  gchar		*description;
  glong		 default_value;
  glong		 value;
  glong		 minimum;
  glong		 maximum;
};

struct _BstRcDouble
{
  BstRcType	 type;
  gchar		*arg_name;
  BstRcFlags	 flags;
  gchar		*description;
  gdouble	 default_value;
  gdouble	 value;
  gdouble	 minimum;
  gdouble	 maximum;
};

struct _BstRcString
{
  BstRcType	 type;
  gchar		*arg_name;
  BstRcFlags	 flags;
  gchar		*description;
  gchar		*default_value;
  gchar		*value;
};

struct _BstRcStringList
{
  BstRcType	 type;
  gchar		*arg_name;
  BstRcFlags	 flags;
  gchar		*description;
  GSList	*default_value;
  GSList	*value		/* may hold the pointer from default_value */;
};

struct _BstRcCallback
{
  BstRcType	 type;
  gchar		*arg_name;
  BstRcFlags	 flags;
  gchar		*description;
  gpointer	 data1	/* default value */;
  gpointer	 data2	/* value */;
  guint		(*parse_arg)	(GScanner         *,
				 BstRcCallback *);
  void		(*dump_arg)	(void          *stream,
				 BstRcCallback *,
				 gchar         *indent);
  gboolean	(*has_default)	(BstRcCallback *);
  gpointer	 data3	/* parse_arg data */;
  gpointer	 data4	/* dump_arg data */;
  gpointer	 data5	/* has_default data */;
};

union _BstRcUnion
{
  BstRcType		type;
  BstRcAny		any;
  BstRcBool		abool;
  BstRcLong		along;
  BstRcDouble		adouble;
  BstRcString		astring;
  BstRcStringList	astring_list;
  BstRcCallback		acallback;
};

void		bst_rc_add_arg	(BstRcUnion	*arg);
void		bst_rc_parse	(const gchar	*file_name);
void		bst_rc_dump	(const gchar	*prg_name,
				 const gchar	*file_name);
BstRcUnion*	bst_rc_get_arg	(const gchar	*arg_name);


/* helper definitions
 */
#define BST_RCARG_ITERATOR_ENUMS( type, name )  BST_RCIDX_##name,
#define BST_RCARG_ITERATOR_STRUC( type, name )  ((BstRcUnion*) (& bst_rc_arg_##name)),
#define BST_RCARG_DECLARATE( type, name )       BstRc##type     bst_rc_arg_##name
#define BST_RCVAL( type, arg_name )     ( \
  ((BstRc##type *) bst_rc_args[BST_RCIDX_##arg_name]) \
)



#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BST_RC_H__ */
