/* BEAST - Bedevilled Audio System
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BST_INSTRUMENT_EDITOR_H__
#define __BST_INSTRUMENT_EDITOR_H__


#include	<bse/bse.h>
#include	<gtk/gtk.h>



#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


/* --- type macros --- */
#define	BST_TYPE_INSTRUMENT_EDITOR		(bst_instrument_editor_get_type ())
#define	BST_INSTRUMENT_EDITOR(object)		(GTK_CHECK_CAST ((object), BST_TYPE_INSTRUMENT_EDITOR, BstInstrumentEditor))
#define	BST_INSTRUMENT_EDITOR_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), BST_TYPE_INSTRUMENT_EDITOR, BstInstrumentEditorClass))
#define	BST_IS_INSTRUMENT_EDITOR(object)	(GTK_CHECK_TYPE ((object), BST_TYPE_INSTRUMENT_EDITOR))
#define	BST_IS_INSTRUMENT_EDITOR_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), BST_TYPE_INSTRUMENT_EDITOR))


/* --- typedefs --- */
typedef struct _BstInstrumentEditor		BstInstrumentEditor;
typedef struct _BstInstrumentEditorClass	BstInstrumentEditorClass;


/* --- structures --- */
struct _BstInstrumentEditor
{
  GtkWindow	window;

  BseSong	*song;

  gint		current_row;

  guint		block_apply : 1;

  GtkCList	*clist_instruments;
  GtkWidget	*darea;

  /* instrument data
   */
  GtkEntry		*entry_name;
  GtkEntry		*entry_blurb;
  GtkEntry		*entry_combo;
  GtkList		*list_samples;
  GtkToggleButton	*toggle_interpolation;
  GtkToggleButton	*toggle_polyphony;
  GtkToggleButton	*toggle_sequencer_sustain;
  GtkAdjustment		*adj_volume;
  GtkAdjustment		*adj_balance;
  GtkAdjustment		*adj_transpose;
  GtkAdjustment		*adj_fine_tune;
  
  GtkAdjustment		*adj_delay_time;
  GtkAdjustment		*adj_attack_time;
  GtkAdjustment		*adj_attack_level;
  GtkAdjustment		*adj_decay_time;
  GtkAdjustment		*adj_sustain_level;
  GtkAdjustment		*adj_release_level;
  GtkAdjustment		*adj_sustain_time;
  GtkAdjustment		*adj_release_time;
};

struct _BstInstrumentEditorClass
{
  GtkWindowClass	parent_class;

  gchar                 *factories_path;
  GtkObject             *ilist_popup_factory;
};


/* instrument editor actions of bst_instrument_editor_operation()
 */
typedef enum
{
  BST_INSTRUMENT_EDITOR_OP_NONE,

  /* instrument operations
   */
  BST_INSTRUMENT_EDITOR_OP_INSTR_NEW,
  BST_INSTRUMENT_EDITOR_OP_INSTR_DEL,

  BST_INSTRUMENT_EDITOR_OP_LAST
} BstInstrumentEditorClassOps;


/* --- prototypes --- */
GtkType	   bst_instrument_editor_get_type (void);
GtkWidget* bst_instrument_editor_new	  (BseSong		      *song);
void	   bst_instrument_editor_reload	  (BstInstrumentEditor	      *inst_ed);
void       bst_instrument_editor_clop	  (BstInstrumentEditorClass   *klass,
					   BstInstrumentEditorClassOps ined_op);

     






#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif	/* __BST_INSTRUMENT_EDITOR_H__ */
