/* BEAST - Bedevilled Audio System
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BST_DIALOGS_H__
#define __BST_DIALOGS_H__

#include	<bse/bse.h>
#include	<gtk/gtk.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */







GtkWidget*	bst_new_hseperator (GtkWidget   *parent);
GtkWidget*	bst_new_vseperator (GtkWidget   *parent);
GtkWidget*	bst_new_label	 (GtkWidget     *parent,
				  const gchar   *label);
GtkWidget*	bst_new_entry	 (GtkWidget     *parent,
				  GtkWidget     *activate_window);
GtkWidget*	bst_new_spinner  (GtkWidget	*parent,
				  GtkAdjustment **adj,
				  gint  	init_value,
				  gint  	lower,
				  gint  	upper,
				  gint  	page_increment);
GtkWidget*	bst_new_spinner_s(GtkWidget	*parent,
				  GtkAdjustment **adj,
				  gint  	init_value,
				  gint  	lower,
				  gint  	upper,
				  gint  	page_increment,
				  gpointer	value_changed_cb,
				  gpointer	cb_data);
GtkWidget*	bst_new_spinner_os(GtkWidget	*parent,
				   GtkAdjustment **adj,
				   gint  	init_value,
				   gint  	lower,
				   gint  	upper,
				   gint  	page_increment,
				   gpointer	value_changed_cb,
				   gpointer	cb_data);
GtkWidget*	bst_new_toggle	(GtkWidget	*parent,
				 const gchar	*label,
				 gboolean	 active);
GtkWidget*	bst_new_toggle_os(GtkWidget	*parent,
				  const gchar	*label,
				  gboolean	 active,
				  gpointer	 clicked_cb,
				  gpointer	 cb_data);
GtkWidget*	bst_new_hbox	(GtkWidget	*parent,
				 gboolean	 homogenous,
				 guint		 spacing,
				 guint		 border_width,
				 gboolean	 self_expand,
				 guint		 expand_index,
				 ...);
GtkWidget*	bst_new_vbox	(GtkWidget	*parent,
				 gboolean	 homogenous,
				 guint		 spacing,
				 guint		 border_width,
				 gboolean	 self_expand,
				 guint		 expand_index,
				 ...);
GtkWidget*	bst_new_hframe	(GtkWidget	*parent,
				 const gchar	*label,
				 gboolean	 self_expand,
				 guint		 expand_index,
				 ...);
GtkWidget*	bst_new_vframe	(GtkWidget	*parent,
				 const gchar	*label,
				 gboolean	 self_expand,
				 guint		 expand_index,
				 ...);
GtkWidget*	bst_new_darea_s (GtkWidget      *parent,
				 gboolean        expand,
				 gint            uwidth,
				 gint            uheight,
				 gpointer        draw_data,
				 gpointer        expose_cb,
				 gpointer        cb_data);
GtkWidget*	bst_new_darea   (GtkWidget      *parent,
				 gboolean        expand,
				 gint            uwidth,
				 gint            uheight,
				 gpointer        draw_data);
     
     


#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BST_DIALOGS_H__ */
