/*******************************************************************************
 *
 *  Rate Tables for PROATM-155 and PROATM-25 ATM Cards
 *
 *******************************************************************************
 *
 *
 *  Date: 26-06-2003
 *  Version: 1.06
 *
 * $FreeBSD: stable/4/sys/dev/proatm/proatm_rtbl.c 117885 2003-07-22 11:53:20Z harti $
 */

/*
 *  Rate tables for 155.52 Mbps adapters
 */ 

u_int32_t abr_vbr_rate_tables_155Mb[] = { 

/* Rate Converstion Table */
  /* rate,             cps bits:31-17, nrm bits:16-14, interval bits:13-0  */
  /* 000 */ 0x8d022e27, /* cps = 10.015625, nrm = 3, interval = 35264.000000 */
  /* 001 */ 0x8d362e11, /* cps = 10.421875, nrm = 3, interval = 33856.000000 */
  /* 002 */ 0x8d6e2bf8, /* cps = 10.859375, nrm = 3, interval = 32512.000000 */
  /* 003 */ 0x8da82bcf, /* cps = 11.312500, nrm = 3, interval = 31200.000000 */
  /* 004 */ 0x8de42ba8, /* cps = 11.781250, nrm = 3, interval = 29952.000000 */
  /* 005 */ 0x8e222b83, /* cps = 12.265625, nrm = 3, interval = 28768.000000 */
  /* 006 */ 0x8e662b5e, /* cps = 12.796875, nrm = 3, interval = 27584.000000 */
  /* 007 */ 0x8eaa2b3c, /* cps = 13.328125, nrm = 3, interval = 26496.000000 */
  /* 008 */ 0x8ef22b1a, /* cps = 13.890625, nrm = 3, interval = 25408.000000 */
  /* 009 */ 0x8f3e2afa, /* cps = 14.484375, nrm = 3, interval = 24384.000000 */
  /* 010 */ 0x8f8a2adc, /* cps = 15.078125, nrm = 3, interval = 23424.000000 */
  /* 011 */ 0x8fdc2abe, /* cps = 15.718750, nrm = 3, interval = 22464.000000 */
  /* 012 */ 0x90182aa2, /* cps = 16.375000, nrm = 3, interval = 21568.000000 */
  /* 013 */ 0x90422a87, /* cps = 17.031250, nrm = 3, interval = 20704.000000 */
  /* 014 */ 0x90702a6d, /* cps = 17.750000, nrm = 3, interval = 19872.000000 */
  /* 015 */ 0x90a02a54, /* cps = 18.500000, nrm = 3, interval = 19072.000000 */
  /* 016 */ 0x90d22a3c, /* cps = 19.281250, nrm = 3, interval = 18304.000000 */
  /* 017 */ 0x91062a25, /* cps = 20.093750, nrm = 3, interval = 17568.000000 */
  /* 018 */ 0x913c2a0f, /* cps = 20.937500, nrm = 3, interval = 16864.000000 */
  /* 019 */ 0x917427f4, /* cps = 21.812500, nrm = 3, interval = 16192.000000 */
  /* 020 */ 0x91ae27cb, /* cps = 22.718750, nrm = 3, interval = 15536.000000 */
  /* 021 */ 0x91ea27a4, /* cps = 23.656250, nrm = 3, interval = 14912.000000 */
  /* 022 */ 0x922a277f, /* cps = 24.656250, nrm = 3, interval = 14320.000000 */
  /* 023 */ 0x926c275b, /* cps = 25.687500, nrm = 3, interval = 13744.000000 */
  /* 024 */ 0x92b22738, /* cps = 26.781250, nrm = 3, interval = 13184.000000 */
  /* 025 */ 0x92fa2717, /* cps = 27.906250, nrm = 3, interval = 12656.000000 */
  /* 026 */ 0x934426f7, /* cps = 29.062500, nrm = 3, interval = 12144.000000 */
  /* 027 */ 0x939226d9, /* cps = 30.281250, nrm = 3, interval = 11664.000000 */
  /* 028 */ 0x93e426bb, /* cps = 31.562500, nrm = 3, interval = 11184.000000 */
  /* 029 */ 0x941c269f, /* cps = 32.875000, nrm = 3, interval = 10736.000000 */
  /* 030 */ 0x94482684, /* cps = 34.250000, nrm = 3, interval = 10304.000000 */
  /* 031 */ 0x9476266a, /* cps = 35.687500, nrm = 3, interval = 9888.000000 */
  /* 032 */ 0x94a62651, /* cps = 37.187500, nrm = 3, interval = 9488.000000 */
  /* 033 */ 0x94d82639, /* cps = 38.750000, nrm = 3, interval = 9104.000000 */
  /* 034 */ 0x950a6623, /* cps = 40.312500, nrm = 4, interval = 8752.000000 */
  /* 035 */ 0x9540660d, /* cps = 42.000000, nrm = 4, interval = 8400.000000 */
  /* 036 */ 0x957a63ef, /* cps = 43.812500, nrm = 4, interval = 8056.000000 */
  /* 037 */ 0x95b463c7, /* cps = 45.625000, nrm = 4, interval = 7736.000000 */
  /* 038 */ 0x95f263a0, /* cps = 47.562500, nrm = 4, interval = 7424.000000 */
  /* 039 */ 0x9630637b, /* cps = 49.500000, nrm = 4, interval = 7128.000000 */
  /* 040 */ 0x96746357, /* cps = 51.625000, nrm = 4, interval = 6840.000000 */
  /* 041 */ 0x96b86335, /* cps = 53.750000, nrm = 4, interval = 6568.000000 */
  /* 042 */ 0x97006314, /* cps = 56.000000, nrm = 4, interval = 6304.000000 */
  /* 043 */ 0x974c62f4, /* cps = 58.375000, nrm = 4, interval = 6048.000000 */
  /* 044 */ 0x979c62d5, /* cps = 60.875000, nrm = 4, interval = 5800.000000 */
  /* 045 */ 0x97ec62b8, /* cps = 63.375000, nrm = 4, interval = 5568.000000 */
  /* 046 */ 0x9820629c, /* cps = 66.000000, nrm = 4, interval = 5344.000000 */
  /* 047 */ 0x984e6281, /* cps = 68.875000, nrm = 4, interval = 5128.000000 */
  /* 048 */ 0x987a6268, /* cps = 71.625000, nrm = 4, interval = 4928.000000 */
  /* 049 */ 0x98aa624f, /* cps = 74.625000, nrm = 4, interval = 4728.000000 */
  /* 050 */ 0x98dc6237, /* cps = 77.750000, nrm = 4, interval = 4536.000000 */
  /* 051 */ 0x9912a220, /* cps = 81.125000, nrm = 8, interval = 4352.000000 */
  /* 052 */ 0x9948a20a, /* cps = 84.500000, nrm = 8, interval = 4176.000000 */
  /* 053 */ 0x99809feb, /* cps = 88.000000, nrm = 8, interval = 4012.000000 */
  /* 054 */ 0x99ba9fc3, /* cps = 91.625000, nrm = 8, interval = 3852.000000 */
  /* 055 */ 0x99f89f9c, /* cps = 95.500000, nrm = 8, interval = 3696.000000 */
  /* 056 */ 0x9a389f77, /* cps = 99.500000, nrm = 8, interval = 3548.000000 */
  /* 057 */ 0x9a7c9f53, /* cps = 103.750000, nrm = 8, interval = 3404.000000 */
  /* 058 */ 0x9ac09f31, /* cps = 108.000000, nrm = 8, interval = 3268.000000 */
  /* 059 */ 0x9b0a9f10, /* cps = 112.625000, nrm = 8, interval = 3136.000000 */
  /* 060 */ 0x9b549ef1, /* cps = 117.250000, nrm = 8, interval = 3012.000000 */
  /* 061 */ 0x9ba49ed2, /* cps = 122.250000, nrm = 8, interval = 2888.000000 */
  /* 062 */ 0x9bf69eb5, /* cps = 127.375000, nrm = 8, interval = 2772.000000 */
  /* 063 */ 0x9c269e99, /* cps = 132.750000, nrm = 8, interval = 2660.000000 */
  /* 064 */ 0x9c509e7f, /* cps = 138.000000, nrm = 8, interval = 2556.000000 */
  /* 065 */ 0x9c809e65, /* cps = 144.000000, nrm = 8, interval = 2452.000000 */
  /* 066 */ 0x9cb09e4c, /* cps = 150.000000, nrm = 8, interval = 2352.000000 */
  /* 067 */ 0x9ce29e35, /* cps = 156.250000, nrm = 8, interval = 2260.000000 */
  /* 068 */ 0x9d16de1e, /* cps = 162.750000, nrm = 16, interval = 2168.000000 */
  /* 069 */ 0x9d4ede08, /* cps = 169.750000, nrm = 16, interval = 2080.000000 */
  /* 070 */ 0x9d86dbe7, /* cps = 176.750000, nrm = 16, interval = 1998.000000 */
  /* 071 */ 0x9dc0dbbf, /* cps = 184.000000, nrm = 16, interval = 1918.000000 */
  /* 072 */ 0x9dfedb98, /* cps = 191.750000, nrm = 16, interval = 1840.000000 */
  /* 073 */ 0x9e40db73, /* cps = 200.000000, nrm = 16, interval = 1766.000000 */
  /* 074 */ 0x9e84db4f, /* cps = 208.500000, nrm = 16, interval = 1694.000000 */
  /* 075 */ 0x9ec8db2d, /* cps = 217.000000, nrm = 16, interval = 1626.000000 */
  /* 076 */ 0x9f10db0d, /* cps = 226.000000, nrm = 16, interval = 1562.000000 */
  /* 077 */ 0x9f5edaed, /* cps = 235.750000, nrm = 16, interval = 1498.000000 */
  /* 078 */ 0x9facdacf, /* cps = 245.500000, nrm = 16, interval = 1438.000000 */
  /* 079 */ 0x9ffedab2, /* cps = 255.750000, nrm = 16, interval = 1380.000000 */
  /* 080 */ 0xa02ada96, /* cps = 266.500000, nrm = 16, interval = 1324.000000 */
  /* 081 */ 0xa056da7c, /* cps = 277.500000, nrm = 16, interval = 1272.000000 */
  /* 082 */ 0xa086da62, /* cps = 289.500000, nrm = 16, interval = 1220.000000 */
  /* 083 */ 0xa0b4da4a, /* cps = 301.000000, nrm = 16, interval = 1172.000000 */
  /* 084 */ 0xa0e8da32, /* cps = 314.000000, nrm = 16, interval = 1124.000000 */
  /* 085 */ 0xa11f1a1b, /* cps = 327.500000, nrm = 32, interval = 1078.000000 */
  /* 086 */ 0xa1531a06, /* cps = 340.500000, nrm = 32, interval = 1036.000000 */
  /* 087 */ 0xa18d17e2, /* cps = 355.000000, nrm = 32, interval = 994.000000 */
  /* 088 */ 0xa1c917ba, /* cps = 370.000000, nrm = 32, interval = 954.000000 */
  /* 089 */ 0xa2071794, /* cps = 385.500000, nrm = 32, interval = 916.000000 */
  /* 090 */ 0xa247176f, /* cps = 401.500000, nrm = 32, interval = 879.000000 */
  /* 091 */ 0xa289174c, /* cps = 418.000000, nrm = 32, interval = 844.000000 */
  /* 092 */ 0xa2d1172a, /* cps = 436.000000, nrm = 32, interval = 810.000000 */
  /* 093 */ 0xa31b1709, /* cps = 454.500000, nrm = 32, interval = 777.000000 */
  /* 094 */ 0xa36516ea, /* cps = 473.000000, nrm = 32, interval = 746.000000 */
  /* 095 */ 0xa3b516cc, /* cps = 493.000000, nrm = 32, interval = 716.000000 */
  /* 096 */ 0xa40516af, /* cps = 514.000000, nrm = 32, interval = 687.000000 */
  /* 097 */ 0xa42f1694, /* cps = 535.000000, nrm = 32, interval = 660.000000 */
  /* 098 */ 0xa45b1679, /* cps = 557.000000, nrm = 32, interval = 633.000000 */
  /* 099 */ 0xa4891660, /* cps = 580.000000, nrm = 32, interval = 608.000000 */
  /* 100 */ 0xa4bb1647, /* cps = 605.000000, nrm = 32, interval = 583.000000 */
  /* 101 */ 0xa4ed1630, /* cps = 630.000000, nrm = 32, interval = 560.000000 */
  /* 102 */ 0xa5231619, /* cps = 657.000000, nrm = 32, interval = 537.000000 */
  /* 103 */ 0xa55b1603, /* cps = 685.000000, nrm = 32, interval = 515.000000 */
  /* 104 */ 0xa59313de, /* cps = 713.000000, nrm = 32, interval = 495.000000 */
  /* 105 */ 0xa5cf13b6, /* cps = 743.000000, nrm = 32, interval = 475.000000 */
  /* 106 */ 0xa60d1390, /* cps = 774.000000, nrm = 32, interval = 456.000000 */
  /* 107 */ 0xa64f136b, /* cps = 807.000000, nrm = 32, interval = 437.500000 */
  /* 108 */ 0xa6911348, /* cps = 840.000000, nrm = 32, interval = 420.000000 */
  /* 109 */ 0xa6d91326, /* cps = 876.000000, nrm = 32, interval = 403.000000 */
  /* 110 */ 0xa7211306, /* cps = 912.000000, nrm = 32, interval = 387.000000 */
  /* 111 */ 0xa76d12e7, /* cps = 950.000000, nrm = 32, interval = 371.500000 */
  /* 112 */ 0xa7bd12c9, /* cps = 990.000000, nrm = 32, interval = 356.500000 */
  /* 113 */ 0xa80912ac, /* cps = 1032.000000, nrm = 32, interval = 342.000000 */
  /* 114 */ 0xa8331291, /* cps = 1074.000000, nrm = 32, interval = 328.500000 */
  /* 115 */ 0xa8611276, /* cps = 1120.000000, nrm = 32, interval = 315.000000 */
  /* 116 */ 0xa88f125d, /* cps = 1166.000000, nrm = 32, interval = 302.500000 */
  /* 117 */ 0xa8bf1245, /* cps = 1214.000000, nrm = 32, interval = 290.500000 */
  /* 118 */ 0xa8f5122d, /* cps = 1268.000000, nrm = 32, interval = 278.500000 */
  /* 119 */ 0xa9291217, /* cps = 1320.000000, nrm = 32, interval = 267.500000 */
  /* 120 */ 0xa9611201, /* cps = 1376.000000, nrm = 32, interval = 256.500000 */
  /* 121 */ 0xa9990fda, /* cps = 1432.000000, nrm = 32, interval = 246.500000 */
  /* 122 */ 0xa9d50fb2, /* cps = 1492.000000, nrm = 32, interval = 236.500000 */
  /* 123 */ 0xaa130f8c, /* cps = 1554.000000, nrm = 32, interval = 227.000000 */
  /* 124 */ 0xaa570f67, /* cps = 1622.000000, nrm = 32, interval = 217.750000 */
  /* 125 */ 0xaa990f44, /* cps = 1688.000000, nrm = 32, interval = 209.000000 */
  /* 126 */ 0xaadf0f23, /* cps = 1758.000000, nrm = 32, interval = 200.750000 */
  /* 127 */ 0xab2b0f02, /* cps = 1834.000000, nrm = 32, interval = 192.500000 */
  /* 128 */ 0xab770ee3, /* cps = 1910.000000, nrm = 32, interval = 184.750000 */
  /* 129 */ 0xabc50ec6, /* cps = 1988.000000, nrm = 32, interval = 177.500000 */
  /* 130 */ 0xac0d0ea9, /* cps = 2072.000000, nrm = 32, interval = 170.250000 */
  /* 131 */ 0xac390e8e, /* cps = 2160.000000, nrm = 32, interval = 163.500000 */
  /* 132 */ 0xac670e73, /* cps = 2252.000000, nrm = 32, interval = 156.750000 */
  /* 133 */ 0xac950e5a, /* cps = 2344.000000, nrm = 32, interval = 150.500000 */
  /* 134 */ 0xacc70e42, /* cps = 2444.000000, nrm = 32, interval = 144.500000 */
  /* 135 */ 0xacf90e2b, /* cps = 2544.000000, nrm = 32, interval = 138.750000 */
  /* 136 */ 0xad2f0e14, /* cps = 2652.000000, nrm = 32, interval = 133.000000 */
  /* 137 */ 0xad650bff, /* cps = 2760.000000, nrm = 32, interval = 127.875000 */
  /* 138 */ 0xada10bd5, /* cps = 2880.000000, nrm = 32, interval = 122.625000 */
  /* 139 */ 0xaddb0bae, /* cps = 2996.000000, nrm = 32, interval = 117.750000 */
  /* 140 */ 0xae1b0b88, /* cps = 3124.000000, nrm = 32, interval = 113.000000 */
  /* 141 */ 0xae5b0b64, /* cps = 3252.000000, nrm = 32, interval = 108.500000 */
  /* 142 */ 0xaea10b41, /* cps = 3392.000000, nrm = 32, interval = 104.125000 */
  /* 143 */ 0xaee90b1f, /* cps = 3536.000000, nrm = 32, interval = 99.875000 */
  /* 144 */ 0xaf330aff, /* cps = 3684.000000, nrm = 32, interval = 95.875000 */
  /* 145 */ 0xaf7f0ae0, /* cps = 3836.000000, nrm = 32, interval = 92.000000 */
  /* 146 */ 0xafcf0ac3, /* cps = 3996.000000, nrm = 32, interval = 88.375000 */
  /* 147 */ 0xb0110aa6, /* cps = 4160.000000, nrm = 32, interval = 84.750000 */
  /* 148 */ 0xb03d0a8b, /* cps = 4336.000000, nrm = 32, interval = 81.375000 */
  /* 149 */ 0xb06b0a71, /* cps = 4520.000000, nrm = 32, interval = 78.125000 */
  /* 150 */ 0xb0990a58, /* cps = 4704.000000, nrm = 32, interval = 75.000000 */
  /* 151 */ 0xb0cd0a3f, /* cps = 4912.000000, nrm = 32, interval = 71.875000 */
  /* 152 */ 0xb0ff0a28, /* cps = 5112.000000, nrm = 32, interval = 69.000000 */
  /* 153 */ 0xb1350a12, /* cps = 5328.000000, nrm = 32, interval = 66.250000 */
  /* 154 */ 0xb16b07fa, /* cps = 5544.000000, nrm = 32, interval = 63.625000 */
  /* 155 */ 0xb1a707d1, /* cps = 5784.000000, nrm = 32, interval = 61.062500 */
  /* 156 */ 0xb1e307aa, /* cps = 6024.000000, nrm = 32, interval = 58.625000 */
  /* 157 */ 0xb2210784, /* cps = 6272.000000, nrm = 32, interval = 56.250000 */
  /* 158 */ 0xb2630760, /* cps = 6536.000000, nrm = 32, interval = 54.000000 */
  /* 159 */ 0xb2a9073d, /* cps = 6816.000000, nrm = 32, interval = 51.812500 */
  /* 160 */ 0xb2ef071c, /* cps = 7096.000000, nrm = 32, interval = 49.750000 */
  /* 161 */ 0xb33906fc, /* cps = 7392.000000, nrm = 32, interval = 47.750000 */
  /* 162 */ 0xb38706dd, /* cps = 7704.000000, nrm = 32, interval = 45.812500 */
  /* 163 */ 0xb3d706c0, /* cps = 8024.000000, nrm = 32, interval = 44.000000 */
  /* 164 */ 0xb41706a3, /* cps = 8368.000000, nrm = 32, interval = 42.187500 */
  /* 165 */ 0xb4430688, /* cps = 8720.000000, nrm = 32, interval = 40.500000 */
  /* 166 */ 0xb46f066e, /* cps = 9072.000000, nrm = 32, interval = 38.875000 */
  /* 167 */ 0xb49f0655, /* cps = 9456.000000, nrm = 32, interval = 37.312500 */
  /* 168 */ 0xb4d1063d, /* cps = 9856.000000, nrm = 32, interval = 35.812500 */
  /* 169 */ 0xb5050626, /* cps = 10272.000000, nrm = 32, interval = 34.375000 */
  /* 170 */ 0xb5390610, /* cps = 10688.000000, nrm = 32, interval = 33.000000 */
  /* 171 */ 0xb57103f6, /* cps = 11136.000000, nrm = 32, interval = 31.687500 */
  /* 172 */ 0xb5ad03cd, /* cps = 11616.000000, nrm = 32, interval = 30.406250 */
  /* 173 */ 0xb5e903a6, /* cps = 12096.000000, nrm = 32, interval = 29.187500 */
  /* 174 */ 0xb6290380, /* cps = 12608.000000, nrm = 32, interval = 28.000000 */
  /* 175 */ 0xb66b035c, /* cps = 13136.000000, nrm = 32, interval = 26.875000 */
  /* 176 */ 0xb6af033a, /* cps = 13680.000000, nrm = 32, interval = 25.812500 */
  /* 177 */ 0xb6f70318, /* cps = 14256.000000, nrm = 32, interval = 24.750000 */
  /* 178 */ 0xb74302f8, /* cps = 14864.000000, nrm = 32, interval = 23.750000 */
  /* 179 */ 0xb78f02da, /* cps = 15472.000000, nrm = 32, interval = 22.812500 */
  /* 180 */ 0xb7e302bc, /* cps = 16144.000000, nrm = 32, interval = 21.875000 */
  /* 181 */ 0xb81b02a0, /* cps = 16800.000000, nrm = 32, interval = 21.000000 */
  /* 182 */ 0xb8470285, /* cps = 17504.000000, nrm = 32, interval = 20.156250 */
  /* 183 */ 0xb875026b, /* cps = 18240.000000, nrm = 32, interval = 19.343750 */
  /* 184 */ 0xb8a50252, /* cps = 19008.000000, nrm = 32, interval = 18.562500 */
  /* 185 */ 0xb8d7023a, /* cps = 19808.000000, nrm = 32, interval = 17.812500 */
  /* 186 */ 0xb9090224, /* cps = 20608.000000, nrm = 32, interval = 17.125000 */
  /* 187 */ 0xb941020d, /* cps = 21504.000000, nrm = 32, interval = 16.406250 */
  /* 188 */ 0xb97901f8, /* cps = 22400.000000, nrm = 32, interval = 15.750000 */
  /* 189 */ 0xb9b301e4, /* cps = 23328.000000, nrm = 32, interval = 15.125000 */
  /* 190 */ 0xb9ef01d1, /* cps = 24288.000000, nrm = 32, interval = 14.531250 */
  /* 191 */ 0xba2f01be, /* cps = 25312.000000, nrm = 32, interval = 13.937500 */
  /* 192 */ 0xba7301ac, /* cps = 26400.000000, nrm = 32, interval = 13.375000 */
  /* 193 */ 0xbab7019b, /* cps = 27488.000000, nrm = 32, interval = 12.843750 */
  /* 194 */ 0xbb01018a, /* cps = 28672.000000, nrm = 32, interval = 12.312500 */
  /* 195 */ 0xbb4d017a, /* cps = 29888.000000, nrm = 32, interval = 11.812500 */
  /* 196 */ 0xbb9b016b, /* cps = 31136.000000, nrm = 32, interval = 11.343750 */
  /* 197 */ 0xbbed015c, /* cps = 32448.000000, nrm = 32, interval = 10.875000 */
  /* 198 */ 0xbc21014e, /* cps = 33792.000000, nrm = 32, interval = 10.437500 */
  /* 199 */ 0xbc4d0141, /* cps = 35200.000000, nrm = 32, interval = 10.031250 */
  /* 200 */ 0xbc7b0134, /* cps = 36672.000000, nrm = 32, interval = 9.625000 */
  /* 201 */ 0xbca90128, /* cps = 38144.000000, nrm = 32, interval = 9.250000 */
  /* 202 */ 0xbcdb011c, /* cps = 39744.000000, nrm = 32, interval = 8.875000 */
  /* 203 */ 0xbd130110, /* cps = 41536.000000, nrm = 32, interval = 8.500000 */
  /* 204 */ 0xbd490105, /* cps = 43264.000000, nrm = 32, interval = 8.156250 */
  /* 205 */ 0xbd7f00fb, /* cps = 44992.000000, nrm = 32, interval = 7.843750 */
  /* 206 */ 0xbdb900f1, /* cps = 46848.000000, nrm = 32, interval = 7.531250 */
  /* 207 */ 0xbdf900e7, /* cps = 48896.000000, nrm = 32, interval = 7.218750 */
  /* 208 */ 0xbe3700de, /* cps = 50880.000000, nrm = 32, interval = 6.937500 */
  /* 209 */ 0xbe7b00d5, /* cps = 53056.000000, nrm = 32, interval = 6.656250 */
  /* 210 */ 0xbec300cc, /* cps = 55360.000000, nrm = 32, interval = 6.375000 */
  /* 211 */ 0xbf0b00c4, /* cps = 57664.000000, nrm = 32, interval = 6.125000 */
  /* 212 */ 0xbf5700bc, /* cps = 60096.000000, nrm = 32, interval = 5.875000 */
  /* 213 */ 0xbf9f00b5, /* cps = 62400.000000, nrm = 32, interval = 5.656250 */
  /* 214 */ 0xbff900ad, /* cps = 65280.000000, nrm = 32, interval = 5.406250 */
  /* 215 */ 0xc02700a6, /* cps = 67968.000000, nrm = 32, interval = 5.187500 */
  /* 216 */ 0xc04f00a0, /* cps = 70528.000000, nrm = 32, interval = 5.000000 */
  /* 217 */ 0xc0830099, /* cps = 73856.000000, nrm = 32, interval = 4.781250 */
  /* 218 */ 0xc0b10093, /* cps = 76800.000000, nrm = 32, interval = 4.593750 */
  /* 219 */ 0xc0e5008d, /* cps = 80128.000000, nrm = 32, interval = 4.406250 */
  /* 220 */ 0xc11d0087, /* cps = 83712.000000, nrm = 32, interval = 4.218750 */
  /* 221 */ 0xc14f0082, /* cps = 86912.000000, nrm = 32, interval = 4.062500 */
  /* 222 */ 0xc185007d, /* cps = 90368.000000, nrm = 32, interval = 3.906250 */
  /* 223 */ 0xc1bf0078, /* cps = 94080.000000, nrm = 32, interval = 3.750000 */
  /* 224 */ 0xc1ff0073, /* cps = 98176.000000, nrm = 32, interval = 3.593750 */
  /* 225 */ 0xc245006e, /* cps = 102656.000000, nrm = 32, interval = 3.437500 */
  /* 226 */ 0xc283006a, /* cps = 106624.000000, nrm = 32, interval = 3.312500 */
  /* 227 */ 0xc2d50065, /* cps = 111872.000000, nrm = 32, interval = 3.156250 */
  /* 228 */ 0xc31d0061, /* cps = 116480.000000, nrm = 32, interval = 3.031250 */
  /* 229 */ 0xc36b005d, /* cps = 121472.000000, nrm = 32, interval = 2.906250 */
  /* 230 */ 0xc3ab005a, /* cps = 125568.000000, nrm = 32, interval = 2.812500 */
  /* 231 */ 0xc4030056, /* cps = 131328.000000, nrm = 32, interval = 2.687500 */
  /* 232 */ 0xc4270053, /* cps = 135936.000000, nrm = 32, interval = 2.593750 */
  /* 233 */ 0xc45d004f, /* cps = 142848.000000, nrm = 32, interval = 2.468750 */
  /* 234 */ 0xc489004c, /* cps = 148480.000000, nrm = 32, interval = 2.375000 */
  /* 235 */ 0xc4b90049, /* cps = 154624.000000, nrm = 32, interval = 2.281250 */
  /* 236 */ 0xc4ed0046, /* cps = 161280.000000, nrm = 32, interval = 2.187500 */
  /* 237 */ 0xc5250043, /* cps = 168448.000000, nrm = 32, interval = 2.093750 */
  /* 238 */ 0xc5630040, /* cps = 176384.000000, nrm = 32, interval = 2.000000 */
  /* 239 */ 0xc591003e, /* cps = 182272.000000, nrm = 32, interval = 1.937500 */
  /* 240 */ 0xc5d9003b, /* cps = 191488.000000, nrm = 32, interval = 1.843750 */
  /* 241 */ 0xc60d0039, /* cps = 198144.000000, nrm = 32, interval = 1.781250 */
  /* 242 */ 0xc6450037, /* cps = 205312.000000, nrm = 32, interval = 1.718750 */
  /* 243 */ 0xc6a30034, /* cps = 217344.000000, nrm = 32, interval = 1.625000 */
  /* 244 */ 0xc6e70032, /* cps = 226048.000000, nrm = 32, interval = 1.562500 */
  /* 245 */ 0xc72f0030, /* cps = 235264.000000, nrm = 32, interval = 1.500000 */
  /* 246 */ 0xc77f002e, /* cps = 245504.000000, nrm = 32, interval = 1.437500 */
  /* 247 */ 0xc7d7002c, /* cps = 256768.000000, nrm = 32, interval = 1.375000 */
  /* 248 */ 0xc803002b, /* cps = 262656.000000, nrm = 32, interval = 1.343750 */
  /* 249 */ 0xc8350029, /* cps = 275456.000000, nrm = 32, interval = 1.281250 */
  /* 250 */ 0xc86d0027, /* cps = 289792.000000, nrm = 32, interval = 1.218750 */
  /* 251 */ 0xc8890026, /* cps = 296960.000000, nrm = 32, interval = 1.187500 */
  /* 252 */ 0xc8cb0024, /* cps = 313856.000000, nrm = 32, interval = 1.125000 */
  /* 253 */ 0xc8ed0023, /* cps = 322560.000000, nrm = 32, interval = 1.093750 */
  /* 254 */ 0xc9390021, /* cps = 342016.000000, nrm = 32, interval = 1.031250 */
  /* 255 */ 0xc9630020, /* cps = 352768.000000, nrm = 32, interval = 1.000000 */

/* rate2log table */
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x03020100, 0x07060504, 0x0A090908,
 0x0F0E0C0B, 0x14131210, 0x18171615, 0x1B1A1919,
 0x201F1C1C, 0x25242221, 0x29282726, 0x2C2B2A29,
 0x31302E2D, 0x36343332, 0x39393837, 0x3D3C3B3A,
 0x42403F3E, 0x46454443, 0x4A494848, 0x4E4D4C4B,
 0x5351504F, 0x57565554, 0x5B5A5958, 0x5C5D5E5F,
 0x6462615F, 0x68676665, 0x6C6B6A69, 0x706F6F6E,
 0x75737270, 0x79787776, 0x7D7C7B7A, 0x80807F7E,
 0x85848381, 0x8A898887, 0x8E8D8C8B, 0x8F909191,
 0x96959492, 0x9B9A9998, 0x9F9E9D9C, 0xA2A1A1A0,
 0xA7A6A4A3, 0XACABAAA8, 0XB0AFAEAD, 0xB3B2B1B1,
 0xB8B7B5B4, 0xBDBCBAB9, 0xC1C0BFBE, 0xC4C3C2C1,
 0xC9C8C6C5, 0xCECDCBCA, 0xD1D1D0CF, 0xD5D4D3D2,
 0xDAD8D7D6, 0xDFDDDCDB, 0xE2E1E0E0, 0xE6E5E4E3,
 0xEBE9E8E6, 0xEFEEEDEC, 0xF3F2F1F0, 0xF6F6F5F4,
 0xFBFAF9F7, 0xFFFFFEFD, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,

/* sram_globals*/
 0x000064B1, 0x000062B1, 0x000160B1, 0x00015EB1,
 0x00035AB1, 0x000354B1, 0x00030000, 0x00030000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,

 /* air table 0*/
  0x3BF83BFC, 0x3BF03BF4, 0x3BE93BEC, 0x3BE03BE4,
  0x3BD83BDC, 0x3BD03BD4, 0x3BC93BCC, 0x3BC03BC4,
  0x3BB83BBC, 0x3BB03BB4, 0x3BA83BAC, 0x3BA03BA4,
  0x3B983B9C, 0x3B903B94, 0x3B883B8C, 0x3B803B84,
  0x3B783B7C, 0x3B713B75, 0x3B683B6C, 0x3B613B64,
  0x3B583B5C, 0x3B503B54, 0x3B483B4C, 0x3B403B44,
  0x3B383B3C, 0x3B303B34, 0x3B283B2C, 0x3B203B24,
  0x3B183B1C, 0x3B103B14, 0x3B083B0C, 0x3B003B04,
  0x3AF83AFD, 0x3AF03AF4, 0x3AE83AEC, 0x3AE13AE4,
  0x3AD83ADC, 0x3AD03AD4, 0x3AC83ACC, 0x3AC03AC4,
  0x3AB83ABC, 0x3AB13AB4, 0x3AA83AAC, 0x3AA03AA5,
  0x3A983A9C, 0x3A913A94, 0x3A883A8C, 0x3A803A84,
  0x3A783A7C, 0x3A713A75, 0x3A693A6C, 0x3A603A64,
  0x3A583A5C, 0x3A503A54, 0x3A483A4C, 0x3A403A44,
  0x3A383A3C, 0x3A303A35, 0x3A293A2D, 0x3A203A24,
  0x3A183A1C, 0x3A103A14, 0x3A083A0C, 0x3A003A04,
  0x37F137F9, 0x37E137E9, 0x37D137D9, 0x37C137C9,
  0x37B137B9, 0x37A137A9, 0x37923799, 0x37813789,
  0x37713779, 0x37623769, 0x37513759, 0x3741374A,
  0x37313739, 0x3721372A, 0x37113719, 0x37013709,
  0x36F136F9, 0x36E136E9, 0x36D136D9, 0x36C136C9,
  0x36B136B9, 0x36A236AA, 0x36913699, 0x36813689,
  0x36713679, 0x36613669, 0x36513659, 0x36413649,
  0x36313639, 0x3621362A, 0x36113619, 0x36013609,
  0x33E333F3, 0x33C333D3, 0x33A233B3, 0x33833393,
  0x33633373, 0x33423353, 0x33233332, 0x33033313,
  0x32E332F3, 0x32C232D2, 0x32A332B2, 0x32823292,
  0x32623274, 0x32423253, 0x32223231, 0x32033213,
  0x2FC32FE6, 0x2F802FA6, 0x2F402F61, 0x2F032F26,
  0x2EC22EE8, 0x2E842EA3, 0x2E412E63, 0x2E032E1D,
  0x2B852BBA, 0x2AF52B4E, 0x2A792AB8, 0x27E22A37,
  0x2707279C, 0x261D2669, 0x223622E0, 0x07E21B23,

 /* air table 1*/
  0x3BB53BB9, 0x3BAD3BB1, 0x3BA53BA9, 0x3B9D3BA1,
  0x3B953B99, 0x3B8D3B91, 0x3B853B89, 0x3B7D3B81,
  0x3B753B79, 0x3B6D3B71, 0x3B653B69, 0x3B5D3B61,
  0x3B553B59, 0x3B4D3B51, 0x3B453B49, 0x3B3D3B41,
  0x3B353B39, 0x3B2D3B31, 0x3B253B29, 0x3B1D3B21,
  0x3B153B19, 0x3B0D3B11, 0x3B053B09, 0x3AFD3B01,
  0x3AF53AF9, 0x3AED3AF1, 0x3AE53AE9, 0x3ADD3AE1,
  0x3AD53AD9, 0x3ACD3AD1, 0x3AC53AC9, 0x3ABD3AC1,
  0x3AB53AB9, 0x3AAD3AB1, 0x3AA53AA9, 0x3A9D3AA1,
  0x3A953A99, 0x3A8D3A91, 0x3A853A89, 0x3A7D3A81,
  0x3A753A79, 0x3A6D3A71, 0x3A653A69, 0x3A5D3A61,
  0x3A553A59, 0x3A4D3A51, 0x3A453A49, 0x3A3D3A41,
  0x3A353A39, 0x3A2D3A31, 0x3A253A29, 0x3A1D3A21,
  0x3A153A19, 0x3A0D3A11, 0x3A053A09, 0x37FB3A01,
  0x37EB37F3, 0x37DB37E4, 0x37CC37D4, 0x37BC37C3,
  0x37AC37B4, 0x379C37A4, 0x378C3794, 0x377C3784,
  0x376D3774, 0x375D3765, 0x374D3754, 0x373D3745,
  0x372D3735, 0x371E3725, 0x370E3716, 0x36FE3706,
  0x36EE36F6, 0x36DF36E7, 0x36CF36D7, 0x36BF36C8,
  0x36B036B8, 0x36A036A8, 0x36913699, 0x36813689,
  0x3672367A, 0x3663366B, 0x3653365B, 0x3644364C,
  0x3635363D, 0x3626362E, 0x3617361F, 0x36083610,
  0x33F33601, 0x33D633E4, 0x33B833C7, 0x339B33AA,
  0x337E338D, 0x33613370, 0x33453353, 0x33293337,
  0x330D331B, 0x32F132FF, 0x32D632E4, 0x32BB32C9,
  0x32A132AE, 0x32863294, 0x326D3279, 0x32543261,
  0x323B3248, 0x3222322E, 0x320B3216, 0x2FE62FFD,
  0x2FB82FD1, 0x2F8C2FA3, 0x2F612F74, 0x2F382F4C,
  0x2F0C2F22, 0x2EE22EF9, 0x2EBC2ECF, 0x2E982EAC,
  0x2E732E89, 0x2E522E63, 0x2E2F2E40, 0x2E032E1D,
  0x2B852BBA, 0x2AF52B4E, 0x2A792AB8, 0x27E22A37,
  0x2707279C, 0x261D2669, 0x223622E0, 0x07E21B23,

 /* air table 2 */
  0x3B713B75, 0x3B693B6D, 0x3B613B65, 0x3B593B5D,
  0x3B513B55, 0x3B493B4D, 0x3B413B45, 0x3B393B3D,
  0x3B313B35, 0x3B293B2D, 0x3B213B25, 0x3B193B1D,
  0x3B113B15, 0x3B093B0D, 0x3B013B05, 0x3AF93AFD,
  0x3AF13AF5, 0x3AE93AED, 0x3AE13AE5, 0x3AD93ADD,
  0x3AD13AD5, 0x3AC93ACD, 0x3AC13AC5, 0x3AB93ABD,
  0x3AB13AB5, 0x3AA93AAD, 0x3AA13AA5, 0x3A993A9D,
  0x3A913A95, 0x3A893A8D, 0x3A813A85, 0x3A793A7D,
  0x3A713A76, 0x3A693A6D, 0x3A613A65, 0x3A5A3A5D,
  0x3A513A56, 0x3A4A3A4D, 0x3A413A46, 0x3A3A3A3E,
  0x3A323A36, 0x3A2A3A2D, 0x3A223A26, 0x3A1A3A1E,
  0x3A123A16, 0x3A0A3A0E, 0x3A023A06, 0x37F437FC,
  0x37E437EC, 0x37D537DC, 0x37C537CC, 0x37B437BC,
  0x37A537AD, 0x3795379D, 0x3785378D, 0x3775377D,
  0x3765376D, 0x3756375E, 0x3746374E, 0x3736373E,
  0x3726372E, 0x3717371E, 0x3707370E, 0x36F736FF,
  0x36E836EF, 0x36D836E0, 0x36C836D0, 0x36B936C0,
  0x36A936B1, 0x369A36A1, 0x368A3692, 0x367B3682,
  0x366B3673, 0x365C3664, 0x364D3654, 0x363D3645,
  0x362E3636, 0x361F3627, 0x36113618, 0x36013609,
  0x33E633F5, 0x33C933D7, 0x33AB33BA, 0x338E339D,
  0x33713380, 0x33553363, 0x33393347, 0x331D332B,
  0x3301330F, 0x32E632F3, 0x32CB32D8, 0x32B032BD,
  0x329532A2, 0x327B3289, 0x3262326F, 0x32493256,
  0x3230323C, 0x32183224, 0x3200320C, 0x2FD22FE9,
  0x2FA62FBC, 0x2F782F90, 0x2F4F2F63, 0x2F242F3A,
  0x2EFC2F10, 0x2ED42EE7, 0x2EAF2EC1, 0x2E892E9B,
  0x2E652E79, 0x2E432E54, 0x2E222E31, 0x2E042E13,
  0x2BC82BE8, 0x2B8B2BAD, 0x2B542B70, 0x2B222B3E,
  0x2AEE2B0C, 0x2AC02AD7, 0x2A912AA9, 0x2A682A79,
  0x2A3E2A4F, 0x2A132A2E, 0x27E22A02, 0x279A27BE,
  0x27072788, 0x261D2669, 0x223622E0, 0x07E21B23,

 /* air table 3 */
  0x3B2E3B32, 0x3B263B2A, 0x3B1E3B22, 0x3B163B1A,
  0x3B0E3B12, 0x3B063B0A, 0x3AFE3B02, 0x3AF63AFA,
  0x3AEE3AF2, 0x3AE63AEA, 0x3ADE3AE2, 0x3AD63ADA,
  0x3ACE3AD2, 0x3AC63ACA, 0x3ABE3AC2, 0x3AB63ABA,
  0x3AAE3AB2, 0x3AA63AAA, 0x3A9E3AA2, 0x3A963A9A,
  0x3A8E3A92, 0x3A863A8A, 0x3A7E3A82, 0x3A763A7A,
  0x3A6E3A72, 0x3A663A6A, 0x3A5E3A62, 0x3A563A5A,
  0x3A4E3A52, 0x3A463A4A, 0x3A3E3A42, 0x3A363A3A,
  0x3A2E3A32, 0x3A263A2A, 0x3A1E3A22, 0x3A163A1A,
  0x3A0E3A12, 0x3A063A0A, 0x37FD3A02, 0x37ED37F5,
  0x37DD37E5, 0x37CD37D5, 0x37BD37C5, 0x37AD37B6,
  0x379E37A5, 0x378E3796, 0x377E3786, 0x376E3776,
  0x375E3766, 0x374F3757, 0x373F3747, 0x372F3737,
  0x371F3727, 0x370F3717, 0x37003708, 0x36F036F8,
  0x36E036E8, 0x36D136D9, 0x36C136C9, 0x36B236B9,
  0x36A236AA, 0x3693369A, 0x3683368B, 0x3674367C,
  0x3665366C, 0x3655365D, 0x3646364D, 0x3637363E,
  0x3628362F, 0x36193620, 0x360A3611, 0x33F63602,
  0x33D933E7, 0x33BC33CA, 0x339E33AD, 0x33813390,
  0x33653373, 0x33483357, 0x332C333A, 0x3310331E,
  0x32F53302, 0x32DA32E7, 0x32BE32CC, 0x32A432B1,
  0x328A3297, 0x3270327D, 0x32573263, 0x323E324A,
  0x32253232, 0x320E3219, 0x2FED3201, 0x2FBF2FD6,
  0x2F922FA8, 0x2F662F7C, 0x2F3C2F51, 0x2F132F27,
  0x2EEB2EFE, 0x2EC32ED6, 0x2E9D2EB0, 0x2E792E8B,
  0x2E572E68, 0x2E342E46, 0x2E152E24, 0x2BEB2E05,
  0x2BB02BCE, 0x2B762B92, 0x2B422B5B, 0x2B0C2B25,
  0x2ADA2AF6, 0x2AAC2AC4, 0x2A802A94, 0x2A582A6C,
  0x2A2E2A43, 0x2A062A1C, 0x27C727EA, 0x278827AB,
  0x2748276D, 0x270F272C, 0x26D626F2, 0x26A426B8,
  0x26732687, 0x2640265F, 0x2618262C, 0x23DD2603,
  0x239F23C9, 0x23602374, 0x223622E0, 0x07E21B23,

 /* air table 4 */
  0x3AEA3AEE, 0x3AE23AE6, 0x3ADA3ADE, 0x3AD23AD6,
  0x3ACA3ACE, 0x3AC23AC6, 0x3ABA3ABE, 0x3AB23AB6,
  0x3AAA3AAE, 0x3AA23AA6, 0x3A9A3A9E, 0x3A923A96,
  0x3A8A3A8E, 0x3A823A86, 0x3A7A3A7E, 0x3A723A76,
  0x3A6A3A6E, 0x3A623A66, 0x3A5A3A5E, 0x3A523A56,
  0x3A4A3A4E, 0x3A423A46, 0x3A3A3A3E, 0x3A323A36,
  0x3A2B3A2F, 0x3A223A27, 0x3A1B3A1E, 0x3A133A17,
  0x3A0B3A0F, 0x3A033A07, 0x37F637FE, 0x37E637EE,
  0x37D637DE, 0x37C637CE, 0x37B637BE, 0x37A737AE,
  0x3796379F, 0x3787378E, 0x3777377F, 0x3767376F,
  0x3757375F, 0x3748374F, 0x3737373F, 0x37283730,
  0x37183720, 0x37093710, 0x36F93701, 0x36E936F1,
  0x36D936E1, 0x36CA36D2, 0x36BA36C2, 0x36AB36B2,
  0x369B36A3, 0x368C3694, 0x367C3684, 0x366D3675,
  0x365E3665, 0x364E3656, 0x363F3647, 0x36303637,
  0x36213628, 0x3612361A, 0x3603360A, 0x33E933F8,
  0x33CC33DA, 0x33AE33BD, 0x339133A0, 0x33753383,
  0x33583366, 0x333C334A, 0x3320332E, 0x33043312,
  0x32E832F6, 0x32CE32DB, 0x32B332C0, 0x329832A6,
  0x327E328B, 0x32653272, 0x324C3258, 0x3233323F,
  0x321B3227, 0x3203320F, 0x2FD82FEF, 0x2FAB2FC2,
  0x2F7E2F94, 0x2F542F69, 0x2F292F3E, 0x2F012F15,
  0x2ED92EED, 0x2EB32EC5, 0x2E8E2EA0, 0x2E6A2E7C,
  0x2E482E59, 0x2E262E37, 0x2E072E16, 0x2BD22BF0,
  0x2B972BB3, 0x2B5E2B7A, 0x2B292B43, 0x2AF72B10,
  0x2AC82ADF, 0x2A982AB1, 0x2A6E2A83, 0x2A452A5A,
  0x2A1E2A32, 0x27F32A0B, 0x27B027D0, 0x276D278C,
  0x272F2751, 0x26F72714, 0x26C226DA, 0x269126A9,
  0x265F2678, 0x2631264B, 0x2608261D, 0x23C923F2,
  0x238023AA, 0x23402360, 0x23002320, 0x22C922DF,
  0x229322A8, 0x225B227D, 0x222F2245, 0x22022219,
  0x1FC21FEF, 0x1F7E1F94, 0x1F3A1F50, 0x07E21B23,

 /* air table 5*/
  0x3AA73AAA, 0x3A9F3AA3, 0x3A973A9B, 0x3A8F3A93,
  0x3A873A8B, 0x3A7F3A83, 0x3A773A7B, 0x3A6F3A73,
  0x3A673A6B, 0x3A5F3A63, 0x3A573A5B, 0x3A4F3A53,
  0x3A473A4B, 0x3A3F3A43, 0x3A373A3B, 0x3A2F3A33,
  0x3A273A2B, 0x3A1F3A23, 0x3A173A1B, 0x3A0F3A13,
  0x3A073A0B, 0x37FF3A03, 0x37EF37F7, 0x37DF37E7,
  0x37CF37D7, 0x37BF37C7, 0x37AF37B7, 0x379F37A7,
  0x378F3797, 0x377F3788, 0x37703778, 0x37603768,
  0x37503758, 0x37403748, 0x37303739, 0x37213729,
  0x37113719, 0x37013709, 0x36F236FA, 0x36E236EA,
  0x36D236DA, 0x36C336CA, 0x36B336BB, 0x36A436AC,
  0x3694369C, 0x3685368D, 0x3675367D, 0x3666366E,
  0x3657365E, 0x3648364F, 0x36393640, 0x36293631,
  0x361A3622, 0x360B3613, 0x33F93604, 0x33DC33EB,
  0x33BE33CD, 0x33A133B0, 0x33853393, 0x33683376,
  0x334B3359, 0x332F333D, 0x33133321, 0x32F73306,
  0x32DD32EA, 0x32C132CF, 0x32A732B4, 0x328D3299,
  0x32733280, 0x325A3266, 0x3241324D, 0x32283234,
  0x3210321C, 0x2FF23204, 0x2FC42FDB, 0x2F962FAE,
  0x2F6B2F81, 0x2F402F56, 0x2F172F2B, 0x2EEF2F03,
  0x2EC82EDB, 0x2EA22EB5, 0x2E7D2E90, 0x2E5B2E6C,
  0x2E392E4A, 0x2E192E29, 0x2BF32E08, 0x2BB72BD4,
  0x2B7E2B9A, 0x2B472B62, 0x2B132B2C, 0x2AE22AFA,
  0x2AB22ACA, 0x2A862A9D, 0x2A5C2A70, 0x2A342A48,
  0x2A0E2A20, 0x27D427F7, 0x279127B2, 0x27522771,
  0x27182734, 0x26DF26FC, 0x26AC26C4, 0x267A2694,
  0x264D2664, 0x26222637, 0x23F8260E, 0x23AA23CE,
  0x2365238B, 0x23252345, 0x22E92304, 0x22B422CF,
  0x227D2298, 0x224B2266, 0x221E2234, 0x1FEF220D,
  0x1FA01FCE, 0x1F5C1F7E, 0x1F181F3A, 0x1EDD1EF5,
  0x1EA41EBB, 0x1E6A1E8D, 0x1E3C1E52, 0x1E0D1E24,
  0x1BD41E01, 0x1B8E1BA4, 0x1B471B5E, 0x07E21B18,

 /* air table 6 */
  0x3A633A67, 0x3A5B3A5F, 0x3A533A57, 0x3A4B3A4F,
  0x3A433A47, 0x3A3B3A3F, 0x3A333A37, 0x3A2B3A2F,
  0x3A233A27, 0x3A1B3A1F, 0x3A133A17, 0x3A0B3A0F,
  0x3A033A07, 0x37F837FF, 0x37E837EF, 0x37D837E0,
  0x37C837D0, 0x37B837C0, 0x37A837B0, 0x379837A0,
  0x37883790, 0x37793781, 0x37693770, 0x37593761,
  0x37493751, 0x37393741, 0x372A3731, 0x371A3722,
  0x370A3712, 0x36FA3702, 0x36EB36F3, 0x36DB36E3,
  0x36CB36D4, 0x36BC36C4, 0x36AC36B4, 0x369D36A5,
  0x368D3695, 0x367E3685, 0x366E3676, 0x365F3667,
  0x36503658, 0x36413648, 0x36313639, 0x3623362A,
  0x3614361B, 0x3605360C, 0x33EC33FB, 0x33CF33DE,
  0x33B233C0, 0x339533A3, 0x33783386, 0x335B3369,
  0x333F334D, 0x33223331, 0x33073315, 0x32EC32F9,
  0x32D032DE, 0x32B532C3, 0x329C32A8, 0x3281328E,
  0x32683274, 0x324E325B, 0x32363241, 0x321D3229,
  0x32063211, 0x2FDD2FF4, 0x2FAF2FC5, 0x2F832F99,
  0x2F582F6D, 0x2F2E2F42, 0x2F052F19, 0x2EDD2EF1,
  0x2EB72ECA, 0x2E922EA4, 0x2E6E2E80, 0x2E4B2E5D,
  0x2E2A2E3B, 0x2E0A2E1A, 0x2BD82BF6, 0x2B9D2BBA,
  0x2B652B81, 0x2B302B4A, 0x2AFC2B16, 0x2ACD2AE5,
  0x2A9E2AB5, 0x2A732A89, 0x2A4A2A5E, 0x2A232A36,
  0x27FC2A10, 0x27B727D9, 0x27762795, 0x27382756,
  0x26FE271B, 0x26C826E4, 0x269626AF, 0x2667267E,
  0x263A2650, 0x26102625, 0x23D423FA, 0x238C23AF,
  0x234B236A, 0x230A232B, 0x22D122ED, 0x229B22B6,
  0x22692282, 0x223A2250, 0x22102224, 0x1FCE1FF4,
  0x1F831FAC, 0x1F3F1F61, 0x1F001F1C, 0x1EC71EE3,
  0x1E8D1EAA, 0x1E581E75, 0x1E2A1E41, 0x1E011E18,
  0x1BB21BE1, 0x1B6B1B8E, 0x1B241B47, 0x1AE81B00,
  0x1AAD1AC5, 0x1A711A96, 0x1A421A5A, 0x1A121A2A,
  0x17DE1A06, 0x179717AD, 0x174E1766, 0x07E2171F,

 /* air table 7 */
  0x3A203A24, 0x3A183A1C, 0x3A103A14, 0x3A083A0C,
  0x3A003A04, 0x37F037F8, 0x37E137E8, 0x37D137D9,
  0x37C137C9, 0x37B137B9, 0x37A137A9, 0x37913799,
  0x37813789, 0x37713779, 0x37623769, 0x3752375A,
  0x3742374A, 0x3732373A, 0x3723372A, 0x3713371B,
  0x3703370B, 0x36F336FB, 0x36E436EB, 0x36D436DC,
  0x36C536CC, 0x36B536BD, 0x36A536AD, 0x3696369E,
  0x3686368E, 0x3677367F, 0x3668366F, 0x36583660,
  0x36493651, 0x363A3642, 0x362B3633, 0x361C3623,
  0x360D3615, 0x33FD3605, 0x33DF33EE, 0x33C233D0,
  0x33A533B3, 0x33883396, 0x336A3379, 0x334E335D,
  0x33323340, 0x33163324, 0x32FA3308, 0x32DF32ED,
  0x32C432D1, 0x32AA32B7, 0x3290329D, 0x32753282,
  0x325C3269, 0x32433250, 0x322A3237, 0x3213321F,
  0x2FF63207, 0x2FC82FE0, 0x2F9C2FB2, 0x2F6F2F85,
  0x2F452F5A, 0x2F1C2F30, 0x2EF32F07, 0x2ECC2EE0,
  0x2EA62EB9, 0x2E812E94, 0x2E5E2E6F, 0x2E3C2E4D,
  0x2E1C2E2C, 0x2BFA2E0C, 0x2BBE2BDB, 0x2B832BA0,
  0x2B4D2B68, 0x2B192B32, 0x2AE72B00, 0x2AB72AD0,
  0x2A8A2AA1, 0x2A602A76, 0x2A382A4C, 0x2A122A25,
  0x27DD2A00, 0x279A27BB, 0x27592779, 0x271E273C,
  0x26E62702, 0x26B226CC, 0x26812698, 0x26522669,
  0x2627263D, 0x23FF2613, 0x23B423D8, 0x236E2391,
  0x232D234D, 0x22F12310, 0x22B922D4, 0x2285229F,
  0x2254226C, 0x2226223D, 0x1FFA2211, 0x1FAD1FD3,
  0x1F671F89, 0x1F221F45, 0x1EE61F03, 0x1EAD1ECA,
  0x1E781E93, 0x1E471E5E, 0x1E1B1E30, 0x1BE11E04,
  0x1B931BBD, 0x1B4D1B70, 0x1B0C1B29, 0x1AD11AEE,
  0x1A961AB3, 0x1A601A7D, 0x1A301A48, 0x1A061A1E,
  0x17BB17EB, 0x17721797, 0x172B174E, 0x16ED1706,
  0x16B216CA, 0x1675169A, 0x1646165D, 0x1615162D,
  0x13E31609, 0x139B13B2, 0x13521369, 0x07E21322,

 /* air table 8 */
  0x37BA37C1, 0x37AA37B2, 0x379A37A2, 0x378A3792,
  0x377A3782, 0x376A3772, 0x375B3762, 0x374B3753,
  0x373B3743, 0x372B3733, 0x371C3723, 0x370C3714,
  0x36FC3704, 0x36EC36F4, 0x36DD36E4, 0x36CD36D5,
  0x36BD36C5, 0x36AE36B6, 0x369F36A6, 0x368F3697,
  0x36803687, 0x36703678, 0x36613668, 0x36513659,
  0x3643364A, 0x3633363B, 0x3624362C, 0x3615361D,
  0x3606360E, 0x33EF33FE, 0x33D233E1, 0x33B433C3,
  0x339733A6, 0x337B3389, 0x335E336C, 0x33423350,
  0x33253334, 0x330A3317, 0x32EE32FC, 0x32D332E1,
  0x32B832C6, 0x329E32AB, 0x32833291, 0x326A3277,
  0x3251325D, 0x32383244, 0x3220322C, 0x32083214,
  0x2FE22FF9, 0x2FB52FCB, 0x2F882F9E, 0x2F5C2F72,
  0x2F322F47, 0x2F092F1E, 0x2EE12EF5, 0x2EBB2ECE,
  0x2E962EA8, 0x2E722E84, 0x2E502E60, 0x2E2E2E3E,
  0x2E0E2E1D, 0x2BDF2BFD, 0x2BA32BC0, 0x2B6A2B87,
  0x2B362B50, 0x2B022B1C, 0x2AD12AE9, 0x2AA32ABA,
  0x2A782A8D, 0x2A4E2A62, 0x2A272A3A, 0x2A012A14,
  0x27BE27E0, 0x277D279D, 0x273F275D, 0x27042722,
  0x26CE26E9, 0x269B26B5, 0x266C2683, 0x263F2655,
  0x2615262A, 0x23DD2601, 0x239423B8, 0x23512373,
  0x23122331, 0x22D822F5, 0x22A122BC, 0x226F2287,
  0x22402257, 0x22142229, 0x1FD81FFF, 0x1F8D1FB2,
  0x1F481F6A, 0x1F081F28, 0x1ECD1EE9, 0x1E961EB1,
  0x1E631E7B, 0x1E331E4A, 0x1E071E1D, 0x1BBF1BE6,
  0x1B761B99, 0x1B2F1B53, 0x1AF11B0F, 0x1AB61AD4,
  0x1A801A9B, 0x1A4E1A66, 0x1A211A36, 0x17EB1A09,
  0x179B17C7, 0x17541778, 0x1712172F, 0x16D616F4,
  0x169A16B8, 0x16631681, 0x1633164B, 0x16091621,
  0x13BF13F0, 0x1376139B, 0x132E1352, 0x12F01309,
  0x12B412CC, 0x1277129C, 0x1247125F, 0x1217122F,
  0x0FE5120B, 0x0F9D0FB4, 0x0F540F6B, 0x07E20F23,

 /* air table 9 */
  0x3734373C, 0x3724372C, 0x3715371C, 0x3705370D,
  0x36F536FD, 0x36E536ED, 0x36D636DD, 0x36C636CE,
  0x36B736BE, 0x36A736AF, 0x3698369F, 0x36883690,
  0x36793680, 0x36693671, 0x365A3662, 0x364B3652,
  0x363C3643, 0x362D3634, 0x361E3625, 0x360F3616,
  0x36003607, 0x33E233F1, 0x33C533D3, 0x33A733B6,
  0x338B3399, 0x336E337C, 0x3351335F, 0x33353343,
  0x33193327, 0x32FD330B, 0x32E232F0, 0x32C732D4,
  0x32AC32BA, 0x3292329F, 0x32783285, 0x325F326B,
  0x32463252, 0x322D3239, 0x32153221, 0x2FFB3209,
  0x2FCD2FE4, 0x2FA12FB6, 0x2F742F8A, 0x2F492F5F,
  0x2F202F34, 0x2EF82F0B, 0x2ED02EE3, 0x2EAA2EBD,
  0x2E862E97, 0x2E632E74, 0x2E402E51, 0x2E1F2E2F,
  0x2E002E0F, 0x2BC32BE2, 0x2B892BA7, 0x2B532B6E,
  0x2B1E2B38, 0x2AEC2B05, 0x2ABD2AD4, 0x2A8F2AA5,
  0x2A652A79, 0x2A3D2A50, 0x2A162A28, 0x27E42A04,
  0x27A127C1, 0x27602780, 0x27242741, 0x26EC2707,
  0x26B826D1, 0x2686269D, 0x2658266E, 0x262C2641,
  0x26032617, 0x23BD23E1, 0x23762399, 0x23332355,
  0x22F72315, 0x22BF22DB, 0x228B22A4, 0x22592272,
  0x222C2242, 0x22022217, 0x1FB61FDC, 0x1F6E1F92,
  0x1F2B1F4C, 0x1EEE1F0C, 0x1EB41ECF, 0x1E7E1E98,
  0x1E4D1E65, 0x1E201E36, 0x1BEC1E0A, 0x1B9E1BC4,
  0x1B561B79, 0x1B141B35, 0x1AD71AF5, 0x1A9F1ABA,
  0x1A6A1A83, 0x1A391A51, 0x1A0D1A22, 0x17C817F0,
  0x177E17A2, 0x1736175A, 0x16F71715, 0x16BB16D9,
  0x168416A0, 0x1651166A, 0x16241639, 0x13F0160C,
  0x13A013CB, 0x1357137C, 0x13151333, 0x12D912F7,
  0x129C12BB, 0x12651283, 0x1235124D, 0x120B1222,
  0x0FC10FF2, 0x0F780F9D, 0x0F300F54, 0x0EF20F0B,
  0x0EB50ECE, 0x0E780E9D, 0x0E480E60, 0x0E170E30,
  0x0BE60E0B, 0x0B9E0BB5, 0x0B550B6C, 0x07E20B24,

 /* air table 10 */
  0x36B036B7, 0x36A036A8, 0x36913698, 0x36813689,
  0x36723679, 0x3662366A, 0x3653365B, 0x3644364C,
  0x3635363C, 0x3626362D, 0x3617361E, 0x3608360F,
  0x33F23600, 0x33D533E4, 0x33B833C6, 0x339B33A9,
  0x337E338C, 0x33613370, 0x33453353, 0x33293336,
  0x330D331B, 0x32F132FF, 0x32D632E3, 0x32BB32C9,
  0x32A132AE, 0x32863294, 0x326D3279, 0x32543260,
  0x323B3247, 0x3222322F, 0x320A3216, 0x2FE62FFE,
  0x2FB92FD0, 0x2F8C2FA3, 0x2F612F77, 0x2F372F4C,
  0x2F0D2F22, 0x2EE62EF9, 0x2EBF2ED2, 0x2E992EAC,
  0x2E762E87, 0x2E532E63, 0x2E312E42, 0x2E112E21,
  0x2BE42E01, 0x2BAA2BC7, 0x2B702B8D, 0x2B3B2B56,
  0x2B082B20, 0x2AD72AEF, 0x2AA92ABF, 0x2A7C2A92,
  0x2A522A67, 0x2A2B2A3E, 0x2A052A18, 0x27C627E8,
  0x278327A4, 0x27452764, 0x270C2728, 0x26D426EE,
  0x26A126B9, 0x26712688, 0x26442659, 0x2619262E,
  0x23E62605, 0x239C23C0, 0x23582379, 0x23192337,
  0x22DE22FA, 0x22A722C1, 0x2274228D, 0x2244225C,
  0x2219222E, 0x1FE22204, 0x1F951FBB, 0x1F4E1F73,
  0x1F0E1F2E, 0x1ED21EF1, 0x1E9C1EB6, 0x1E681E81,
  0x1E391E50, 0x1E0D1E22, 0x1BC81BF0, 0x1B7E1BA3,
  0x1B381B5A, 0x1AF91B18, 0x1ABD1ADA, 0x1A861AA1,
  0x1A541A6D, 0x1A261A3C, 0x17F61A0F, 0x17A717CE,
  0x175D1781, 0x171A173C, 0x16DC16FA, 0x16A316BF,
  0x166E1687, 0x163C1654, 0x160F1625, 0x13CD13F5,
  0x138213A6, 0x1339135E, 0x12FA1318, 0x12BD12DC,
  0x128612A2, 0x1253126C, 0x1226123B, 0x0FF2120E,
  0x0FA20FCE, 0x0F590F7E, 0x0F160F35, 0x0EDA0EF8,
  0x0E9D0EBC, 0x0E660E84, 0x0E360E4E, 0x0E0B0E23,
  0x0BC30BF4, 0x0B790B9E, 0x0B310B55, 0x0AF20B0C,
  0x0AB60ACE, 0x0A790A9E, 0x0A490A60, 0x0A180A30,
  0x07E70A0C, 0x079F07B6, 0x0755076D, 0x070C0725,

 /* air table 11 */
  0x362E3635, 0x361F3627, 0x36103618, 0x36013609,
  0x33E533F4, 0x33C833D6, 0x33AB33B9, 0x338E339C,
  0x3371337F, 0x33543362, 0x33383346, 0x331C332A,
  0x3300330E, 0x32E532F3, 0x32CA32D7, 0x32AF32BD,
  0x329532A2, 0x327B3288, 0x3262326E, 0x32493255,
  0x3230323C, 0x32183224, 0x3200320B, 0x2FD12FE9,
  0x2FA52FBC, 0x2F782F8F, 0x2F4E2F63, 0x2F242F39,
  0x2EFB2F10, 0x2ED42EE8, 0x2EAE2EC1, 0x2E892E9B,
  0x2E662E78, 0x2E442E54, 0x2E222E33, 0x2E032E13,
  0x2BC92BE8, 0x2B902BAC, 0x2B582B74, 0x2B232B3D,
  0x2AF12B0A, 0x2AC22AD8, 0x2A932AAA, 0x2A692A7F,
  0x2A402A54, 0x2A1A2A2D, 0x27EB2A07, 0x27A727C9,
  0x27672786, 0x272C2749, 0x26F2270E, 0x26BC26D7,
  0x268B26A3, 0x265C2673, 0x26302646, 0x2608261C,
  0x23C423E9, 0x237D23A1, 0x233C235C, 0x22FE231B,
  0x22C522E0, 0x229022AA, 0x225E2276, 0x22302247,
  0x2207221B, 0x1FBE1FE5, 0x1F751F98, 0x1F321F52,
  0x1EF41F12, 0x1EBA1ED5, 0x1E841E9E, 0x1E521E6A,
  0x1E241E3A, 0x1BF51E0F, 0x1BA61BCD, 0x1B5D1B82,
  0x1B1B1B3C, 0x1ADD1AFC, 0x1AA51AC0, 0x1A6F1A8A,
  0x1A3F1A57, 0x1A121A28, 0x17D117FA, 0x178617AC,
  0x173F1761, 0x16FF171F, 0x16C216DF, 0x168B16A6,
  0x16581671, 0x1629163F, 0x13FB1612, 0x13AB13D2,
  0x13611385, 0x131D1340, 0x12DF12FD, 0x12A512C2,
  0x1270128A, 0x123E1256, 0x12111227, 0x0FCF0FF8,
  0x0F840FA8, 0x0F3B0F60, 0x0EFB0F1A, 0x0EBF0EDD,
  0x0E880EA3, 0x0E540E6D, 0x0E270E3C, 0x0BF40E0E,
  0x0BA30BCF, 0x0B5A0B7F, 0x0B170B35, 0x0ADB0AF9,
  0x0A9E0ABC, 0x0A670A85, 0x0A360A4E, 0x0A0C0A24,
  0x07C307F4, 0x077A079F, 0x07310756, 0x06F3070C,
  0x06B706CF, 0x0679069E, 0x06490661, 0x06180630,
  0x03E8060C, 0x03A003B6, 0x0356036D, 0x030D0325,

 /* air table 12 */
  0x33643372, 0x33483356, 0x332C333A, 0x3310331D,
  0x32F43302, 0x32D932E6, 0x32BE32CB, 0x32A432B1,
  0x32893296, 0x326F327C, 0x32563263, 0x323D324A,
  0x32253231, 0x320D3219, 0x2FEB3201, 0x2FBE2FD4,
  0x2F912FA7, 0x2F662F7C, 0x2F3B2F50, 0x2F122F26,
  0x2EEA2EFE, 0x2EC32ED6, 0x2E9D2EB0, 0x2E792E8B,
  0x2E572E68, 0x2E342E46, 0x2E142E24, 0x2BEB2E05,
  0x2BAF2BCD, 0x2B762B93, 0x2B402B5B, 0x2B0C2B26,
  0x2ADB2AF5, 0x2AAD2AC4, 0x2A802A97, 0x2A572A6B,
  0x2A2F2A43, 0x2A092A1B, 0x27CC27F0, 0x278A27AB,
  0x274C276A, 0x2711272D, 0x26D926F4, 0x26A626C0,
  0x2675268D, 0x2649265E, 0x261D2633, 0x23ED260A,
  0x23A423C7, 0x23602382, 0x2320233F, 0x22E32301,
  0x22AD22C8, 0x22792293, 0x22492261, 0x221E2233,
  0x1FE92209, 0x1F9D1FC3, 0x1F581F7A, 0x1F151F35,
  0x1ED91EF6, 0x1EA11EBD, 0x1E6D1E86, 0x1E3D1E55,
  0x1E111E27, 0x1BD01BF9, 0x1B851BA9, 0x1B3F1B61,
  0x1AFF1B1E, 0x1AC41AE0, 0x1A8D1AA7, 0x1A591A72,
  0x1A2A1A41, 0x1A001A14, 0x17AF17D6, 0x1764178A,
  0x17211742, 0x16E21702, 0x16A916C5, 0x1673168E,
  0x1642165A, 0x1615162B, 0x13D613FF, 0x138A13B0,
  0x13421365, 0x13021322, 0x12C512E2, 0x128D12A8,
  0x125A1273, 0x122A1241, 0x0FFE1213, 0x0FAD0FD5,
  0x0F630F87, 0x0F1F0F41, 0x0EE00EFF, 0x0EA70EC3,
  0x0E710E8B, 0x0E3F0E57, 0x0E110E28, 0x0BD10BF9,
  0x0B850BA9, 0x0B3C0B61, 0x0AFC0B1B, 0x0ABF0ADE,
  0x0A880AA4, 0x0A540A6D, 0x0A270A3C, 0x07F40A0F,
  0x07A407D0, 0x075B0780, 0x07180736, 0x06DB06F9,
  0x069E06BD, 0x06670686, 0x0636064F, 0x060C0624,
  0x03C403F5, 0x037B03A0, 0x03320356, 0x02F3030D,
  0x02B702D0, 0x027A029F, 0x02490261, 0x02190231,
  0x01F4020C, 0x01D001DB, 0x01AB01B6, 0x01860193,

 /* air table 13 */
  0x327E328A, 0x32643271, 0x324B3258, 0x3232323F,
  0x321A3226, 0x3202320E, 0x2FD82FEE, 0x2FAA2FC1,
  0x2F7D2F93, 0x2F522F68, 0x2F292F3D, 0x2F002F14,
  0x2ED82EEC, 0x2EB22EC5, 0x2E8D2E9F, 0x2E692E7B,
  0x2E472E58, 0x2E262E37, 0x2E062E16, 0x2BD12BEE,
  0x2B962BB3, 0x2B5E2B7A, 0x2B292B43, 0x2AF62B10,
  0x2AC72ADF, 0x2A982AB0, 0x2A6D2A83, 0x2A452A59,
  0x2A1E2A31, 0x27F32A0B, 0x27AE27D0, 0x276D278D,
  0x27312750, 0x26F82714, 0x26C226DD, 0x269026A8,
  0x26612678, 0x2635264A, 0x260B2620, 0x23CC23F1,
  0x238523A7, 0x23432362, 0x23032322, 0x22CB22E7,
  0x229522AF, 0x2264227C, 0x2235224C, 0x220B2220,
  0x1FC71FED, 0x1F7E1FA2, 0x1F3A1F5B, 0x1EF91F19,
  0x1EBF1EDC, 0x1E891EA4, 0x1E571E70, 0x1E291E40,
  0x1BFD1E13, 0x1BAE1BD6, 0x1B661B8A, 0x1B221B42,
  0x1AE41B02, 0x1AAB1AC7, 0x1A751A8E, 0x1A431A5C,
  0x1A171A2D, 0x17DA1A02, 0x178D17B2, 0x17461768,
  0x17051724, 0x16C916E5, 0x169116AC, 0x165C1676,
  0x162D1644, 0x16021617, 0x13B313DB, 0x1368138E,
  0x13241346, 0x12E51305, 0x12AB12C7, 0x12751290,
  0x1244125C, 0x1217122D, 0x0FD81201, 0x0F8C0FB2,
  0x0F440F67, 0x0F030F23, 0x0EC60EE3, 0x0E8E0EA9,
  0x0E5A0E74, 0x0E2B0E42, 0x0BFF0E14, 0x0BAF0BD6,
  0x0B640B88, 0x0B1F0B42, 0x0AE10B00, 0x0AA70AC4,
  0x0A720A8B, 0x0A3F0A58, 0x0A120A28, 0x07D107FA,
  0x078607AA, 0x073C0762, 0x06FD071B, 0x06C006DE,
  0x068806A4, 0x0654066E, 0x0627063C, 0x03F5060F,
  0x03A503D0, 0x035B0380, 0x03180336, 0x02DB02FA,
  0x029F02BD, 0x02680286, 0x0237024F, 0x020C0224,
  0x01E201FA, 0x01BD01D0, 0x019901AB, 0x01790186,
  0x015B0168, 0x013D0150, 0x01240130, 0x010C0118,
  0x00FA0106, 0x00E800EE, 0x00D600DB, 0x00C300C9,

 /* air table 14 */
  0x2F6A2F7F, 0x2F3F2F54, 0x2F172F2B, 0x2EEE2F02,
  0x2EC62EDA, 0x2EA12EB4, 0x2E7D2E8F, 0x2E5A2E6C,
  0x2E382E49, 0x2E182E28, 0x2BF22E08, 0x2BB62BD3,
  0x2B7C2B99, 0x2B462B61, 0x2B122B2C, 0x2AE12AF9,
  0x2AB12AC9, 0x2A862A9C, 0x2A5B2A70, 0x2A332A47,
  0x2A0E2A20, 0x27D427F7, 0x279127B1, 0x27512771,
  0x27172734, 0x26DF26FB, 0x26AB26C4, 0x267A2693,
  0x264C2663, 0x26222637, 0x23F5260E, 0x23AA23CF,
  0x23662389, 0x23262345, 0x22E92308, 0x22B322CE,
  0x227E2298, 0x224E2265, 0x22212238, 0x1FF1220D,
  0x1FA51FCA, 0x1F5F1F80, 0x1F1B1F3C, 0x1EDF1EFE,
  0x1EA71EC2, 0x1E731E8C, 0x1E421E5A, 0x1E161E2C,
  0x1BD91E00, 0x1B8E1BB3, 0x1B471B69, 0x1B051B25,
  0x1AC91AE7, 0x1A911AAD, 0x1A5E1A78, 0x1A301A47,
  0x1A031A19, 0x17B717E0, 0x176E1792, 0x17281749,
  0x16E91707, 0x16AF16CC, 0x16791693, 0x16471660,
  0x161A1630, 0x13DF1604, 0x139113B7, 0x134A136C,
  0x13081328, 0x12CB12E8, 0x129312AE, 0x125E1278,
  0x122F1246, 0x12041219, 0x0FB60FDE, 0x0F6A0F91,
  0x0F260F48, 0x0EE60F06, 0x0EAD0EC9, 0x0E760E91,
  0x0E450E5D, 0x0E170E2E, 0x0BDA0E01, 0x0B8D0BB3,
  0x0B450B68, 0x0B040B24, 0x0AC70AE4, 0x0A8E0AAA,
  0x0A5B0A74, 0x0A2C0A42, 0x0A000A14, 0x07AF07D7,
  0x07640789, 0x07200743, 0x06E20700, 0x06A806C4,
  0x0672068C, 0x06400658, 0x06120628, 0x03D103FB,
  0x038603AB, 0x033C0362, 0x02FD031C, 0x02C002DF,
  0x028902A5, 0x0255026E, 0x0227023D, 0x01FA020F,
  0x01D201E8, 0x01AD01C0, 0x018C019B, 0x016D017D,
  0x0150015E, 0x01340143, 0x011B0128, 0x01060112,
  0x00F100FD, 0x00DF00E8, 0x00CD00D6, 0x00BD00C3,
  0x00AE00B4, 0x009E00A8, 0x00920098, 0x0086008C,
  0x007D0083, 0x00740077, 0x006B006D, 0x00620065,

 /* air table 15 */
  0x2E292E39, 0x2E092E19, 0x2BD72BF5, 0x2B9C2BB9,
  0x2B632B7F, 0x2B2E2B49, 0x2AFC2B14, 0x2ACC2AE4,
  0x2A9D2AB4, 0x2A722A87, 0x2A492A5D, 0x2A222A35,
  0x27FA2A0F, 0x27B527D8, 0x27742794, 0x27372755,
  0x26FD271A, 0x26C826E3, 0x269526AE, 0x2666267D,
  0x263A264F, 0x26102625, 0x23D423F9, 0x238B23AF,
  0x2349236A, 0x230A232A, 0x22D022ED, 0x229B22B5,
  0x22682281, 0x223A2251, 0x220F2224, 0x1FCE1FF5,
  0x1F841FAA, 0x1F401F61, 0x1F001F20, 0x1EC61EE2,
  0x1E8F1EAA, 0x1E5C1E74, 0x1E2D1E45, 0x1E031E18,
  0x1BB71BDD, 0x1B6E1B90, 0x1B281B4A, 0x1AEA1B09,
  0x1AB01ACC, 0x1A7B1A95, 0x1A481A61, 0x1A1B1A32,
  0x17E31A05, 0x179717BC, 0x174E1771, 0x170B172C,
  0x16CE16EC, 0x169616B2, 0x1662167C, 0x1633164A,
  0x1606161C, 0x13BC13E4, 0x13721396, 0x132B134D,
  0x12EC130A, 0x12B212CE, 0x127B1295, 0x12491262,
  0x121B1231, 0x0FE11206, 0x0F940FB9, 0x0F4C0F6E,
  0x0F0A0F29, 0x0ECD0EE9, 0x0E940EAF, 0x0E5F0E79,
  0x0E300E47, 0x0E040E19, 0x0BB70BDF, 0x0B6B0B92,
  0x0B270B49, 0x0AE70B07, 0x0AAD0AC9, 0x0A770A92,
  0x0A460A5E, 0x0A180A2E, 0x07DA0A02, 0x078D07B4,
  0x07460769, 0x07040725, 0x06C706E4, 0x068F06AA,
  0x065B0675, 0x062C0643, 0x06000615, 0x03B003D8,
  0x0364038A, 0x03200344, 0x02E20301, 0x02A802C4,
  0x0273028C, 0x02400259, 0x02130229, 0x01E801FE,
  0x01C301D5, 0x019E01B1, 0x017F018E, 0x0160016F,
  0x01440152, 0x012A0137, 0x0113011E, 0x00FD0107,
  0x00EA00F4, 0x00D700E0, 0x00C600CE, 0x00B700BE,
  0x00A800AF, 0x009A00A2, 0x008E0094, 0x00830089,
  0x0078007F, 0x006F0074, 0x0066006B, 0x005E0062,
  0x0057005A, 0x004F0054, 0x0049004C, 0x00430046,
  0x003F0041, 0x003A003B, 0x00360036, 0x00310032,

 /* rdf table 0 */
  0x1E030A6F, 0x23012202, 0x267D23FE, 0x27802701,
  0x2A412A00, 0x2AC12A80, 0x2B3E2B01, 0x2BBF2B7F,
  0x2E202E00, 0x2E602E40, 0x2E9F2E7F, 0x2EDF2EBF,
  0x2F202F00, 0x2F602F40, 0x2FA02F80, 0x2FE02FC0,
  0x32103200, 0x322F321F, 0x324F3240, 0x326F3260,
  0x328F3280, 0x32AF329F, 0x32D032C0, 0x32F032DF,
  0x330F32FF, 0x3330331F, 0x33503340, 0x336F335F,
  0x3390337F, 0x33B0339F, 0x33D033BF, 0x33F033E0,
  0x360833FF, 0x36173610, 0x3628361F, 0x36373630,
  0x3648363F, 0x36583650, 0x3668365F, 0x36783670,
  0x36873680, 0x36973690, 0x36A836A0, 0x36B736AF,
  0x36C836C0, 0x36D736CF, 0x36E836E0, 0x36F836EF,
  0x37073700, 0x3717370F, 0x3727371F, 0x37383730,
  0x3747373F, 0x3758374F, 0x3768375F, 0x3777376F,
  0x3788377F, 0x3798378F, 0x37A7379F, 0x37B837B0,
  0x37C737C0, 0x37D737CF, 0x37E737E0, 0x37F837EF,
  0x3A033A00, 0x3A0C3A07, 0x3A133A10, 0x3A1B3A18,
  0x3A233A20, 0x3A2B3A28, 0x3A333A30, 0x3A3C3A38,
  0x3A443A40, 0x3A4B3A48, 0x3A543A4F, 0x3A5C3A57,
  0x3A643A60, 0x3A6C3A67, 0x3A733A70, 0x3A7C3A77,
  0x3A833A7F, 0x3A8B3A87, 0x3A943A90, 0x3A9B3A97,
  0x3AA43AA0, 0x3AAB3AA7, 0x3AB33AB0, 0x3ABC3AB8,
  0x3AC33ABF, 0x3ACB3AC8, 0x3AD43AD0, 0x3ADC3AD8,
  0x3AE43AE0, 0x3AEC3AE7, 0x3AF43AF0, 0x3AFB3AF7,
  0x3B043B00, 0x3B0C3B08, 0x3B143B10, 0x3B1C3B18,
  0x3B233B20, 0x3B2C3B27, 0x3B343B30, 0x3B3C3B37,
  0x3B443B40, 0x3B4C3B48, 0x3B533B50, 0x3B5C3B58,
  0x3B643B5F, 0x3B6C3B68, 0x3B743B70, 0x3B7B3B78,
  0x3B843B80, 0x3B8C3B88, 0x3B943B90, 0x3B9C3B98,
  0x3BA43B9F, 0x3BAC3BA8, 0x3BB43BB0, 0x3BBC3BB9,
  0x3BC43BC1, 0x3BCD3BC8, 0x3BD53BD1, 0x3BDD3BD9,
  0x3BE43BE0, 0x3BEC3BE9, 0x3BF43BF1, 0x3BFC3BF9,

 /* rdf table 1 */
  0x1E030A6F, 0x23012202, 0x267D23FE, 0x27802701,
  0x2A412A00, 0x2AC12A80, 0x2B3E2B01, 0x2BBF2B7F,
  0x2E1C2E00, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,

 /* rdf table 2*/
  0x1E030A6F, 0x23012202, 0x267D23FE, 0x27802701,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,

 /* rdf table 3 */
  0x1E030A6F, 0x23012202, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,

 /* rdf table 4 */
  0x1E030A6F, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,

 /* rdf table 5 */
  0x1B180A6F, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,

 /* rdf table 6 */
  0x17120A6F, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,

 /* rdf table 7 */
  0x130E0A6F, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130F, 0x130F130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130F130F, 0x130E130E, 0x130E130F, 0x130F130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130F130E,
  0x130F130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130F, 0x130F130F,
  0x130F130F, 0x130F130E, 0x130F130F, 0x130F130F,
  0x130F130E, 0x130E130F, 0x130F130E, 0x130E130E,
  0x130F130F, 0x130F130E, 0x130E130F, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130F130F, 0x130F130F,
  0x130E130F, 0x130F130E, 0x130F130F, 0x130E130F,
  0x130F130E, 0x130F130E, 0x130E130F, 0x130E130E,
  0x130F130E, 0x130F130E, 0x130E130E, 0x130E130F,
  0x130E130E, 0x130F130E, 0x130E130F, 0x130F130E,
  0x130F130F, 0x130F130F, 0x130F130E, 0x130E130F,
  0x130F130F, 0x130F130E, 0x130F130F, 0x130F130F,
  0x130E130F, 0x130F130F, 0x130F130F, 0x130F130F,
  0x130E130F, 0x130E130E, 0x130F130E, 0x130F130F,
  0x130F130F, 0x130F130E, 0x130E130E, 0x130F130E,
  0x130F130E, 0x130F130E, 0x130F130F, 0x130E130F,
  0x130E130F, 0x130E130F, 0x130E130F, 0x130F130F,

 /* rdf table 8   */
  0x0F0D0A6F, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,

 /* rdf table 9     */
  0x0B0C0A6F, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,

 /* rdf table 10      */
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,

 /* rdf table 11        */
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030D030C,
  0x030C030C, 0x030D030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030D, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030D030C, 0x030C030C, 0x030C030C, 0x030C030D,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030D030C,
  0x030C030C, 0x030D030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030D,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030D030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030D030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030D, 0x030C030C, 0x030C030D, 0x030C030C,

 /* rdf table 12          */
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01870186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860186, 0x01860186, 0x01860186, 0x01860186,

 /* rdf table 13            */
  0x00C200C2, 0x00C200C2, 0x00C200C3, 0x00C300C3,
  0x00C300C2, 0x00C200C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C2, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C2,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C200C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C300C3, 0x00C300C3,

 /* rdf table 14      */
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610062, 0x00610061, 0x00610062, 0x00620062,
  0x00620062, 0x00620061, 0x00610062, 0x00620062,
  0x00620061, 0x00610062, 0x00620061, 0x00610061,
  0x00620061, 0x00620061, 0x00610062, 0x00610061,
  0x00610061, 0x00610061, 0x00620062, 0x00620062,
  0x00610062, 0x00620061, 0x00620062, 0x00610062,
  0x00620061, 0x00620061, 0x00610062, 0x00610061,
  0x00620061, 0x00610061, 0x00610061, 0x00610062,
  0x00610061, 0x00620061, 0x00610062, 0x00620061,
  0x00620061, 0x00620062, 0x00620061, 0x00610062,
  0x00620062, 0x00620061, 0x00620062, 0x00620062,
  0x00610062, 0x00620062, 0x00610062, 0x00620062,
  0x00610062, 0x00610061, 0x00620061, 0x00620062,
  0x00620062, 0x00620061, 0x00610061, 0x00620061,
  0x00620061, 0x00620061, 0x00620062, 0x00610062,
  0x00610062, 0x00610061, 0x00610062, 0x00610061,

 /* rdf table 15      */
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00310031,
  0x00300030, 0x00300031, 0x00310031, 0x00300030,
  0x00310030, 0x00300031, 0x00310031, 0x00300031,
  0x00300030, 0x00300031, 0x00310031, 0x00310030,
  0x00310031, 0x00300031, 0x00310031, 0x00310031,
  0x00300031, 0x00300030, 0x00300030, 0x00300030,
  0x00310030, 0x00310030, 0x00310030, 0x00310030,
  0x00310031, 0x00310030, 0x00310031, 0x00300031,
  0x00300031, 0x00300030, 0x00300031, 0x00300031,
  0x00300031, 0x00300031, 0x00310031, 0x00310031,
  0x00310031, 0x00310030, 0x00310031, 0x00310031,
  0x00310031, 0x00300031, 0x00310031, 0x00300031,
  0x00310031, 0x00310030, 0x00300031, 0x00310030,
  0x00300031, 0x00300031, 0x00310031, 0x00310031,
  0x00300031, 0x00310031, 0x00310031, 0x00300031,
  0x00310030, 0x00310030, 0x00310031, 0x00300030,
  0x00310031, 0x00310030, 0x00300031, 0x00310031,
  0x00300030, 0x00310031, 0x00310031, 0x00310030,
  0x00310031, 0x00310031, 0x00310030, 0x00310031,
  0x00310031, 0x00310030, 0x00310031, 0x00310031,
  0x00300031, 0x00310031, 0x00310031, 0x00310031,
  0x00310031, 0x00310030, 0x00310030, 0x00310031,
  0x00310031, 0x00310030, 0x00310030, 0x00310031,
  0x00310030, 0x00310031, 0x00310031, 0x00310031,
  0x00300031, 0x00300031, 0x00300031, 0x00310031
 };



/*
 * Rate tables for 25.6 Mbps adapters
 */ 

u_int32_t abr_vbr_rate_tables_25Mb[] = {


/* Rate Convertion Table  */
  /* rate, cps bits:31-17, nrm bits:16-14, interval bits:13-0  */ 
  /* 000 */ 0x8d0022e1, /* cps = 10.000380, nrm = 3, interval = 5896.000000 */
  /* 001 */ 0x8d2c22c8, /* cps = 10.343750, nrm = 3, interval = 5696.000000 */
  /* 002 */ 0x8d5a22b0, /* cps = 10.703125, nrm = 3, interval = 5504.000000 */
  /* 003 */ 0x8d8a2299, /* cps = 11.078125, nrm = 3, interval = 5320.000000 */
  /* 004 */ 0x8dba2283, /* cps = 11.453125, nrm = 3, interval = 5144.000000 */
  /* 005 */ 0x8dee226d, /* cps = 11.859375, nrm = 3, interval = 4968.000000 */
  /* 006 */ 0x8e242258, /* cps = 12.281250, nrm = 3, interval = 4800.000000 */
  /* 007 */ 0x8e5a2244, /* cps = 12.703125, nrm = 3, interval = 4640.000000 */
  /* 008 */ 0x8e902231, /* cps = 13.125000, nrm = 3, interval = 4488.000000 */
  /* 009 */ 0x8ecc221e, /* cps = 13.593750, nrm = 3, interval = 4336.000000 */
  /* 010 */ 0x8f08220c, /* cps = 14.062500, nrm = 3, interval = 4192.000000 */
  /* 011 */ 0x8f461ff5, /* cps = 14.546875, nrm = 3, interval = 4052.000000 */
  /* 012 */ 0x8f861fd3, /* cps = 15.046875, nrm = 3, interval = 3916.000000 */
  /* 013 */ 0x8fca1fb2, /* cps = 15.578125, nrm = 3, interval = 3784.000000 */
  /* 014 */ 0x90061f93, /* cps = 16.093750, nrm = 3, interval = 3660.000000 */
  /* 015 */ 0x902a1f74, /* cps = 16.656250, nrm = 3, interval = 3536.000000 */
  /* 016 */ 0x90501f56, /* cps = 17.250000, nrm = 3, interval = 3416.000000 */
  /* 017 */ 0x90761f3a, /* cps = 17.843750, nrm = 3, interval = 3304.000000 */
  /* 018 */ 0x909e1f1e, /* cps = 18.468750, nrm = 3, interval = 3192.000000 */
  /* 019 */ 0x90c61f03, /* cps = 19.093750, nrm = 3, interval = 3084.000000 */
  /* 020 */ 0x90f01eea, /* cps = 19.750000, nrm = 3, interval = 2984.000000 */
  /* 021 */ 0x911c1ed1, /* cps = 20.437500, nrm = 3, interval = 2884.000000 */
  /* 022 */ 0x914a1eb8, /* cps = 21.156250, nrm = 3, interval = 2784.000000 */
  /* 023 */ 0x91781ea1, /* cps = 21.875000, nrm = 3, interval = 2692.000000 */
  /* 024 */ 0x91a81e8b, /* cps = 22.625000, nrm = 3, interval = 2604.000000 */
  /* 025 */ 0x91da1e75, /* cps = 23.406250, nrm = 3, interval = 2516.000000 */
  /* 026 */ 0x920e1e60, /* cps = 24.218750, nrm = 3, interval = 2432.000000 */
  /* 027 */ 0x92461e4b, /* cps = 25.093750, nrm = 3, interval = 2348.000000 */
  /* 028 */ 0x927c1e38, /* cps = 25.937500, nrm = 3, interval = 2272.000000 */
  /* 029 */ 0x92b61e25, /* cps = 26.843750, nrm = 3, interval = 2196.000000 */
  /* 030 */ 0x92f21e12, /* cps = 27.781250, nrm = 3, interval = 2120.000000 */
  /* 031 */ 0x932e1e01, /* cps = 28.718750, nrm = 3, interval = 2052.000000 */
  /* 032 */ 0x936e1bdf, /* cps = 29.718750, nrm = 3, interval = 1982.000000 */
  /* 033 */ 0x93b01bbe, /* cps = 30.750000, nrm = 3, interval = 1916.000000 */
  /* 034 */ 0x93f41b9e, /* cps = 31.812500, nrm = 3, interval = 1852.000000 */
  /* 035 */ 0x941e1b7f, /* cps = 32.937500, nrm = 3, interval = 1790.000000 */
  /* 036 */ 0x94421b61, /* cps = 34.062500, nrm = 3, interval = 1730.000000 */
  /* 037 */ 0x94681b44, /* cps = 35.250000, nrm = 3, interval = 1672.000000 */
  /* 038 */ 0x948e1b28, /* cps = 36.437500, nrm = 3, interval = 1616.000000 */
  /* 039 */ 0x94b61b0d, /* cps = 37.687500, nrm = 3, interval = 1562.000000 */
  /* 040 */ 0x94e01af3, /* cps = 39.000000, nrm = 3, interval = 1510.000000 */
  /* 041 */ 0x950e5ad9, /* cps = 40.437500, nrm = 4, interval = 1458.000000 */
  /* 042 */ 0x953a5ac1, /* cps = 41.812500, nrm = 4, interval = 1410.000000 */
  /* 043 */ 0x95685aa9, /* cps = 43.250000, nrm = 4, interval = 1362.000000 */
  /* 044 */ 0x95965a93, /* cps = 44.687500, nrm = 4, interval = 1318.000000 */
  /* 045 */ 0x95c85a7d, /* cps = 46.250000, nrm = 4, interval = 1274.000000 */
  /* 046 */ 0x95fc5a67, /* cps = 47.875000, nrm = 4, interval = 1230.000000 */
  /* 047 */ 0x96305a53, /* cps = 49.500000, nrm = 4, interval = 1190.000000 */
  /* 048 */ 0x96685a3f, /* cps = 51.250000, nrm = 4, interval = 1150.000000 */
  /* 049 */ 0x96a25a2b, /* cps = 53.062500, nrm = 4, interval = 1110.000000 */
  /* 050 */ 0x96dc5a19, /* cps = 54.875000, nrm = 4, interval = 1074.000000 */
  /* 051 */ 0x97185a07, /* cps = 56.750000, nrm = 4, interval = 1038.000000 */
  /* 052 */ 0x975857eb, /* cps = 58.750000, nrm = 4, interval = 1003.000000 */
  /* 053 */ 0x979857ca, /* cps = 60.750000, nrm = 4, interval = 970.000000 */
  /* 054 */ 0x97dc57a9, /* cps = 62.875000, nrm = 4, interval = 937.000000 */
  /* 055 */ 0x9810578a, /* cps = 65.000000, nrm = 4, interval = 906.000000 */
  /* 056 */ 0x9834576c, /* cps = 67.250000, nrm = 4, interval = 876.000000 */
  /* 057 */ 0x985a574e, /* cps = 69.625000, nrm = 4, interval = 846.000000 */
  /* 058 */ 0x98805732, /* cps = 72.000000, nrm = 4, interval = 818.000000 */
  /* 059 */ 0x98aa5716, /* cps = 74.625000, nrm = 4, interval = 790.000000 */
  /* 060 */ 0x98d256fc, /* cps = 77.125000, nrm = 4, interval = 764.000000 */
  /* 061 */ 0x98fe56e2, /* cps = 79.875000, nrm = 4, interval = 738.000000 */
  /* 062 */ 0x992896ca, /* cps = 82.500000, nrm = 8, interval = 714.000000 */
  /* 063 */ 0x995696b2, /* cps = 85.375000, nrm = 8, interval = 690.000000 */
  /* 064 */ 0x9986969b, /* cps = 88.375000, nrm = 8, interval = 667.000000 */
  /* 065 */ 0x99b89684, /* cps = 91.500000, nrm = 8, interval = 644.000000 */
  /* 066 */ 0x99ea966f, /* cps = 94.625000, nrm = 8, interval = 623.000000 */
  /* 067 */ 0x9a1e965a, /* cps = 97.875000, nrm = 8, interval = 602.000000 */
  /* 068 */ 0x9a549646, /* cps = 101.250000, nrm = 8, interval = 582.000000 */
  /* 069 */ 0x9a8e9632, /* cps = 104.875000, nrm = 8, interval = 562.000000 */
  /* 070 */ 0x9ac8961f, /* cps = 108.500000, nrm = 8, interval = 543.000000 */
  /* 071 */ 0x9b04960d, /* cps = 112.250000, nrm = 8, interval = 525.000000 */
  /* 072 */ 0x9b4093f8, /* cps = 116.000000, nrm = 8, interval = 508.000000 */
  /* 073 */ 0x9b8093d6, /* cps = 120.000000, nrm = 8, interval = 491.000000 */
  /* 074 */ 0x9bc493b5, /* cps = 124.250000, nrm = 8, interval = 474.500000 */
  /* 075 */ 0x9c049395, /* cps = 128.500000, nrm = 8, interval = 458.500000 */
  /* 076 */ 0x9c289376, /* cps = 133.000000, nrm = 8, interval = 443.000000 */
  /* 077 */ 0x9c4c9359, /* cps = 137.500000, nrm = 8, interval = 428.500000 */
  /* 078 */ 0x9c72933c, /* cps = 142.250000, nrm = 8, interval = 414.000000 */
  /* 079 */ 0x9c9a9320, /* cps = 147.250000, nrm = 8, interval = 400.000000 */
  /* 080 */ 0x9cc49305, /* cps = 152.500000, nrm = 8, interval = 386.500000 */
  /* 081 */ 0x9cee92eb, /* cps = 157.750000, nrm = 8, interval = 373.500000 */
  /* 082 */ 0x9d1ad2d2, /* cps = 163.250000, nrm = 16, interval = 361.000000 */
  /* 083 */ 0x9d46d2ba, /* cps = 168.750000, nrm = 16, interval = 349.000000 */
  /* 084 */ 0x9d74d2a3, /* cps = 174.500000, nrm = 16, interval = 337.500000 */
  /* 085 */ 0x9da6d28c, /* cps = 180.750000, nrm = 16, interval = 326.000000 */
  /* 086 */ 0x9dd8d276, /* cps = 187.000000, nrm = 16, interval = 315.000000 */
  /* 087 */ 0x9e0cd261, /* cps = 193.500000, nrm = 16, interval = 304.500000 */
  /* 088 */ 0x9e40d24d, /* cps = 200.000000, nrm = 16, interval = 294.500000 */
  /* 089 */ 0x9e78d239, /* cps = 207.000000, nrm = 16, interval = 284.500000 */
  /* 090 */ 0x9eb2d226, /* cps = 214.250000, nrm = 16, interval = 275.000000 */
  /* 091 */ 0x9eecd214, /* cps = 221.500000, nrm = 16, interval = 266.000000 */
  /* 092 */ 0x9f2ad202, /* cps = 229.250000, nrm = 16, interval = 257.000000 */
  /* 093 */ 0x9f6acfe2, /* cps = 237.250000, nrm = 16, interval = 248.500000 */
  /* 094 */ 0x9faccfc0, /* cps = 245.500000, nrm = 16, interval = 240.000000 */
  /* 095 */ 0x9ff0cfa0, /* cps = 254.000000, nrm = 16, interval = 232.000000 */
  /* 096 */ 0xa01acf81, /* cps = 262.500000, nrm = 16, interval = 224.250000 */
  /* 097 */ 0xa040cf63, /* cps = 272.000000, nrm = 16, interval = 216.750000 */
  /* 098 */ 0xa064cf46, /* cps = 281.000000, nrm = 16, interval = 209.500000 */
  /* 099 */ 0xa08ccf2a, /* cps = 291.000000, nrm = 16, interval = 202.500000 */
  /* 100 */ 0xa0b4cf0f, /* cps = 301.000000, nrm = 16, interval = 195.750000 */
  /* 101 */ 0xa0decef5, /* cps = 311.500000, nrm = 16, interval = 189.250000 */
  /* 102 */ 0xa10b0edb, /* cps = 322.500000, nrm = 32, interval = 182.750000 */
  /* 103 */ 0xa1370ec3, /* cps = 333.500000, nrm = 32, interval = 176.750000 */
  /* 104 */ 0xa1650eab, /* cps = 345.000000, nrm = 32, interval = 170.750000 */
  /* 105 */ 0xa1950e94, /* cps = 357.000000, nrm = 32, interval = 165.000000 */
  /* 106 */ 0xa1c70e7e, /* cps = 369.500000, nrm = 32, interval = 159.500000 */
  /* 107 */ 0xa1f90e69, /* cps = 382.000000, nrm = 32, interval = 154.250000 */
  /* 108 */ 0xa22f0e54, /* cps = 395.500000, nrm = 32, interval = 149.000000 */
  /* 109 */ 0xa2650e40, /* cps = 409.000000, nrm = 32, interval = 144.000000 */
  /* 110 */ 0xa29d0e2d, /* cps = 423.000000, nrm = 32, interval = 139.250000 */
  /* 111 */ 0xa2d90e1a, /* cps = 438.000000, nrm = 32, interval = 134.500000 */
  /* 112 */ 0xa3170e08, /* cps = 453.500000, nrm = 32, interval = 130.000000 */
  /* 113 */ 0xa3530bee, /* cps = 468.500000, nrm = 32, interval = 125.750000 */
  /* 114 */ 0xa3950bcc, /* cps = 485.000000, nrm = 32, interval = 121.500000 */
  /* 115 */ 0xa3d70bac, /* cps = 501.500000, nrm = 32, interval = 117.500000 */
  /* 116 */ 0xa40f0b8c, /* cps = 519.000000, nrm = 32, interval = 113.500000 */
  /* 117 */ 0xa4330b6e, /* cps = 537.000000, nrm = 32, interval = 109.750000 */
  /* 118 */ 0xa4590b50, /* cps = 556.000000, nrm = 32, interval = 106.000000 */
  /* 119 */ 0xa47f0b34, /* cps = 575.000000, nrm = 32, interval = 102.500000 */
  /* 120 */ 0xa4a50b19, /* cps = 594.000000, nrm = 32, interval = 99.125000 */
  /* 121 */ 0xa4cf0afe, /* cps = 615.000000, nrm = 32, interval = 95.750000 */
  /* 122 */ 0xa4fb0ae4, /* cps = 637.000000, nrm = 32, interval = 92.500000 */
  /* 123 */ 0xa5250acc, /* cps = 658.000000, nrm = 32, interval = 89.500000 */
  /* 124 */ 0xa5530ab4, /* cps = 681.000000, nrm = 32, interval = 86.500000 */
  /* 125 */ 0xa5850a9c, /* cps = 706.000000, nrm = 32, interval = 83.500000 */
  /* 126 */ 0xa5b50a86, /* cps = 730.000000, nrm = 32, interval = 80.750000 */
  /* 127 */ 0xa5e70a70, /* cps = 755.000000, nrm = 32, interval = 78.000000 */
  /* 128 */ 0xa61d0a5b, /* cps = 782.000000, nrm = 32, interval = 75.375000 */
  /* 129 */ 0xa6530a47, /* cps = 809.000000, nrm = 32, interval = 72.875000 */
  /* 130 */ 0xa6890a34, /* cps = 836.000000, nrm = 32, interval = 70.500000 */
  /* 131 */ 0xa6c30a21, /* cps = 865.000000, nrm = 32, interval = 68.125000 */
  /* 132 */ 0xa6ff0a0f, /* cps = 895.000000, nrm = 32, interval = 65.875000 */
  /* 133 */ 0xa73d07fa, /* cps = 926.000000, nrm = 32, interval = 63.625000 */
  /* 134 */ 0xa77d07d8, /* cps = 958.000000, nrm = 32, interval = 61.500000 */
  /* 135 */ 0xa7c107b7, /* cps = 992.000000, nrm = 32, interval = 59.437500 */
  /* 136 */ 0xa8030797, /* cps = 1026.000000, nrm = 32, interval = 57.437500 */
  /* 137 */ 0xa8250779, /* cps = 1060.000000, nrm = 32, interval = 55.562500 */
  /* 138 */ 0xa84b075b, /* cps = 1098.000000, nrm = 32, interval = 53.687500 */
  /* 139 */ 0xa871073e, /* cps = 1136.000000, nrm = 32, interval = 51.875000 */
  /* 140 */ 0xa8990722, /* cps = 1176.000000, nrm = 32, interval = 50.125000 */
  /* 141 */ 0xa8c10707, /* cps = 1216.000000, nrm = 32, interval = 48.437500 */
  /* 142 */ 0xa8eb06ed, /* cps = 1258.000000, nrm = 32, interval = 46.812500 */
  /* 143 */ 0xa91706d4, /* cps = 1302.000000, nrm = 32, interval = 45.250000 */
  /* 144 */ 0xa94306bc, /* cps = 1346.000000, nrm = 32, interval = 43.750000 */
  /* 145 */ 0xa97106a5, /* cps = 1392.000000, nrm = 32, interval = 42.312500 */
  /* 146 */ 0xa9a3068e, /* cps = 1442.000000, nrm = 32, interval = 40.875000 */
  /* 147 */ 0xa9d50678, /* cps = 1492.000000, nrm = 32, interval = 39.500000 */
  /* 148 */ 0xaa090663, /* cps = 1544.000000, nrm = 32, interval = 38.187500 */
  /* 149 */ 0xaa3f064e, /* cps = 1598.000000, nrm = 32, interval = 36.875000 */
  /* 150 */ 0xaa75063b, /* cps = 1652.000000, nrm = 32, interval = 35.687500 */
  /* 151 */ 0xaab10627, /* cps = 1712.000000, nrm = 32, interval = 34.437500 */
  /* 152 */ 0xaae90615, /* cps = 1768.000000, nrm = 32, interval = 33.312500 */
  /* 153 */ 0xab270603, /* cps = 1830.000000, nrm = 32, interval = 32.187500 */
  /* 154 */ 0xab6703e4, /* cps = 1894.000000, nrm = 32, interval = 31.125000 */
  /* 155 */ 0xaba703c3, /* cps = 1958.000000, nrm = 32, interval = 30.093750 */
  /* 156 */ 0xabeb03a3, /* cps = 2026.000000, nrm = 32, interval = 29.093750 */
  /* 157 */ 0xac190383, /* cps = 2096.000000, nrm = 32, interval = 28.093750 */
  /* 158 */ 0xac3d0365, /* cps = 2168.000000, nrm = 32, interval = 27.156250 */
  /* 159 */ 0xac630348, /* cps = 2244.000000, nrm = 32, interval = 26.250000 */
  /* 160 */ 0xac89032c, /* cps = 2320.000000, nrm = 32, interval = 25.375000 */
  /* 161 */ 0xacb10311, /* cps = 2400.000000, nrm = 32, interval = 24.531250 */
  /* 162 */ 0xacdb02f7, /* cps = 2484.000000, nrm = 32, interval = 23.718750 */
  /* 163 */ 0xad0702dd, /* cps = 2572.000000, nrm = 32, interval = 22.906250 */
  /* 164 */ 0xad3302c5, /* cps = 2660.000000, nrm = 32, interval = 22.156250 */
  /* 165 */ 0xad6102ad, /* cps = 2752.000000, nrm = 32, interval = 21.406250 */
  /* 166 */ 0xad910296, /* cps = 2848.000000, nrm = 32, interval = 20.687500 */
  /* 167 */ 0xadc30280, /* cps = 2948.000000, nrm = 32, interval = 20.000000 */
  /* 168 */ 0xadf7026a, /* cps = 3052.000000, nrm = 32, interval = 19.312500 */
  /* 169 */ 0xae290256, /* cps = 3152.000000, nrm = 32, interval = 18.687500 */
  /* 170 */ 0xae610242, /* cps = 3264.000000, nrm = 32, interval = 18.062500 */
  /* 171 */ 0xae9b022e, /* cps = 3380.000000, nrm = 32, interval = 17.437500 */
  /* 172 */ 0xaed3021c, /* cps = 3492.000000, nrm = 32, interval = 16.875000 */
  /* 173 */ 0xaf130209, /* cps = 3620.000000, nrm = 32, interval = 16.281250 */
  /* 174 */ 0xaf4f01f8, /* cps = 3740.000000, nrm = 32, interval = 15.750000 */
  /* 175 */ 0xaf9101e7, /* cps = 3872.000000, nrm = 32, interval = 15.218750 */
  /* 176 */ 0xafd301d7, /* cps = 4004.000000, nrm = 32, interval = 14.718750 */
  /* 177 */ 0xb00d01c7, /* cps = 4144.000000, nrm = 32, interval = 14.218750 */
  /* 178 */ 0xb03101b8, /* cps = 4288.000000, nrm = 32, interval = 13.750000 */
  /* 179 */ 0xb05501a9, /* cps = 4432.000000, nrm = 32, interval = 13.281250 */
  /* 180 */ 0xb07b019b, /* cps = 4584.000000, nrm = 32, interval = 12.843750 */
  /* 181 */ 0xb0a5018d, /* cps = 4752.000000, nrm = 32, interval = 12.406250 */
  /* 182 */ 0xb0cd0180, /* cps = 4912.000000, nrm = 32, interval = 12.000000 */
  /* 183 */ 0xb0f70173, /* cps = 5080.000000, nrm = 32, interval = 11.593750 */
  /* 184 */ 0xb1250166, /* cps = 5264.000000, nrm = 32, interval = 11.187500 */
  /* 185 */ 0xb153015a, /* cps = 5448.000000, nrm = 32, interval = 10.812500 */
  /* 186 */ 0xb181014f, /* cps = 5632.000000, nrm = 32, interval = 10.468750 */
  /* 187 */ 0xb1af0144, /* cps = 5816.000000, nrm = 32, interval = 10.125000 */
  /* 188 */ 0xb1e30139, /* cps = 6024.000000, nrm = 32, interval = 9.781250 */
  /* 189 */ 0xb219012e, /* cps = 6240.000000, nrm = 32, interval = 9.437500 */
  /* 190 */ 0xb24f0124, /* cps = 6456.000000, nrm = 32, interval = 9.125000 */
  /* 191 */ 0xb289011a, /* cps = 6688.000000, nrm = 32, interval = 8.812500 */
  /* 192 */ 0xb2bf0111, /* cps = 6904.000000, nrm = 32, interval = 8.531250 */
  /* 193 */ 0xb2fb0108, /* cps = 7144.000000, nrm = 32, interval = 8.250000 */
  /* 194 */ 0xb33900ff, /* cps = 7392.000000, nrm = 32, interval = 7.968750 */
  /* 195 */ 0xb37d00f6, /* cps = 7664.000000, nrm = 32, interval = 7.687500 */
  /* 196 */ 0xb3bd00ee, /* cps = 7920.000000, nrm = 32, interval = 7.437500 */
  /* 197 */ 0xb40100e6, /* cps = 8192.000000, nrm = 32, interval = 7.187500 */
  /* 198 */ 0xb42700de, /* cps = 8496.000000, nrm = 32, interval = 6.937500 */
  /* 199 */ 0xb44900d7, /* cps = 8768.000000, nrm = 32, interval = 6.718750 */
  /* 200 */ 0xb46d00d0, /* cps = 9056.000000, nrm = 32, interval = 6.500000 */
  /* 201 */ 0xb49500c9, /* cps = 9376.000000, nrm = 32, interval = 6.281250 */
  /* 202 */ 0xb4bf00c2, /* cps = 9712.000000, nrm = 32, interval = 6.062500 */
  /* 203 */ 0xb4ed00bb, /* cps = 10080.000000, nrm = 32, interval = 5.843750 */
  /* 204 */ 0xb51700b5, /* cps = 10416.000000, nrm = 32, interval = 5.656250 */
  /* 205 */ 0xb54300af, /* cps = 10768.000000, nrm = 32, interval = 5.468750 */
  /* 206 */ 0xb57300a9, /* cps = 11152.000000, nrm = 32, interval = 5.281250 */
  /* 207 */ 0xb59f00a4, /* cps = 11504.000000, nrm = 32, interval = 5.125000 */
  /* 208 */ 0xb5d5009e, /* cps = 11936.000000, nrm = 32, interval = 4.937500 */
  /* 209 */ 0xb6050099, /* cps = 12320.000000, nrm = 32, interval = 4.781250 */
  /* 210 */ 0xb6390094, /* cps = 12736.000000, nrm = 32, interval = 4.625000 */
  /* 211 */ 0xb671008f, /* cps = 13184.000000, nrm = 32, interval = 4.468750 */
  /* 212 */ 0xb6ad008a, /* cps = 13664.000000, nrm = 32, interval = 4.312500 */
  /* 213 */ 0xb6ed0085, /* cps = 14176.000000, nrm = 32, interval = 4.156250 */
  /* 214 */ 0xb7250081, /* cps = 14624.000000, nrm = 32, interval = 4.031250 */
  /* 215 */ 0xb76f007c, /* cps = 15216.000000, nrm = 32, interval = 3.875000 */
  /* 216 */ 0xb7ad0078, /* cps = 15712.000000, nrm = 32, interval = 3.750000 */
  /* 217 */ 0xb7f10074, /* cps = 16256.000000, nrm = 32, interval = 3.625000 */
  /* 218 */ 0xb81d0070, /* cps = 16832.000000, nrm = 32, interval = 3.500000 */
  /* 219 */ 0xb839006d, /* cps = 17280.000000, nrm = 32, interval = 3.406250 */
  /* 220 */ 0xb8630069, /* cps = 17952.000000, nrm = 32, interval = 3.281250 */
  /* 221 */ 0xb88f0065, /* cps = 18656.000000, nrm = 32, interval = 3.156250 */
  /* 222 */ 0xb8b30062, /* cps = 19232.000000, nrm = 32, interval = 3.062500 */
  /* 223 */ 0xb8d9005f, /* cps = 19840.000000, nrm = 32, interval = 2.968750 */
  /* 224 */ 0xb90f005b, /* cps = 20704.000000, nrm = 32, interval = 2.843750 */
  /* 225 */ 0xb93d0058, /* cps = 21440.000000, nrm = 32, interval = 2.750000 */
  /* 226 */ 0xb96b0055, /* cps = 22176.000000, nrm = 32, interval = 2.656250 */
  /* 227 */ 0xb98d0053, /* cps = 22720.000000, nrm = 32, interval = 2.593750 */
  /* 228 */ 0xb9c30050, /* cps = 23584.000000, nrm = 32, interval = 2.500000 */
  /* 229 */ 0xb9fb004d, /* cps = 24480.000000, nrm = 32, interval = 2.406250 */
  /* 230 */ 0xba39004a, /* cps = 25472.000000, nrm = 32, interval = 2.312500 */
  /* 231 */ 0xba650048, /* cps = 26176.000000, nrm = 32, interval = 2.250000 */
  /* 232 */ 0xba950046, /* cps = 26944.000000, nrm = 32, interval = 2.187500 */
  /* 233 */ 0xbae10043, /* cps = 28160.000000, nrm = 32, interval = 2.093750 */
  /* 234 */ 0xbb170041, /* cps = 29024.000000, nrm = 32, interval = 2.031250 */
  /* 235 */ 0xbb4f003f, /* cps = 29920.000000, nrm = 32, interval = 1.968750 */
  /* 236 */ 0xbb8d003d, /* cps = 30912.000000, nrm = 32, interval = 1.906250 */
  /* 237 */ 0xbbcf003b, /* cps = 31968.000000, nrm = 32, interval = 1.843750 */
  /* 238 */ 0xbc0b0039, /* cps = 33088.000000, nrm = 32, interval = 1.781250 */
  /* 239 */ 0xbc310037, /* cps = 34304.000000, nrm = 32, interval = 1.718750 */
  /* 240 */ 0xbc590035, /* cps = 35584.000000, nrm = 32, interval = 1.656250 */
  /* 241 */ 0xbc850033, /* cps = 36992.000000, nrm = 32, interval = 1.593750 */
  /* 242 */ 0xbcb30031, /* cps = 38464.000000, nrm = 32, interval = 1.531250 */
  /* 243 */ 0xbccd0030, /* cps = 39296.000000, nrm = 32, interval = 1.500000 */
  /* 244 */ 0xbd01002e, /* cps = 40960.000000, nrm = 32, interval = 1.437500 */
  /* 245 */ 0xbd3d002c, /* cps = 42880.000000, nrm = 32, interval = 1.375000 */
  /* 246 */ 0xbd5b002b, /* cps = 43840.000000, nrm = 32, interval = 1.343750 */
  /* 247 */ 0xbd7b002a, /* cps = 44864.000000, nrm = 32, interval = 1.312500 */
  /* 248 */ 0xbdc30028, /* cps = 47168.000000, nrm = 32, interval = 1.250000 */
  /* 249 */ 0xbde70027, /* cps = 48320.000000, nrm = 32, interval = 1.218750 */
  /* 250 */ 0xbe390025, /* cps = 50944.000000, nrm = 32, interval = 1.156250 */
  /* 251 */ 0xbe650024, /* cps = 52352.000000, nrm = 32, interval = 1.125000 */
  /* 252 */ 0xbe950023, /* cps = 53888.000000, nrm = 32, interval = 1.093750 */
  /* 253 */ 0xbec70022, /* cps = 55488.000000, nrm = 32, interval = 1.062500 */
  /* 254 */ 0xbefb0021, /* cps = 57152.000000, nrm = 32, interval = 1.031250 */
  /* 255 */ 0xbf6f001f, /* cps = 60864.000000, nrm = 32, interval = 0.968750 */

/* rate2log table  */
 0x01010101, 0x01010101, 0x01010101, 0x01010101,
 0x01010101, 0x01010101, 0x01010101, 0x01010101,
 0x01010101, 0x01010101, 0x01010101, 0x01010101,
 0x01010101, 0x05040302, 0x09080706, 0x0C0B0A0A,
 0x11100F0D, 0x16151413, 0x1A191817, 0x1D1C1B1A,
 0x2221201E, 0x27262523, 0x2A2A2928, 0x2E2D2C2B,
 0x3332312F, 0x38373534, 0x3B3A3A39, 0x3F3E3D3C,
 0x44434140, 0x48474645, 0x4C4B4A49, 0x4F4F4E4D,
 0x55545251, 0x59585756, 0x5D5C5B5A, 0x60605F5E,
 0x66656362, 0x6A696867, 0x6E6D6C6B, 0x7171706F,
 0x77757473, 0x7B7A7978, 0x7F7E7D7C, 0x82818180,
 0x88868584, 0x8C8B8A89, 0x908F8E8D, 0x93929191,
 0x98979695, 0x9D9C9B9A, 0xA1A09F9E, 0xA4A3A2A2,
 0xA9A8A7A5, 0xAEADACAB, 0xB1B1B0AF, 0xB5B4B3B2,
 0xBAB9B7B6, 0xBFBEBCBB, 0xC2C1C1C0, 0xC6C5C4C3,
 0xCBCAC8C7, 0xCFCECDCC, 0xD3D2D1D0, 0xD7D6D5D4,
 0xDBDAD9D7, 0xE0DFDEDC, 0xE4E3E1E1, 0xE7E6E6E4,
 0xEBEBE9E7, 0xF0F0EDED, 0xF5F2F2F2, 0xF8F5F5F5,
 0xFCFCF8F8, 0xFFFFFCFC, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,

/* sram_globals  */
 0x00005F7A, 0x00005D7A, 0x00015B7A, 0x0001597A,
 0x0003557A, 0x00034F7A, 0x00030000, 0x00030000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,
 0x00000000, 0x00000000, 0x00000000, 0x00000000,

 /* rate_table[4] additive increase 0.000424 */
  0x3B473E15, 0x3B3F3B43, 0x3B373B3B, 0x3B2F3B33,
  0x3B273B2A, 0x3B1E3B23, 0x3B173B1B, 0x3B0F3B13,
  0x3B073B0B, 0x3AFF3B03, 0x3AF63AFA, 0x3AEF3AF3,
  0x3AE73AEB, 0x3ADF3AE3, 0x3AD73ADB, 0x3ACF3AD3,
  0x3AC73ACB, 0x3ABF3AC2, 0x3AB73ABB, 0x3AAF3AB3,
  0x3AA63AAA, 0x3A9F3AA2, 0x3A973A9B, 0x3A8F3A93,
  0x3A863A8B, 0x3A7E3A83, 0x3A773A7A, 0x3A6F3A73,
  0x3A663A6B, 0x3A5F3A63, 0x3A563A5B, 0x3A4F3A53,
  0x3A473A4B, 0x3A3F3A43, 0x3A363A3A, 0x3A2F3A33,
  0x3A273A2A, 0x3A1F3A23, 0x3A173A1A, 0x3A0F3A13,
  0x3A073A0B, 0x37FE3A03, 0x37EE37F6, 0x37DD37E5,
  0x37CE37D6, 0x37BE37C6, 0x37AE37B5, 0x379E37A6,
  0x378E3796, 0x377E3786, 0x376D3776, 0x375D3766,
  0x374E3756, 0x373E3745, 0x372E3736, 0x371E3726,
  0x370E3716, 0x36FE3705, 0x36EE36F6, 0x36DE36E6,
  0x36CE36D5, 0x36BE36C5, 0x36AD36B6, 0x369D36A6,
  0x368E3696, 0x367E3686, 0x366E3676, 0x365E3666,
  0x364E3656, 0x363E3646, 0x362E3636, 0x361E3626,
  0x360E3616, 0x33FB3606, 0x33DC33EC, 0x33BB33CC,
  0x339C33AB, 0x337B338B, 0x335B336B, 0x333B334B,
  0x331B332A, 0x32FC330B, 0x32DB32EA, 0x32BA32CB,
  0x329B32AC, 0x327A328B, 0x325A326C, 0x323A324A,
  0x3219322B, 0x2FF3320A, 0x2FB52FD8, 0x2F712F98,
  0x2F372F51, 0x2EF02F15, 0x2EB72ED4, 0x2E782E98,
  0x2E342E57, 0x2BEF2E10, 0x2B692BA0, 0x2AD82B31,
  0x2A572A99, 0x27E32A16, 0x26B82751, 0x2390261A,
  0x1F002235, 0x5BFF1B04, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[5] additive increase 0.000212 */
  0x3B033BE7, 0x3AFB3AFF, 0x3AF33AF7, 0x3AEB3AEF,
  0x3AE33AE7, 0x3ADB3ADF, 0x3AD33AD7, 0x3ACB3ACF,
  0x3AC33AC7, 0x3ABB3ABF, 0x3AB33AB7, 0x3AAB3AAF,
  0x3AA33AA7, 0x3A9B3A9F, 0x3A933A97, 0x3A8B3A8F,
  0x3A833A87, 0x3A7B3A7F, 0x3A733A77, 0x3A6B3A6F,
  0x3A633A67, 0x3A5B3A5F, 0x3A533A57, 0x3A4B3A4F,
  0x3A433A47, 0x3A3B3A3F, 0x3A333A37, 0x3A2B3A2F,
  0x3A233A27, 0x3A1B3A1F, 0x3A133A17, 0x3A0C3A0F,
  0x3A033A07, 0x37F837FF, 0x37E737EF, 0x37D837E0,
  0x37C837D0, 0x37B837C0, 0x37A837B0, 0x379837A0,
  0x37883790, 0x37793781, 0x37693771, 0x37593761,
  0x37493751, 0x37393741, 0x372A3731, 0x371A3722,
  0x370A3712, 0x36FA3702, 0x36EB36F3, 0x36DB36E3,
  0x36CB36D3, 0x36BC36C3, 0x36AC36B4, 0x369D36A5,
  0x368D3695, 0x367E3686, 0x366F3676, 0x365F3667,
  0x36503658, 0x36413648, 0x36313639, 0x3622362A,
  0x3614361B, 0x3605360C, 0x33EC33FB, 0x33CF33DE,
  0x33B233C0, 0x339533A3, 0x33783386, 0x335B3369,
  0x333F334D, 0x33223331, 0x33073315, 0x32EB32F9,
  0x32D032DD, 0x32B532C3, 0x329B32A8, 0x3280328D,
  0x32673273, 0x324E325A, 0x32353240, 0x321C3228,
  0x32053212, 0x2FDB2FF3, 0x2FAD2FC7, 0x2F802F97,
  0x2F542F6D, 0x2F2B2F40, 0x2F032F19, 0x2ED92EF1,
  0x2EB72EC6, 0x2E8D2EA2, 0x2E6D2E7E, 0x2E4C2E5D,
  0x2E282E3A, 0x2BEF2E10, 0x2B692BA0, 0x2AD82B31,
  0x2A572A99, 0x27E32A16, 0x26B82751, 0x2390261A,
  0x1F002235, 0x5BFF1B04, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[6] additive increase 0.000106 */
  0x3ABF3BA4, 0x3AB73ABC, 0x3AB03AB4, 0x3AA73AAB,
  0x3A9F3AA3, 0x3A973A9B, 0x3A903A94, 0x3A883A8C,
  0x3A803A84, 0x3A783A7C, 0x3A703A73, 0x3A683A6C,
  0x3A603A64, 0x3A583A5C, 0x3A503A54, 0x3A483A4C,
  0x3A403A44, 0x3A383A3C, 0x3A303A34, 0x3A283A2C,
  0x3A203A24, 0x3A183A1C, 0x3A103A14, 0x3A083A0C,
  0x3A003A04, 0x37F037F8, 0x37E037E8, 0x37D137D9,
  0x37C137C9, 0x37B137B9, 0x37A137A9, 0x37913799,
  0x37813789, 0x37713779, 0x37613769, 0x3752375A,
  0x3742374A, 0x3732373A, 0x3723372A, 0x3713371B,
  0x3703370B, 0x36F436FB, 0x36E436EC, 0x36D436DC,
  0x36C436CD, 0x36B536BD, 0x36A536AD, 0x3696369E,
  0x3687368E, 0x3677367F, 0x36683670, 0x36583660,
  0x36493651, 0x363A3641, 0x362B3633, 0x361C3623,
  0x360D3614, 0x33FD3605, 0x33DF33EE, 0x33C233D1,
  0x33A533B3, 0x33883396, 0x336A3379, 0x334E335D,
  0x33323340, 0x33173324, 0x32FB3309, 0x32DF32ED,
  0x32C432D2, 0x32AA32B7, 0x3290329C, 0x32763282,
  0x325C3269, 0x32433250, 0x322B3237, 0x3212321F,
  0x2FF63206, 0x2FC82FDF, 0x2F9B2FB1, 0x2F6F2F84,
  0x2F442F58, 0x2F1C2F2F, 0x2EF32F05, 0x2ECA2EDE,
  0x2EA52EBA, 0x2E802E93, 0x2E5D2E70, 0x2E3A2E4C,
  0x2E192E2B, 0x2BF52E0A, 0x2BBA2BDB, 0x2B7E2BA0,
  0x2B4D2B62, 0x2B132B30, 0x2AE62AFD, 0x2AB82ACF,
  0x2A882AA0, 0x2A602A70, 0x2A362A47, 0x2A0B2A25,
  0x27CF27F3, 0x279A27AD, 0x26B82751, 0x2390261A,
  0x1F002235, 0x5BFF1B04, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[7] additive increase 0.000053 */
  0x3A7C3B60, 0x3A743A78, 0x3A6C3A70, 0x3A643A68,
  0x3A5C3A60, 0x3A543A58, 0x3A4C3A50, 0x3A443A48,
  0x3A3C3A40, 0x3A343A38, 0x3A2C3A30, 0x3A243A28,
  0x3A1C3A20, 0x3A143A18, 0x3A0C3A10, 0x3A043A08,
  0x37F93A00, 0x37E937F1, 0x37D937E1, 0x37C937D2,
  0x37BA37C1, 0x37AA37B2, 0x379A37A2, 0x378A3792,
  0x377A3782, 0x376A3772, 0x375B3762, 0x374B3753,
  0x373B3743, 0x372B3733, 0x371B3723, 0x370C3714,
  0x36FC3704, 0x36EC36F4, 0x36DD36E4, 0x36CD36D5,
  0x36BD36C5, 0x36AE36B6, 0x369F36A6, 0x368F3697,
  0x36803687, 0x36703678, 0x36613669, 0x36513659,
  0x3642364A, 0x3633363B, 0x3624362B, 0x3615361D,
  0x3606360E, 0x33EF33FF, 0x33D233E1, 0x33B433C3,
  0x339833A6, 0x337B3389, 0x335E336C, 0x33423350,
  0x33263334, 0x330A3317, 0x32EE32FC, 0x32D332E1,
  0x32B832C5, 0x329E32AB, 0x32833291, 0x326A3277,
  0x3251325D, 0x32393245, 0x3220322C, 0x32083214,
  0x2FE22FF9, 0x2FB52FCB, 0x2F882F9E, 0x2F5D2F72,
  0x2F322F47, 0x2F092F1E, 0x2EE12EF5, 0x2EBA2ECE,
  0x2E952EA7, 0x2E712E83, 0x2E4F2E60, 0x2E2D2E3D,
  0x2E0D2E1C, 0x2BDE2BFB, 0x2BA32BBD, 0x2B692B85,
  0x2B342B51, 0x2B002B1A, 0x2ACF2AEA, 0x2AA02AB8,
  0x2A742A8D, 0x2A4B2A60, 0x2A252A3A, 0x27FC2A14,
  0x27BE27D9, 0x2775279A, 0x273E2759, 0x27052722,
  0x26CB26E9, 0x269B26AE, 0x2669267D, 0x26372655,
  0x260D2622, 0x23DE23F3, 0x238923B4, 0x234B2360,
  0x1F002235, 0x5BFF1B04, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[8] additive increase 0.000027 */
  0x3A393B1D, 0x3A313A35, 0x3A293A2D, 0x3A213A25,
  0x3A193A1C, 0x3A113A15, 0x3A093A0D, 0x3A013A05,
  0x37F237FA, 0x37E237EA, 0x37D237DA, 0x37C237CA,
  0x37B337BB, 0x37A337AB, 0x3793379B, 0x3783378B,
  0x3773377B, 0x3763376B, 0x3754375B, 0x3744374C,
  0x3734373C, 0x3724372C, 0x3715371C, 0x3705370D,
  0x36F536FD, 0x36E536ED, 0x36D636DD, 0x36C636CE,
  0x36B636BE, 0x36A736AF, 0x3697369F, 0x36883690,
  0x36793680, 0x36693671, 0x365A3662, 0x364B3652,
  0x363C3643, 0x362D3634, 0x361E3625, 0x360E3616,
  0x36003607, 0x33E333F1, 0x33C533D3, 0x33A733B6,
  0x338B3399, 0x336E337C, 0x3351335F, 0x33353343,
  0x33193327, 0x32FD330C, 0x32E232F0, 0x32C732D5,
  0x32AC32BA, 0x3292329F, 0x32783285, 0x325F326C,
  0x32463252, 0x322D3239, 0x32153221, 0x2FFB3209,
  0x2FCE2FE4, 0x2FA12FB6, 0x2F742F8A, 0x2F492F5F,
  0x2F202F34, 0x2EF82F0B, 0x2ED02EE4, 0x2EAA2EBD,
  0x2E862E97, 0x2E622E74, 0x2E402E51, 0x2E1F2E2F,
  0x2E002E0F, 0x2BC32BE1, 0x2B8A2BA7, 0x2B522B6F,
  0x2B1E2B37, 0x2AEC2B04, 0x2ABC2AD3, 0x2A8E2AA4,
  0x2A642A78, 0x2A3C2A4F, 0x2A162A27, 0x27E22A02,
  0x279F27C3, 0x275E277E, 0x27222743, 0x26E92705,
  0x26B326D0, 0x2682269B, 0x2655266E, 0x26272641,
  0x26032613, 0x23B423DE, 0x23752394, 0x23352355,
  0x22F42315, 0x22BE22D4, 0x2287229D, 0x22502272,
  0x2224223A, 0x2202220E, 0x1FAA1FD8, 0x1F671F7E,
  0x1F001F39, 0x5BFF1B04, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[9] additive increase 0.000013 */
  0x37EB3AD9, 0x37DB37E3, 0x37CB37D3, 0x37BB37C3,
  0x37AB37B3, 0x379B37A3, 0x378C3794, 0x377C3784,
  0x376C3774, 0x375C3764, 0x374C3754, 0x373D3745,
  0x372D3735, 0x371D3725, 0x370D3715, 0x36FE3706,
  0x36EE36F6, 0x36DE36E6, 0x36CF36D7, 0x36BF36C7,
  0x36B036B7, 0x36A036A8, 0x36913698, 0x36813689,
  0x3672367A, 0x3662366A, 0x3653365B, 0x3644364C,
  0x3635363C, 0x3626362D, 0x3617361E, 0x3608360F,
  0x33F23600, 0x33D533E4, 0x33B733C6, 0x339A33A9,
  0x337E338C, 0x3361336F, 0x33453353, 0x33283336,
  0x330D331A, 0x32F232FF, 0x32D632E3, 0x32BB32C8,
  0x32A132AE, 0x32863294, 0x326D3279, 0x32543260,
  0x323B3247, 0x3222322F, 0x320A3216, 0x2FE62FFE,
  0x2FB92FD0, 0x2F8D2FA2, 0x2F612F77, 0x2F372F4C,
  0x2F0D2F22, 0x2EE62EF9, 0x2EBF2ED2, 0x2E992EAC,
  0x2E762E87, 0x2E532E63, 0x2E312E42, 0x2E112E21,
  0x2BE42E01, 0x2BAA2BC7, 0x2B712B8D, 0x2B3B2B56,
  0x2B082B21, 0x2AD72AEF, 0x2AA92ABF, 0x2A7C2A92,
  0x2A522A67, 0x2A2A2A3E, 0x2A052A18, 0x27C427E9,
  0x278327A2, 0x27452763, 0x270A2726, 0x26D326ED,
  0x269F26B8, 0x26712687, 0x26432657, 0x2618262D,
  0x23E32606, 0x239923BE, 0x2355237A, 0x23152335,
  0x22D922FA, 0x22A322BE, 0x2272228D, 0x2240225C,
  0x2218222A, 0x1FD82202, 0x1F941FB6, 0x1F501F72,
  0x1F0B1F2E, 0x1ED21EE9, 0x1E981EAF, 0x1E5F1E81,
  0x1E301E47, 0x1E0D1E19, 0x1BBC1BEB, 0x1B761B8E,
  0x1B2F1B47, 0x5BFF1B04, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[10] additive increase 0.000007 */
  0x37653A96, 0x3755375D, 0x3746374D, 0x3736373D,
  0x3726372D, 0x3716371E, 0x3707370E, 0x36F736FF,
  0x36E736EF, 0x36D836DF, 0x36C836CF, 0x36B836C0,
  0x36A936B1, 0x369936A1, 0x368A3691, 0x367A3682,
  0x366B3673, 0x365C3663, 0x364D3654, 0x363D3645,
  0x362E3635, 0x361F3627, 0x36103618, 0x36013609,
  0x33E533F4, 0x33C833D7, 0x33AB33B9, 0x338E339C,
  0x3371337F, 0x33553363, 0x33383346, 0x331C332A,
  0x3300330E, 0x32E532F3, 0x32CA32D7, 0x32AF32BD,
  0x329532A2, 0x327B3288, 0x3262326E, 0x32483255,
  0x3230323C, 0x32183224, 0x3200320C, 0x2FD12FE9,
  0x2FA52FBC, 0x2F792F8F, 0x2F4E2F62, 0x2F242F39,
  0x2EFC2F10, 0x2ED42EE8, 0x2EAE2EC1, 0x2E892E9B,
  0x2E662E77, 0x2E442E54, 0x2E222E33, 0x2E032E13,
  0x2BCA2BE8, 0x2B902BAC, 0x2B582B74, 0x2B232B3E,
  0x2AF22B0A, 0x2AC22AD9, 0x2A932AAB, 0x2A692A7F,
  0x2A402A54, 0x2A1B2A2D, 0x27EC2A08, 0x27A727CA,
  0x27682786, 0x272B2749, 0x26F2270E, 0x26BD26D6,
  0x268B26A3, 0x265B2673, 0x26302646, 0x2607261C,
  0x23C323E8, 0x237D239F, 0x233B235A, 0x22FC231A,
  0x22C322DE, 0x229022A8, 0x225E2274, 0x222F2246,
  0x2205221C, 0x1FBB1FE3, 0x1F721F9A, 0x1F2E1F50,
  0x1EEE1F11, 0x1EB51ED2, 0x1E811E9E, 0x1E4D1E6A,
  0x1E241E36, 0x1BEB1E0D, 0x1BA51BC8, 0x1B5E1B82,
  0x1B171B3B, 0x1ADD1AF4, 0x1AA11AB9, 0x1A661A8A,
  0x1A361A4E, 0x1A121A1F, 0x17C517F5, 0x177E1796,
  0x1736174E, 0x5BFF171E, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[11] additive increase 0.000003 */
  0x36E03A52, 0x36D036D8, 0x36C136C9, 0x36B136B9,
  0x36A236A9, 0x3692369A, 0x3683368B, 0x3674367B,
  0x3664366C, 0x3655365C, 0x3646364D, 0x3637363E,
  0x3628362F, 0x36183620, 0x36093611, 0x33F63602,
  0x33D833E7, 0x33BB33C9, 0x339E33AC, 0x33813390,
  0x33643372, 0x33483356, 0x332C333A, 0x3310331E,
  0x32F43302, 0x32D932E7, 0x32BE32CB, 0x32A332B1,
  0x32893296, 0x3270327C, 0x32563263, 0x323E324A,
  0x32253231, 0x320D3219, 0x2FEB3201, 0x2FBE2FD5,
  0x2F912FA7, 0x2F652F7B, 0x2F3B2F50, 0x2F122F26,
  0x2EEA2EFD, 0x2EC32ED7, 0x2E9E2EB0, 0x2E792E8B,
  0x2E562E68, 0x2E342E45, 0x2E142E24, 0x2BEB2E05,
  0x2BB02BCE, 0x2B772B94, 0x2B402B5C, 0x2B0C2B26,
  0x2ADC2AF4, 0x2AAD2AC3, 0x2A802A97, 0x2A572A6B,
  0x2A2F2A43, 0x2A092A1B, 0x27CD27F0, 0x278A27AB,
  0x274C276A, 0x2711272D, 0x26D926F5, 0x26A526C0,
  0x2675268D, 0x2649265F, 0x261E2633, 0x23ED260A,
  0x23A423C7, 0x23602381, 0x2320233F, 0x22E42301,
  0x22AC22C8, 0x22792292, 0x22492261, 0x221D2234,
  0x1FE92208, 0x1F9D1FC2, 0x1F561F78, 0x1F141F34,
  0x1ED81EF4, 0x1EA11EBB, 0x1E6D1E84, 0x1E3C1E53,
  0x1E101E28, 0x1BCD1BF7, 0x1B821BAB, 0x1B3B1B5E,
  0x1AFA1B1E, 0x1ABF1ADD, 0x1A8A1AA7, 0x1A541A72,
  0x1A2A1A3C, 0x17F51A12, 0x17AE17D1, 0x1766178A,
  0x171E1742, 0x16E216FA, 0x16A616BD, 0x166A168E,
  0x16391651, 0x16151622, 0x13CA13FA, 0x1382139A,
  0x13391352, 0x5BFF1321, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[12] additive increase 0.000002 */
  0x365D3A0F, 0x364E3656, 0x363F3647, 0x36303637,
  0x36213628, 0x36123619, 0x3603360A, 0x33E933F8,
  0x33CB33DA, 0x33AE33BC, 0x3391339F, 0x33743382,
  0x33583366, 0x333B3349, 0x331F332D, 0x33033311,
  0x32E832F6, 0x32CD32DA, 0x32B232BF, 0x329832A5,
  0x327E328A, 0x32643271, 0x324B3258, 0x3233323F,
  0x321A3226, 0x3202320E, 0x2FD72FEE, 0x2FAA2FC1,
  0x2F7D2F94, 0x2F532F68, 0x2F282F3D, 0x2F002F14,
  0x2ED82EEC, 0x2EB22EC5, 0x2E8D2E9F, 0x2E692E7B,
  0x2E472E58, 0x2E262E36, 0x2E062E16, 0x2BD02BEE,
  0x2B962BB2, 0x2B5F2B7A, 0x2B292B43, 0x2AF62B0F,
  0x2AC62ADF, 0x2A992AAF, 0x2A6E2A82, 0x2A452A59,
  0x2A1E2A32, 0x27F32A0C, 0x27AE27D1, 0x276D278E,
  0x2731274F, 0x26F82713, 0x26C226DD, 0x269026A9,
  0x26612678, 0x2635264A, 0x260C2620, 0x23CC23F2,
  0x238523A7, 0x23432362, 0x23032323, 0x22CA22E7,
  0x229522AF, 0x2264227C, 0x2235224C, 0x220B2220,
  0x1FC71FED, 0x1F7E1FA2, 0x1F391F5A, 0x1EFA1F18,
  0x1EBF1EDC, 0x1E891EA4, 0x1E571E70, 0x1E281E40,
  0x1BFD1E12, 0x1BAE1BD4, 0x1B651B88, 0x1B201B41,
  0x1AE21B00, 0x1AAA1AC5, 0x1A741A8C, 0x1A421A5A,
  0x1A161A2E, 0x17D71A00, 0x178A17B4, 0x17421766,
  0x17001724, 0x16C416E2, 0x168E16AC, 0x16581676,
  0x162D1640, 0x13FA1615, 0x13B213D6, 0x1369138E,
  0x13211345, 0x12E512FD, 0x12A812C0, 0x126C1290,
  0x123B1253, 0x12171223, 0x0FCC0FFD, 0x0F840F9C,
  0x0F3B0F54, 0x5BFF0F22, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[13] additive increase 0.000001 */
  0x33BE3798, 0x33A133B0, 0x33843392, 0x33673375,
  0x334B3358, 0x332E333C, 0x33133321, 0x32F73305,
  0x32DC32E9, 0x32C132CE, 0x32A632B3, 0x328C3299,
  0x3272327F, 0x32593266, 0x3240324C, 0x32273234,
  0x320F321C, 0x2FF03204, 0x2FC32FD9, 0x2F962FAD,
  0x2F6A2F7F, 0x2F402F54, 0x2F172F2B, 0x2EEE2F02,
  0x2EC72EDB, 0x2EA12EB4, 0x2E7D2E8F, 0x2E5A2E6C,
  0x2E382E49, 0x2E182E28, 0x2BF12E08, 0x2BB62BD4,
  0x2B7D2B99, 0x2B462B61, 0x2B122B2B, 0x2AE02AF9,
  0x2AB12AC9, 0x2A852A9B, 0x2A5B2A6F, 0x2A332A47,
  0x2A0D2A20, 0x27D527F8, 0x279127B2, 0x27512770,
  0x27172735, 0x26DF26FB, 0x26AB26C4, 0x267A2693,
  0x264D2664, 0x26222638, 0x23F5260E, 0x23AB23D0,
  0x23662388, 0x23262345, 0x22EA2308, 0x22B322CE,
  0x227E2298, 0x224E2265, 0x22222238, 0x1FF1220D,
  0x1FA51FCA, 0x1F5E1F80, 0x1F1B1F3C, 0x1EDE1EFD,
  0x1EA61EC2, 0x1E731E8C, 0x1E421E5A, 0x1E161E2C,
  0x1BDA1E00, 0x1B8E1BB3, 0x1B471B69, 0x1B061B25,
  0x1AC91AE7, 0x1A911AAD, 0x1A5E1A78, 0x1A2F1A47,
  0x1A031A18, 0x17B717DE, 0x176C1790, 0x17271748,
  0x16E81706, 0x16AF16CA, 0x16781690, 0x1645165E,
  0x16181631, 0x13DC1603, 0x138E13B9, 0x13451369,
  0x13021327, 0x12C612E5, 0x129012AE, 0x12591278,
  0x122F1241, 0x0FFD1217, 0x0FB40FD9, 0x0F6B0F90,
  0x0F220F47, 0x0EE60EFE, 0x0EA90EC1, 0x0E6D0E91,
  0x0E3B0E54, 0x0E170E24, 0x0BCD0BFE, 0x0B850B9D,
  0x0B3C0B54, 0x5BFF0B23, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[14] additive increase 0.000000 */
  0x32D03713, 0x32B532C3, 0x329B32A8, 0x3280328D,
  0x32673273, 0x324D325A, 0x32353242, 0x321D3229,
  0x32053211, 0x2FDD2FF3, 0x2FAE2FC4, 0x2F822F98,
  0x2F572F6D, 0x2F2D2F42, 0x2F042F18, 0x2EDC2EF0,
  0x2EB62ECA, 0x2E912EA3, 0x2E6D2E7F, 0x2E4A2E5C,
  0x2E292E39, 0x2E0A2E19, 0x2BD72BF5, 0x2B9C2BB9,
  0x2B632B80, 0x2B2E2B49, 0x2AFC2B15, 0x2ACC2AE4,
  0x2A9D2AB4, 0x2A722A88, 0x2A492A5D, 0x2A222A35,
  0x27FB2A0F, 0x27B627D8, 0x27742794, 0x27372755,
  0x26FD2719, 0x26C826E2, 0x269526AD, 0x2666267D,
  0x263A264F, 0x26112625, 0x23D423F9, 0x238B23AE,
  0x2349236B, 0x230A2329, 0x22D122EC, 0x229B22B5,
  0x22692282, 0x223A2251, 0x220F2224, 0x1FCE1FF6,
  0x1F851FA9, 0x1F401F61, 0x1F001F20, 0x1EC61EE2,
  0x1E8F1EAA, 0x1E5C1E75, 0x1E2E1E45, 0x1E031E18,
  0x1BB71BDD, 0x1B6D1B90, 0x1B281B4A, 0x1AE91B09,
  0x1AB01ACC, 0x1A7B1A95, 0x1A491A62, 0x1A1B1A32,
  0x17E41A06, 0x179617BC, 0x174E1771, 0x170C172C,
  0x16CE16EC, 0x169516B2, 0x1662167C, 0x1632164A,
  0x1606161B, 0x13BB13E3, 0x13701394, 0x132A134C,
  0x12EA1308, 0x12B112CC, 0x127A1292, 0x12471260,
  0x121A1232, 0x0FDE1204, 0x0F900FBB, 0x0F470F6B,
  0x0F040F29, 0x0EC80EE6, 0x0E910EAF, 0x0E5A0E79,
  0x0E2F0E42, 0x0BFE0E17, 0x0BB50BDA, 0x0B6C0B91,
  0x0B230B48, 0x0AE70AFF, 0x0AAA0AC2, 0x0A6D0A92,
  0x0A3C0A55, 0x0A180A24, 0x07CE07FF, 0x0786079E,
  0x073C0755, 0x5BFF0724, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[15] additive increase 0.000000 */
  0x2FF5368F, 0x2FC72FDF, 0x2F9B2FB1, 0x2F6F2F84,
  0x2F442F58, 0x2F1A2F2F, 0x2EF32F07, 0x2ECB2EDF,
  0x2EA62EB8, 0x2E812E93, 0x2E5D2E6E, 0x2E3C2E4D,
  0x2E1B2E2B, 0x2BF82E0B, 0x2BBC2BD9, 0x2B822B9F,
  0x2B4B2B68, 0x2B172B31, 0x2AE62AFE, 0x2AB62ACF,
  0x2A892A9F, 0x2A5F2A74, 0x2A382A4B, 0x2A112A24,
  0x27DA27FF, 0x279727BA, 0x27582777, 0x271D273B,
  0x26E52701, 0x26B126CA, 0x267F2698, 0x26522668,
  0x2626263B, 0x23FE2612, 0x23B223D7, 0x236D238F,
  0x232C234C, 0x22F0230E, 0x22B822D3, 0x2284229D,
  0x2254226B, 0x2227223D, 0x1FFA2211, 0x1FAC1FD2,
  0x1F651F89, 0x1F231F43, 0x1EE61F02, 0x1EAC1EC9,
  0x1E781E92, 0x1E471E60, 0x1E1A1E30, 0x1BE11E05,
  0x1B951BBB, 0x1B4E1B70, 0x1B0C1B2D, 0x1AD01AED,
  0x1A971AB3, 0x1A641A7D, 0x1A341A4C, 0x1A081A1E,
  0x17C017E7, 0x17751798, 0x172E1751, 0x16EF170F,
  0x16B416D1, 0x167F1699, 0x164C1665, 0x161E1635,
  0x13E91608, 0x139A13C0, 0x13521374, 0x130F132F,
  0x12D112EF, 0x129812B4, 0x1264127E, 0x1233124C,
  0x1207121C, 0x0FBD0FE5, 0x0F720F96, 0x0F2C0F4D,
  0x0EEC0F0A, 0x0EB30ECE, 0x0E7B0E94, 0x0E480E61,
  0x0E1B0E33, 0x0BDF0E05, 0x0B910BBC, 0x0B480B6C,
  0x0B050B2A, 0x0AC80AE7, 0x0A920AB0, 0x0A5B0A7A,
  0x0A300A42, 0x07FF0A18, 0x07B607DA, 0x076D0792,
  0x07230748, 0x06E706FF, 0x06AA06C2, 0x066E0692,
  0x063C0655, 0x06180625, 0x03CF03FF, 0x0386039E,
  0x033D0355, 0x5BFF0324, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[16] additive increase 0.000000 */
  0x2E95360E, 0x2E712E83, 0x2E4F2E60, 0x2E2D2E3D,
  0x2E0D2E1C, 0x2BDC2BFB, 0x2BA32BC0, 0x2B6A2B86,
  0x2B352B4F, 0x2B022B1A, 0x2AD02AE8, 0x2AA22AB9,
  0x2A772A8D, 0x2A4D2A62, 0x2A262A39, 0x2A012A13,
  0x27BC27E0, 0x277B279B, 0x273E275C, 0x27032721,
  0x26CD26E7, 0x269A26B3, 0x266B2682, 0x263E2654,
  0x26142629, 0x23DB2601, 0x239323B6, 0x23502371,
  0x23102330, 0x22D722F3, 0x22A022BB, 0x226E2287,
  0x223F2256, 0x22142229, 0x1FD61FFD, 0x1F8C1FB1,
  0x1F461F68, 0x1F071F26, 0x1ECC1EE8, 0x1E941EAF,
  0x1E621E7A, 0x1E331E4A, 0x1E071E1C, 0x1BBD1BE5,
  0x1B741B9A, 0x1B2F1B51, 0x1AF11B0E, 0x1AB61AD3,
  0x1A801A9B, 0x1A4E1A67, 0x1A201A37, 0x17EB1A0A,
  0x179D17C4, 0x17551777, 0x17121733, 0x16D516F3,
  0x169C16B8, 0x16681681, 0x1637164F, 0x160B1621,
  0x13C413EC, 0x1379139D, 0x13321355, 0x12F21312,
  0x12B712D4, 0x1281129B, 0x124E1267, 0x12201237,
  0x0FEB120A, 0x0F9C0FC3, 0x0F540F76, 0x0F100F31,
  0x0ED20EF1, 0x0E990EB5, 0x0E650E7F, 0x0E340E4D,
  0x0E080E1D, 0x0BBE0BE6, 0x0B730B97, 0x0B2C0B4E,
  0x0AED0B0B, 0x0AB30ACE, 0x0A7C0A94, 0x0A480A61,
  0x0A1B0A34, 0x07E00A05, 0x079207BD, 0x0749076C,
  0x0705072A, 0x06C906E7, 0x069206B0, 0x065B067A,
  0x06300643, 0x03FF0618, 0x03B603DB, 0x036D0392,
  0x03240349, 0x02E702FF, 0x02AA02C2, 0x026E0292,
  0x023C0255, 0x02180225, 0x01E70200, 0x01C301CF,
  0x019E01AA, 0x5BFF0192, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[17] additive increase 0.000000 */
  0x2B1D3328, 0x2AEB2B04, 0x2ABC2AD3, 0x2A8E2AA4,
  0x2A642A78, 0x2A3B2A4F, 0x2A162A28, 0x27E32A03,
  0x27A027C0, 0x2760277E, 0x27232740, 0x26EB2707,
  0x26B626D0, 0x2684269D, 0x2656266D, 0x262B2640,
  0x26022617, 0x23BA23DF, 0x23752397, 0x23332354,
  0x22F62313, 0x22BE22D9, 0x228A22A3, 0x22592271,
  0x222B2242, 0x22012216, 0x1FB51FDA, 0x1F6D1F90,
  0x1F291F4B, 0x1EEC1F0A, 0x1EB21ECF, 0x1E7E1E97,
  0x1E4C1E64, 0x1E1F1E35, 0x1BEA1E09, 0x1B9C1BC3,
  0x1B551B77, 0x1B131B33, 0x1AD61AF3, 0x1A9D1AB9,
  0x1A691A82, 0x1A3A1A51, 0x1A0D1A22, 0x17C617EF,
  0x177C17A2, 0x17361759, 0x16F61714, 0x16BB16D8,
  0x168416A0, 0x1651166B, 0x1623163A, 0x13F0160D,
  0x13A213C8, 0x1359137B, 0x13151337, 0x12D812F6,
  0x129E12BA, 0x12691283, 0x12391251, 0x120C1222,
  0x0FC70FEE, 0x0F7B0F9F, 0x0F330F57, 0x0EF30F14,
  0x0EB80ED5, 0x0E820E9C, 0x0E4F0E68, 0x0E210E38,
  0x0BEC0E0A, 0x0B9D0BC4, 0x0B540B77, 0x0B110B31,
  0x0AD30AF2, 0x0A990AB6, 0x0A650A7F, 0x0A340A4D,
  0x0A080A1D, 0x07BF07E7, 0x07730798, 0x072D074F,
  0x06ED070B, 0x06B406CE, 0x067C0694, 0x06490661,
  0x061B0634, 0x03E00606, 0x039203BD, 0x0349036C,
  0x0305032A, 0x02C902E8, 0x029202B0, 0x025B027A,
  0x02300243, 0x01FF0218, 0x01DB01ED, 0x01B601C9,
  0x019201A4, 0x0173017F, 0x01550161, 0x01370149,
  0x011E012A, 0x010C0112, 0x00F400FF, 0x00E100E7,
  0x00CF00D4, 0x5BFF00C9, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[18] additive increase 0.000000 */
  0x27823248, 0x27442763, 0x270A2726, 0x26D326ED,
  0x269F26B8, 0x266F2687, 0x26432659, 0x2619262E,
  0x23E52605, 0x239C23BE, 0x23562377, 0x23182337,
  0x22DD22FA, 0x22A622C1, 0x2273228C, 0x2244225B,
  0x2218222E, 0x1FDF2203, 0x1F941FB9, 0x1F4E1F71,
  0x1F0D1F2C, 0x1ED11EEE, 0x1E9B1EB5, 0x1E671E80,
  0x1E371E4F, 0x1E0B1E21, 0x1BC71BEE, 0x1B7C1BA1,
  0x1B361B59, 0x1AF71B16, 0x1ABB1AD9, 0x1A861AA0,
  0x1A531A6B, 0x1A251A3B, 0x17F41A0E, 0x17A517CC,
  0x175C177F, 0x1719173A, 0x16DB16F9, 0x16A216BE,
  0x166D1687, 0x163D1654, 0x160F1625, 0x13CB13F4,
  0x138013A7, 0x133A135C, 0x12F91318, 0x12BD12DB,
  0x128612A2, 0x1253126D, 0x1224123C, 0x0FF2120E,
  0x0FA40FCB, 0x0F5B0F7D, 0x0F160F38, 0x0ED90EF7,
  0x0E9F0EBC, 0x0E6A0E84, 0x0E3A0E52, 0x0E0D0E23,
  0x0BC80BEF, 0x0B7C0BA0, 0x0B340B58, 0x0AF40B15,
  0x0AB90AD6, 0x0A830A9D, 0x0A4F0A69, 0x0A210A38,
  0x07ED0A0B, 0x079E07C4, 0x07550778, 0x07110732,
  0x06D306F2, 0x069A06B6, 0x06660680, 0x0635064E,
  0x0609061E, 0x03BF03E7, 0x03740398, 0x032D034F,
  0x02ED030B, 0x02B402CE, 0x027C0295, 0x02490261,
  0x021B0234, 0x01F00206, 0x01C901DF, 0x01A501B6,
  0x01820195, 0x01640174, 0x01480157, 0x012D013D,
  0x01180121, 0x00FF010C, 0x00ED00F7, 0x00DB00E4,
  0x00C800D2, 0x00B900BF, 0x00AA00B0, 0x009B00A4,
  0x008F0095, 0x00860089, 0x007A0080, 0x00700073,
  0x0067006A, 0x5BFF0064, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[19] additive increase 0.000000 */
  0x23C22F11, 0x237B239F, 0x233B235A, 0x22FD231A,
  0x22C322DE, 0x228E22A8, 0x225E2276, 0x22302247,
  0x2206221A, 0x1FBE1FE3, 0x1F731F96, 0x1F311F52,
  0x1EF21F11, 0x1EB81ED5, 0x1E831E9D, 0x1E511E69,
  0x1E231E3B, 0x1BF21E0E, 0x1BA51BCB, 0x1B5C1B81,
  0x1B191B39, 0x1ADC1AFA, 0x1AA41ABF, 0x1A6F1A88,
  0x1A3D1A56, 0x1A111A27, 0x17D017F8, 0x178417AA,
  0x173D1760, 0x16FD171D, 0x16C016DE, 0x168A16A5,
  0x1657166F, 0x1628163F, 0x13F91611, 0x13A913D1,
  0x13601383, 0x131C133D, 0x12DE12FC, 0x12A412C0,
  0x126F1289, 0x123E1256, 0x12111227, 0x0FCE0FF7,
  0x0F820FA9, 0x0F3B0F5E, 0x0EFB0F19, 0x0EBE0EDC,
  0x0E870EA3, 0x0E540E6E, 0x0E250E3C, 0x0BF40E0F,
  0x0BA50BCC, 0x0B5C0B7E, 0x0B170B39, 0x0ADA0AF8,
  0x0AA00ABC, 0x0A6B0A84, 0x0A3A0A52, 0x0A0D0A23,
  0x07C807F0, 0x077C07A0, 0x07350758, 0x06F40715,
  0x06B906D6, 0x0683069D, 0x064F0669, 0x06210638,
  0x03EE060B, 0x039E03C4, 0x03550378, 0x03120332,
  0x02D302F2, 0x029A02B7, 0x02660280, 0x0235024E,
  0x0209021E, 0x01DF01F3, 0x01BA01CC, 0x019601A7,
  0x01760185, 0x015A0167, 0x013E014A, 0x01240130,
  0x010D011A, 0x00F70103, 0x00E400EF, 0x00D200DA,
  0x00C100CA, 0x00B200BA, 0x00A400AB, 0x0096009E,
  0x008C0090, 0x007F0085, 0x0076007B, 0x006D0072,
  0x00640068, 0x005C005F, 0x00550058, 0x004E0052,
  0x0047004A, 0x00430044, 0x003D0040, 0x00380039,
  0x00330034, 0x5BFF0032, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,
  0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF, 0x5BFF5BFF,

 /* rate_table[20] rate decrease 0.000000  */
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,
  0x2a002a00, 0x2a002a00, 0x2a002a00, 0x2a002a00,

 /* rate_table[21] rate decrease 0.000000  */
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,
  0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C, 0x2E1C2E1C,

 /* rate_table[22] rate decrease 0.000000  */
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,
  0x27812781, 0x27812781, 0x27812781, 0x27812781,

 /* rate_table[23] rate decrease 0.000000  */
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,
  0x23412341, 0x23412341, 0x23412341, 0x23412341,

 /* rate_table[24] rate decrease 0.000000  */
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,
  0x1F251F25, 0x1F251F25, 0x1F251F25, 0x1F251F25,

 /* rate_table[25] rate decrease 0.000000 */
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,
  0x1B181B18, 0x1B181B18, 0x1B181B18, 0x1B181B18,

 /* rate_table[26] rate decrease 0.000000 */
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,
  0x17121712, 0x17121712, 0x17121712, 0x17121712,

 /* rate_table[27] rate decrease 0.000000  */
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130F130E, 0x130E130F,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130F130F, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130F, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130F130E, 0x130E130E, 0x130E130F,
  0x130E130E, 0x130E130E, 0x130F130F, 0x130E130E,
  0x130E130E, 0x130F130E, 0x130F130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130F, 0x130E130E, 0x130E130F, 0x130E130E,
  0x130E130E, 0x130F130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,
  0x130E130E, 0x130E130E, 0x130E130E, 0x130E130E,

 /* rate_table[28] rate decrease 0.000000 */
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,
  0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D, 0x0F0D0F0D,

 /* rate_table[29] rate decrease 0.000000  */
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,
  0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C, 0x0B0C0B0C,

 /* rate_table[30] rate decrease 0.000000 */
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,
  0x070C070C, 0x070C070C, 0x070C070C, 0x070C070C,

 /* rate_table[31] rate decrease 0.000000 */
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030B030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030B, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030B, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030B030B, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030C030C, 0x030B030C, 0x030C030C, 0x030B030C,
  0x030C030C, 0x030C030C, 0x030C030B, 0x030C030B,
  0x030C030C, 0x030B030C, 0x030B030C, 0x030C030C,
  0x030C030C, 0x030C030B, 0x030C030B, 0x030C030C,
  0x030C030B, 0x030C030C, 0x030C030C, 0x030C030C,
  0x030B030C, 0x030B030C, 0x030C030C, 0x030C030C,
  0x030C030B, 0x030B030B, 0x030C030C, 0x030C030C,
  0x030B030C, 0x030C030C, 0x030B030C, 0x030C030C,
  0x030C030C, 0x030B030C, 0x030C030C, 0x030B030C,
  0x030C030B, 0x030C030B, 0x030B030B, 0x030B030C,
  0x030C030C, 0x030C030B, 0x030C030C, 0x030C030B,
  0x030C030C, 0x030C030C, 0x030C030B, 0x030C030C,
  0x030C030C, 0x030C030C, 0x030C030C, 0x030B030C,
  0x030C030C, 0x030B030B, 0x030B030C, 0x030B030C,
  0x030C030C, 0x030C030B, 0x030B030C, 0x030C030B,
  0x030B030C, 0x030C030C, 0x030B030B, 0x030B030C,
  0x030B030C, 0x030B030B, 0x030C030C, 0x030B030C,
  0x030C030B, 0x030C030C, 0x030B030C, 0x030B030B,
  0x030B030B, 0x030C030C, 0x030B030C, 0x030B030B,
  0x030B030B, 0x030B030B, 0x030C030C, 0x030C030C,

 /* rate_table[32] rate decrease 0.000000 */
  0x01860186, 0x01860186, 0x01860186, 0x01860186,
  0x01860185, 0x01850186, 0x01860185, 0x01850185,
  0x01860185, 0x01860185, 0x01860186, 0x01850186,
  0x01850185, 0x01860185, 0x01850185, 0x01860186,
  0x01860186, 0x01860185, 0x01860186, 0x01860186,
  0x01850186, 0x01850186, 0x01850186, 0x01860186,
  0x01860185, 0x01860185, 0x01860185, 0x01850185,
  0x01850185, 0x01860186, 0x01860186, 0x01860186,
  0x01850186, 0x01850186, 0x01860185, 0x01850186,
  0x01860185, 0x01850185, 0x01860186, 0x01860185,
  0x01850185, 0x01850186, 0x01860186, 0x01860186,
  0x01850185, 0x01850186, 0x01860186, 0x01860186,
  0x01860185, 0x01850186, 0x01860186, 0x01850186,
  0x01860186, 0x01860186, 0x01860185, 0x01860185,
  0x01850185, 0x01850186, 0x01850186, 0x01850185,
  0x01860185, 0x01860185, 0x01860185, 0x01850185,
  0x01860185, 0x01860186, 0x01860186, 0x01850186,
  0x01850186, 0x01850186, 0x01860186, 0x01860185,
  0x01850185, 0x01850185, 0x01850186, 0x01860185,
  0x01850186, 0x01860186, 0x01850186, 0x01860186,
  0x01850186, 0x01850186, 0x01860186, 0x01850186,
  0x01860185, 0x01860185, 0x01850185, 0x01850186,
  0x01860186, 0x01850185, 0x01860186, 0x01860185,
  0x01860186, 0x01860186, 0x01860185, 0x01860186,
  0x01860186, 0x01860186, 0x01850186, 0x01850185,
  0x01860185, 0x01850185, 0x01850185, 0x01850186,
  0x01860186, 0x01860185, 0x01850186, 0x01860185,
  0x01850186, 0x01860186, 0x01850185, 0x01850186,
  0x01850186, 0x01850185, 0x01860186, 0x01850186,
  0x01860185, 0x01850186, 0x01850185, 0x01850185,
  0x01850185, 0x01860186, 0x01850186, 0x01850185,
  0x01850185, 0x01850185, 0x01860186, 0x01860186,

 /* rate_table[33] rate decrease 0.000000  */
  0x00C200C3, 0x00C200C2, 0x00C200C2, 0x00C200C2,
  0x00C300C2, 0x00C200C3, 0x00C300C2, 0x00C200C2,
  0x00C300C2, 0x00C300C2, 0x00C300C3, 0x00C200C2,
  0x00C200C2, 0x00C300C2, 0x00C200C2, 0x00C200C3,
  0x00C300C2, 0x00C300C2, 0x00C300C3, 0x00C300C2,
  0x00C200C3, 0x00C200C3, 0x00C200C3, 0x00C300C3,
  0x00C200C2, 0x00C300C2, 0x00C300C2, 0x00C200C2,
  0x00C200C2, 0x00C200C2, 0x00C300C3, 0x00C300C3,
  0x00C200C3, 0x00C200C3, 0x00C200C2, 0x00C200C3,
  0x00C300C2, 0x00C200C2, 0x00C300C3, 0x00C300C2,
  0x00C200C2, 0x00C200C3, 0x00C300C2, 0x00C300C2,
  0x00C200C2, 0x00C200C3, 0x00C300C3, 0x00C300C3,
  0x00C300C2, 0x00C200C2, 0x00C200C2, 0x00C200C3,
  0x00C300C3, 0x00C300C3, 0x00C300C2, 0x00C300C2,
  0x00C200C2, 0x00C200C3, 0x00C200C3, 0x00C200C2,
  0x00C300C2, 0x00C300C2, 0x00C300C2, 0x00C200C2,
  0x00C300C2, 0x00C200C3, 0x00C300C3, 0x00C200C3,
  0x00C200C3, 0x00C200C3, 0x00C300C3, 0x00C200C2,
  0x00C200C2, 0x00C200C2, 0x00C200C3, 0x00C300C2,
  0x00C200C3, 0x00C300C3, 0x00C200C3, 0x00C300C2,
  0x00C200C3, 0x00C200C3, 0x00C300C3, 0x00C200C3,
  0x00C300C2, 0x00C300C2, 0x00C200C2, 0x00C200C3,
  0x00C300C3, 0x00C200C2, 0x00C300C3, 0x00C300C2,
  0x00C300C3, 0x00C300C3, 0x00C300C2, 0x00C300C3,
  0x00C300C3, 0x00C300C3, 0x00C200C3, 0x00C200C2,
  0x00C300C2, 0x00C200C2, 0x00C200C2, 0x00C200C3,
  0x00C300C3, 0x00C300C2, 0x00C200C3, 0x00C300C2,
  0x00C200C3, 0x00C300C3, 0x00C200C2, 0x00C200C3,
  0x00C200C3, 0x00C200C2, 0x00C300C3, 0x00C200C3,
  0x00C300C2, 0x00C200C3, 0x00C200C2, 0x00C200C2,
  0x00C200C2, 0x00C300C3, 0x00C200C3, 0x00C200C2,
  0x00C200C2, 0x00C200C2, 0x00C300C3, 0x00C300C3,

 /* rate_table[34] rate decrease 0.000000  */
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610060, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00600061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,
  0x00610061, 0x00610061, 0x00610061, 0x00610061,

 /* rate_table[35] rate decrease 0.000000 */
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00310030,
  0x00300030, 0x00300031, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00310030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00310030, 0x00300030, 0x00310030, 0x00300031,
  0x00300030, 0x00300031, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00310030,
  0x00300031, 0x00310031, 0x00300030, 0x00300030,
  0x00300030, 0x00300031, 0x00300030, 0x00300030,
  0x00300030, 0x00310030, 0x00300030, 0x00300031,
  0x00300030, 0x00300030, 0x00310031, 0x00300030,
  0x00300031, 0x00310030, 0x00310030, 0x00300031,
  0x00300030, 0x00300031, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300031, 0x00300030, 0x00300031, 0x00300030,
  0x00300030, 0x00310031, 0x00300030, 0x00300030,
  0x00300031, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00300030, 0x00300030,
  0x00300030, 0x00300030, 0x00310031, 0x00310031
 };


u_int32_t abr_vbr_rate_tables_len = (sizeof(abr_vbr_rate_tables_155Mb) / sizeof(u_long));

