#!/bin/sh

# db:1:pho1>  bt
# Tracing pid 5640 tid 102468 td 0xfffffe00e4d26ac0
# kdb_enter() at kdb_enter+0x32/frame 0xfffffe010dbcf260
# vpanic() at vpanic+0x163/frame 0xfffffe010dbcf390
# panic() at panic+0x43/frame 0xfffffe010dbcf3f0
# vm_map_insert1() at vm_map_insert1+0x147/frame 0xfffffe010dbcf4a0
# vm_map_insert() at vm_map_insert+0x69/frame 0xfffffe010dbcf510
# vm_map_growstack() at vm_map_growstack+0x90e/frame 0xfffffe010dbcf650
# vm_map_lookup() at vm_map_lookup+0x15f/frame 0xfffffe010dbcf6e0
# vm_fault() at vm_fault+0x12f/frame 0xfffffe010dbcf820
# vm_fault_trap() at vm_fault_trap+0x6f/frame 0xfffffe010dbcf860
# trap_pfault() at trap_pfault+0x24a/frame 0xfffffe010dbcf8d0
# calltrap() at calltrap+0x8/frame 0xfffffe010dbcf8d0
# --- trap 0xc, rip = 0xffffffff81057a06, rsp = 0xfffffe010dbcf9a0, rbp = 0xfffffe010dbcf9a0 ---
# copyin_nosmap_erms() at copyin_nosmap_erms+0x156/frame 0xfffffe010dbcf9a0
# uiomove_fromphys() at uiomove_fromphys+0x145/frame 0xfffffe010dbcfa10
# uiomove_object_page() at uiomove_object_page+0x1dc/frame 0xfffffe010dbcfa70
# uiomove_object() at uiomove_object+0xa4/frame 0xfffffe010dbcfac0
# tmpfs_write() at tmpfs_write+0xe4/frame 0xfffffe010dbcfb10
# VOP_WRITE_APV() at VOP_WRITE_APV+0xcf/frame 0xfffffe010dbcfc20
# vn_write() at vn_write+0x2f4/frame 0xfffffe010dbcfcb0
# vn_io_fault() at vn_io_fault+0x1e2/frame 0xfffffe010dbcfd40
# dofilewrite() at dofilewrite+0x82/frame 0xfffffe010dbcfd90
# kern_pwritev() at kern_pwritev+0x64/frame 0xfffffe010dbcfdd0
# sys_pwritev() at sys_pwritev+0x3a/frame 0xfffffe010dbcfe00
# amd64_syscall() at amd64_syscall+0x14f/frame 0xfffffe010dbcff30
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe010dbcff30
# --- syscall (0, FreeBSD ELF64, syscall), rip = 0x822d56fca, rsp = 0x824255f58, rbp = 0x824255f90 ---
# FreeBSD 14.0-ALPHA1 #1 main-n264742-81b41b2ef5bfd5-dirty: Tue Aug 15 19:52:50 CEST 2023

uname -p | grep -Eq "amd64" || exit 0
[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
prog=$(basename "$0" .sh)
cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=4c33ed3d5a9072d2ccaec3b2ef7a129f0997f477
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+c325d6a75e4fd0a68714@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i = 0;
  for (; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void execute_one(void)
{
  int i, call, thread;
  for (call = 0; call < 4; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      event_timedwait(&th->done, 50);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused = 0;
  for (;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[1] = {0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res = 0;
  switch (call) {
  case 0:
    memcpy((void*)0x20000240, "./file0\000", 8);
    res = syscall(SYS_open, /*file=*/0x20000240ul,
                  /*flags=*/0x40000400000002c2ul, /*mode=*/0ul);
    if (res != -1)
      r[0] = res;
    break;
  case 1:
    *(uint64_t*)0x20000080 = 0x200006c0;
    *(uint64_t*)0x20000088 = 0x100000;
    syscall(SYS_pwritev, /*fd=*/r[0], /*vec=*/0x20000080ul, /*vlen=*/1ul,
            /*off=*/0ul);
    break;
  case 2:
    syscall(SYS_mmap, /*addr=*/0x20000000ul, /*len=*/0x200000ul, /*prot=*/3ul,
            /*flags=*/0x410ul, /*fd=*/-1, /*offset=*/0ul);
    break;
  case 3:
    syscall(SYS_mmap, /*addr=*/0x2000c000ul, /*len=*/0x4000ul, /*prot=*/0ul,
            /*flags=*/0x2010ul, /*fd=*/-1, /*offset=*/0ul);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, /*addr=*/0x20000000ul, /*len=*/0x1000000ul, /*prot=*/7ul,
          /*flags=*/0x1012ul, /*fd=*/-1, /*offset=*/0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/$prog -Wall -Wextra -O0 /tmp/$prog.c -lpthread || exit 1

mount | grep -q "on $mntpoint " && umount $mntpoint
mount -o size=10m -t tmpfs dummy $mntpoint

cd $mntpoint
for i in `jot 20`; do
	timeout 3m /tmp/$prog &
done
wait
cd -

umount $mntpoint
rm -rf /tmp/$prog /tmp/$prog.c /tmp/$prog.core
exit 0
