#!/bin/sh

# panic: Thread not suspended
# cpuid = 9
# time = 1651215111
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe018701d9c0
# vpanic() at vpanic+0x17f/frame 0xfffffe018701da10
# panic() at panic+0x43/frame 0xfffffe018701da70
# thread_unsuspend_one() at thread_unsuspend_one+0xc5/frame 0xfffffe018701daa0
# thread_suspend_check() at thread_suspend_check+0x1f8/frame 0xfffffe018701dae0
# exit1() at exit1+0xb7/frame 0xfffffe018701db50
# sigexit() at sigexit+0x157/frame 0xfffffe018701de20
# postsig() at postsig+0x1aa/frame 0xfffffe018701def0
# ast() at ast+0x4fb/frame 0xfffffe018701df30
# doreti_ast() at doreti_ast+0x1f/frame 0x820bf50f0
# KDB: enter: panic
# [ thread pid 8379 tid 100392 ]
# Stopped at      kdb_enter+0x32: movq    $0,0x12790b3(%rip)
# db> x/s version
# FreeBSD 14.0-CURRENT #0 main-n255099-0923ff82fb383: Thu Apr 28 09:48:48 CEST 2022
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO
# db> 

[ `uname -p` != "amd64" ] && exit 0

. ../default.cfg
cat > /tmp/syzkaller53.c <<EOF
// https://syzkaller.appspot.com/bug?id=3b00c85aa7a7a1bad3bf0af3abde3c16b543f2a0
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+7789d9923f58fa08ecba@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <pwd.h>
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static __thread int clone_ongoing;
static __thread int skip_segv;
static __thread jmp_buf segv_env;

static void segv_handler(int sig, siginfo_t* info, void* ctx __unused)
{
  if (__atomic_load_n(&clone_ongoing, __ATOMIC_RELAXED) != 0) {
    exit(sig);
  }
  uintptr_t addr = (uintptr_t)info->si_addr;
  const uintptr_t prog_start = 1 << 20;
  const uintptr_t prog_end = 100 << 20;
  int skip = __atomic_load_n(&skip_segv, __ATOMIC_RELAXED) != 0;
  int valid = addr < prog_start || addr > prog_end;
  if (sig == SIGBUS)
    valid = 1;
  if (skip && valid) {
    _longjmp(segv_env, 1);
  }
  exit(sig);
}

static void install_segv_handler(void)
{
  struct sigaction sa;
  memset(&sa, 0, sizeof(sa));
  sa.sa_sigaction = segv_handler;
  sa.sa_flags = SA_NODEFER | SA_SIGINFO;
  sigaction(SIGSEGV, &sa, NULL);
  sigaction(SIGBUS, &sa, NULL);
}

#define NONFAILING(...)                                                        \
  ({                                                                           \
    int ok = 1;                                                                \
    __atomic_fetch_add(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    if (_setjmp(segv_env) == 0) {                                              \
      __VA_ARGS__;                                                             \
    } else                                                                     \
      ok = 0;                                                                  \
    __atomic_fetch_sub(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    ok;                                                                        \
  })

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused = 0;
  for (;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

void execute_one(void)
{
  NONFAILING(*(uint32_t*)0x20000080 = 0x13);
  NONFAILING(*(uint32_t*)0x20000084 = 0);
  NONFAILING(*(uint32_t*)0x20000088 = 0);
  NONFAILING(*(uint32_t*)0x2000008c = 0);
  NONFAILING(*(uint32_t*)0x20000090 = -1);
  NONFAILING(memset((void*)0x20000094, 0, 60));
  syscall(SYS_procctl, 0ul, 0, 6ul, 0x20000080ul);
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  install_segv_handler();
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller53 -Wall -Wextra -O0 /tmp/syzkaller53.c ||
    exit 1

for i in `jot 20`; do
	(cd /tmp; timeout 3m ./syzkaller53) &
done
wait

rm -rf /tmp/syzkaller53 /tmp/syzkaller53.c /tmp/syzkaller53.*
exit 0
