/*-
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * Copyright (c) 2011 NetApp, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY NETAPP, INC ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL NETAPP, INC OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	_MEVENT_H_
#define	_MEVENT_H_

enum ev_type {
	EVF_READ,
	EVF_WRITE,
	EVF_TIMER,
	EVF_SIGNAL,
	EVF_VNODE,
};

/* Filter flags for EVF_VNODE */
#define	EVFF_ATTRIB	0x0001

struct mevent;

struct mevent *mevent_add(int fd, enum ev_type type,
			  void (*func)(int, enum ev_type, void *),
			  void *param);
struct mevent *mevent_add_flags(int fd, enum ev_type type, int fflags,
			  void (*func)(int, enum ev_type, void *),
			  void *param);
struct mevent *mevent_add_disabled(int fd, enum ev_type type,
			  void (*func)(int, enum ev_type, void *),
			  void *param);
int	mevent_enable(struct mevent *evp);
int	mevent_disable(struct mevent *evp);
int	mevent_delete(struct mevent *evp);
int	mevent_delete_close(struct mevent *evp);

void	mevent_dispatch(void);

#endif	/* _MEVENT_H_ */
