/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.jdt;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModel;
import org.eclipse.xwt.tools.ui.designer.jdt.ClasspathContainer;
import org.osgi.framework.Bundle;

public class ProjectHelper {
    static String[] bundleNames = new String[]{"org.eclipse.swt." + Platform.getWS() + "." + Platform.getOS() + "." + Platform.getOSArch(), "org.eclipse.swt." + Platform.getWS() + "." + Platform.getOS(), "org.eclipse.jface"};

    public static ClasspathContainer createContainer() {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        String[] stringArray = bundleNames;
        int n = bundleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleName = stringArray[n2];
            Bundle bundle = Platform.getBundle((String)bundleName);
            try {
                if (bundle != null) {
                    Path path;
                    String fileName = bundle.getLocation();
                    if (fileName != null && fileName.startsWith("reference:file:")) {
                        fileName = fileName.substring(15);
                    }
                    if ((path = new Path(fileName)).toFile().exists() && "jar".equalsIgnoreCase(path.getFileExtension())) {
                        entries.add(JavaCore.newLibraryEntry((IPath)path, null, null));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        IClasspathEntry[] paths = new IClasspathEntry[entries.size()];
        entries.toArray(paths);
        return new ClasspathContainer(paths);
    }

    public static void checkDependenceJars(IProject project) {
        ProjectHelper.checkDependenceJars(JavaCore.create((IProject)project));
    }

    public static void checkDependenceJars(IJavaProject javaProject) {
        if (javaProject == null) {
            return;
        }
        IProject project = javaProject.getProject();
        IFile file = project.getFile("META-INF/MANIFEST.MF");
        if (file != null && file.exists()) {
            Object fModel = null;
            IFile fragmentFile = project.getFile("fragment.xml");
            IFile pluginFile = project.getFile("plugin.xml");
            fModel = fragmentFile != null && fragmentFile.exists() ? new WorkspaceBundleFragmentModel(file, fragmentFile) : new WorkspaceBundlePluginModel(file, pluginFile);
            IPluginBase pluginBase = fModel.getPluginBase();
            try {
                IPluginReference[] dependencies;
                IPluginReference[] iPluginReferenceArray = dependencies = ProjectHelper.getDependencies();
                int n = dependencies.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginReference pluginReference = iPluginReferenceArray[n2];
                    IPluginImport iimport = fModel.getPluginFactory().createImport();
                    iimport.setId(pluginReference.getId());
                    iimport.setVersion(pluginReference.getVersion());
                    iimport.setMatch(pluginReference.getMatch());
                    pluginBase.add(iimport);
                    ++n2;
                }
                fModel.save();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            ProjectHelper.addJars(javaProject);
        }
    }

    public static IPluginReference[] getDependencies() {
        return new IPluginReference[0];
    }

    protected static Bundle findProjectBundle(IProject project) {
        try {
            IBundleGroupProvider[] groupProviders;
            URL location = project.getLocationURI().toURL();
            IBundleGroupProvider[] iBundleGroupProviderArray = groupProviders = Platform.getBundleGroupProviders();
            int n = groupProviders.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleGroupProvider bundleGroupProvider = iBundleGroupProviderArray[n2];
                IBundleGroup[] iBundleGroupArray = bundleGroupProvider.getBundleGroups();
                int n3 = iBundleGroupArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBundleGroup bundleGroup = iBundleGroupArray[n4];
                    Bundle[] bundleArray = bundleGroup.getBundles();
                    int n5 = bundleArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Bundle bundle = bundleArray[n6];
                        URL bundlePath = bundle.getEntry("/");
                        URL url = FileLocator.resolve((URL)bundlePath);
                        if (location.toString().equals(url.toString())) {
                            return bundle;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean containsJar(IJavaProject javaProject, IClasspathEntry entry, String jarName) {
        switch (entry.getEntryKind()) {
            case 4: {
                JavaCore.getJavaCore();
                IClasspathEntry resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                IPath resolvedPath = resolvedEntry.getPath();
                String string = resolvedPath.toString();
                if (string.indexOf(jarName) == -1) return false;
                return true;
            }
            case 5: {
                try {
                    IPath path = entry.getPath();
                    JavaCore.getJavaCore();
                    IClasspathContainer classpathContainer = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)javaProject);
                    if (classpathContainer == null) return false;
                    classpathContainer.getClasspathEntries();
                    IClasspathEntry[] oldclasspath = classpathContainer.getClasspathEntries();
                    int i = 0;
                    while (true) {
                        if (i >= oldclasspath.length) {
                            return false;
                        }
                        if (ProjectHelper.containsJar(javaProject, oldclasspath[i], jarName)) {
                            return true;
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            case 1: 
            case 3: {
                IPath path = entry.getPath();
                String value = path.toString();
                if (value.indexOf(jarName) == -1) return false;
                return true;
            }
        }
        return false;
    }

    public static void addJars(IJavaProject javaProject) {
        try {
            IClasspathEntry[] oldclasspath = javaProject.getRawClasspath();
            int i = 0;
            while (i < oldclasspath.length) {
                if (oldclasspath[i].getPath().toString().equals("XWT_CONTAINER")) {
                    return;
                }
                ++i;
            }
            ClasspathContainer container = ProjectHelper.createContainer();
            IClasspathEntry newContainerEntry = JavaCore.newContainerEntry((IPath)container.getPath());
            JavaCore.setClasspathContainer((IPath)newContainerEntry.getPath(), (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
            IClasspathEntry[] newclasspath = new IClasspathEntry[oldclasspath.length + 1];
            int i2 = 0;
            while (i2 < oldclasspath.length) {
                newclasspath[i2] = oldclasspath[i2];
                ++i2;
            }
            newclasspath[newclasspath.length - 1] = newContainerEntry;
            javaProject.setRawClasspath(newclasspath, null);
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
    }

    public static void removeJars(IJavaProject javaProject) {
        try {
            IClasspathEntry[] oldclasspath = javaProject.getRawClasspath();
            int i = 0;
            while (i < oldclasspath.length) {
                IPath path = oldclasspath[i].getPath();
                if (path.toString().equals("XWT_CONTAINER")) {
                    oldclasspath[i] = null;
                    break;
                }
                if (i == oldclasspath.length - 1) {
                    return;
                }
                ++i;
            }
            IClasspathEntry[] newclasspath = new IClasspathEntry[oldclasspath.length - 1];
            int i2 = 0;
            int m = 0;
            while (i2 < oldclasspath.length) {
                if (oldclasspath[i2] != null) {
                    newclasspath[m++] = oldclasspath[i2];
                }
                ++i2;
            }
            javaProject.setRawClasspath(newclasspath, null);
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
    }
}

