/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.layouts.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.xwt.tools.ui.designer.commands.AddNewChildCommand;
import org.eclipse.xwt.tools.ui.designer.commands.ApplyAttributeSettingCommand;
import org.eclipse.xwt.tools.ui.designer.commands.DeleteCommand;
import org.eclipse.xwt.tools.ui.designer.core.editor.EditDomain;
import org.eclipse.xwt.tools.ui.designer.layouts.control.CheckBoxFieldEditor;
import org.eclipse.xwt.tools.ui.designer.layouts.control.FieldEditor;
import org.eclipse.xwt.tools.ui.designer.layouts.control.FieldEditorEvent;
import org.eclipse.xwt.tools.ui.designer.layouts.control.FieldEditorListener;
import org.eclipse.xwt.tools.ui.designer.layouts.control.RadioGroupFieldEditor;
import org.eclipse.xwt.tools.ui.designer.layouts.control.SpinnerFieldEditor;
import org.eclipse.xwt.tools.ui.designer.layouts.pages.IAssistantPage;
import org.eclipse.xwt.tools.ui.designer.loader.XWTProxy;
import org.eclipse.xwt.tools.ui.designer.model.RefreshAdapter;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public abstract class AssistantPage
implements IAssistantPage,
FieldEditorListener {
    private EditPart editPart;
    private Control control;
    private List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private XamlAttribute assistParentAttr;
    private XamlElement assistModel;
    private Map<FieldEditor, List<RefreshAdapter>> editor2refresher;

    @Override
    public void setEditPart(EditPart editPart) {
        if (editPart != null && editPart != this.editPart) {
            this.editPart = editPart;
        }
        this.refresh();
    }

    public EditPart getEditPart() {
        return this.editPart;
    }

    public XamlNode getModel() {
        if (this.editPart == null) {
            return null;
        }
        return (XamlNode)this.editPart.getModel();
    }

    @Override
    public Control getControl(Composite parent) {
        if (this.control == null || this.control.isDisposed()) {
            this.control = this.createControl(parent);
            this.control.setData((Object)this);
        }
        return this.control;
    }

    protected void execute(Command command) {
        if (this.editPart == null || command == null || !command.canExecute()) {
            return;
        }
        EditDomain editDomain = EditDomain.getEditDomain((EditPart)this.editPart);
        if (editDomain == null) {
            return;
        }
        CommandStack commandStack = editDomain.getCommandStack();
        if (commandStack == null) {
            return;
        }
        commandStack.execute(command);
    }

    protected RadioGroupFieldEditor createRadio(Composite parent, String groupName, String fieldName, String[][] labelsAndValues) {
        RadioGroupFieldEditor editor = new RadioGroupFieldEditor(fieldName, labelsAndValues, parent, groupName);
        this.addEditor(editor);
        return editor;
    }

    protected CheckBoxFieldEditor createCheckBox(Composite parent, String fieldName, String labelText) {
        CheckBoxFieldEditor editor = new CheckBoxFieldEditor(fieldName, labelText, parent);
        this.addEditor(editor);
        return editor;
    }

    protected SpinnerFieldEditor createSpinner(Composite parent, String fieldName, String labelText) {
        SpinnerFieldEditor editor = new SpinnerFieldEditor(fieldName, labelText, parent);
        this.addEditor(editor);
        return editor;
    }

    protected void addEditor(FieldEditor editor) {
        editor.addListener(this);
        this.editors.add(editor);
        this.setUpRefresher(editor);
    }

    protected void setUpRefresher(final FieldEditor editor) {
        XamlElement model = this.getAssistModel();
        if (model != null) {
            String fieldName = editor.getFieldName();
            RefreshAdapter refresher = new RefreshAdapter((XamlNode)model, fieldName){

                @Override
                protected void performRefresh(Notification msg) {
                    Display display = editor.getEditor().getDisplay();
                    if (Display.getCurrent() == display) {
                        editor.apply(AssistantPage.this.getAssistant());
                    } else {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                editor.apply(AssistantPage.this.getAssistant());
                            }
                        });
                    }
                }
            };
            this.getRefreshers(editor).add(refresher);
        }
    }

    protected Group createGroup(Composite composite, String groupName, int numColumns) {
        Group group = new Group(composite, 0);
        group.setText(groupName);
        group.setLayout((Layout)new GridLayout(numColumns, false));
        this.adapt((Control)group);
        return group;
    }

    protected Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.adapt((Control)composite);
        return composite;
    }

    protected void adapt(Control control) {
        control.setBackground(control.getDisplay().getSystemColor(1));
    }

    @Override
    public final void handleEvent(FieldEditorEvent event) {
        FieldEditor editor = event.editor;
        List<RefreshAdapter> refreshers = this.getRefreshers(editor);
        for (RefreshAdapter refresher : refreshers) {
            refresher.setRefreshRequired(false);
        }
        Command command = this.computeCommand(event);
        if (command != null && command.canExecute()) {
            this.execute(command);
        }
        for (RefreshAdapter refresher : refreshers) {
            refresher.setRefreshRequired(true);
        }
    }

    protected List<RefreshAdapter> getRefreshers(FieldEditor editor) {
        List<RefreshAdapter> result;
        if (editor == null) {
            return Collections.emptyList();
        }
        if (this.editor2refresher == null) {
            this.editor2refresher = new HashMap<FieldEditor, List<RefreshAdapter>>();
        }
        if ((result = this.editor2refresher.get(editor)) == null) {
            result = new ArrayList<RefreshAdapter>();
            this.editor2refresher.put(editor, result);
        }
        return result;
    }

    protected Command computeCommand(FieldEditorEvent event) {
        return this.createCommand(event.field, event.newVlaue);
    }

    protected Command createCommand(String attrName, String attrValue) {
        CompoundCommand command = new CompoundCommand();
        XamlElement assistModel = this.getAssistModel();
        if (assistModel == null) {
            return null;
        }
        XamlAttribute assistParent = this.getAssistParent();
        if (assistModel.eContainer() == null) {
            command.add((Command)new AddNewChildCommand((XamlNode)assistParent, (XamlNode)assistModel));
        }
        if (assistParent.eContainer() == null) {
            command.add((Command)new AddNewChildCommand(this.getModel(), (XamlNode)assistParent));
        }
        command.add((Command)new ApplyAttributeSettingCommand((XamlNode)assistModel, attrName, "http://www.eclipse.org/xwt/presentation", attrValue));
        return command.unwrap();
    }

    private XamlElement getAssistModel() {
        if (this.assistModel == null && this.editPart != null) {
            this.assistModel = this.createAssistModel(this.getModel());
        }
        return this.assistModel;
    }

    @Override
    public void refresh() {
        this.assistModel = null;
        this.assistParentAttr = null;
        this.apply(this.getAssistant());
    }

    protected Object getAssistant() {
        XamlElement assistModel = this.getAssistModel();
        if (assistModel == null) {
            return null;
        }
        return XWTProxy.createValue(assistModel);
    }

    @Override
    public void performDefault() {
        XamlElement assistModel = this.getAssistModel();
        if (assistModel != null) {
            this.execute(new DeleteCommand((List)assistModel.getAttributes()));
        }
    }

    protected XamlAttribute getAssistParent() {
        if (this.assistParentAttr == null) {
            this.assistParentAttr = this.createAssistParent(this.getModel());
        }
        return this.assistParentAttr;
    }

    @Override
    public void dispose() {
        if (this.control != null) {
            this.control.dispose();
        }
        this.editPart = null;
        this.assistParentAttr = null;
        this.assistModel = null;
        for (FieldEditor editor : this.editors) {
            List<RefreshAdapter> list = this.editor2refresher.get(editor);
            for (RefreshAdapter refresher : list) {
                refresher.dispose();
            }
        }
        this.editor2refresher.clear();
        this.editors.clear();
    }

    protected void apply(Object assistant) {
        for (FieldEditor fEditor : this.editors) {
            this.setUpRefresher(fEditor);
            fEditor.apply(assistant);
        }
    }

    protected abstract XamlElement createAssistModel(XamlNode var1);

    protected abstract XamlAttribute createAssistParent(XamlNode var1);

    protected abstract Control createControl(Composite var1);
}

