/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.palette.contribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.xwt.tools.ui.palette.CompoundInitializer;
import org.eclipse.xwt.tools.ui.palette.Entry;
import org.eclipse.xwt.tools.ui.palette.Initializer;
import org.eclipse.xwt.tools.ui.palette.PaletteFactory;
import org.eclipse.xwt.tools.ui.palette.page.CustomPalettePage;
import org.eclipse.xwt.tools.ui.palette.page.CustomPaletteViewerProvider;
import org.eclipse.xwt.tools.ui.palette.page.resources.IPaletteResourceProvider;
import org.eclipse.xwt.tools.ui.palette.root.PaletteRootFactory;

public class PaletteContribution
implements IExecutableExtension {
    public static final String EXTENSION_POINT_ID = "org.eclipse.xwt.tools.ui.palette.paletteContribution";
    public static final String CONTRIBUTION = "Contribution";
    public static final String CONTRIBUTION_TARGET_ID = "targetId";
    public static final String RESOURCE = "Resource";
    public static final String RESOURCE_URI = "uri";
    public static final String RESOURCE_PROVIDER = "provider";
    public static final String INITIALIZER = "Initializer";
    public static final String INITIALIZER_TARGET = "target";
    public static final String INITIALIZER_TARGET_ID = "id";
    public static final String INITIALIZER_TARGET_OVERRIDE_ID = "overrideId";
    public static final String INITIALIZER_TARGET_GLOBAL = "*";
    public static final String INITIALIZER_CLASS = "class";
    public static final String TOOL = "Tool";
    public static final String TOOL_CLASS = "class";
    public static final String TOOL_TYPE = "type";
    public static final String TOOL_TYPE_CREATION = "creation";
    public static final String TOOL_TYPE_SELECTION = "selection";
    private String editorId;
    private Map<String, Initializer> initializersMap;
    private List<IPaletteResourceProvider> resourceProviders;
    private Class<? extends Tool> creationTool;
    private Class<? extends Tool> selectionTool;
    private static final Map<String, PaletteContribution> contributions = new HashMap<String, PaletteContribution>();

    private PaletteContribution(String editorId) {
        this.editorId = editorId;
        this.loadFromExtensions();
    }

    private void loadFromExtensions() {
        IConfigurationElement[] configurations;
        IConfigurationElement[] iConfigurationElementArray = configurations = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ctrib = iConfigurationElementArray[n2];
            String targetId = ctrib.getAttribute(CONTRIBUTION_TARGET_ID);
            if (this.editorId.equals(targetId)) {
                this.loadResources(ctrib.getChildren(RESOURCE));
                this.loadInitializers(ctrib.getChildren(INITIALIZER));
                this.loadTools(ctrib.getChildren(TOOL));
            }
            ++n2;
        }
    }

    private void loadResources(IConfigurationElement[] resources) {
        if (resources == null || resources.length == 0) {
            return;
        }
        if (this.resourceProviders == null) {
            this.resourceProviders = new ArrayList<IPaletteResourceProvider>();
        }
        IConfigurationElement[] iConfigurationElementArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement resConfig = iConfigurationElementArray[n2];
            try {
                IPaletteResourceProvider provider = (IPaletteResourceProvider)resConfig.createExecutableExtension(RESOURCE_PROVIDER);
                this.resourceProviders.add(provider);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    private void loadInitializers(IConfigurationElement[] initializers) {
        if (initializers == null || initializers.length == 0) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = initializers;
        int n = initializers.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IConfigurationElement initConfig = iConfigurationElementArray[n2];
                String target = this.normalizeTarget(initConfig.getAttribute(INITIALIZER_TARGET));
                String id = initConfig.getAttribute(INITIALIZER_TARGET_ID);
                String overrideId = initConfig.getAttribute(INITIALIZER_TARGET_OVERRIDE_ID);
                Initializer initializer = null;
                try {
                    initializer = (Initializer)initConfig.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    break block4;
                }
                this.addInitializer(target, id, overrideId, initializer);
            }
            ++n2;
        }
    }

    private void addInitializer(String target, String id, String overrideId, Initializer initializer) {
        if (id == null || initializer == null) {
            return;
        }
        initializer.setId(id);
        if (this.initializersMap == null) {
            this.initializersMap = new HashMap<String, Initializer>();
        }
        if (overrideId != null && this.findInitializerById(overrideId) != null) {
            Initializer idOfInit = this.findInitializerById(overrideId);
            if (idOfInit.equals(this.initializersMap.get(target))) {
                this.initializersMap.put(target, initializer);
            } else {
                for (String key : new ArrayList<String>(this.initializersMap.keySet())) {
                    if (!idOfInit.equals(this.initializersMap.get(key))) continue;
                    this.initializersMap.put(key, initializer);
                }
            }
        } else {
            if (target != null && target.indexOf(",") != -1) {
                StringTokenizer stk = new StringTokenizer(target, ",");
                while (stk.hasMoreTokens()) {
                    this.addInitializer(stk.nextToken().trim(), id, null, initializer);
                }
                return;
            }
            Initializer oldInit = this.initializersMap.get(target = this.normalizeTarget(target));
            if (oldInit == null) {
                this.initializersMap.put(target, initializer);
            } else if (oldInit instanceof CompoundInitializer) {
                ((CompoundInitializer)oldInit).getInitializers().add((Object)initializer);
            } else {
                CompoundInitializer newInit = PaletteFactory.eINSTANCE.createCompoundInitializer();
                newInit.getInitializers().add((Object)oldInit);
                newInit.getInitializers().add((Object)initializer);
                this.initializersMap.put(target, newInit);
            }
        }
    }

    public Initializer findInitializerById(String id) {
        if (id == null || this.initializersMap == null) {
            return null;
        }
        for (Initializer init : this.initializersMap.values()) {
            if (!id.equals(init.getId())) continue;
            return init;
        }
        return null;
    }

    private String normalizeTarget(String target) {
        if (target == null || "".equals(target)) {
            target = INITIALIZER_TARGET_GLOBAL;
        }
        return target.toUpperCase();
    }

    private void loadTools(IConfigurationElement[] tools) {
        if (tools == null || tools.length == 0) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement toolConfig = iConfigurationElementArray[n2];
            String type = toolConfig.getAttribute(TOOL_TYPE);
            try {
                Tool tool = (Tool)toolConfig.createExecutableExtension("class");
                if (TOOL_TYPE_CREATION.equals(type)) {
                    this.creationTool = tool.getClass();
                } else if (TOOL_TYPE_SELECTION.equals(type)) {
                    this.selectionTool = tool.getClass();
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public Class<? extends Tool> getCreationTool() {
        return this.creationTool;
    }

    public Class<? extends Tool> getSelectionTool() {
        return this.selectionTool;
    }

    public String getEditorId() {
        return this.editorId;
    }

    public Initializer getInitializer(String type) {
        if (this.initializersMap == null) {
            return null;
        }
        type = this.normalizeTarget(type);
        return this.initializersMap.get(type);
    }

    public void applyInitializer(Entry entry) {
        Initializer globalInitializer;
        Initializer oldInitializer;
        String id;
        if (entry == null || !entry.getEntries().isEmpty()) {
            return;
        }
        ArrayList<Initializer> initializers = new ArrayList<Initializer>();
        String name = entry.getName();
        if (name != null) {
            this.merge(this.initializersMap.get(name.toUpperCase()), initializers);
        }
        if ((id = entry.getId()) != null) {
            this.merge(this.initializersMap.get(id.toUpperCase()), initializers);
        }
        if ((oldInitializer = entry.getInitializer()) != null) {
            this.merge(oldInitializer, initializers);
        }
        if ((globalInitializer = this.getGlobalInitializer()) != null) {
            this.merge(globalInitializer, initializers);
        }
        if (!initializers.isEmpty()) {
            CompoundInitializer initializer = PaletteFactory.eINSTANCE.createCompoundInitializer();
            initializer.getInitializers().addAll(initializers);
            entry.setInitializer(initializer.unwrap());
        }
    }

    private void merge(Initializer initializer, List<Initializer> initList) {
        if (initializer == null || initList == null) {
            return;
        }
        if (initializer instanceof CompoundInitializer) {
            initList.addAll((Collection<Initializer>)((CompoundInitializer)initializer).getInitializers());
        } else {
            initList.add(initializer);
        }
    }

    public Initializer getGlobalInitializer() {
        return this.getInitializer(INITIALIZER_TARGET_GLOBAL);
    }

    public boolean hasInitialiers() {
        return this.initializersMap != null && this.initializersMap.size() > 0;
    }

    public List<IPaletteResourceProvider> getResourceProviders() {
        return this.resourceProviders;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public CustomPalettePage createPalette(String editorId, EditDomain editDomain) {
        PaletteRootFactory factory = new PaletteRootFactory(this.resourceProviders, this.creationTool, this.selectionTool);
        PaletteRoot paletteRoot = factory.createPaletteRoot();
        if (paletteRoot != null) {
            editDomain.setPaletteRoot(paletteRoot);
        }
        CustomPaletteViewerProvider provider = new CustomPaletteViewerProvider(editDomain);
        return new CustomPalettePage(provider);
    }

    public static PaletteContribution getContribution(String editorId) {
        PaletteContribution paletteContribution = contributions.get(editorId);
        if (paletteContribution == null) {
            paletteContribution = new PaletteContribution(editorId);
            contributions.put(editorId, paletteContribution);
        }
        return paletteContribution;
    }
}

