/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.SWT;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.xwt.tools.ui.designer.editor.XWTDesigner;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;

public class CopyElementAction
extends SelectionAction {
    private XWTDesigner editorPart;
    private EditPart editpart;

    public CopyElementAction(IWorkbenchPart part) {
        super(part);
        this.editorPart = (XWTDesigner)part;
        this.setText(WorkbenchMessages.Workbench_copy);
        this.setToolTipText(WorkbenchMessages.Workbench_copyToolTip);
        this.setId(ActionFactory.COPY.getId());
        this.setAccelerator(SWT.MOD1 | 0x63);
        ISharedImages sharedImages = part.getSite().getWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
    }

    protected boolean calculateEnabled() {
        boolean result;
        if (this.editorPart == null) {
            return false;
        }
        if (this.editorPart.getGraphicalViewer() == null) {
            return false;
        }
        List selectedEditParts = this.editorPart.getGraphicalViewer().getSelectedEditParts();
        boolean bl = result = selectedEditParts != null && !selectedEditParts.isEmpty();
        if (result) {
            for (EditPart editPart : selectedEditParts) {
                EObject eObject;
                Object object = editPart.getModel();
                if (!(object instanceof EObject) || (eObject = (EObject)object).eContainer() != null) continue;
                return false;
            }
        }
        return result;
    }

    public void run() {
        List selectedEditParts = this.editorPart.getGraphicalViewer().getSelectedEditParts();
        ArrayList<XamlElement> selectResult = new ArrayList<XamlElement>();
        if (selectedEditParts != null && !selectedEditParts.isEmpty()) {
            int i = 0;
            while (i < selectedEditParts.size()) {
                this.editpart = (EditPart)selectedEditParts.get(i);
                Object model = this.editpart.getModel();
                Object parentModel = this.editpart.getParent().getModel();
                if (model instanceof XamlElement && parentModel instanceof XamlElement) {
                    XamlElement copymodel = (XamlElement)EcoreUtil.copy((EObject)((XamlElement)model));
                    selectResult.add(copymodel);
                }
                ++i;
            }
        }
        if (selectResult != null && selectResult.size() != 0) {
            Clipboard.getDefault().setContents(selectResult);
        }
        super.run();
    }
}

