/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.layouts.pages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutDataType;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutType;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutsHelper;
import org.eclipse.xwt.tools.ui.designer.layouts.pages.FillLayoutAssistantPage;
import org.eclipse.xwt.tools.ui.designer.layouts.pages.GridDataAssistantPage;
import org.eclipse.xwt.tools.ui.designer.layouts.pages.GridLayoutAssistantPage;
import org.eclipse.xwt.tools.ui.designer.layouts.pages.IAssistantPage;
import org.eclipse.xwt.tools.ui.designer.layouts.pages.LayoutAssistantPage;
import org.eclipse.xwt.tools.ui.designer.layouts.pages.LayoutDataAssistantPage;
import org.eclipse.xwt.tools.ui.designer.layouts.pages.RowDataAssistantPage;
import org.eclipse.xwt.tools.ui.designer.layouts.pages.RowLayoutAssistantPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssistancePageFactory {
    public static LayoutAssistantPage createPage(LayoutType layoutType) {
        if (!AssistancePageFactory.isSupport(layoutType)) {
            return null;
        }
        if (LayoutType.FillLayout == layoutType) {
            return new FillLayoutAssistantPage();
        }
        if (LayoutType.GridLayout == layoutType) {
            return new GridLayoutAssistantPage();
        }
        if (LayoutType.RowLayout == layoutType) {
            return new RowLayoutAssistantPage();
        }
        return null;
    }

    public static boolean isSupport(LayoutType layoutType) {
        return LayoutType.FillLayout == layoutType || LayoutType.GridLayout == layoutType || LayoutType.RowLayout == layoutType;
    }

    public static boolean isSupport(LayoutDataType layoutDataType) {
        return LayoutDataType.GridData == layoutDataType || LayoutDataType.RowData == layoutDataType;
    }

    public static LayoutDataAssistantPage createPage(LayoutDataType layoutDataType) {
        if (!AssistancePageFactory.isSupport(layoutDataType)) {
            return null;
        }
        if (LayoutDataType.GridData == layoutDataType) {
            return new GridDataAssistantPage();
        }
        if (LayoutDataType.RowData == layoutDataType) {
            return new RowDataAssistantPage();
        }
        return null;
    }

    public static Map<Object, IAssistantPage> newPages() {
        HashMap<Object, IAssistantPage> map = new HashMap<Object, IAssistantPage>();
        for (LayoutType layoutType : LayoutsHelper.layoutsList) {
            LayoutAssistantPage page = AssistancePageFactory.createPage(layoutType);
            if (page == null) continue;
            map.put((Object)layoutType, page);
        }
        map.put((Object)LayoutDataType.RowData, AssistancePageFactory.createPage(LayoutDataType.RowData));
        map.put((Object)LayoutDataType.GridData, AssistancePageFactory.createPage(LayoutDataType.GridData));
        return map;
    }
}

