/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.databinding.ui;

import java.beans.PropertyChangeEvent;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.tools.ui.designer.databinding.BindingContext;
import org.eclipse.xwt.tools.ui.designer.databinding.IObservable;
import org.eclipse.xwt.tools.ui.designer.databinding.Observable;
import org.eclipse.xwt.tools.ui.designer.databinding.ObservableUtil;
import org.eclipse.xwt.tools.ui.designer.databinding.Property;
import org.eclipse.xwt.tools.ui.designer.databinding.ui.ObserveGroup;
import org.eclipse.xwt.tools.ui.designer.parts.ViewerEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.WidgetEditPart;

public class ObserveTargetGroup
extends ObserveGroup {
    public ObserveTargetGroup(BindingContext bindingContext, EditPart rootEditPart) {
        super(bindingContext, rootEditPart);
    }

    protected String computeMessage() {
        String message = "Target:";
        BindingContext bc = this.getBindingContext();
        IObservable target = bc.getTarget();
        Property targetProperty = bc.getTargetProperty();
        if (target != null) {
            message = String.valueOf(message) + target.getDisplayName();
            if (targetProperty != null) {
                message = String.valueOf(message) + "." + targetProperty;
            }
        } else {
            message = String.valueOf(message) + "<empty>";
        }
        return message;
    }

    protected void handleSelection(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        BindingContext bindingContext = this.getBindingContext();
        if (element == null) {
            bindingContext.setTarget(null);
            bindingContext.setTargetProperty(null);
        } else if (element instanceof IObservable) {
            bindingContext.setTarget((IObservable)element);
            bindingContext.setTargetProperty(null);
        } else if (element instanceof Property) {
            bindingContext.setTargetProperty((Property)element);
        }
    }

    protected void selectAndReveal(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        if ("target".equals(evt.getPropertyName())) {
            TreeViewer treeViewer = this.observableList.getTreeViewer();
            treeViewer.setExpandedElements(new Object[]{newValue});
            treeViewer.setSelection((ISelection)this.createSelection(newValue), true);
        } else if ("targetProperty".equals(evt.getPropertyName())) {
            this.propertiesTree.setSelection((ISelection)this.createSelection(newValue), true);
        }
    }

    protected IObservable[] computeObservables(EditPart rootEditPart) {
        if (rootEditPart == null) {
            return new IObservable[0];
        }
        Widget root = null;
        if (rootEditPart instanceof WidgetEditPart) {
            root = ((WidgetEditPart)rootEditPart).getWidget();
        } else if (rootEditPart instanceof ViewerEditPart) {
            root = ((ViewerEditPart)rootEditPart).getViewer();
        }
        if (root == null) {
            return new IObservable[0];
        }
        Observable widgets = ObservableUtil.getObservable(root);
        if (widgets != null) {
            return new IObservable[]{widgets};
        }
        return new IObservable[0];
    }
}

