/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.workbench.properties;

import java.net.URL;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.xwt.DefaultLoadingContext;
import org.eclipse.xwt.ILoadingContext;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.emf.EMFBinding;

public class XWTSection
extends AbstractPropertySection {
    private ILoadingContext loadingContext = new DefaultLoadingContext(((Object)((Object)this)).getClass().getClassLoader());
    private URL sectionURL;
    private Composite self;

    public XWTSection(URL sectionURL) {
        this.sectionURL = sectionURL;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.self = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.self.setLayout((Layout)layout);
        layout = new GridLayout(1, false);
        layout.verticalSpacing = 5;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        this.self.setLayoutData((Object)data);
        this.self.setBackground(parent.getBackground());
        this.self.setBackgroundMode(1);
    }

    public void refresh() {
        if (this.self == null || this.self.isDisposed()) {
            this.dispose();
            return;
        }
        Control[] controlArray = this.self.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        Object source = this.getDataObject();
        if (source == null) {
            return;
        }
        if (this.sectionURL != null) {
            this.createSection(this.self, this.sectionURL, source);
        }
        this.layout(this.self);
    }

    private Object getDataObject() {
        IStructuredSelection selection = this.getSelection();
        return selection.getFirstElement();
    }

    private Control createSection(Composite parent, URL xwtFile, Object source) {
        EMFBinding.initialze();
        ILoadingContext xwtContext = XWT.getLoadingContext();
        XWT.setLoadingContext((ILoadingContext)this.loadingContext);
        Control control = null;
        try {
            control = (Control)XWT.load((Object)parent, (URL)xwtFile, (Object)source);
            if (control != null) {
                control.setLayoutData((Object)new GridData(4, 4, true, true));
            }
        }
        catch (Exception ex) {
            Label label = new Label(parent, 0);
            label.setText("An error occured in the property view. The file " + xwtFile + " could not be loaded");
            ex.printStackTrace();
        }
        XWT.setLoadingContext((ILoadingContext)xwtContext);
        return control;
    }

    private void layout(Composite parent) {
        parent.getParent().getParent().layout();
        parent.getParent().layout();
        parent.layout();
    }

    public void dispose() {
        if (this.self != null) {
            this.self.dispose();
        }
        super.dispose();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (selection == this.getSelection()) {
            return;
        }
        super.setInput(part, selection);
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)super.getSelection();
    }
}

