/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.parser;

import java.awt.BorderLayout;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.ImplicitObjectAssociation;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.core.model.association.SuperConstructorArgumentAssociation;
import org.eclipse.wb.core.model.association.UnknownAssociation;
import org.eclipse.wb.core.model.broadcast.EvaluationEventListener;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CastedSuperInvocationCreationSupport;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.ExposedPropertyCreationSupport;
import org.eclipse.wb.internal.core.model.creation.IThisMethodParameterEvaluator;
import org.eclipse.wb.internal.core.model.creation.MethodParameterCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.ExposedPropertyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.FieldInitializerVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.MethodParameterVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.BorderLayoutInfo;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class ExecuteOnParseTest
extends SwingModelTest {
    private static String COMPONENTS_HIERARCHY_PROVIDERS_POINT_ID = "org.eclipse.wb.core.componentsHierarchyProviders";

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_byteCodeExecutionFlow_1() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  public BasePanel() {", "    createContents();", "  }", "  protected void createContents() {", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends BasePanel {", "  protected void createContents() {", "    super.createContents();", "    add(new JButton());", "  }", "}");
        panel.refresh();
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {/add(new JButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
    }

    @Test
    public void test_byteCodeExecutionFlow_2() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  public BasePanel() {", "    createContents();", "  }", "  protected void createContents() {", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends BasePanel {", "  public Test() {", "    add(new JLabel());", "  }", "  protected void createContents() {", "    super.createContents();", "    add(new JButton());", "  }", "}");
        panel.refresh();
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {/add(new JButton())/ /add(new JLabel())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}", "  {new: javax.swing.JLabel} {empty} {/add(new JLabel())/}");
    }

    @Test
    public void test_byteCodeExecutionFlow_3() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  public BasePanel(boolean enabled) {", "    createContents();", "  }", "  protected void createContents() {", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        this.parseContainer("public class Test extends BasePanel {", "  public Test() {", "    super(true);", "  }", "  protected void createContents() {", "    super.createContents();", "    add(new JButton());", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {/add(new JButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
    }

    @Test
    public void test_byteCodeExecutionFlow_4() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  public BasePanel(boolean enabled) {", "    if (enabled) {", "      setEnabled(true);", "    }", "    createContents();", "  }", "  protected void createContents() {", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        this.parseContainer("public class Test extends BasePanel {", "  public Test() {", "    super(true);", "  }", "  protected void createContents() {", "    super.createContents();", "    add(new JButton());", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {/add(new JButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
    }

    @Test
    public void test_byteCodeExecutionFlow_5() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  public MyPanel() {", "    add(createClient());", "  }", "  protected abstract Component createClient();", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "  }", "  protected Component createClient() {", "    JButton clientButton = new JButton();", "    return clientButton;", "  }", "}");
        List components = panel.getChildrenComponents();
        Assertions.assertThat((List)components).hasSize(1);
        ComponentInfo button = (ComponentInfo)components.get(0);
        ExecuteOnParseTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)button.getCreationSupport());
        ExecuteOnParseTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)button.getVariableSupport());
        ExecuteOnParseTest.assertEquals((Object)"clientButton", (Object)button.getVariableSupport().getName());
        ExecuteOnParseTest.assertInstanceOf(UnknownAssociation.class, (Object)button.getAssociation());
        ExecutionFlowDescription flowDescription = this.m_lastState.getFlowDescription();
        MethodDeclaration constructor = (MethodDeclaration)panel.getCreationSupport().getNode();
        MethodDeclaration createClientMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)((TypeDeclaration)constructor.getParent()), (String)"createClient()");
        List methodsAfter = flowDescription.getBinaryFlowMethodsAfter((Statement)constructor.getBody());
        Assertions.assertThat((List)methodsAfter).containsOnly((Object[])new MethodDeclaration[]{createClientMethod});
        panel.refresh();
        methodsAfter = flowDescription.getBinaryFlowMethodsAfter((Statement)constructor.getBody());
        Assertions.assertThat((List)methodsAfter).containsOnly((Object[])new MethodDeclaration[]{createClientMethod});
    }

    @Test
    public void test_byteCodeExecutionFlow_6() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  public MyPanel() {", "    add(createClient());", "  }", "  protected abstract Component createClient();", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    {", "      JButton constructorButton = new JButton();", "      add(constructorButton);", "    }", "  }", "  protected Component createClient() {", "    JButton clientButton = new JButton();", "    return clientButton;", "  }", "}");
        List components = panel.getChildrenComponents();
        Assertions.assertThat((List)components).hasSize(2);
        ComponentInfo button = (ComponentInfo)components.get(0);
        ExecuteOnParseTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)button.getCreationSupport());
        ExecuteOnParseTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)button.getVariableSupport());
        ExecuteOnParseTest.assertEquals((Object)"clientButton", (Object)button.getVariableSupport().getName());
        ExecuteOnParseTest.assertInstanceOf(UnknownAssociation.class, (Object)button.getAssociation());
        button = (ComponentInfo)components.get(1);
        ExecuteOnParseTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)button.getCreationSupport());
        ExecuteOnParseTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)button.getVariableSupport());
        ExecuteOnParseTest.assertEquals((Object)"constructorButton", (Object)button.getVariableSupport().getName());
        ExecuteOnParseTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
    }

    @Test
    public void test_byteCodeExecutionFlow_7() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  public MyPanel() {", "    add(createClient());", "  }", "  protected abstract Component createClient();", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  private final JButton fieldButton = new JButton();", "  public Test() {", "    add(fieldButton);", "  }", "  protected Component createClient() {", "    JButton clientButton = new JButton();", "    return clientButton;", "  }", "}");
        List components = panel.getChildrenComponents();
        Assertions.assertThat((List)components).hasSize(2);
        ComponentInfo button = (ComponentInfo)components.get(0);
        ExecuteOnParseTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)button.getCreationSupport());
        ExecuteOnParseTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)button.getVariableSupport());
        ExecuteOnParseTest.assertEquals((Object)"clientButton", (Object)button.getVariableSupport().getName());
        ExecuteOnParseTest.assertInstanceOf(UnknownAssociation.class, (Object)button.getAssociation());
        button = (ComponentInfo)components.get(1);
        ExecuteOnParseTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)button.getCreationSupport());
        ExecuteOnParseTest.assertInstanceOf(FieldInitializerVariableSupport.class, (Object)button.getVariableSupport());
        ExecuteOnParseTest.assertEquals((Object)"fieldButton", (Object)button.getVariableSupport().getName());
        ExecuteOnParseTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
    }

    @Test
    public void test_byteCodeExecutionFlow_8() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  public MyPanel() {", "    fillPanel();", "  }", "  protected void fillPanel() {", "    add(new JLabel('super JLabel'));", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "  }", "  protected void fillPanel() {", "    super.fillPanel();", "    {", "      JButton button = new JButton('local JButton');", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        Object[] components = panel.getChildrenComponents();
        Assertions.assertThat((List)components).hasSize(1);
        ExecuteOnParseTest.assertEquals((Object)"button", (Object)((ComponentInfo)components.get(0)).getVariableSupport().getName());
        components = panel.getContainer().getComponents();
        Assertions.assertThat((Object[])components).hasSize(2);
        JLabel superJLabel = (JLabel)components[0];
        ExecuteOnParseTest.assertEquals((Object)"super JLabel", (Object)superJLabel.getText());
        JButton localJButton = (JButton)components[1];
        ExecuteOnParseTest.assertEquals((Object)"local JButton", (Object)localJButton.getText());
    }

    @Test
    public void test_byteCodeExecutionFlow_9() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  public MyPanel() {", "    fillPanel();", "  }", "  protected void fillPanel() {", "    add(new JLabel('super JLabel'));", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "  }", "  protected void fillPanel() {", "    {", "      JButton button = new JButton('local JButton');", "      add(button);", "    }", "    super.fillPanel();", "  }", "}");
        panel.refresh();
        Object[] components = panel.getChildrenComponents();
        Assertions.assertThat((List)components).hasSize(1);
        ExecuteOnParseTest.assertEquals((Object)"button", (Object)((ComponentInfo)components.get(0)).getVariableSupport().getName());
        components = panel.getContainer().getComponents();
        Assertions.assertThat((Object[])components).hasSize(2);
        JButton localJButton = (JButton)components[0];
        ExecuteOnParseTest.assertEquals((Object)"local JButton", (Object)localJButton.getText());
        JLabel superJLabel = (JLabel)components[1];
        ExecuteOnParseTest.assertEquals((Object)"super JLabel", (Object)superJLabel.getText());
    }

    @Test
    public void test_byteCodeExecutionFlow_10() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  private JPanel container = new JPanel();", "  public MyPanel() {", "    add(container);", "    container.add(createClient());", "  }", "  public Container getContainer() {", "    return container;", "  }", "  protected abstract Component createClient();", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "  }", "  protected Component createClient() {", "    JButton clientButton = new JButton();", "    return clientButton;", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {method: public java.awt.Container test.MyPanel.getContainer()} {property} {}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {new: javax.swing.JButton} {local-unique: clientButton} {/new JButton()/ /clientButton/}");
        ContainerInfo container = (ContainerInfo)panel.getChildrenComponents().get(0);
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)container, null);
        Block expectedBlock = ((MethodDeclaration)panel.getCreationSupport().getNode()).getBody();
        ExecuteOnParseTest.assertTarget(target, expectedBlock, null, true);
    }

    @Test
    public void test_byteCodeExecutionFlow_11() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyDialog.java", this.getTestSource("public abstract class MyDialog extends JPanel {", "  public MyDialog() {", "    setLayout(new BorderLayout());", "    JPanel contentArea = new JPanel();", "    add(contentArea);", "    createDialogArea(contentArea);", "  }", "  protected abstract void createDialogArea(Container parent);", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyDialog {", "  public Test() {", "  }", "  protected void createDialogArea(Container parent) {", "    JButton button = new JButton();", "    parent.add(button);", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.MyDialog} {this} {}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {parameter} {parent} {/parent.add(button)/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /parent.add(button)/}");
        ContainerInfo parent = (ContainerInfo)panel.getChildrenComponents().get(0);
        ExecuteOnParseTest.assertInstanceOf(UnknownAssociation.class, (Object)parent.getAssociation());
        ExecuteOnParseTest.assertInstanceOf(MethodParameterCreationSupport.class, (Object)parent.getCreationSupport());
        ExecuteOnParseTest.assertInstanceOf(MethodParameterVariableSupport.class, (Object)parent.getVariableSupport());
        panel.refresh();
        ExecuteOnParseTest.assertNotNull((Object)parent.getObject());
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration((JavaInfo)panel);
        MethodDeclaration createDialogAreaMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"createDialogArea(java.awt.Container)");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)parent, null);
        Statement expectedStatement = ExecuteOnParseTest.getStatement(createDialogAreaMethod.getBody(), 1);
        ExecuteOnParseTest.assertTarget(target, null, expectedStatement, false);
    }

    @Test
    public void test_byteCodeExecutionFlow_12() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyDialog.java", this.getTestSource("public abstract class MyDialog extends JPanel {", "  public MyDialog() {", "    setLayout(new BorderLayout());", "    configureShell(this);", "    {", "      JPanel contentArea = new JPanel();", "      add(contentArea);", "      createDialogArea(contentArea);", "    }", "    {", "      JPanel buttonBar = new JPanel();", "      add(buttonBar, BorderLayout.SOUTH);", "      createButtonsForButtonBar(buttonBar);", "    }", "  }", "  protected void configureShell(Container shell) {", "  }", "  protected void createDialogArea(Container parent) {", "  }", "  protected void createButtonsForButtonBar(Container parent) {", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        this.parseContainer("public class Test extends MyDialog {", "  public Test() {", "  }", "  protected void configureShell(Container shell) {", "    shell.setEnabled(true);", "  }", "  protected void createDialogArea(Container parent) {", "    JButton button_1 = new JButton();", "    parent.add(button_1);", "  }", "  protected void createButtonsForButtonBar(Container parent) {", "    JButton button_2 = new JButton();", "    parent.add(button_2);", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.MyDialog} {this} {}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {parameter} {shell} {/shell.setEnabled(true)/}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "    {parameter} {parent} {/parent.add(button_1)/}", "      {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "      {new: javax.swing.JButton} {local-unique: button_1} {/new JButton()/ /parent.add(button_1)/}", "    {parameter} {parent} {/parent.add(button_2)/}", "      {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "      {new: javax.swing.JButton} {local-unique: button_2} {/new JButton()/ /parent.add(button_2)/}");
    }

    @Test
    public void test_byteCodeExecutionFlow_13() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyDialog.java", this.getTestSource("public abstract class MyDialog extends JPanel {", "  public MyDialog() {", "    setLayout(new BorderLayout());", "    //", "    JPanel contentArea = new JPanel();", "    add(contentArea);", "    //", "    Component dialogArea = createDialogArea(contentArea);", "  }", "  protected Component createDialogArea(Container parent) {", "    JPanel dialogArea = new JPanel();", "    parent.add(dialogArea);", "    return dialogArea;", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyDialog {", "  public Test() {", "  }", "  protected Component createDialogArea(Container parent) {", "    Container container = (Container) super.createDialogArea(parent);", "    JButton button = new JButton();", "    container.add(button);", "    return button;", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.MyDialog} {this} {}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {parameter} {parent} {/super.createDialogArea(parent)/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {casted-superInvocation: (Container)super.createDialogArea(parent)} {local-unique: container} {/(Container) super.createDialogArea(parent)/ /container.add(button)/}", "      {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "      {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /container.add(button)/ /button/}");
        ContainerInfo createDialogAreaParent = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerInfo container = (ContainerInfo)createDialogAreaParent.getChildrenComponents().get(0);
        CastedSuperInvocationCreationSupport creationSupport = (CastedSuperInvocationCreationSupport)container.getCreationSupport();
        ExecuteOnParseTest.assertEquals((Object)"(Container) super.createDialogArea(parent)", (Object)this.m_lastEditor.getSource(creationSupport.getNode()));
        ExecuteOnParseTest.assertFalse((boolean)creationSupport.canDelete());
        ExecuteOnParseTest.assertFalse((boolean)creationSupport.canReorder());
        ExecuteOnParseTest.assertFalse((boolean)creationSupport.canReparent());
        ExecuteOnParseTest.assert_creation((JavaInfo)panel);
    }

    @Test
    public void test_byteCodeExecutionFlow_14() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyDialog.java", this.getTestSource("public abstract class MyDialog extends JPanel {", "  public MyDialog() {", "    int sum = getSum(1, 2);", "    if (sum != 3) {", "      throw new IllegalStateException('3 expected, but ' + sum + ' found.');", "    }", "  }", "  protected abstract int getSum(int a, int b);", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyDialog {", "  public Test() {", "  }", "  protected int getSum(int a, int b) {", "    return a + b;", "  }", "}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_byteCodeExecutionFlow_15() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  public BasePanel() {", "    method_1();", "    method_2();", "  }", "  protected void method_1() {", "  }", "  protected void method_2() {", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends BasePanel {", "  public Test() {", "    super();", "  }", "  protected void method_1() {", "    setEnabled(true);", "  }", "  protected void method_2() {", "    setEnabled(false);", "  }", "}");
        ExecutionFlowDescription flowDescription = this.m_lastState.getFlowDescription();
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration((JavaInfo)panel);
        MethodDeclaration constructor = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"<init>()");
        MethodDeclaration method_1 = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"method_1()");
        MethodDeclaration method_2 = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"method_2()");
        Assertions.assertThat((List)flowDescription.getTraceStatements()).isEmpty();
        List flowMethods = flowDescription.getBinaryFlowMethodsAfter((Statement)constructor.getBody());
        Assertions.assertThat((List)flowMethods).hasSize(2);
        ExecuteOnParseTest.assertSame((Object)method_1, flowMethods.get(0));
        ExecuteOnParseTest.assertSame((Object)method_2, flowMethods.get(1));
        panel.refresh();
        flowDescription = this.m_lastState.getFlowDescription();
        Assertions.assertThat((List)flowDescription.getTraceStatements()).isEmpty();
    }

    @Test
    public void test_byteCodeExecutionFlow_16() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  public BasePanel() {", "    method_1();", "    method_2();", "  }", "  protected void method_1() {", "  }", "  protected void method_2() {", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends BasePanel {", "  private JButton m_button;", "  public Test() {", "    super();", "  }", "  protected void method_1() {", "    m_button = new JButton();", "  }", "  protected void method_2() {", "    add(m_button);", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        NodeTarget nodeTarget = ExecuteOnParseTest.getNodeStatementTarget((JavaInfo)panel, "method_2()", true, 0);
        ExecuteOnParseTest.assertEquals((Object)"m_button", (Object)button.getVariableSupport().getName());
        ExecuteOnParseTest.assertEquals((Object)"m_button", (Object)button.getVariableSupport().getReferenceExpression(nodeTarget));
    }

    @Test
    public void test_byteCodeExecutionFlow_17() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyDialog.java", this.getTestSource("public abstract class MyDialog extends JPanel {", "  public MyDialog() {", "    setLayout(new BorderLayout());", "    {", "      JPanel contentArea = new JPanel();", "      add(contentArea);", "      configureContentArea(contentArea);", "    }", "  }", "  protected void configureContentArea(Container contentArea) {", "  }", "}"));
        ExecuteOnParseTest.setFileContentSrc("test/MyDialog.configureContentArea_java.awt.Container_.0.wbp-component.xml", ExecuteOnParseTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='thisCreation.ignoreBind'>true</parameter>", "  </parameters>", "</component>"));
        ExecuteOnParseTest.waitForAutoBuild();
        this.parseContainer("public class Test extends MyDialog {", "  public Test() {", "  }", "  protected void configureContentArea(Container contentArea) {", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.MyDialog} {this} {}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}");
    }

    @Test
    public void test_byteCodeExecutionFlow_18() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  public void add2(Component component) {", "    add(component);", "  }", "}"));
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ExecuteOnParseTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='add2'>", "      <parameter type='java.awt.Component'/>", "    </method>", "  </methods>", "</component>"));
        ExecuteOnParseTest.waitForAutoBuild();
        this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    add2(new JButton());", "    add(new JCheckBox());", "    add(new JRadioButton());", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.MyPanel} {this} {/add2(new JButton())/ /add(new JCheckBox())/ /add(new JRadioButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add2(new JButton())/}", "  {new: javax.swing.JCheckBox} {empty} {/add(new JCheckBox())/}", "  {new: javax.swing.JRadioButton} {empty} {/add(new JRadioButton())/}");
    }

    @Test
    public void test_byteCodeExecutionFlow_duplicateMethodInvocation() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  public BasePanel() {", "    createContents();", "  }", "  protected void createContents() {", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends BasePanel {", "  public Test() {", "    createContents();", "  }", "  protected void createContents() {", "    add(new JButton());", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {/add(new JButton())/ /createContents()/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_byteCodeExecutionFlow_duplicateMethodInvocation2() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  public BasePanel() {", "    createButton(this);", "    createButton(this);", "  }", "  protected void createButton(Container parent) {", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends BasePanel {", "  public Test() {", "  }", "  protected void createButton(Container parent) {", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {parameter} {parent} {}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_byteCodeExecutionFlow_duplicateMethodInvocation3() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  public BasePanel() {", "    if (getObj() == null) {", "      throw new IllegalStateException();", "    }", "    if (getObj() == null) {", "      throw new IllegalStateException();", "    }", "  }", "  protected Object getObj() {", "    return null;", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends BasePanel {", "  private Object m_object = new Object();", "  public Test() {", "  }", "  protected Object getObj() {", "    return (m_object);", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_byteCodeExecutionFlow_duplicateMethodInvocation_lazy() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  public BasePanel() {", "    if (getButton() == null) {", "      throw new IllegalStateException();", "    }", "    if (getButton() == null) {", "      throw new IllegalStateException();", "    }", "  }", "  protected JButton getButton() {", "    return null;", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends BasePanel {", "  private Object m_object = new Object();", "  public Test() {", "  }", "  private JButton button;", "  protected JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_byteCodeExecutionFlow_infiniteRecursion() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  public BasePanel() {", "    createContents();", "  }", "  protected void createContents() {", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends BasePanel {", "  public Test() {", "  }", "  protected void createContents() {", "    add(new JButton());", "    createContents();", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {/add(new JButton())/ /createContents()/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_byteCodeExecutionFlow_callSuper_andIntercept() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  public BasePanel() {", "    createContents();", "  }", "  protected void createContents() {", "    JButton button = createButton();", "    button.setEnabled(true); // should not cause NPE", "  }", "  protected JButton createButton() {", "    return null;", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends BasePanel {", "  protected void createContents() {", "    super.createContents();", "  }", "  protected JButton createButton() {", "    return new JButton();", "  }", "}");
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_byteCodeExecutionFlow_callSuper_whenBridgeMethod() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/PanelA.java", this.getTestSource("public class PanelA extends JPanel {", "  protected JComponent createButton() {", "    return new JButton();", "  }", "}"));
        ExecuteOnParseTest.setFileContentSrc("test/PanelB.java", this.getTestSource("public class PanelB extends PanelA {", "  protected JButton createButton() {", "    return (JButton) super.createButton();", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        this.parseContainer("public class Test extends PanelB {", "  public Test() {", "    JButton button = createButton();", "    add(button);", "  }", "  protected JButton createButton() {", "    return super.createButton();", "  }", "}");
        this.refresh();
        Object button = ExecuteOnParseTest.getJavaInfoByName("button");
        ExecuteOnParseTest.assertNotNull((Object)button.getObject());
    }

    @Test
    public void test_exposedComponents_binaryExecutionFlow_noOverride() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  private JPanel m_inner;", "  public BasePanel() {", "    createContents();", "  }", "  protected void createContents() {", "    m_inner = new JPanel();", "    add(m_inner);", "  }", "  public JPanel getInner() {", "    return m_inner;", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends BasePanel {", "  // no createContents()", "}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {method: public javax.swing.JPanel test.BasePanel.getInner()} {property} {}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_binaryExecutionFlow_setLayoutInSuper() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  public BasePanel() {", "    createContents();", "  }", "  protected void createContents() {", "    setLayout(new BorderLayout());", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        this.parseContainer("public class Test extends BasePanel {", "  protected void createContents() {", "    super.createContents();", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}");
    }

    @Test
    public void test_exposedComponents_binaryExecutionFlow_withOverride2() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  private JPanel m_inner;", "  public BasePanel() {", "    createContents();", "  }", "  protected void createContents() {", "    m_inner = new JPanel();", "    add(m_inner);", "  }", "  public JPanel getInner() {", "    return m_inner;", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends BasePanel {", "  protected void createContents() {", "    super.createContents();", "    getInner().add(new JButton());", "  }", "}");
        ExecuteOnParseTest.assert_creation((JavaInfo)panel);
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {method: public javax.swing.JPanel test.BasePanel.getInner()} {property} {/getInner().add(new JButton())/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {new: javax.swing.JButton} {empty} {/getInner().add(new JButton())/}");
    }

    @Test
    public void test_exposedComponents_binaryExecutionFlow_decideCreationByOverrideResult() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  private JPanel m_inner;", "  public BasePanel() {", "    createContents();", "  }", "  protected void createContents() {", "    if (shouldCreateInner()) {", "      m_inner = new JPanel();", "      add(m_inner);", "    }", "  }", "  public JPanel getInner() {", "    return m_inner;", "  }", "  public boolean shouldCreateInner() {", "    return true;", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends BasePanel {", "  public boolean shouldCreateInner() {", "    return true;", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {method: public javax.swing.JPanel test.BasePanel.getInner()} {property} {}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_exposedComponents_binaryExecutionFlow_dontVisit() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  private JPanel m_inner;", "  public BasePanel() {", "    createContents();", "  }", "  protected void createContents() {", "  }", "}"));
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.wbp-component.xml", ExecuteOnParseTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='createContents'>", "      <tag name='binaryExecutionFlow.dontVisit' value='true'/>", "    </method>", "  </methods>", "</component>"));
        ExecuteOnParseTest.waitForAutoBuild();
        this.parseContainer("public class Test extends BasePanel {", "  protected void createContents() {", "    add(new JButton());", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_binaryExecutionFlow_disableForPackage_withException() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  private JPanel m_inner;", "  public BasePanel() {", "    method_1();", "    method_2();", "    method_3();", "  }", "  protected void method_1() {", "  }", "  protected void method_2() {", "  }", "  protected void method_3() {", "  }", "}"));
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.wbp-component.xml", ExecuteOnParseTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='binaryExecutionFlow.dontVisit.package test'>method_2()</parameter>", "  </parameters>", "</component>"));
        ExecuteOnParseTest.waitForAutoBuild();
        this.parseContainer("public class Test extends BasePanel {", "  protected void method_1() {", "    add(new JButton('1'));", "  }", "  protected void method_2() {", "    add(new JButton('2'));", "  }", "  protected void method_3() {", "    add(new JButton('3'));", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {/add(new JButton('2'))/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton('2'))/}");
    }

    @Test
    public void test_binaryExecutionFlow_disableForPackage_noExceptions() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  private JPanel m_inner;", "  public BasePanel() {", "    method_1();", "    method_2();", "    method_3();", "  }", "  protected void method_1() {", "  }", "  protected void method_2() {", "  }", "  protected void method_3() {", "  }", "}"));
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.wbp-component.xml", ExecuteOnParseTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='binaryExecutionFlow.dontVisit.package test'/>", "  </parameters>", "</component>"));
        ExecuteOnParseTest.waitForAutoBuild();
        this.parseContainer("public class Test extends BasePanel {", "  protected void method_1() {", "    add(new JButton('1'));", "  }", "  protected void method_2() {", "    add(new JButton('2'));", "  }", "  protected void method_3() {", "    add(new JButton('3'));", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_byteCodeExecutionFlow_disableForClass() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel() {", "    createContents();", "  }", "  public void createContents() {", "  }", "}"));
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ExecuteOnParseTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='binaryExecutionFlow.no'>true</parameter>", "  </parameters>", "</component>"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "  }", "  public void createContents() {", "    add(new JButton());", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
        ExecuteOnParseTest.assertFalse((boolean)ReflectionUtils.isEnchancedClass(panel.getObject().getClass()));
    }

    @Test
    public void test_exposedComponents_binaryExecutionFlow_prepareObjectsForExposed() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  protected JPanel m_inner;", "  public BasePanel() {", "    createContents();", "  }", "  protected void createContents() {", "    m_inner = new JPanel();", "    add(m_inner);", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends BasePanel {", "  protected void createContents() {", "    super.createContents();", "    m_inner.add(new JButton());", "  }", "  public boolean shouldCreateInner() {", "    return true;", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {field: javax.swing.JPanel} {m_inner} {/m_inner.add(new JButton())/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {new: javax.swing.JButton} {empty} {/m_inner.add(new JButton())/}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_byteCodeExecutionFlow_whenSearchExposedChildren() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public abstract class BasePanel extends JPanel {", "  public BasePanel() {", "  }", "  public abstract JButton getButton();", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends BasePanel {", "  public Test() {", "  }", "  public JButton getButton() {", "    return null;", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: test.BasePanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        panel.refresh();
    }

    @Test
    public void test_byteCodeExecutionFlow_ignoreSwingMethods() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/Super.java", this.getTestSource("public class Super extends JFrame {", "  public void setVisible(boolean b) {", "    super.setVisible(b);", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends Super {", "  public Test() {", "  }", "  public void setVisible(boolean b) {", "    super.setVisible(b);", "  }", "}");
        frame.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)frame);
        JFrame frameObject = (JFrame)frame.getObject();
        ExecuteOnParseTest.assertFalse((boolean)frameObject.isVisible());
    }

    @Test
    public void test_byteCodeExecutionFlow_ignoreSwingMethods2() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/Super.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Super extends JPanel {", "  // filler filler filler", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends Super {", "  public Test() {", "  }", "  public void paint(Graphics g) {", "    super.paint(g);", "    setEnabled(false);", "  }", "}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
        ExecuteOnParseTest.assertTrue((boolean)panel.getComponent().isEnabled());
    }

    @Test
    public void test_byteCodeExecutionFlow_anyParameterValue() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/Super.java", this.getTestSource("public class Super extends JFrame {", "  public Super() {", "  }", "  public void setVisible(boolean b) {", "    super.setVisible(b);", "    myMethod(123);", "  }", "  public void myMethod(int value) {", "    if (value != 123) throw new Error('Invalid value.');", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends Super {", "  public Test() {", "  }", "  public void myMethod(int value) {", "    super.myMethod(value);", "  }", "}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_bindBinary_toDepth() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  private JPanel internalPanel;", "  private JButton contentButton;", "  public MyPanel(){", "    internalPanel = new JPanel();", "    add(internalPanel);", "    contentButton = getContentButton();", "  }", "  abstract protected JButton getContentButton();", "  // some internal actions for pending attach", "  //   contentPanel to 'this'.", "}"));
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ExecuteOnParseTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='bindBinary.toDepth'>true</parameter>", "  </parameters>", "</component>"));
        ExecuteOnParseTest.waitForAutoBuild();
        TestUtils.addDynamicExtension(COMPONENTS_HIERARCHY_PROVIDERS_POINT_ID, "  <provider class='" + Test_HierarchyProvider.class.getName() + "'/>");
        try {
            this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "  }", "  protected JButton getContentButton(){", "    return new JButton();", "  }", "}");
            ExecuteOnParseTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/new JButton()/}");
            this.refresh();
            ExecuteOnParseTest.assertNoErrors(this.m_lastParseInfo);
        }
        finally {
            TestUtils.removeDynamicExtension(COMPONENTS_HIERARCHY_PROVIDERS_POINT_ID);
        }
    }

    @Test
    public void test_layoutInSuperConstructor_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    super(new BorderLayout());", "  }", "}");
        panel.refresh();
        ExecuteOnParseTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {new: java.awt.BorderLayout} {empty} {/super(new BorderLayout());/}");
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        ExecuteOnParseTest.assertInstanceOf(BorderLayout.class, (Object)layout.getObject());
        ExecuteOnParseTest.assertInstanceOf(EmptyVariableSupport.class, (Object)layout.getVariableSupport());
        SuperConstructorArgumentAssociation association = (SuperConstructorArgumentAssociation)layout.getAssociation();
        ExecuteOnParseTest.assertEquals((Object)"super(new BorderLayout());", (Object)association.getSource());
    }

    @Test
    public void test_layoutInSuperConstructor_2() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    super(new GridBagLayout());", "    add(new JButton());", "  }", "}");
    }

    @Test
    public void test_evaluateBroadcast() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        List<String> expectedNodes_before = List.of("setEnabled(false)", "setEnabled(false);");
        List<String> expectedNodes_after = List.of("setEnabled(false)", "setEnabled(false);");
        final Iterator<String> expectedIterator_before = expectedNodes_before.iterator();
        final Iterator<String> expectedIterator_after = expectedNodes_after.iterator();
        panel.addBroadcastListener((Object)new EvaluationEventListener(){

            public void evaluateBefore(EvaluationContext context, ASTNode node) throws Exception {
                ExecuteOnParseTest.assertEquals(expectedIterator_before.next(), (Object)ExecuteOnParseTest.this.m_lastEditor.getSource(node));
            }

            public void evaluateAfter(EvaluationContext context, ASTNode node) throws Exception {
                ExecuteOnParseTest.assertEquals(expectedIterator_after.next(), (Object)ExecuteOnParseTest.this.m_lastEditor.getSource(node));
            }
        });
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
        ExecuteOnParseTest.assertFalse((boolean)expectedIterator_before.hasNext());
        ExecuteOnParseTest.assertFalse((boolean)expectedIterator_after.hasNext());
    }

    @Test
    public void test_instanceMethod_simple() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton(getMyText());", "    add(button);", "  }", "  private String getMyText() {", "    return 'txt';", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ExecuteOnParseTest.assertEquals((Object)"txt", (Object)((JButton)button.getObject()).getText());
    }

    @Test
    public void test_instanceMethod_abstractMethod() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  public MyPanel() {", "    setName(getAbstractName());", "  }", "  protected abstract String getAbstractName();", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ExecuteOnParseTest.useStrictEvaluationMode(false);
        ContainerInfo panel = this.parseContainer("public abstract class Test extends MyPanel {", "  public Test() {", "  }", "  protected abstract String getAbstractName();", "}");
        panel.refresh();
        ExecuteOnParseTest.assertEquals((Object)"<dynamic>", (Object)((JPanel)panel.getObject()).getName());
    }

    @Test
    public void test_instanceMethod_complex() throws Exception {
        try {
            this.parseContainer("public class Test {", "  public static void main(String[] args) {", "    Test app = new Test();", "    app.open();", "  }", "  public void open() {", "    JPanel panel = new JPanel();", "    JButton button = new JButton(getMyText());", "    panel.add(button);", "  }", "  private String getMyText() {", "    String result = 'txt';", "    return result;", "  }", "}");
            ExecuteOnParseTest.fail();
        }
        catch (Throwable e) {
            Throwable rootCause = DesignerExceptionUtils.getRootCause((Throwable)e);
            ExecuteOnParseTest.assertInstanceOf(DesignerException.class, (Object)rootCause);
            ExecuteOnParseTest.assertEquals((int)306, (int)((DesignerException)rootCause).getCode());
        }
    }

    @Test
    public void test_duplicateMethodInvocation_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    addButton();", "    addButton();", "  }", "  private void addButton() {", "    add(new JButton());", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_duplicateMethodInvocation_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    addButton();", "  }", "  private void addButton() {", "    add(new JButton());", "  }", "  private void disconnectedForExecutionFlow() {", "    addButton();", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_duplicateEvaluateExpression() throws Exception {
        ContainerInfo toolBar = this.parseContainer("public class Test extends JToolBar {", "  public Test() {", "    addSeparator();", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: javax.swing.JToolBar} {this} {/addSeparator()/}", "  {void} {void} {/addSeparator()/}");
        toolBar.refresh();
        Container container = toolBar.getContainer();
        Assertions.assertThat((Object[])container.getComponents()).hasSize(1);
    }

    @Test
    public void test_executeAssignment() throws Exception {
        ContainerInfo panel = (ContainerInfo)this.parseSource("test", "Test.java", ExecuteOnParseTest.getSource("package test;", "import javax.swing.*;", "class Test {", "  public static void main(String[] args) {", "    JPanel panel;", "    panel = new JPanel();", "  }", "}"));
        ExecuteOnParseTest.assert_creation((JavaInfo)panel);
    }

    @Test
    public void test_executeAssignment_FieldAccess() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public int m_value;", "  public MyButton(Container container) {", "    container.add(this);", "  }", "}"));
        ExecuteOnParseTest.setFileContentSrc("test/MyButton.wbp-component.xml", ExecuteOnParseTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    new MyButton(this).m_value = 1;", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ExecuteOnParseTest.assertEquals((int)1, (int)ReflectionUtils.getFieldInt((Object)button.getObject(), (String)"m_value"));
    }

    @Test
    public void test_Java5_varArgs() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyFactory.java", this.getTestSource("public class MyFactory {", "  public static JLabel createLabel(String text, Object... parameters) {", "    return new JLabel(text);", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JLabel label = MyFactory.createLabel('text', 'p1', 'p2');", "      add(label);", "    }", "  }", "}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
        ExecuteOnParseTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(label)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {static factory: test.MyFactory createLabel(java.lang.String,java.lang.Object[])} {local-unique: label} {/MyFactory.createLabel('text', 'p1', 'p2')/ /add(label)/}");
    }

    private ContainerInfo parsePanelWithButton() throws Exception {
        return this.parseContainer("class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "    {", "      JButton button = new JButton();", "      button.setText('New button');", "      panel.add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_PanelButton_1a() throws Exception {
        ContainerInfo panel = this.parsePanelWithButton();
        ExecuteOnParseTest.assert_isCleanHierarchy((JavaInfo)panel);
        ExecuteOnParseTest.assertHierarchy("{new: javax.swing.JPanel} {local-unique: panel} {/new JPanel()/ /panel.add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /button.setText('New button')/ /panel.add(button)/}");
    }

    @Test
    public void test_Frame() throws Exception {
        ContainerInfo frame = (ContainerInfo)this.parseSource("test", "Test.java", ExecuteOnParseTest.getSource("package test;", "import java.awt.*;", "import javax.swing.*;", "class Test {", "  public static void main(String[] args) {", "    JFrame frame = new JFrame();", "    frame.setBackground(Color.YELLOW);", "  }", "}"));
        ExecuteOnParseTest.assert_isCleanHierarchy((JavaInfo)frame);
        ExecuteOnParseTest.assertHierarchy("{new: javax.swing.JFrame} {local-unique: frame} {/new JFrame()/ /frame.setBackground(Color.YELLOW)/}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}");
        ExecuteOnParseTest.assertTrue((boolean)(frame.getCreationSupport() instanceof ConstructorCreationSupport));
        ExecuteOnParseTest.assertEquals((int)1, (int)frame.getChildrenComponents().size());
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ExecuteOnParseTest.assertInstanceOf(ExposedPropertyCreationSupport.class, (Object)contentPane.getCreationSupport());
        ExecuteOnParseTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)contentPane.getAssociation());
        ExecuteOnParseTest.assert_creation((JavaInfo)frame);
    }

    @Test
    public void test_FrameButton() throws Exception {
        ContainerInfo frame = this.parseContainer("class Test {", "  public static void main(String[] args) {", "    JFrame frame = new JFrame();", "    {", "      JButton button = new JButton();", "      button.setText('JButton on JFrame');", "      frame.getContentPane().add(button, BorderLayout.NORTH);", "    }", "  }", "}");
        ExecuteOnParseTest.assert_isCleanHierarchy((JavaInfo)frame);
        ExecuteOnParseTest.assertHierarchy("{new: javax.swing.JFrame} {local-unique: frame} {/new JFrame()/ /frame.getContentPane()/}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {/frame.getContentPane().add(button, BorderLayout.NORTH)/}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "    {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /button.setText('JButton on JFrame')/ /frame.getContentPane().add(button, BorderLayout.NORTH)/}");
        ExecuteOnParseTest.assertTrue((boolean)(frame.getCreationSupport() instanceof ConstructorCreationSupport));
        ExecuteOnParseTest.assertEquals((int)1, (int)frame.getChildrenComponents().size());
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        CreationSupport creationSupport = contentPane.getCreationSupport();
        ExecuteOnParseTest.assertInstanceOf(ExposedPropertyCreationSupport.class, (Object)contentPane.getCreationSupport());
        ExecuteOnParseTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)contentPane.getAssociation());
        ExecuteOnParseTest.assertEquals((Object)frame.getCreationSupport().getNode(), (Object)creationSupport.getNode());
        try {
            creationSupport.create(null, null);
            ExecuteOnParseTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            creationSupport.add_getSource(null);
            ExecuteOnParseTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            creationSupport.add_setSourceExpression(null);
            ExecuteOnParseTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        VariableSupport variableSupport = contentPane.getVariableSupport();
        ExecuteOnParseTest.assertTrue((boolean)(variableSupport instanceof ExposedPropertyVariableSupport));
        NodeTarget target = ExecuteOnParseTest.getNodeStatementTarget((JavaInfo)frame, "main(java.lang.String[])", false, 0);
        ExecuteOnParseTest.assertEquals((Object)"frame.getContentPane()", (Object)variableSupport.getReferenceExpression(target));
        ExecuteOnParseTest.assertEquals((Object)"frame.getContentPane().", (Object)variableSupport.getAccessExpression(target));
        ExecuteOnParseTest.assertFalse((boolean)variableSupport.hasName());
        try {
            variableSupport.getName();
            ExecuteOnParseTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.setName("foo");
            ExecuteOnParseTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ExecuteOnParseTest.assertFalse((boolean)variableSupport.canConvertLocalToField());
        try {
            variableSupport.convertLocalToField();
            ExecuteOnParseTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ExecuteOnParseTest.assertFalse((boolean)variableSupport.canConvertFieldToLocal());
        try {
            variableSupport.convertFieldToLocal();
            ExecuteOnParseTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ExecuteOnParseTest.assertEquals((int)1, (int)contentPane.getChildrenComponents().size());
        ContainerInfo button = (ContainerInfo)contentPane.getChildrenComponents().get(0);
        ExecuteOnParseTest.assertTrue((boolean)(button.getCreationSupport() instanceof ConstructorCreationSupport));
        ExecuteOnParseTest.assert_creation((JavaInfo)frame);
    }

    @Test
    public void test_ThisFrameButton() throws Exception {
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  public Test() {", "    {", "      JButton button = new JButton();", "      button.setText('JButton on this JFrame');", "      getContentPane().add(button, BorderLayout.NORTH);", "    }", "  }", "}");
        ExecuteOnParseTest.assert_isCleanHierarchy((JavaInfo)frame);
        ExecuteOnParseTest.assertHierarchy("{this: javax.swing.JFrame} {this} {}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {/getContentPane().add(button, BorderLayout.NORTH)/}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "    {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /button.setText('JButton on this JFrame')/ /getContentPane().add(button, BorderLayout.NORTH)/}");
        ExecuteOnParseTest.assert_creation((JavaInfo)frame);
    }

    @Test
    public void test_otherMethodInvocation() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("class Test {", "  static void foo() {", "  }", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    foo();", "  }", "}");
        ExecuteOnParseTest.assertRelatedNodes((JavaInfo)panel, new String[]{"new JPanel()"});
    }

    @Test
    public void test_this_relatedNode_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    setEnabled(true);", "  }", "}");
        ExecuteOnParseTest.assertRelatedNodes((JavaInfo)panel, new String[]{"setEnabled(true)"});
    }

    @Test
    public void test_this_relatedNode_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    this.setEnabled(true);", "  }", "}");
        ExecuteOnParseTest.assertRelatedNodes((JavaInfo)panel, new String[]{"this.setEnabled(true)"});
    }

    @Test
    public void test_localMethodInvocation() throws Exception {
        this.parseContainer("class Test {", "  public static void main(String[] args) {", "    new Test();", "  }", "  public Test() {", "    JPanel panel = new JPanel();", "    JButton button = new JButton();", "    button.setText(getMyText('some text'));", "    panel.add(button);", "  }", "  public String getMyText(String s) {", "    return s;", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{new: javax.swing.JPanel} {local-unique: panel} {/new JPanel()/ /panel.add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /button.setText(getMyText('some text'))/ /panel.add(button)/}");
    }

    @Test
    public void test_isParsing() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ExecuteOnParseTest.assertFalse((boolean)GlobalState.isParsing());
    }

    @Test
    public void test_ignoreNullSuperClass() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/NoClass.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class NoClass extends JPanel {", "  // filler", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ExecuteOnParseTest.getFile("bin/test/NoClass.class").delete(true, null);
        try {
            this.parseContainer("// filler filler filler", "public class Test extends NoClass {", "  public Test() {", "  }", "}");
            ExecuteOnParseTest.fail();
        }
        catch (Throwable e) {
            DesignerException de = DesignerExceptionUtils.getDesignerException((Throwable)e);
            ExecuteOnParseTest.assertEquals((int)109, (int)de.getCode());
        }
    }

    @Test
    public void test_assignToThisField() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    this.button = new JButton();", "    add(button);", "  }", "}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ExecuteOnParseTest.assertNotNull((Object)panel.getObject());
        ExecuteOnParseTest.assertNotNull((Object)button.getObject());
    }

    @Test
    public void test_assignToThisField_applicationPattern() throws Exception {
        this.parseContainer("public class Test {", "  private JPanel panel;", "  private JButton button;", "  public static void main(String[] args) {", "    new Test();", "  }", "  public Test() {", "    this.panel = new JPanel();", "    ", "    this.button = new JButton();", "    this.panel.add(this.button);", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{new: javax.swing.JPanel} {field-unique: panel} {/new JPanel()/ /this.panel.add(this.button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {field-unique: button} {/new JButton()/ /this.panel.add(this.button)/}");
    }

    @Test
    public void test_useEmptyField() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private LayoutManager layout;", "  public Test() {", "    setLayout(layout);", "  }", "}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
        ExecuteOnParseTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(layout)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_useUnknownParameter_inConstructor() throws Exception {
        try {
            this.parseContainer("public class Test extends JPanel {", "  private String m_text;", "  public Test(String text) {", "    m_text = text;", "    add(new JButton(m_text));", "  }", "}");
            ExecuteOnParseTest.fail();
        }
        catch (Throwable e) {
            DesignerException designerCause = (DesignerException)DesignerExceptionUtils.getDesignerCause((Throwable)e);
            ExecuteOnParseTest.assertEquals((int)304, (int)designerCause.getCode());
            Assertions.assertThat((String)designerCause.getMessage()).contains(new CharSequence[]{"String text"});
        }
    }

    @Test
    public void test_useUnknownParameter_inLazy() throws Exception {
        try {
            this.parseContainer("public class Test extends JPanel {", "  private String m_text;", "  public Test(String text) {", "    m_text = text;", "    add(getButton());", "  }", "  private JButton button;", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton(m_text);", "    }", "    return button;", "  }", "}");
            ExecuteOnParseTest.fail();
        }
        catch (Throwable e) {
            DesignerException designerCause = (DesignerException)DesignerExceptionUtils.getDesignerCause((Throwable)e);
            ExecuteOnParseTest.assertEquals((int)304, (int)designerCause.getCode());
            Assertions.assertThat((String)designerCause.getMessage()).contains(new CharSequence[]{"String text"});
        }
    }

    @Test
    public void test_dontVisit_AnonymouseClassDeclaration() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    addKeyListener(new KeyAdapter() {", "      public void keyPressed(KeyEvent e) {", "        foo(e != null);", "      }", "    });", "  }", "  public void foo(boolean enabled) {", "    setEnabled(enabled);", "  }", "}");
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_createAssociateAndInvokeMethod() throws Exception {
        this.setJavaContentSrc("test", "MyButton", new String[]{"public class MyButton extends JButton {", "  public MyButton(Container container) {", "    container.add(this);", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"});
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    boolean enabled = new MyButton(this).isEnabled();", "  }", "}");
        ExecuteOnParseTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/new MyButton(this)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyButton} {empty} {/new MyButton(this).isEnabled()/}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_defaultParameterValues() throws Exception {
        ExecuteOnParseTest.assertSame(null, (Object)JavaInfoEvaluationHelper.getDefaultValue(null));
        this.check_defaultParameterValue("boolean", false);
        this.check_defaultParameterValue("byte", (byte)0);
        this.check_defaultParameterValue("char", Character.valueOf('\u0000'));
        this.check_defaultParameterValue("short", (short)0);
        this.check_defaultParameterValue("int", 0);
        this.check_defaultParameterValue("long", 0L);
        this.check_defaultParameterValue("float", Float.valueOf(0.0f));
        this.check_defaultParameterValue("double", 0.0);
        this.check_defaultParameterValue("String", "<dynamic>");
        Object defaultValue = this.getDefaultValue("java.util.ArrayList");
        ExecuteOnParseTest.assertInstanceOf(ArrayList.class, (Object)defaultValue);
        defaultValue = this.getDefaultValue("java.util.LinkedList");
        ExecuteOnParseTest.assertInstanceOf(LinkedList.class, (Object)defaultValue);
        defaultValue = this.getDefaultValue("java.util.Vector");
        ExecuteOnParseTest.assertInstanceOf(Vector.class, (Object)defaultValue);
        defaultValue = this.getDefaultValue("java.util.HashSet");
        ExecuteOnParseTest.assertInstanceOf(Set.class, (Object)defaultValue);
        defaultValue = this.getDefaultValue("java.util.HashMap");
        ExecuteOnParseTest.assertInstanceOf(Map.class, (Object)defaultValue);
        defaultValue = this.getDefaultValue("Object");
        ExecuteOnParseTest.assertNull((Object)defaultValue);
    }

    private void check_defaultParameterValue(String typeName, Object expectedValue) throws Exception {
        Object defaultValue = this.getDefaultValue(typeName);
        ExecuteOnParseTest.assertEquals((Object)expectedValue, (Object)defaultValue);
    }

    private Object getDefaultValue(String typeName) throws Exception {
        try {
            Object defaultValue;
            this.createTypeDeclaration("test", "Test.java", ExecuteOnParseTest.getSource("package test;", "public class Test {", "  public Test(" + typeName + " parameter) {", "  }", "}"));
            SingleVariableDeclaration parameter = (SingleVariableDeclaration)this.m_lastEditor.getEnclosingNode("parameter").getParent();
            ITypeBinding binding = AstNodeUtils.getTypeBinding((SingleVariableDeclaration)parameter);
            Object object = defaultValue = JavaInfoEvaluationHelper.getDefaultValue((ITypeBinding)binding);
            return object;
        }
        finally {
            if (this.m_lastModelUnit != null) {
                ExecuteOnParseTest.forceDeleteCompilationUnit(this.m_lastModelUnit);
            }
        }
    }

    @Test
    public void test_useUnknownParameter_nonStrictMode() throws Exception {
        ExecuteOnParseTest.useStrictEvaluationMode(false);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test(String text) {", "    add(new JButton(text));", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ExecuteOnParseTest.assertEquals((Object)"<dynamic>", (Object)((JButton)button.getObject()).getText());
    }

    @Test
    public void test_exceptionIn_SuperMethodInvocation() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public String getFoo() {", "    throw new IllegalStateException();", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setName(super.getFoo());", "  }", "}");
        EditorState.BadNodesCollection badParserNodes = this.m_lastState.getBadParserNodes();
        List badNodes = badParserNodes.nodes();
        Assertions.assertThat((List)badNodes).hasSize(1);
        ASTNode badNode = ((EditorState.BadNodeInformation)badNodes.get(0)).getNode();
        ExecuteOnParseTest.assertEquals((Object)"setName(super.getFoo());", (Object)this.m_lastEditor.getSource(badNode));
    }

    @Test
    public void test_unknownVectorParameter() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyList.java", this.getTestSource("public class MyList extends JList {", "  public MyList(java.util.Vector values) {", "    super(values);", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ExecuteOnParseTest.useStrictEvaluationMode(false);
        ContainerInfo panel = this.parseContainer("import java.util.Vector;", "public class Test extends JPanel {", "  public Test(Vector values) {", "    MyList list = new MyList(values);", "    add(list);", "  }", "}");
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_disconnectedModel() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private Object button;", "  public MyPanel(JButton button) {", "    this.button = button;", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    super(new JButton());", "  }", "}");
        this.refresh();
        Object button_1 = ReflectionUtils.getFieldObject((Object)panel.getObject(), (String)"button");
        ExecuteOnParseTest.assertNotNull((Object)button_1);
        this.refresh();
        Object button_2 = ReflectionUtils.getFieldObject((Object)panel.getObject(), (String)"button");
        ExecuteOnParseTest.assertNotNull((Object)button_2);
        ExecuteOnParseTest.assertNotSame((Object)button_1, (Object)button_2);
    }

    @Test
    public void test_disconnectedModel_useItsVariable() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JLabel object = new JLabel();", "    String text = object.toString();", "    setName(text);", "  }", "}");
        this.refresh();
        String name = panel.getComponent().getName();
        Assertions.assertThat((String)name).startsWith((CharSequence)"javax.swing.JLabel");
    }

    @Test
    public void test_returnFromMethod_validJavaInfo() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  Test() {", "    add(createInnerPanel());", "  }", "  private JPanel createInnerPanel() {", "    return new JPanel();", "  }", "}");
        ExecuteOnParseTest.assertEquals((int)1, (int)panel.getChildrenComponents().size());
        ExecuteOnParseTest.assert_creation((JavaInfo)panel);
    }

    @Test
    public void test_returnFromMethod_invalidObject() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyBadObject.java", ExecuteOnParseTest.getSource("package test;", "public class MyBadObject {", "  public MyBadObject() {", "    throw new IllegalStateException();", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  Test() {", "    foo();", "  }", "  private Object foo() {", "    return new MyBadObject();", "  }", "}");
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_isDesignTime_forComponent() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton() {", "    if (!java.beans.Beans.isDesignTime()) {", "      throw new IllegalStateException();", "    }", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
        ExecuteOnParseTest.assertEquals((int)1, (int)panel.getChildrenComponents().size());
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_isDesignTime_forRoot() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel() {", "    if (!java.beans.Beans.isDesignTime()) {", "      throw new IllegalStateException();", "    }", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
        panel.refresh();
        ExecuteOnParseTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_constructorParameters_real() throws Exception {
        this.prepare_constructorParameters();
        this.parseContainer("class Test extends SuperPanel {", "  public Test(int _int, boolean _true, boolean _false, String _string, Object _null) {", "    super(1, true, false, 'abc', null);", "  }", "}");
    }

    @Test
    public void test_constructorParameters_parameters() throws Exception {
        this.prepare_constructorParameters();
        this.parseContainer("class Test extends SuperPanel {", "  /**", "  * @wbp.eval.method.parameter _int 1", "  * @wbp.eval.method.parameter _true true", "  * @wbp.eval.method.parameter _false false", "  * @wbp.eval.method.parameter _string 'ab' + 'c'", "  * @wbp.eval.method.parameter _null null", "  */", "  public Test(int _int, boolean _true, boolean _false, String _string, Object _null) {", "    super(_int, _true, _false, _string, _null);", "  }", "}");
    }

    @Test
    public void test_constructorParameters_IThisMethodParameterEvaluator() throws Exception {
        this.prepare_ThisEvaluatorObject();
        this.parseContainer("class Test extends ThisEvaluatorObject {", "  public Test(JFrame parent, int style) {", "    super(parent, style);", "  }", "}");
        Expression styleExpression = (Expression)this.m_lastEditor.getEnclosingNode("style);");
        ExecuteOnParseTest.assertEquals((Object)555, (Object)JavaInfoEvaluationHelper.getValue((Expression)styleExpression));
    }

    @Test
    public void test_constructorParameters_IThisMethodParameterEvaluator_explicitValue() throws Exception {
        this.prepare_ThisEvaluatorObject();
        this.parseContainer("class Test extends ThisEvaluatorObject {", "  public Test(JFrame parent, int style) {", "    super(parent, 123);", "  }", "}");
        Expression styleExpression = (Expression)this.m_lastEditor.getEnclosingNode("123);");
        ExecuteOnParseTest.assertEquals((Object)123, (Object)JavaInfoEvaluationHelper.getValue((Expression)styleExpression));
    }

    private void prepare_constructorParameters() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/SuperPanel.java", ExecuteOnParseTest.getSourceDQ("package test;", "public class SuperPanel extends javax.swing.JPanel {", "  public SuperPanel(int _int, boolean _true, boolean _false, String _string, Object _null) {", "    if (_int != 1 || !_true || _false || !'abc'.equals(_string) || _null != null) {", "      throw new IllegalArgumentException();", "    }", "  }", "}"));
        ExecuteOnParseTest.waitForAutoBuild();
    }

    private void prepare_ThisEvaluatorObject() throws Exception {
        ExecuteOnParseTest.setFileContentSrc("test/ThisEvaluatorObject.java", this.getTestSource("public class ThisEvaluatorObject extends JPanel {", "  public ThisEvaluatorObject(JFrame parent, int style) {", "  }", "}"));
        ExecuteOnParseTest.setFileContentSrc("test/ThisEvaluatorObject.wbp-component.xml", ExecuteOnParseTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <model class='" + ThisEvaluatorJavaInfo.class.getName() + "'/>", "</component>"));
        ExecuteOnParseTest.waitForAutoBuild();
    }

    public static final class Test_HierarchyProvider
    extends JavaInfoUtils.HierarchyProvider {
        public Object[] getChildrenObjects(Object object) throws Exception {
            if (ReflectionUtils.isSuccessorOf(object.getClass(), (String)"test.MyPanel")) {
                Object internalPanel = ReflectionUtils.getFieldObject((Object)object, (String)"internalPanel");
                Object contentButton = ReflectionUtils.getFieldObject((Object)object, (String)"contentButton");
                Object[] children = contentButton != null ? new Object[]{internalPanel, contentButton} : new Object[]{internalPanel};
                return children;
            }
            return super.getChildrenObjects(object);
        }
    }

    public static class ThisEvaluatorJavaInfo
    extends ContainerInfo
    implements IThisMethodParameterEvaluator {
        public ThisEvaluatorJavaInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
            super(editor, description, creationSupport);
        }

        public Object evaluateParameter(EvaluationContext context, MethodDeclaration methodDeclaration, String methodSignature, SingleVariableDeclaration parameter, int index) throws Exception {
            if (index == 0) {
                return new JFrame();
            }
            if (index == 1) {
                return 555;
            }
            return AstEvaluationEngine.UNKNOWN;
        }
    }
}

