/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.bean;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.editor.palette.PaletteEventListener;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.ImplicitFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ConstructorDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.generation.statement.lazy.LazyStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.description.LazyVariableDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo;
import org.eclipse.wb.internal.swing.model.bean.ActionExpressionAccessor;
import org.eclipse.wb.internal.swing.model.bean.ActionInfo;
import org.eclipse.wb.internal.swing.model.bean.ActionInnerCreationSupport;
import org.eclipse.wb.internal.swing.model.bean.IActionSupport;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JToolBarInfo;
import org.eclipse.wb.internal.swing.palette.ActionUseEntryInfo;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.designer.swing.SwingTestUtils;
import org.junit.jupiter.api.Test;

public class ActionTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_noDesign_forActions() throws Exception {
        try {
            this.parseJavaInfo("public class Test extends AbstractAction {", "  public Test() {", "    putValue(NAME, 'My name');", "    putValue(SHORT_DESCRIPTION, 'My short description');", "  }", "  public void actionPerformed(ActionEvent e) {", "  }", "}");
            ActionTest.fail();
        }
        catch (DesignerException e) {
            ActionTest.assertEquals((int)1002, (int)e.getCode());
        }
    }

    @Test
    public void test_noActions() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionTest.assertEquals((int)0, (int)panel.getChildren(ActionContainerInfo.class).size());
        ActionTest.assertEquals((int)0, (int)ActionContainerInfo.getActions((JavaInfo)panel).size());
        ActionTest.assertEquals((int)0, (int)panel.getChildren(ActionContainerInfo.class).size());
    }

    private void createExternalAction() throws Exception {
        ActionTest.setFileContentSrc("test/ExternalAction.java", this.getTestSource("public class ExternalAction extends AbstractAction {", "  public ExternalAction() {", "    putValue(NAME, 'My name');", "    putValue(SHORT_DESCRIPTION, 'My short description');", "  }", "  public void actionPerformed(ActionEvent e) {", "  }", "}"));
        ActionTest.waitForAutoBuild();
    }

    @Test
    public void test_external_parse() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "    button.setAction(action);", "  }", "}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
        ActionContainerInfo container = ActionContainerInfo.get((JavaInfo)panel);
        ActionTest.assertNotNull((Object)container);
        ActionTest.assertFalse((boolean)container.canDelete());
        container.delete();
        ActionTest.assertEquals((Object)"(actions)", (Object)container.getPresentation().getText());
        ActionTest.assertNotNull((Object)container.getPresentation().getIcon());
        ActionTest.assertEquals((int)1, (int)container.getChildren().size());
        List actions = ActionContainerInfo.getActions((JavaInfo)panel);
        ActionTest.assertEquals((int)1, (int)actions.size());
        ActionInfo action = (ActionInfo)actions.get(0);
        ActionTest.assertNotNull((Object)action.getAssociation());
        Action actionObject = action.getAction();
        ActionTest.assertEquals((Object)"My name", (Object)actionObject.getValue("Name"));
        ActionTest.assertEquals((Object)"My short description", (Object)actionObject.getValue("ShortDescription"));
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JButton buttonObject = (JButton)button.getObject();
        ActionTest.assertSame((Object)action.getObject(), (Object)buttonObject.getAction());
        ActionTest.assertEquals((Object)"My name", (Object)buttonObject.getText());
    }

    @Test
    public void test_external_setProperty() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "      button.setAction(action);", "    }", "  }", "}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        action.getPropertyByTitle("enabled").setValue((Object)Boolean.FALSE);
        this.assertEditor("public class Test extends JPanel {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "    action.setEnabled(false);", "    {", "      JButton button = new JButton();", "      add(button);", "      button.setAction(action);", "    }", "  }", "}");
        ActionTest.assertNull((Object)action.getPropertyByTitle("name"));
    }

    @Test
    public void test_external_new_lazy() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
        ActionTest.assertTrue((boolean)ActionContainerInfo.getActions((JavaInfo)panel).isEmpty());
        ActionInfo newAction = (ActionInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.ExternalAction"), (CreationSupport)new ConstructorCreationSupport());
        SwingTestUtils.setGenerations(LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE);
        ActionContainerInfo.add((JavaInfo)panel, (ActionInfo)newAction);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private ExternalAction externalAction;", "  public Test() {", "  }", "  private ExternalAction getExternalAction() {", "    if (externalAction == null) {", "      externalAction = new ExternalAction();", "    }", "    return externalAction;", "  }", "}");
        Assertions.assertThat((List)ActionContainerInfo.getActions((JavaInfo)panel)).containsOnly((Object[])new ActionInfo[]{newAction});
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_external_new() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
        ActionTest.assertTrue((boolean)ActionContainerInfo.getActions((JavaInfo)panel).isEmpty());
        ActionInfo newAction = (ActionInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.ExternalAction"), (CreationSupport)new ConstructorCreationSupport());
        ActionContainerInfo.add((JavaInfo)panel, (ActionInfo)newAction);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private final ExternalAction externalAction = new ExternalAction();", "  public Test() {", "  }", "}");
        Assertions.assertThat((List)ActionContainerInfo.getActions((JavaInfo)panel)).containsOnly((Object[])new ActionInfo[]{newAction});
    }

    @Test
    public void test_external_addOnJToolBar() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ActionInfo newAction = (ActionInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.ExternalAction"), (CreationSupport)new ConstructorCreationSupport());
        ComponentInfo newButton = bar.command_CREATE(newAction, null);
        this.assertEditor("class Test extends JPanel {", "  private final ExternalAction externalAction = new ExternalAction();", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    {", "      JButton button = bar.add(externalAction);", "    }", "  }", "}");
        ImplicitFactoryCreationSupport creationSupport = (ImplicitFactoryCreationSupport)newButton.getCreationSupport();
        ActionTest.assertEquals((Object)"bar.add(externalAction)", (Object)this.m_lastEditor.getSource(creationSupport.getNode()));
    }

    @Test
    public void test_external_setOnJButton() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ActionInfo newAction = (ActionInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.ExternalAction"), (CreationSupport)new ConstructorCreationSupport());
        ActionInfo.setAction((ComponentInfo)button, (ActionInfo)newAction);
        this.assertEditor("class Test extends JPanel {", "  private final ExternalAction externalAction = new ExternalAction();", "  Test() {", "    JButton button = new JButton();", "    button.setAction(externalAction);", "    add(button);", "  }", "}");
    }

    @Test
    public void test_notAttached_lazy() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private ExternalAction externalAction;", "  public Test() {", "  }", "  private ExternalAction getExternalAction() {", "    if (externalAction == null) {", "      externalAction = new ExternalAction();", "    }", "    return externalAction;", "  }", "}");
        ActionTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {new: test.ExternalAction} {lazy: externalAction getExternalAction()} {/new ExternalAction()/ /externalAction/}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_attached_lazy() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private ExternalAction externalAction;", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "    button.setAction(getExternalAction());", "  }", "  private ExternalAction getExternalAction() {", "    if (externalAction == null) {", "      externalAction = new ExternalAction();", "    }", "    return externalAction;", "  }", "}");
        ActionTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/ /button.setAction(getExternalAction())/}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {new: test.ExternalAction} {lazy: externalAction getExternalAction()} {/new ExternalAction()/ /externalAction/ /button.setAction(getExternalAction())/}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
        ((ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0)).delete();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ActionTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}");
    }

    @Test
    public void test_notAttached_fieldInitializer() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "  }", "}");
        ActionTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {new: test.ExternalAction} {field-initializer: action} {/new ExternalAction()/}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_contributeToPalette() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
        CategoryInfo category = new CategoryInfo();
        category.setId("org.eclipse.wb.internal.swing.actions");
        ArrayList entries = new ArrayList();
        PaletteEventListener listener = (PaletteEventListener)panel.getBroadcast(PaletteEventListener.class);
        listener.entries(category, entries);
        ActionTest.assertEquals((int)1, (int)entries.size());
        ActionTest.assertInstanceOf(ActionUseEntryInfo.class, entries.get(0));
    }

    @Test
    public void test_setAction() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private ExternalAction action_1 = new ExternalAction();", "  private ExternalAction action_2 = new ExternalAction();", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ActionInfo action_1 = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        ActionInfo action_2 = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(1);
        ActionInfo.setAction((ComponentInfo)button, (ActionInfo)action_1);
        this.assertEditor("public class Test extends JPanel {", "  private ExternalAction action_1 = new ExternalAction();", "  private ExternalAction action_2 = new ExternalAction();", "  public Test() {", "    {", "      JButton button = new JButton();", "      button.setAction(action_1);", "      add(button);", "    }", "  }", "}");
        ActionInfo.setAction((ComponentInfo)button, (ActionInfo)action_2);
        this.assertEditor("public class Test extends JPanel {", "  private ExternalAction action_1 = new ExternalAction();", "  private ExternalAction action_2 = new ExternalAction();", "  public Test() {", "    {", "      JButton button = new JButton();", "      button.setAction(action_2);", "      add(button);", "    }", "  }", "}");
        ActionInfo.setAction((ComponentInfo)button, null);
        this.assertEditor("public class Test extends JPanel {", "  private ExternalAction action_1 = new ExternalAction();", "  private ExternalAction action_2 = new ExternalAction();", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_factory() throws Exception {
        this.prepare_ActionFactory();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private AbstractAction action = ActionFactory.createAction();", "  public Test() {", "  }", "}");
        ActionTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {static factory: test.ActionFactory createAction()} {field-initializer: action} {/ActionFactory.createAction()/}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
    }

    private void prepare_ActionFactory() throws Exception {
        ActionTest.setFileContentSrc("test/ActionFactory.java", this.getTestSource("public class ActionFactory {", "  public static AbstractAction createAction() {", "    return new AbstractAction() {", "      public void actionPerformed(ActionEvent e) {", "      }", "    };", "  }", "}"));
        ActionTest.waitForAutoBuild();
    }

    @Test
    public void test_inner_parse() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      putValue(NAME, 'My name');", "      putValue(SHORT_DESCRIPTION, 'My short description');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
        ActionTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {innerAction} {field-initializer: action_1} {/new Action_1()/}");
        ActionContainerInfo container = ActionContainerInfo.get((JavaInfo)panel);
        ActionTest.assertNotNull((Object)container);
        ActionTest.assertFalse((boolean)container.canDelete());
        container.delete();
        ActionTest.assertEquals((Object)"(actions)", (Object)container.getPresentation().getText());
        ActionTest.assertNotNull((Object)container.getPresentation().getIcon());
        ActionTest.assertEquals((int)1, (int)container.getChildren().size());
        List actions = ActionContainerInfo.getActions((JavaInfo)panel);
        ActionTest.assertEquals((int)1, (int)actions.size());
        ActionInfo actionInfo = (ActionInfo)actions.get(0);
        Action action = actionInfo.getAction();
        ActionTest.assertEquals((Object)"My name", (Object)action.getValue("Name"));
        ActionTest.assertEquals((Object)"My short description", (Object)action.getValue("ShortDescription"));
        ActionInnerCreationSupport creationSupport = (ActionInnerCreationSupport)actionInfo.getCreationSupport();
        ActionTest.assertEquals((Object)"new Action_1()", (Object)this.m_lastEditor.getSource(creationSupport.getNode()));
        ActionTest.assertFalse((boolean)creationSupport.canReorder());
        ActionTest.assertFalse((boolean)creationSupport.canReparent());
    }

    @Test
    public void test_inner_parse2() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      putValue('Name', 'My name');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
        ActionInfo actionInfo = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        Action action = actionInfo.getAction();
        ActionTest.assertEquals((Object)"My name", (Object)action.getValue("Name"));
    }

    @Test
    public void test_inner_parse3() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      putValue(Action.NAME, 'My name');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
        ActionInfo actionInfo = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        Action action = actionInfo.getAction();
        ActionTest.assertEquals((Object)"My name", (Object)action.getValue("Name"));
        Property nameProperty = actionInfo.getPropertyByTitle("name");
        ActionTest.assertTrue((boolean)nameProperty.isModified());
        ActionTest.assertEquals((Object)"My name", (Object)nameProperty.getValue());
    }

    @Test
    public void test_inner_parse_noConstructor() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
        ActionInfo action = (ActionInfo)ActionTest.getJavaInfoByName("action_1");
        ActionTest.assertNull((Object)action.getPropertyByTitle("name"));
    }

    @Test
    public void test_inner_new() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
        ActionTest.assertTrue((boolean)ActionContainerInfo.getActions((JavaInfo)panel).isEmpty());
        ActionInfo newAction = ActionInfo.createInner((AstEditor)this.m_lastEditor);
        ActionContainerInfo.add((JavaInfo)panel, (ActionInfo)newAction);
        panel.refresh();
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private final Action action = new SwingAction();", "  public Test() {", "  }", "  private class SwingAction extends AbstractAction {", "    public SwingAction() {", "      putValue(NAME, 'SwingAction');", "      putValue(SHORT_DESCRIPTION, 'Some short description');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "}");
        Assertions.assertThat((List)ActionContainerInfo.getActions((JavaInfo)panel)).containsOnly((Object[])new ActionInfo[]{newAction});
        TypeDeclaration mainType = AstNodeUtils.getEnclosingType((ASTNode)panel.getCreationSupport().getNode());
        TypeDeclaration actionType = mainType.getTypes()[0];
        MethodDeclaration constructor = actionType.getMethods()[0];
        ActionExpressionAccessor accessor = new ActionExpressionAccessor((IActionSupport)new LazyActionSupport(constructor), "NAME");
        accessor.setExpression((JavaInfo)panel, "{wbp_classTop}.getName()");
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private final Action action = new SwingAction();", "  public Test() {", "  }", "  private class SwingAction extends AbstractAction {", "    public SwingAction() {", "      putValue(NAME, Test.class.getName());", "      putValue(SHORT_DESCRIPTION, 'Some short description');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "}");
    }

    @Test
    public void test_inner_new2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final Action action = new SwingAction();", "  public Test() {", "  }", "  private class SwingAction extends AbstractAction {", "    public SwingAction() {", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
        ActionInfo newAction = ActionInfo.createInner((AstEditor)this.m_lastEditor);
        ActionContainerInfo.add((JavaInfo)panel, (ActionInfo)newAction);
        this.assertEditor("public class Test extends JPanel {", "  private final Action action = new SwingAction();", "  private final Action action_1 = new SwingAction_1();", "  public Test() {", "  }", "  private class SwingAction extends AbstractAction {", "    public SwingAction() {", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private class SwingAction_1 extends AbstractAction {", "    public SwingAction_1() {", "      putValue(NAME, 'SwingAction_1');", "      putValue(SHORT_DESCRIPTION, 'Some short description');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "}");
    }

    @Test
    public void test_inner_delete() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        ActionTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {innerAction} {field-initializer: action_1} {/new Action_1()/}");
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        ActionTest.assertTrue((boolean)action.canDelete());
        action.delete();
        String[] lines = new String[]{"public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  public Test() {", "  }", "}"};
        this.assertEditor(lines);
        ActionTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}");
    }

    @Test
    public void test_inner_ActionExpressionAccessor_1() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      putValue(NAME, 'My name');", "      putValue('ShortDescription', 'My short description');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        TypeDeclaration mainType = AstNodeUtils.getEnclosingType((ASTNode)panel.getCreationSupport().getNode());
        TypeDeclaration actionType = mainType.getTypes()[0];
        MethodDeclaration constructor = actionType.getMethods()[0];
        ActionExpressionAccessor accessor = new ActionExpressionAccessor((IActionSupport)new LazyActionSupport(constructor), "NAME");
        ActionTest.assertEquals((Object)"\"My name\"", (Object)this.m_lastEditor.getSource((ASTNode)accessor.getExpression((JavaInfo)action)));
        accessor = new ActionExpressionAccessor((IActionSupport)new LazyActionSupport(constructor), "SHORT_DESCRIPTION");
        ActionTest.assertEquals((Object)"\"My short description\"", (Object)this.m_lastEditor.getSource((ASTNode)accessor.getExpression((JavaInfo)action)));
        accessor = new ActionExpressionAccessor((IActionSupport)new LazyActionSupport(constructor), "LONG_DESCRIPTION");
        ActionTest.assertNull((Object)accessor.getExpression((JavaInfo)action));
        accessor = new ActionExpressionAccessor((IActionSupport)new LazyActionSupport(constructor), "NAME");
        accessor.setExpression((JavaInfo)action, "\"New name\"");
        this.assertEditor("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      putValue(NAME, 'New name');", "      putValue('ShortDescription', 'My short description');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        accessor = new ActionExpressionAccessor((IActionSupport)new LazyActionSupport(constructor), "NAME");
        accessor.setExpression((JavaInfo)action, null);
        this.assertEditor("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      putValue('ShortDescription', 'My short description');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        accessor = new ActionExpressionAccessor((IActionSupport)new LazyActionSupport(constructor), "SMALL_ICON");
        accessor.setExpression((JavaInfo)action, "null");
        this.assertEditor("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      putValue(SMALL_ICON, null);", "      putValue('ShortDescription', 'My short description');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_inner_ActionExpressionAccessor_2() throws Exception {
        this.m_waitForAutoBuild = true;
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      super('My name');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        Action actionObject = action.getAction();
        ActionTest.assertEquals((Object)"My name", (Object)actionObject.getValue("Name"));
        TypeDeclaration mainType = AstNodeUtils.getEnclosingType((ASTNode)panel.getCreationSupport().getNode());
        TypeDeclaration actionType = mainType.getTypes()[0];
        MethodDeclaration constructor = actionType.getMethods()[0];
        ActionExpressionAccessor accessor = new ActionExpressionAccessor((IActionSupport)new LazyActionSupport(constructor){

            @Override
            public ConstructorDescription getConstructorDescription() {
                ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)panel.getEditor(), AbstractAction.class);
                return description.getConstructor("<init>(java.lang.String)");
            }
        }, "NAME");
        ActionTest.assertEquals((Object)"\"My name\"", (Object)this.m_lastEditor.getSource((ASTNode)accessor.getExpression((JavaInfo)action)));
        accessor = new ActionExpressionAccessor((IActionSupport)new LazyActionSupport(constructor){

            @Override
            public ConstructorDescription getConstructorDescription() {
                ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)panel.getEditor(), AbstractAction.class);
                return description.getConstructor("<init>(java.lang.String)");
            }
        }, "NAME");
        accessor.setExpression((JavaInfo)action, "\"New name\"");
        this.assertEditor("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      super('New name');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        accessor = new ActionExpressionAccessor((IActionSupport)new LazyActionSupport(constructor), "NAME");
        accessor.setExpression((JavaInfo)action, null);
        this.assertEditor("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      super('New name');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        accessor = new ActionExpressionAccessor((IActionSupport)new LazyActionSupport(constructor), "SMALL_ICON");
        accessor.setExpression((JavaInfo)action, "null");
        this.assertEditor("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      super('New name');", "      putValue(SMALL_ICON, null);", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_inner_properties_putValue() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      putValue(NAME, 'My name');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        Property nameProperty = action.getPropertyByTitle("name");
        ActionTest.assertEquals((Object)"My name", (Object)nameProperty.getValue());
        nameProperty.setValue((Object)"New name");
        this.assertEditor("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      putValue(NAME, 'New name');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_inner_properties_putValue_inInitializer() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    {", "      putValue(NAME, 'My name');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        Action actionObject = action.getAction();
        ActionTest.assertEquals((Object)"My name", (Object)actionObject.getValue("Name"));
        Property nameProperty = action.getPropertyByTitle("name");
        ActionTest.assertEquals((Object)"My name", (Object)nameProperty.getValue());
        nameProperty.setValue((Object)"New name");
        this.assertEditor("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    {", "      putValue(NAME, 'New name');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        ActionTest.assertNotNull((Object)action.getPropertyByTitle("small icon"));
    }

    @Test
    public void test_inner_properties_superConstructor() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      super('My name');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        Property nameProperty = action.getPropertyByTitle("name");
        ActionTest.assertEquals((Object)"My name", (Object)nameProperty.getValue());
        String oldSource = this.m_lastEditor.getSource();
        nameProperty.setValue((Object)"My name");
        ActionTest.assertEquals((Object)oldSource, (Object)this.m_lastEditor.getSource());
        nameProperty.setValue((Object)"New name");
        this.assertEditor("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      super('New name');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        nameProperty.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("public class Test extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      super(null);", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_inner_inGeneric() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public class Test<T> extends JPanel {", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      putValue(NAME, 'My name');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private Action_1 action_1 = new Action_1();", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
        List actions = ActionContainerInfo.getActions((JavaInfo)panel);
        ActionTest.assertEquals((int)1, (int)actions.size());
        ActionInfo actionInfo = (ActionInfo)actions.get(0);
        Action action = actionInfo.getAction();
        ActionTest.assertEquals((Object)"My name", (Object)action.getValue("Name"));
    }

    @Test
    public void test_external() throws Exception {
        ActionTest.setFileContentSrc("test/ExternalActions.java", ActionTest.getSourceDQ("package test;", "import java.awt.event.*;", "import javax.swing.*;", "public class ExternalActions {", "  public static class MyAction extends AbstractAction {", "    public MyAction() {", "      super('My name');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "}"));
        ActionTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  private Action action = new ExternalActions.MyAction();", "  public Test() {", "  }", "}");
        ActionTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {new: javax.swing.AbstractAction} {field-initializer: action} {/new ExternalActions.MyAction()/}");
    }

    @Test
    public void test_anonymous_parse() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  private AbstractAction m_action = new AbstractAction('Text') {", "    public void actionPerformed(ActionEvent e) {", "    }", "  };", "  public Test() {", "  }", "}");
        ActionTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {anonymousAction} {field-initializer: m_action} {/new AbstractAction('Text')/}");
    }

    @Test
    public void test_anonymous_properties_inInitializer() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private AbstractAction action = new AbstractAction() {", "    {", "      putValue(NAME, 'My name');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  };", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        Property nameProperty = action.getPropertyByTitle("name");
        ActionTest.assertEquals((Object)"My name", (Object)nameProperty.getValue());
        nameProperty.setValue((Object)"New name");
        action.getPropertyByTitle("short description").setValue((Object)"Test description");
        this.assertEditor("public class Test extends JPanel {", "  private AbstractAction action = new AbstractAction() {", "    {", "      putValue(SHORT_DESCRIPTION, 'Test description');", "      putValue(NAME, 'New name');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  };", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_anonymous_properties_inConstructorArgument() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private AbstractAction action = new AbstractAction('My name') {", "    public void actionPerformed(ActionEvent e) {", "    }", "  };", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        Property nameProperty = action.getPropertyByTitle("name");
        ActionTest.assertEquals((Object)"My name", (Object)nameProperty.getValue());
        nameProperty.setValue((Object)"New name");
        this.assertEditor("public class Test extends JPanel {", "  private AbstractAction action = new AbstractAction('New name') {", "    public void actionPerformed(ActionEvent e) {", "    }", "  };", "  public Test() {", "  }", "}");
        ActionTest.assertNull((Object)action.getPropertyByTitle("small icon"));
    }

    @Test
    public void test_presentation() throws Exception {
        this.m_waitForAutoBuild = true;
        ActionTest.setFileContentSrc("Test.png", TestUtils.createImagePNG(1, 1));
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private Action action_1 = new Action_1();", "  private Action action_2 = new Action_2();", "  private class Action_1 extends AbstractAction {", "    public Action_1() {", "      putValue(SMALL_ICON, new ImageIcon(Test.class.getResource('/Test.png')));", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  private class Action_2 extends AbstractAction {", "    public Action_2() {", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "  public Test() {", "  }", "}");
        panel.refresh();
        ActionTest.assertNoErrors((JavaInfo)panel);
        ActionInfo action_1 = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        ActionInfo action_2 = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(1);
        ImageDescriptor icon_1 = action_1.getPresentation().getIcon();
        ImageDescriptor icon_2 = action_2.getPresentation().getIcon();
        ActionTest.assertNotSame((Object)action_1.getDescription().getIcon(), (Object)icon_1);
        ActionTest.assertSame((Object)action_2.getDescription().getIcon(), (Object)icon_2);
    }

    @Test
    public void test_contextMenu_notButton() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        MenuManager designerMenu = ActionTest.getDesignerMenuManager();
        panel.getBroadcastObject().addContextMenu(List.of(panel), (ObjectInfo)panel, (IMenuManager)designerMenu);
        IMenuManager actionsMenu = ActionTest.findChildMenuManager((IContributionManager)designerMenu, "Set Action");
        ActionTest.assertNull((Object)actionsMenu);
    }

    @Test
    public void test_contextMenu_setAction_single() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private ExternalAction m_action = new ExternalAction();", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MenuManager designerMenu = ActionTest.getDesignerMenuManager();
        panel.getBroadcastObject().addContextMenu(List.of(button), (ObjectInfo)button, (IMenuManager)designerMenu);
        IMenuManager actionsMenu = ActionTest.findChildMenuManager((IContributionManager)designerMenu, "Set Action");
        IAction runnable = ActionTest.findChildAction((IContributionManager)actionsMenu, "m_action");
        ActionTest.assertNotNull((Object)runnable);
        runnable.setChecked(true);
        runnable.run();
        this.assertEditor("public class Test extends JPanel {", "  private ExternalAction m_action = new ExternalAction();", "  public Test() {", "    {", "      JButton button = new JButton();", "      button.setAction(m_action);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_contextMenu_setAction_multiple() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private ExternalAction m_action = new ExternalAction();", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        MenuManager designerMenu = ActionTest.getDesignerMenuManager();
        panel.getBroadcastObject().addContextMenu(List.of(button_1, button_2), (ObjectInfo)button_2, (IMenuManager)designerMenu);
        IMenuManager actionsMenu = ActionTest.findChildMenuManager((IContributionManager)designerMenu, "Set Action");
        IAction runnable = ActionTest.findChildAction((IContributionManager)actionsMenu, "m_action");
        String expectedSource = this.m_lastEditor.getSource();
        runnable.setChecked(true);
        runnable.run();
        ActionTest.assertEditor(expectedSource, this.m_lastEditor);
        MenuManager designerMenu2 = ActionTest.getDesignerMenuManager();
        panel.getBroadcastObject().addContextMenu(List.of(button_1, button_2), (ObjectInfo)button_1, (IMenuManager)designerMenu2);
        IMenuManager actionsMenu2 = ActionTest.findChildMenuManager((IContributionManager)designerMenu2, "Set Action");
        IAction runnable2 = ActionTest.findChildAction((IContributionManager)actionsMenu2, "m_action");
        ActionTest.assertNotNull((Object)runnable2);
        runnable2.setChecked(true);
        runnable2.run();
        this.assertEditor("public class Test extends JPanel {", "  private ExternalAction m_action = new ExternalAction();", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      button_1.setAction(m_action);", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      button_2.setAction(m_action);", "      add(button_2);", "    }", "  }", "}");
    }

    @Test
    public void test_contextMenu_noAction() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private ExternalAction m_action = new ExternalAction();", "  public Test() {", "    {", "      JButton button = new JButton();", "      button.setAction(m_action);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MenuManager designerMenu = ActionTest.getDesignerMenuManager();
        panel.getBroadcastObject().addContextMenu(List.of(button), (ObjectInfo)button, (IMenuManager)designerMenu);
        IMenuManager actionsMenu = ActionTest.findChildMenuManager((IContributionManager)designerMenu, "Set Action");
        IAction runnable = ActionTest.findChildAction((IContributionManager)actionsMenu, "None");
        runnable.run();
        this.assertEditor("public class Test extends JPanel {", "  private ExternalAction m_action = new ExternalAction();", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_contextMenu_newGroup() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MenuManager designerMenu = ActionTest.getDesignerMenuManager();
        panel.getBroadcastObject().addContextMenu(List.of(button), (ObjectInfo)button, (IMenuManager)designerMenu);
        IMenuManager actionsMenu = ActionTest.findChildMenuManager((IContributionManager)designerMenu, "Set Action");
        IAction runnable = ActionTest.findChildAction((IContributionManager)actionsMenu, "New...");
        ActionTest.assertNotNull((Object)runnable);
        runnable.run();
        this.assertEditor("public class Test extends JPanel {", "  private final Action action = new SwingAction();", "  public Test() {", "    {", "      JButton button = new JButton();", "      button.setAction(action);", "      add(button);", "    }", "  }", "  private class SwingAction extends AbstractAction {", "    public SwingAction() {", "      putValue(NAME, 'SwingAction');", "      putValue(SHORT_DESCRIPTION, 'Some short description');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "}");
    }

    private static class LazyActionSupport
    implements IActionSupport {
        MethodDeclaration m_constructor;

        LazyActionSupport(MethodDeclaration constructor) {
            this.m_constructor = constructor;
        }

        public ASTNode getCreation() {
            return null;
        }

        public List<Block> getInitializationBlocks() {
            return Lists.newArrayList((Object[])new Block[]{this.m_constructor.getBody()});
        }

        public ConstructorDescription getConstructorDescription() {
            return null;
        }
    }
}

