/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.util.StackContainerSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class StackContainerSupportTest
extends SwingModelTest {
    @Override
    protected void configureNewProject() throws Exception {
        super.configureNewProject();
        this.prepareCardPanel();
        StackContainerSupportTest.forgetCreatedResources();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_noChildren() throws Exception {
        CardPanel_Info panel = (CardPanel_Info)((Object)this.parseJavaInfo("// filler filler filler filler filler", "public class Test extends CardPanel {", "  public Test() {", "  }", "}"));
        panel.refresh();
        StackContainerSupportTest.assertSame(null, (Object)panel.m_activeComponent);
    }

    @Test
    public void test_notifySelecting_null() throws Exception {
        CardPanel_Info panel = (CardPanel_Info)((Object)this.parseJavaInfo("// filler filler filler filler filler", "public class Test extends CardPanel {", "  public Test() {", "  }", "}"));
        panel.refresh();
        boolean[] refresh = new boolean[1];
        panel.getBroadcastObject().selecting(null, refresh);
    }

    @Test
    public void test_setActiveInfo() throws Exception {
        CardPanel_Info panel = (CardPanel_Info)((Object)this.parseJavaInfo("public class Test extends CardPanel {", "  public Test() {", "    add(new JButton());", "    add(new JButton());", "  }", "}"));
        panel.refresh();
        List components = panel.getChildrenComponents();
        ComponentInfo button_0 = (ComponentInfo)components.get(0);
        ComponentInfo button_1 = (ComponentInfo)components.get(1);
        StackContainerSupportTest.assertSame((Object)button_0, (Object)panel.m_activeComponent);
        panel.m_stackContainer.setActive((ObjectInfo)button_1);
        StackContainerSupportTest.assertSame((Object)button_1, (Object)panel.m_activeComponent);
        panel.m_stackContainer.setActive((ObjectInfo)button_0);
        StackContainerSupportTest.assertSame((Object)button_0, (Object)panel.m_activeComponent);
    }

    @Test
    public void test_getNext() throws Exception {
        CardPanel_Info panel = (CardPanel_Info)((Object)this.parseJavaInfo("public class Test extends CardPanel {", "  public Test() {", "    add(new JButton('A'));", "    add(new JButton('B'));", "    add(new JButton('C'));", "  }", "}"));
        panel.refresh();
        List components = panel.getChildrenComponents();
        ComponentInfo button_0 = (ComponentInfo)components.get(0);
        ComponentInfo button_1 = (ComponentInfo)components.get(1);
        ComponentInfo button_2 = (ComponentInfo)components.get(2);
        StackContainerSupportTest.assertSame((Object)button_0, (Object)panel.m_activeComponent);
        StackContainerSupportTest.assertSame((Object)button_1, (Object)panel.m_stackContainer.getNext());
        panel.m_stackContainer.setActive((ObjectInfo)button_1);
        StackContainerSupportTest.assertSame((Object)button_1, (Object)panel.m_activeComponent);
        StackContainerSupportTest.assertSame((Object)button_2, (Object)panel.m_stackContainer.getNext());
        panel.m_stackContainer.setActive((ObjectInfo)button_2);
        StackContainerSupportTest.assertSame((Object)button_2, (Object)panel.m_activeComponent);
        StackContainerSupportTest.assertSame((Object)button_0, (Object)panel.m_stackContainer.getNext());
        panel.m_stackContainer.setActive((ObjectInfo)button_0);
        StackContainerSupportTest.assertSame((Object)button_0, (Object)panel.m_activeComponent);
    }

    @Test
    public void test_getPrev() throws Exception {
        CardPanel_Info panel = (CardPanel_Info)((Object)this.parseJavaInfo("public class Test extends CardPanel {", "  public Test() {", "    add(new JButton('A'));", "    add(new JButton('B'));", "    add(new JButton('C'));", "  }", "}"));
        panel.refresh();
        List components = panel.getChildrenComponents();
        ComponentInfo button_0 = (ComponentInfo)components.get(0);
        ComponentInfo button_1 = (ComponentInfo)components.get(1);
        ComponentInfo button_2 = (ComponentInfo)components.get(2);
        StackContainerSupportTest.assertSame((Object)button_0, (Object)panel.m_activeComponent);
        StackContainerSupportTest.assertSame((Object)button_2, (Object)panel.m_stackContainer.getPrev());
        panel.m_stackContainer.setActive((ObjectInfo)button_2);
        StackContainerSupportTest.assertSame((Object)button_2, (Object)panel.m_activeComponent);
        StackContainerSupportTest.assertSame((Object)button_1, (Object)panel.m_stackContainer.getPrev());
        panel.m_stackContainer.setActive((ObjectInfo)button_1);
        StackContainerSupportTest.assertSame((Object)button_1, (Object)panel.m_activeComponent);
        StackContainerSupportTest.assertSame((Object)button_0, (Object)panel.m_stackContainer.getPrev());
        panel.m_stackContainer.setActive((ObjectInfo)button_0);
        StackContainerSupportTest.assertSame((Object)button_0, (Object)panel.m_activeComponent);
    }

    @Test
    public void test_notifySelecting_directChild() throws Exception {
        CardPanel_Info panel = (CardPanel_Info)((Object)this.parseJavaInfo("public class Test extends CardPanel {", "  public Test() {", "    add(new JButton());", "    add(new JButton());", "  }", "}"));
        panel.refresh();
        List components = panel.getChildrenComponents();
        ComponentInfo button_0 = (ComponentInfo)components.get(0);
        ComponentInfo button_1 = (ComponentInfo)components.get(1);
        StackContainerSupportTest.assertSame((Object)button_0, (Object)panel.m_activeComponent);
        boolean shouldRefresh = StackContainerSupportTest.notifySelecting((ObjectInfo)button_1);
        StackContainerSupportTest.assertTrue((boolean)shouldRefresh);
        panel.refresh();
        StackContainerSupportTest.assertSame((Object)button_1, (Object)panel.m_activeComponent);
        shouldRefresh = StackContainerSupportTest.notifySelecting((ObjectInfo)button_1);
        StackContainerSupportTest.assertFalse((boolean)shouldRefresh);
        StackContainerSupportTest.assertSame((Object)button_1, (Object)panel.m_activeComponent);
    }

    @Test
    public void test_notifySelecting_indirectChild() throws Exception {
        CardPanel_Info panel = (CardPanel_Info)((Object)this.parseJavaInfo("public class Test extends CardPanel {", "  public Test() {", "    add(new JButton());", "    {", "      JPanel inner = new JPanel();", "      add(inner);", "      inner.add(new JButton());", "    }", "  }", "}"));
        panel.refresh();
        List components = panel.getChildrenComponents();
        ComponentInfo button_0 = (ComponentInfo)components.get(0);
        ContainerInfo inner = (ContainerInfo)components.get(1);
        ComponentInfo innerButton = (ComponentInfo)inner.getChildrenComponents().get(0);
        StackContainerSupportTest.assertSame((Object)button_0, (Object)panel.m_activeComponent);
        boolean shouldRefresh = StackContainerSupportTest.notifySelecting((ObjectInfo)innerButton);
        StackContainerSupportTest.assertTrue((boolean)shouldRefresh);
        panel.refresh();
        StackContainerSupportTest.assertSame((Object)inner, (Object)panel.m_activeComponent);
        shouldRefresh = StackContainerSupportTest.notifySelecting((ObjectInfo)innerButton);
        StackContainerSupportTest.assertFalse((boolean)shouldRefresh);
        StackContainerSupportTest.assertSame((Object)inner, (Object)panel.m_activeComponent);
    }

    @Test
    public void test_notifySelecting_notStackChild() throws Exception {
        CardPanel_Info panel = (CardPanel_Info)((Object)this.parseJavaInfo("public class Test extends CardPanel {", "  public Test() {", "    add(new JTextField('not stack child'));", "    add(new JButton('1'));", "    add(new JButton('2'));", "  }", "}"));
        panel.refresh();
        List components = panel.getChildrenComponents();
        ComponentInfo textField = (ComponentInfo)components.get(0);
        ComponentInfo button_1 = (ComponentInfo)components.get(1);
        ComponentInfo button_2 = (ComponentInfo)components.get(2);
        StackContainerSupportTest.assertSame((Object)button_1, (Object)panel.m_activeComponent);
        boolean shouldRefresh = StackContainerSupportTest.notifySelecting((ObjectInfo)button_2);
        StackContainerSupportTest.assertTrue((boolean)shouldRefresh);
        panel.refresh();
        StackContainerSupportTest.assertSame((Object)button_2, (Object)panel.m_activeComponent);
        shouldRefresh = StackContainerSupportTest.notifySelecting((ObjectInfo)textField);
        StackContainerSupportTest.assertFalse((boolean)shouldRefresh);
        StackContainerSupportTest.assertSame((Object)button_2, (Object)panel.m_activeComponent);
    }

    @Test
    public void test_deleteNotActive() throws Exception {
        CardPanel_Info panel = (CardPanel_Info)((Object)this.parseJavaInfo("public class Test extends CardPanel {", "  public Test() {", "    add(new JButton());", "    add(new JButton());", "    add(new JButton());", "  }", "}"));
        panel.refresh();
        List components = panel.getChildrenComponents();
        ComponentInfo button_1 = (ComponentInfo)components.get(1);
        ComponentInfo button_2 = (ComponentInfo)components.get(2);
        StackContainerSupportTest.notifySelecting((ObjectInfo)button_1);
        panel.refresh();
        StackContainerSupportTest.assertSame((Object)button_1, (Object)panel.m_activeComponent);
        button_2.delete();
        StackContainerSupportTest.assertSame((Object)button_1, (Object)panel.m_activeComponent);
    }

    @Test
    public void test_deleteActive_selectFirst() throws Exception {
        CardPanel_Info panel = (CardPanel_Info)((Object)this.parseJavaInfo("public class Test extends CardPanel {", "  public Test() {", "    add(new JButton());", "    add(new JButton());", "    add(new JButton());", "  }", "}"));
        panel.refresh();
        List components = panel.getChildrenComponents();
        ComponentInfo button_0 = (ComponentInfo)components.get(0);
        ComponentInfo button_1 = (ComponentInfo)components.get(1);
        StackContainerSupportTest.notifySelecting((ObjectInfo)button_1);
        panel.refresh();
        StackContainerSupportTest.assertSame((Object)button_1, (Object)panel.m_activeComponent);
        button_1.delete();
        StackContainerSupportTest.assertSame((Object)button_0, (Object)panel.m_activeComponent);
    }

    @Test
    public void test_deleteActive_noOther() throws Exception {
        CardPanel_Info panel = (CardPanel_Info)((Object)this.parseJavaInfo("// filler filler filler filler filler", "public class Test extends CardPanel {", "  public Test() {", "    add(new JButton());", "  }", "}"));
        panel.refresh();
        List components = panel.getChildrenComponents();
        ComponentInfo button_0 = (ComponentInfo)components.get(0);
        StackContainerSupportTest.notifySelecting((ObjectInfo)button_0);
        panel.refresh();
        StackContainerSupportTest.assertSame((Object)button_0, (Object)panel.m_activeComponent);
        button_0.delete();
        StackContainerSupportTest.assertSame(null, (Object)panel.m_activeComponent);
    }

    @Test
    public void test_addChild_andActivate() throws Exception {
        CardPanel_Info panel = (CardPanel_Info)((Object)this.parseJavaInfo("// filler filler filler filler filler", "public class Test extends CardPanel {", "  public Test() {", "  }", "}"));
        panel.refresh();
        StackContainerSupportTest.assertSame(null, (Object)panel.m_activeComponent);
        ComponentInfo button = StackContainerSupportTest.createJButton();
        ((FlowLayoutInfo)panel.getLayout()).add(button, null);
        panel.refresh();
        StackContainerSupportTest.assertSame((Object)button, (Object)panel.m_activeComponent);
    }

    @Test
    public void test_moveChild_inner() throws Exception {
        CardPanel_Info panel = (CardPanel_Info)((Object)this.parseJavaInfo("public class Test extends CardPanel {", "  public Test() {", "    {", "      JButton button_0 = new JButton('0');", "      add(button_0);", "    }", "    add(new JButton('1'));", "    add(new JButton('2'));", "  }", "}"));
        panel.refresh();
        List components = panel.getChildrenComponents();
        ComponentInfo button_0 = (ComponentInfo)components.get(0);
        StackContainerSupportTest.assertSame((Object)button_0, (Object)panel.m_activeComponent);
        ((FlowLayoutInfo)panel.getLayout()).move(button_0, null);
        panel.refresh();
        StackContainerSupportTest.assertSame((Object)button_0, (Object)panel.m_activeComponent);
        this.assertEditor("public class Test extends CardPanel {", "  public Test() {", "    add(new JButton('1'));", "    add(new JButton('2'));", "    {", "      JButton button_0 = new JButton('0');", "      add(button_0);", "    }", "  }", "}");
    }

    @Test
    public void test_moveChild_fromOuter() throws Exception {
        ContainerInfo panel = (ContainerInfo)this.parseJavaInfo("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_0 = new JButton('0');", "      add(button_0);", "    }", "    {", "      CardPanel cardPanel = new CardPanel();", "      add(cardPanel);", "      cardPanel.add(new JButton('1'));", "      cardPanel.add(new JButton('2'));", "    }", "  }", "}");
        panel.refresh();
        List components = panel.getChildrenComponents();
        ComponentInfo button_0 = (ComponentInfo)components.get(0);
        CardPanel_Info cardPanel = (CardPanel_Info)((Object)components.get(1));
        ComponentInfo button_1 = (ComponentInfo)cardPanel.getChildrenComponents().get(0);
        StackContainerSupportTest.assertSame((Object)button_1, (Object)cardPanel.m_activeComponent);
        ((FlowLayoutInfo)cardPanel.getLayout()).move(button_0, null);
        panel.refresh();
        StackContainerSupportTest.assertSame((Object)button_0, (Object)cardPanel.m_activeComponent);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      CardPanel cardPanel = new CardPanel();", "      add(cardPanel);", "      cardPanel.add(new JButton('1'));", "      cardPanel.add(new JButton('2'));", "      {", "        JButton button_0 = new JButton('0');", "        cardPanel.add(button_0);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_moveChild_toOuter() throws Exception {
        ContainerInfo panel = (ContainerInfo)this.parseJavaInfo("public class Test extends JPanel {", "  public Test() {", "    {", "      CardPanel cardPanel = new CardPanel();", "      add(cardPanel);", "      {", "        JButton button_0 = new JButton('0');", "        cardPanel.add(button_0);", "      }", "      cardPanel.add(new JButton('1'));", "      cardPanel.add(new JButton('2'));", "    }", "  }", "}");
        panel.refresh();
        List components = panel.getChildrenComponents();
        CardPanel_Info cardPanel = (CardPanel_Info)((Object)components.get(0));
        ComponentInfo button_0 = (ComponentInfo)cardPanel.getChildrenComponents().get(0);
        ComponentInfo button_1 = (ComponentInfo)cardPanel.getChildrenComponents().get(1);
        StackContainerSupportTest.notifySelecting((ObjectInfo)button_0);
        panel.refresh();
        StackContainerSupportTest.assertSame((Object)button_0, (Object)cardPanel.m_activeComponent);
        ((FlowLayoutInfo)panel.getLayout()).move(button_0, (ComponentInfo)cardPanel);
        panel.refresh();
        StackContainerSupportTest.assertSame((Object)button_1, (Object)cardPanel.m_activeComponent);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_0 = new JButton('0');", "      add(button_0);", "    }", "    {", "      CardPanel cardPanel = new CardPanel();", "      add(cardPanel);", "      cardPanel.add(new JButton('1'));", "      cardPanel.add(new JButton('2'));", "    }", "  }", "}");
    }

    private void prepareCardPanel() throws Exception {
        this.setJavaContentSrc("test", "CardPanel", new String[]{"public class CardPanel extends JPanel {", "  public CardPanel() {", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <model class='" + CardPanel_Info.class.getName() + "'/>", "</component>"});
    }

    public static class CardPanel_Info
    extends ContainerInfo {
        ComponentInfo m_activeComponent;
        private final StackContainerSupport<ComponentInfo> m_stackContainer = new StackContainerSupport<ComponentInfo>((ObjectInfo)this){

            protected List<ComponentInfo> getChildren() {
                ArrayList<ComponentInfo> stackComponents = new ArrayList<ComponentInfo>();
                for (ComponentInfo component : this.getChildrenComponents()) {
                    if (component.getDescription().getComponentClass() == JTextField.class) continue;
                    stackComponents.add(component);
                }
                return stackComponents;
            }
        };

        public CardPanel_Info(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
            super(editor, description, creationSupport);
        }

        protected void refresh_afterCreate() throws Exception {
            super.refresh_afterCreate();
            this.m_activeComponent = (ComponentInfo)this.m_stackContainer.getActive();
        }
    }
}

