/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.parser;

import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class BadNodesTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_incompatibleVersionJVM() throws Exception {
        EnvironmentUtils.setForcedJavaVersion((Float)Float.valueOf(1.5f));
        try {
            try {
                this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
                BadNodesTest.fail();
            }
            catch (DesignerException e) {
                BadNodesTest.assertEquals((int)108, (int)e.getCode());
                BadNodesTest.assertTrue((boolean)DesignerExceptionUtils.isWarning((Throwable)e));
                EnvironmentUtils.setForcedJavaVersion(null);
            }
        }
        finally {
            EnvironmentUtils.setForcedJavaVersion(null);
        }
    }

    @Test
    public void test_emptyCompilationUnit() throws Exception {
        try {
            this.parseSource("test", "Test.java", "");
            BadNodesTest.fail();
        }
        catch (DesignerException e_) {
            DesignerException e = (DesignerException)DesignerExceptionUtils.getRootCause((Throwable)e_);
            BadNodesTest.assertEquals((int)106, (int)e.getCode());
        }
    }

    @Test
    public void test_badNodeCreation_unknownArgument() throws Exception {
        try {
            this.parseContainer("class Test extends JPanel {", "  public Test(String text) {", "    JButton button = new JButton(text);", "    add(button);", "  }", "}");
            BadNodesTest.fail();
        }
        catch (Throwable e_) {
            DesignerException designerException = (DesignerException)DesignerExceptionUtils.getRootCause((Throwable)e_);
            BadNodesTest.assertEquals((int)304, (int)designerException.getCode());
        }
    }

    @Test
    public void test_badNodeCreation_exceptionInConstructorArgument() throws Exception {
        BadNodesTest.setFileContentSrc("test/MyObject.java", BadNodesTest.getSource("package test;", "public class MyObject {", "  public static String getText() {", "    throw new IllegalStateException();", "  }", "}"));
        BadNodesTest.waitForAutoBuild();
        BadNodesTest.useStrictEvaluationMode(false);
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    String text = MyObject.getText();", "    add(new JButton(text));", "  }", "}");
        BadNodesTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JButton(text))/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton(text))/}");
        List badNodes = this.m_lastState.getBadRefreshNodes().nodes();
        Assertions.assertThat((List)badNodes).hasSize(1);
        EditorState.BadNodeInformation badNode = (EditorState.BadNodeInformation)badNodes.get(0);
        Throwable rootCause = DesignerExceptionUtils.getRootCause((Throwable)badNode.getException());
        BadNodesTest.assertInstanceOf(IllegalStateException.class, (Object)rootCause);
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        BadNodesTest.assertEquals((Object)((JButton)button.getObject()).getText(), (Object)"<dynamic>");
    }

    @Test
    public void test_forcedMethodParameter() throws Exception {
        ContainerInfo panelInfo = this.parseContainer("class Test extends JPanel {", "  /**", "  * Some leading comment...", "  * @wbp.eval.method.parameter text 'ab' + 'c'", "  * @param text 'abc'", "  * Some trailing comment...", "  */", "  public Test(String text) {", "    JButton button = new JButton(text);", "    add(button);", "  }", "}");
        panelInfo.refresh();
        BadNodesTest.assertNoErrors(this.m_lastParseInfo);
        JPanel panelComponent = (JPanel)panelInfo.getComponent();
        JButton buttonComponent = (JButton)panelComponent.getComponent(0);
        BadNodesTest.assertEquals((Object)"abc", (Object)buttonComponent.getText());
        panelInfo.refresh_dispose();
    }

    @Test
    public void test_badNodeInvocation() throws Exception {
        this.parseContainer("class Test extends JPanel {", "  public Test(String text) {", "    JButton button = new JButton();", "    button.setText(text);", "    add(button);", "  }", "}");
        BadNodesTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /button.setText(text)/ /add(button)/}");
        List badParseNodes = this.m_lastState.getBadParserNodes().nodes();
        Assertions.assertThat((List)badParseNodes).hasSize(1);
        EditorState.BadNodeInformation badNodeInformation = (EditorState.BadNodeInformation)badParseNodes.get(0);
        BadNodesTest.assertEquals((Object)"button.setText(text);", (Object)this.m_lastEditor.getSource(badNodeInformation.getNode()));
    }

    @Test
    public void test_error_syntax_1() throws Exception {
        this.m_ignoreCompilationProblems = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JBu();", "    add(new JButton();", "  }", "}");
        BadNodesTest.assertEquals((int)0, (int)panel.getChildrenComponents().size());
    }

    @Test
    public void test_error_syntax_2() throws Exception {
        this.m_ignoreCompilationProblems = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      add(new JBu();", "    }", "    add(new JButton();", "  }", "}");
        BadNodesTest.assertEquals((int)0, (int)panel.getChildrenComponents().size());
    }

    @Test
    public void test_error_noSuchClass_1() throws Exception {
        this.m_ignoreCompilationProblems = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new NoSuchClass());", "  }", "}");
        BadNodesTest.assertEquals((int)0, (int)panel.getChildrenComponents().size());
        panel.refresh();
        BadNodesTest.assertNotNull((Object)panel.getObject());
    }

    @Test
    public void test_error_noSuchClass_2() throws Exception {
        this.m_ignoreCompilationProblems = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new NoSuchClass());", "    add(new JButton());", "  }", "}");
        BadNodesTest.assertEquals((int)1, (int)panel.getChildrenComponents().size());
        panel.refresh();
        BadNodesTest.assertNotNull((Object)panel.getObject());
    }

    @Test
    public void test_error_noSuchMethod() throws Exception {
        this.m_ignoreCompilationProblems = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.setEnaAabled(false);", "    button.setSelected(true);", "    add(button);", "  }", "}");
        BadNodesTest.assertEquals((int)1, (int)panel.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        BadNodesTest.assertNotNull((Object)panel.getObject());
        JButton buttonObject = (JButton)button.getObject();
        BadNodesTest.assertTrue((boolean)buttonObject.isEnabled());
        BadNodesTest.assertTrue((boolean)buttonObject.isSelected());
    }

    @Test
    public void test_noSuchType_forVariable() throws Exception {
        this.m_ignoreCompilationProblems = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private Foo foo = null;", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        BadNodesTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}");
        panel.refresh();
        BadNodesTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_noMethodBinding_noInvocation() throws Exception {
        this.m_ignoreCompilationProblems = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(true);", "  }", "  private badMethod(Foo foo) {", "  }", "}");
        BadNodesTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setEnabled(true)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        panel.refresh();
        BadNodesTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_noMethodBinding_itIsInvoked() throws Exception {
        this.m_ignoreCompilationProblems = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    badMethod(null);", "  }", "  private badMethod(Foo foo) {", "    setEnabled(true);", "  }", "}");
        BadNodesTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        panel.refresh();
        BadNodesTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_doubleAssociationException() throws Exception {
        this.m_ignoreCompilationProblems = true;
        try {
            this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JPanel panel2 = new JPanel();", "    add(panel2);", "    //", "    JButton button = new JButton();", "    add(button);", "    panel2.add(button);", "  }", "}");
            BadNodesTest.fail();
        }
        catch (Throwable e) {
            DesignerException de = DesignerExceptionUtils.getDesignerException((Throwable)e);
            BadNodesTest.assertEquals((int)107, (int)de.getCode());
            BadNodesTest.assertTrue((boolean)DesignerExceptionUtils.isWarning((Throwable)e));
        }
    }
}

