/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.operations;

import javax.swing.JButton;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.generation.statement.block.BlockStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.variable.description.LocalUniqueVariableDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.designer.swing.SwingTestUtils;
import org.junit.jupiter.api.Test;

public class AddTest
extends SwingModelTest {
    @Test
    public void test_localInnerPanel() throws Exception {
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  public Test() {", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "    }", "  }", "}");
        AddTest.assertEquals((int)1, (int)panel.getChildrenComponents().size());
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        AddTest.assertEquals((int)0, (int)innerPanel.getChildrenComponents().size());
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)innerPanel.getLayout();
        ConstructorCreationSupport creationSupport = new ConstructorCreationSupport();
        ComponentInfo newButton = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JButton.class, (CreationSupport)creationSupport);
        SwingTestUtils.setGenerations(LocalUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        flowLayout.add(newButton, null);
        AddTest.assertEquals((int)1, (int)innerPanel.getChildrenComponents().size());
        this.assertEditor("public final class Test extends JPanel {", "  public Test() {", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "      {", "        JButton button = new JButton('New button');", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_fieldInnerPanel() throws Exception {
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  private JPanel innerPanel;", "  public Test() {", "    {", "      innerPanel = new JPanel();", "      add(innerPanel);", "    }", "  }", "}");
        AddTest.assertEquals((int)1, (int)panel.getChildrenComponents().size());
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        AddTest.assertEquals((int)0, (int)innerPanel.getChildrenComponents().size());
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)innerPanel.getLayout();
        ConstructorCreationSupport creationSupport = new ConstructorCreationSupport();
        ComponentInfo newButton = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JButton.class, (CreationSupport)creationSupport);
        SwingTestUtils.setGenerations(LocalUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        flowLayout.add(newButton, null);
        AddTest.assertEquals((int)1, (int)innerPanel.getChildrenComponents().size());
        this.assertEditor("public final class Test extends JPanel {", "  private JPanel innerPanel;", "  public Test() {", "    {", "      innerPanel = new JPanel();", "      add(innerPanel);", "      {", "        JButton button = new JButton('New button');", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_associationTemplateListener() throws Exception {
        AddTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(int value) {", "  }", "}"));
        AddTest.setFileContentSrc("test/MyButton.wbp-component.xml", AddTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton(%theValue%)]]></source>", "  </creation>", "</component>"));
        AddTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  private JPanel innerPanel;", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newButton = (ComponentInfo)AddTest.createJavaInfo("test.MyButton");
        newButton.addBroadcastListener((Object)new JavaEventListener(){

            public void associationTemplate(JavaInfo component, String[] source) throws Exception {
                AddTest.assertNotNull((Object)component.getParent());
                source[0] = StringUtils.replace((String)source[0], (String)"%theValue%", (String)"555");
            }
        });
        flowLayout.add(newButton, null);
        this.assertEditor("public final class Test extends JPanel {", "  private JPanel innerPanel;", "  public Test() {", "    {", "      MyButton myButton = new MyButton(555);", "      add(myButton);", "    }", "  }", "}");
    }
}

