/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.description;

import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.ToolkitProvider;
import org.eclipse.wb.internal.core.model.creation.ThisCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ConstructorDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class ComponentDescriptionTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getDescription_empty() throws Exception {
        ComponentDescriptionTest.setFileContentSrc("test/MyObject.wbp-component.xml", ComponentDescriptionTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <methods-exclude signature='setEnabled(boolean)'/>", "  </methods>", "</component>"));
        ComponentDescriptionTest.setFileContentSrc("test/MyObject.java", ComponentDescriptionTest.getSourceDQ("// filler filler filler filler", "package test;", "public class MyObject {", "  public MyObject() {", "  }", "}"));
        ComponentDescriptionTest.waitForAutoBuild();
        this.initDesigner();
        Class<?> myClass = this.m_lastLoader.loadClass("test.MyObject");
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, myClass);
        ComponentDescriptionTest.assertFalse((boolean)description.isCached());
        ComponentDescriptionTest.assertSame((Object)ToolkitProvider.DESCRIPTION, (Object)description.getToolkit());
        ComponentDescriptionTest.assertSame(myClass, (Object)description.getComponentClass());
        ComponentDescriptionTest.assertSame(JavaInfo.class, (Object)description.getModelClass());
        String string = description.toString();
        ComponentDescriptionTest.assertTrue((boolean)string.contains("test.MyObject"));
        ComponentDescriptionTest.assertTrue((boolean)string.contains("org.eclipse.wb.core.model.JavaInfo"));
        ComponentDescriptionTest.assertSame((Object)description, (Object)ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, myClass));
    }

    @Test
    public void test_methodTag() throws Exception {
        ComponentDescriptionTest.setFileContentSrc("test/MyObject.wbp-component.xml", ComponentDescriptionTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setValue'>", "      <parameter type='int'/>", "      <tag name='tagName' value='tagValue'/>", "    </method>", "  </methods>", "</component>"));
        ComponentDescriptionTest.setFileContentSrc("test/MyObject.java", ComponentDescriptionTest.getSourceDQ("package test;", "public class MyObject {", "  public void setValue(int value) {", "  }", "}"));
        ComponentDescriptionTest.waitForAutoBuild();
        this.initDesigner();
        ComponentDescription componentDescription = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.MyObject");
        MethodDescription methodDescription = componentDescription.getMethod("setValue(int)");
        ComponentDescriptionTest.assertEquals((Object)"tagValue", (Object)methodDescription.getTag("tagName"));
        ComponentDescriptionTest.assertNull((Object)methodDescription.getTag("no-such-tag"));
    }

    @Test
    public void test_parameterTag() throws Exception {
        ComponentDescriptionTest.setFileContentSrc("test/MyObject.wbp-component.xml", ComponentDescriptionTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='int'>", "        <tag name='tagName' value='tagValue'/>", "      </parameter>", "    </constructor>", "  </constructors>", "</component>"));
        ComponentDescriptionTest.setFileContentSrc("test/MyObject.java", ComponentDescriptionTest.getSourceDQ("package test;", "public class MyObject {", "  public MyObject(int value) {", "  }", "}"));
        ComponentDescriptionTest.waitForAutoBuild();
        this.initDesigner();
        ComponentDescription componentDescription = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.MyObject");
        ConstructorDescription constructorDescription = (ConstructorDescription)componentDescription.getConstructors().get(0);
        ComponentDescriptionTest.assertNull((Object)constructorDescription.getTag("tagName"));
        ParameterDescription parameterDescription = constructorDescription.getParameter(0);
        ComponentDescriptionTest.assertEquals((Object)"tagValue", (Object)parameterDescription.getTag("tagName"));
        ComponentDescriptionTest.assertNull((Object)parameterDescription.getTag("no-such-tag"));
    }

    @Test
    public void test_methodEvaluation() throws Exception {
        ComponentDescriptionTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends Button {", "  public void badMethod(int value) {", "    throw new Error();", "  }", "}"));
        ComponentDescriptionTest.setFileContentSrc("test/MyButton.wbp-component.xml", ComponentDescriptionTest.getSourceDQ("<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='badMethod' executable='false'>", "      <parameter type='int'/>", "    </method>", "  </methods>", "</component>"));
        ComponentDescriptionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.badMethod(0);", "  }", "}");
        panel.refresh();
        ComponentDescriptionTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_hasTrueParameter() throws Exception {
        ComponentDescriptionTest.setFileContentSrc("test/MyObject.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyObject {", "  // filler", "}"));
        ComponentDescriptionTest.setFileContentSrc("test/MyObject.wbp-component.xml", ComponentDescriptionTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='parameter_1'>true</parameter>", "    <parameter name='parameter_2'>false</parameter>", "  </parameters>", "</component>"));
        ComponentDescriptionTest.waitForAutoBuild();
        this.initDesigner();
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.MyObject");
        ComponentDescriptionTest.assertTrue((boolean)description.hasTrueParameter("parameter_1"));
        ComponentDescriptionTest.assertFalse((boolean)description.hasTrueParameter("parameter_2"));
        ComponentDescriptionTest.assertFalse((boolean)description.hasTrueParameter("parameter_3"));
    }

    @Test
    public void test_genericConstructorDescription() throws Exception {
        ComponentDescriptionTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.lang.String'/>", "      <parameter type='javax.swing.JComponent'/>", "    </constructor>", "  </constructors>", "</component>"));
        ComponentDescriptionTest.setFileContentSrc("test/MyPanel.java", ComponentDescriptionTest.getSourceDQ("package test;", "import javax.swing.JComponent;", "import javax.swing.JPanel;", "public class MyPanel extends JPanel {", "  public <T extends JComponent> MyPanel(String string, T value) {", "  }", "}"));
        ComponentDescriptionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    super('test', new JButton());", "  }", "}");
        ComponentDescription componentDescription = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.MyPanel");
        ComponentDescriptionTest.assertNotNull((Object)componentDescription.getConstructor("<init>(java.lang.String,javax.swing.JComponent)"));
        ComponentDescriptionTest.assertNull((Object)componentDescription.getConstructor("<init>(java.lang.Object,javax.swing.JButton)"));
        SuperConstructorInvocation superConstructorInvocation = ((ThisCreationSupport)panel.getCreationSupport()).getInvocation();
        IMethodBinding binding = AstNodeUtils.getSuperBinding((SuperConstructorInvocation)superConstructorInvocation);
        ComponentDescriptionTest.assertNotNull((Object)componentDescription.getConstructor(binding));
        ComponentDescriptionTest.assertNull((Object)componentDescription.getConstructor(AstNodeUtils.getMethodSignature((IMethodBinding)binding)));
    }

    private void initDesigner() throws Exception {
        if (m_testProject != null) {
            this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        }
    }
}

