/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.creation;

import java.util.List;
import javax.swing.JButton;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.RootAssociation;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.ThisCreationSupport;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.SetterAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.SuperConstructorAccessor;
import org.eclipse.wb.internal.core.model.property.editor.BooleanPropertyEditor;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class ThisCreationSupportTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_isJavaInfo() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        CreationSupport creationSupport = panel.getCreationSupport();
        ThisExpression node = null;
        ThisCreationSupportTest.assertTrue((boolean)creationSupport.isJavaInfo(node));
        node = this.m_lastEditor.getAstUnit().getAST().newThisExpression();
        ThisCreationSupportTest.assertTrue((boolean)creationSupport.isJavaInfo((ASTNode)node));
        node = creationSupport.getNode();
        ThisCreationSupportTest.assertTrue((boolean)creationSupport.isJavaInfo((ASTNode)node));
    }

    @Test
    public void test_simple() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setBackground(Color.green);", "    JButton button = new JButton('My button');", "    add(button);", "  }", "}");
        ThisCreationSupport creationSupport = (ThisCreationSupport)panel.getCreationSupport();
        ThisCreationSupportTest.assertEquals((Object)"this: javax.swing.JPanel", (Object)creationSupport.toString());
        TypeDeclaration typeDeclaration = (TypeDeclaration)this.m_lastEditor.getAstUnit().types().get(0);
        ThisCreationSupportTest.assertSame((Object)typeDeclaration.getMethods()[0], (Object)creationSupport.getConstructor());
        IMethod constructor = this.m_lastEditor.getModelUnit().getTypes()[0].getMethods()[0];
        int constructorOffset = constructor.getSourceRange().getOffset();
        ThisCreationSupportTest.assertEquals((int)constructorOffset, (int)creationSupport.getNode().getStartPosition());
        ThisCreationSupportTest.assertFalse((boolean)creationSupport.canReorder());
        ThisCreationSupportTest.assertFalse((boolean)creationSupport.canReparent());
        ThisCreationSupportTest.assertEquals((int)2, (int)panel.getChildrenJava().size());
        ThisCreationSupportTest.assertTrue((boolean)(panel.getChildrenJava().get(0) instanceof FlowLayoutInfo));
        ThisCreationSupportTest.assertTrue((boolean)(panel.getChildrenJava().get(1) instanceof ContainerInfo));
        ThisCreationSupportTest.assertInstanceOf(RootAssociation.class, (Object)panel.getAssociation());
        ThisCreationSupportTest.assert_creation((JavaInfo)panel);
    }

    @Test
    public void test_noConstructor() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel implements java.io.Serializable {", "}");
        ThisCreationSupport creationSupport = (ThisCreationSupport)panel.getCreationSupport();
        MethodDeclaration constructor = (MethodDeclaration)creationSupport.getNode();
        ThisCreationSupportTest.assertTrue((boolean)constructor.isConstructor());
        ThisCreationSupportTest.assertInstanceOf(RootAssociation.class, (Object)panel.getAssociation());
        panel.getPropertyByTitle("enabled").setValue((Object)Boolean.FALSE);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel implements java.io.Serializable {", "  public Test() {", "    setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_delete_hasDirectComponent() throws Exception {
        ContainerInfo panel = (ContainerInfo)this.parseJavaInfo("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setBackground(Color.green);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        CreationSupport creationSupport = panel.getCreationSupport();
        ThisCreationSupportTest.assertTrue((boolean)creationSupport.canDelete());
        ThisCreationSupportTest.assertTrue((boolean)panel.canDelete());
        panel.delete();
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.getProperties();
        ThisCreationSupportTest.assertInstanceOf(RootAssociation.class, (Object)panel.getAssociation());
    }

    @Test
    public void test_delete_hasExposedComponent() throws Exception {
        ContainerInfo frame = (ContainerInfo)this.parseJavaInfo("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JFrame {", "  public Test() {", "    setBackground(Color.green);", "    getContentPane().setBackground(Color.green);", "    {", "      JButton button = new JButton();", "      getContentPane().add(button);", "    }", "  }", "}");
        CreationSupport creationSupport = frame.getCreationSupport();
        ThisCreationSupportTest.assertTrue((boolean)creationSupport.canDelete());
        ThisCreationSupportTest.assertTrue((boolean)frame.canDelete());
        frame.delete();
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        frame.getProperties();
        ThisCreationSupportTest.assertInstanceOf(RootAssociation.class, (Object)frame.getAssociation());
    }

    private void prepareMyPanel() throws Exception {
        ThisCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel(boolean enabled) {", "    setEnabled(enabled);", "  }", "}"));
        ThisCreationSupportTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ThisCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='boolean' property='setEnabled(boolean)'/>", "    </constructor>", "  </constructors>", "</component>"));
        ThisCreationSupportTest.waitForAutoBuild();
    }

    @Test
    public void test_boundProperties() throws Exception {
        this.prepareMyPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "class Test extends MyPanel {", "  public Test() {", "    super(false);", "  }", "}");
        GenericProperty enabledProperty = (GenericProperty)panel.getPropertyByTitle("enabled");
        List<ExpressionAccessor> accessors = ThisCreationSupportTest.getGenericPropertyAccessors(enabledProperty);
        Assertions.assertThat(accessors).hasSize(2);
        ThisCreationSupportTest.assertInstanceOf(SetterAccessor.class, (Object)accessors.get(0));
        ThisCreationSupportTest.assertInstanceOf(SuperConstructorAccessor.class, (Object)accessors.get(1));
        enabledProperty.setValue((Object)true);
        this.assertEditor("// filler filler filler", "class Test extends MyPanel {", "  public Test() {", "    super(true);", "  }", "}");
    }

    @Test
    public void test_superProperties() throws Exception {
        this.prepareMyPanel();
        ContainerInfo panel = this.parseContainer("class Test extends MyPanel {", "  public Test() {", "    super(false);", "  }", "}");
        Property superProperty = panel.getPropertyByTitle("Constructor");
        ThisCreationSupportTest.assertNotNull((Object)superProperty);
        Property[] subProperties = ThisCreationSupportTest.getSubProperties(superProperty);
        ThisCreationSupportTest.assertEquals((int)1, (int)subProperties.length);
        GenericProperty enabledProperty = (GenericProperty)subProperties[0];
        ThisCreationSupportTest.assertEquals((Object)"enabled", (Object)enabledProperty.getTitle());
        ThisCreationSupportTest.assertInstanceOf(BooleanPropertyEditor.class, (Object)enabledProperty.getEditor());
        ThisCreationSupportTest.assertSame(Boolean.TYPE, (Object)enabledProperty.getType());
        ThisCreationSupportTest.assertEquals((Object)false, (Object)enabledProperty.getValue());
    }

    @Test
    public void test_create_ConstructorInvocation() throws Exception {
        ContainerInfo button = this.parseContainer("public class Test extends JButton {", "  public Test() {", "    this(false, 'txt');", "  }", "  public Test(boolean enabled, String text) {", "    super(text);", "    setEnabled(enabled);", "  }", "}");
        button.refresh();
        ThisCreationSupportTest.assertEquals((Object)"txt", (Object)((JButton)button.getObject()).getText());
        ThisCreationSupportTest.assertEquals((Object)false, (Object)((JButton)button.getObject()).isEnabled());
    }

    @Test
    public void test_create_SuperConstructorInvocation() throws Exception {
        ContainerInfo button = this.parseContainer("public class Test extends JButton {", "  public Test() {", "    super('txt');", "  }", "}");
        button.refresh();
        ThisCreationSupportTest.assertEquals((Object)"txt", (Object)((JButton)button.getObject()).getText());
    }

    @Test
    public void test_create_useDefaultConstructor() throws Exception {
        ContainerInfo button = this.parseContainer("// filler filler filler", "public class Test extends JButton {", "  public Test() {", "  }", "}");
        button.refresh();
        ThisCreationSupportTest.assertEquals((Object)"", (Object)((JButton)button.getObject()).getText());
    }

    @Test
    public void test_create_varArgs_useSequence() throws Exception {
        ThisCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private String[] names;", "  public MyPanel(int value, String ...names) {", "    this.names = names;", "  }", "}"));
        ThisCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    super(1, 'a', 'b', 'c');", "  }", "}");
        this.refresh();
        Object[] names = (String[])ReflectionUtils.getFieldObject((Object)panel.getObject(), (String)"names");
        ThisCreationSupportTest.assertArrayEquals((Object[])names, (Object[])new String[]{"a", "b", "c"});
    }

    @Test
    public void test_create_varArgs_useArray() throws Exception {
        ThisCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private String[] names;", "  public MyPanel(int value, String ...names) {", "    this.names = names;", "  }", "}"));
        ThisCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    super(1, new String[]{'a', 'b', 'c'});", "  }", "}");
        this.refresh();
        Object[] names = (String[])ReflectionUtils.getFieldObject((Object)panel.getObject(), (String)"names");
        ThisCreationSupportTest.assertArrayEquals((Object[])names, (Object[])new String[]{"a", "b", "c"});
    }

    @Test
    public void test_create_noSuperConstructor() throws Exception {
        ThisCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel(int value) {", "  }", "}"));
        ThisCreationSupportTest.waitForAutoBuild();
        this.m_ignoreCompilationProblems = true;
        try {
            this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        }
        catch (Throwable e) {
            DesignerException de = DesignerExceptionUtils.getDesignerException((Throwable)e);
            ThisCreationSupportTest.assertEquals((int)314, (int)de.getCode());
        }
    }

    @Test
    public void test_create_packagePrivateConstructor_forByteBuddy() throws Exception {
        ThisCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  MyPanel() {", "  }", "}"));
        ThisCreationSupportTest.waitForAutoBuild();
        try {
            this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
            ThisCreationSupportTest.fail();
        }
        catch (DesignerException e) {
            ThisCreationSupportTest.assertEquals((int)311, (int)e.getCode());
        }
    }

    @Test
    public void test_create_exceptionWithDescription() throws Exception {
        ThisCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public MyPanel(String s) {", "  }", "}"));
        ThisCreationSupportTest.waitForAutoBuild();
        try {
            this.m_ignoreCompilationProblems = true;
            this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    super(0);", "  }", "}");
            ThisCreationSupportTest.fail();
        }
        catch (Throwable e) {
            DesignerException de = DesignerExceptionUtils.getDesignerException((Throwable)e);
            ThisCreationSupportTest.assertEquals((int)313, (int)de.getCode());
        }
    }

    @Test
    public void test_create_interceptMethod_usingDescription() throws Exception {
        ThisCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  public MyPanel() {", "    setName(getNameToUse());", "  }", "  protected abstract String getNameToUse();", "}"));
        ThisCreationSupportTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ThisCreationSupportTest.getSource("<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='this.interceptMethod: getNameToUse()'>'some name'</parameter>", "  </parameters>", "</component>"));
        ThisCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public abstract class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ThisCreationSupportTest.assertEquals((Object)"some name", (Object)panel.getComponent().getName());
    }

    @Test
    public void test_create_useDefaultValueForAbstractMethods_Void() throws Exception {
        ThisCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  public MyPanel() {", "    getFoo();", "  }", "  protected abstract void getFoo();", "}"));
        ThisCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public abstract class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ThisCreationSupportTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_create_useDefaultValueForAbstractMethods_String() throws Exception {
        ThisCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  private final String m_foo;", "  public MyPanel() {", "    m_foo = getFoo();", "  }", "  protected abstract String getFoo();", "}"));
        ThisCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public abstract class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ThisCreationSupportTest.assertNoErrors((JavaInfo)panel);
        ThisCreationSupportTest.assertEquals((Object)"<dynamic>", (Object)ReflectionUtils.getFieldObject((Object)panel.getObject(), (String)"m_foo"));
    }

    @Test
    public void test_notInterceptPrivateMethod() throws Exception {
        ThisCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel() {", "  }", "  void foo() {", "  }", "}"));
        ThisCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ReflectionUtils.invokeMethod((Object)panel.getObject(), (String)"foo()", (Object[])new Object[0]);
    }

    @Test
    public void test_abstractMethod_inNonExecution() throws Exception {
        ThisCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  public MyPanel() {", "  }", "  public void setVisible(boolean visible) {", "    super.setVisible(visible);", "    foo();", "  }", "  public abstract void foo();", "}"));
        ThisCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "  public void foo() {", "  }", "}");
        panel.refresh();
        panel.getComponent().setVisible(false);
    }
}

