/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import java.util.ArrayList;
import java.util.Iterator;
import org.assertj.core.util.Lists;
import org.eclipse.wb.gef.core.events.IEditPolicyListener;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.tests.gef.GefTestCase;
import org.eclipse.wb.tests.gef.TestLogger;
import org.junit.jupiter.api.Test;

public class EditPolicyTest
extends GefTestCase {
    @Test
    public void test_Add_Remove_EditPolicyListener() throws Exception {
        EditPolicy testPolicy = new EditPolicy(){};
        EditPolicyTest.assertNull((Object)testPolicy.getListeners(IEditPolicyListener.class));
        IEditPolicyListener listener1 = new IEditPolicyListener(){

            public void activatePolicy(EditPolicy policy) {
            }

            public void deactivatePolicy(EditPolicy policy) {
            }
        };
        testPolicy.addEditPolicyListener(listener1);
        ArrayList list = Lists.newArrayList((Iterator)testPolicy.getListeners(IEditPolicyListener.class));
        EditPolicyTest.assertNotNull((Object)list);
        EditPolicyTest.assertEquals((int)1, (int)list.size());
        EditPolicyTest.assertSame((Object)listener1, list.get(0));
        IEditPolicyListener listener2 = new IEditPolicyListener(){

            public void activatePolicy(EditPolicy policy) {
            }

            public void deactivatePolicy(EditPolicy policy) {
            }
        };
        testPolicy.addEditPolicyListener(listener2);
        list = Lists.newArrayList((Iterator)testPolicy.getListeners(IEditPolicyListener.class));
        EditPolicyTest.assertNotNull((Object)list);
        EditPolicyTest.assertEquals((int)2, (int)list.size());
        EditPolicyTest.assertSame((Object)listener1, list.get(0));
        EditPolicyTest.assertSame((Object)listener2, list.get(1));
        testPolicy.removeEditPolicyListener(listener1);
        list = Lists.newArrayList((Iterator)testPolicy.getListeners(IEditPolicyListener.class));
        EditPolicyTest.assertNotNull((Object)list);
        EditPolicyTest.assertEquals((int)1, (int)list.size());
        EditPolicyTest.assertSame((Object)listener2, list.get(0));
        testPolicy.removeEditPolicyListener(listener2);
        list = Lists.newArrayList((Iterator)testPolicy.getListeners(IEditPolicyListener.class));
        EditPolicyTest.assertNotNull((Object)list);
        EditPolicyTest.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void test_Invoke_EditPolicyListener() throws Exception {
        final TestLogger actualLogger = new TestLogger();
        TestLogger expectedLogger = new TestLogger();
        IEditPolicyListener listener = new IEditPolicyListener(){

            public void activatePolicy(EditPolicy policy) {
                actualLogger.log("activate = " + String.valueOf(policy));
            }

            public void deactivatePolicy(EditPolicy policy) {
                actualLogger.log("deactivate = " + String.valueOf(policy));
            }
        };
        EditPolicy testPolicy = new EditPolicy(){};
        testPolicy.addEditPolicyListener(listener);
        actualLogger.assertEmpty();
        testPolicy.activate();
        expectedLogger.log("activate = " + String.valueOf(testPolicy));
        actualLogger.assertEquals(expectedLogger);
        testPolicy.deactivate();
        expectedLogger.log("deactivate = " + String.valueOf(testPolicy));
        actualLogger.assertEquals(expectedLogger);
        actualLogger.clear();
        expectedLogger.clear();
        testPolicy.removeEditPolicyListener(listener);
        testPolicy.activate();
        testPolicy.deactivate();
        actualLogger.assertEmpty();
    }
}

