/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.rcp;

import org.apache.commons.lang3.NotImplementedException;
import org.assertj.core.api.Assertions;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.model.rcp.EditorPartInfo;
import org.eclipse.wb.internal.rcp.model.rcp.ExtensionElementProperty;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.eclipse.wb.tests.designer.rcp.model.rcp.AbstractPdeTest;
import org.junit.jupiter.api.Test;

public class EditorPartTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_0() throws Exception {
        EditorPartInfo part = (EditorPartInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public abstract class Test extends EditorPart {", "  public Test() {", "  }", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "  }", "}");
        EditorPartTest.assertHierarchy("{this: org.eclipse.ui.part.EditorPart} {this} {}", "  {parameter} {parent} {/new Composite(parent, SWT.NULL)/}", "    {implicit-layout: org.eclipse.swt.layout.FillLayout} {implicit-layout} {}", "    {new: org.eclipse.swt.widgets.Composite} {local-unique: container} {/new Composite(parent, SWT.NULL)/}", "      {implicit-layout: absolute} {implicit-layout} {}");
        CompositeInfo parentComposite = (CompositeInfo)part.getChildren(CompositeInfo.class).get(0);
        CompositeInfo container = (CompositeInfo)parentComposite.getChildrenControls().get(0);
        part.refresh();
        EditorPartTest.assertNoErrors((JavaInfo)part);
        EditorPartTest.assertEquals((int)part.getBounds().width, (int)600);
        EditorPartTest.assertEquals((int)part.getBounds().height, (int)500);
        Assertions.assertThat((int)parentComposite.getBounds().width).isGreaterThan(300);
        Assertions.assertThat((int)parentComposite.getBounds().height).isGreaterThan(30);
        Assertions.assertThat((int)container.getBounds().width).isGreaterThan(300);
        Assertions.assertThat((int)container.getBounds().height).isGreaterThan(300);
    }

    @Test
    public void test_IEditorInput() throws Exception {
        EditorPartInfo part = (EditorPartInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public abstract class Test extends EditorPart {", "  public Test() {", "  }", "  public void init(IEditorSite site, IEditorInput input) throws PartInitException {", "    setSite(site);", "    setInput(input);", "  }", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "  }", "}");
        part.refresh();
        EditorPartTest.assertNoErrors((JavaInfo)part);
        IEditorPart editorPart = (IEditorPart)part.getObject();
        IEditorInput editorInput = editorPart.getEditorInput();
        EditorPartTest.assertNotNull((Object)editorInput);
        EditorPartTest.assertEquals((int)0, (int)editorInput.hashCode());
    }

    @Test
    public void test_IEditorSite() throws Exception {
        EditorPartInfo part = (EditorPartInfo)this.parseJavaInfo("import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public abstract class Test extends EditorPart {", "  public static final String ID = 'some.editor.Identifier';", "  public Test() {", "  }", "  public void init(IEditorSite site, IEditorInput input) throws PartInitException {", "    setSite(site);", "    setInput(input);", "  }", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "  }", "}");
        part.refresh();
        IEditorSite editorSite = (IEditorSite)ReflectionUtils.invokeMethod((Object)part.getObject(), (String)"getEditorSite()", (Object[])new Object[0]);
        try {
            editorSite.getShell();
            EditorPartTest.fail();
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        EditorPartTest.assertEquals((Object)"IEditorSite_stub", (Object)editorSite.toString());
        EditorPartTest.assertEquals((int)0, (int)editorSite.hashCode());
        EditorPartTest.assertEquals((Object)"some.editor.Identifier", (Object)editorSite.getId());
        IWorkbenchWindow window = editorSite.getWorkbenchWindow();
        EditorPartTest.assertSame((Object)DesignerPlugin.getActiveWorkbenchWindow(), (Object)window);
        IEditorSite serviceLocator = editorSite;
        EditorPartTest.assertTrue((boolean)serviceLocator.hasService(IMenuService.class));
        EditorPartTest.assertNotNull((Object)serviceLocator.getService(IMenuService.class));
    }

    @Test
    public void test_exposeControl_usingField() throws Exception {
        EditorPartTest.setFileContentSrc("test/MyEditor.java", this.getTestSource("import org.eclipse.jface.action.*;", "import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public abstract class MyEditor extends EditorPart {", "  protected Composite m_composite;", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "    m_composite = new Composite(container, SWT.NONE);", "    m_composite.setLayout(new FillLayout());", "  }", "}"));
        EditorPartTest.waitForAutoBuild();
        EditorPartInfo part = (EditorPartInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public abstract class Test extends MyEditor {", "  public Test() {", "  }", "  public void createPartControl(Composite parent) {", "    super.createPartControl(parent);", "    Button button = new Button(m_composite, SWT.NONE);", "  }", "}");
        EditorPartTest.assertHierarchy("{this: test.MyEditor} {this} {}", "  {parameter} {parent} {/super.createPartControl(parent)/}", "    {implicit-layout: org.eclipse.swt.layout.FillLayout} {implicit-layout} {}", "  {field: org.eclipse.swt.widgets.Composite} {m_composite} {/new Button(m_composite, SWT.NONE)/}", "    {implicit-layout: org.eclipse.swt.layout.FillLayout} {implicit-layout} {}", "    {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(m_composite, SWT.NONE)/}");
        part.refresh();
        EditorPartTest.assertNoErrors((JavaInfo)part);
    }

    @Test
    public void test_exposeControl_usingMethod() throws Exception {
        EditorPartTest.setFileContentSrc("test/MyEditor.java", this.getTestSource("import org.eclipse.jface.action.*;", "import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public abstract class MyEditor extends EditorPart {", "  private Composite m_inner;", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "    m_inner = new Composite(container, SWT.NONE);", "    m_inner.setLayout(new FillLayout());", "  }", "  public Composite getInner() {", "    return m_inner;", "  }", "}"));
        EditorPartTest.waitForAutoBuild();
        EditorPartInfo part = (EditorPartInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public abstract class Test extends MyEditor {", "  public Test() {", "  }", "  public void createPartControl(Composite parent) {", "    super.createPartControl(parent);", "    Button button = new Button(getInner(), SWT.NONE);", "  }", "}");
        EditorPartTest.assertHierarchy("{this: test.MyEditor} {this} {}", "  {parameter} {parent} {/super.createPartControl(parent)/}", "    {implicit-layout: org.eclipse.swt.layout.FillLayout} {implicit-layout} {}", "  {method: public org.eclipse.swt.widgets.Composite test.MyEditor.getInner()} {property} {/new Button(getInner(), SWT.NONE)/}", "    {implicit-layout: org.eclipse.swt.layout.FillLayout} {implicit-layout} {}", "    {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(getInner(), SWT.NONE)/}");
        part.refresh();
        EditorPartTest.assertNoErrors((JavaInfo)part);
    }

    @Test
    public void test_extensionProperties_hasExtension() throws Exception {
        EditorPartTest.do_projectDispose();
        EditorPartTest.do_projectCreate();
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null, "testplugin.Activator");
        AbstractPdeTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.editors'>", "    <editor id='id_1' name='name 1' icon='icons/false.gif' class='test.Test' extensions='htm, html' default='true'/>", "  </extension>", "</plugin>");
        EditorPartInfo part = (EditorPartInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public abstract class Test extends EditorPart {", "  public Test() {", "  }", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "  }", "}");
        Property extensionProperty = part.getPropertyByTitle("Extension");
        EditorPartTest.assertNotNull((Object)extensionProperty);
        EditorPartTest.assertTrue((boolean)extensionProperty.getCategory().isSystem());
        Object[] subProperties = EditorPartTest.getSubProperties(extensionProperty);
        Assertions.assertThat((Object[])subProperties).hasSize(4);
        Assertions.assertThat((Object[])subProperties).hasOnlyElementsOfType(ExtensionElementProperty.class);
        Object nameProperty = subProperties[0];
        EditorPartTest.assertEquals((Object)"name", (Object)nameProperty.getTitle());
        EditorPartTest.assertTrue((boolean)nameProperty.isModified());
        EditorPartTest.assertEquals((Object)"name 1", (Object)nameProperty.getValue());
        Object iconProperty = subProperties[1];
        EditorPartTest.assertEquals((Object)"icon", (Object)iconProperty.getTitle());
        EditorPartTest.assertTrue((boolean)iconProperty.isModified());
        EditorPartTest.assertEquals((Object)"icons/false.gif", (Object)iconProperty.getValue());
        Object extensionsProperty = subProperties[2];
        EditorPartTest.assertEquals((Object)"extensions", (Object)extensionsProperty.getTitle());
        EditorPartTest.assertTrue((boolean)extensionsProperty.isModified());
        EditorPartTest.assertEquals((Object)"htm, html", (Object)extensionsProperty.getValue());
        Object defaultProperty = subProperties[3];
        EditorPartTest.assertEquals((Object)"default", (Object)defaultProperty.getTitle());
        EditorPartTest.assertTrue((boolean)defaultProperty.isModified());
        EditorPartTest.assertEquals((Object)Boolean.TRUE, (Object)defaultProperty.getValue());
    }
}

